/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.MTrace;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.State;
import net.nooj4nlp.engine.helper.ParameterCheck;

public class Gram
implements Serializable {
    private static final long serialVersionUID = 1544877445200128280L;
    public ArrayList<State> states = new ArrayList();
    ArrayList<Boolean> isTerminal;
    ArrayList<String> vocab;
    transient ArrayList<String> vocabIn;
    transient ArrayList<String> vocabOut;
    transient String[] InflectionsCommands;

    Gram(int nbOfStates) {
        int i = 0;
        while (i < nbOfStates) {
            this.states.add(new State());
            ++i;
        }
        this.vocabOut = null;
        this.vocabIn = null;
        this.vocab = null;
        this.InflectionsCommands = null;
    }

    Gram() {
        this.vocabOut = null;
        this.vocabIn = null;
        this.vocab = null;
        this.InflectionsCommands = null;
    }

    private void cleanup() {
        for (State st : this.states) {
            st.AllIdLabels = null;
        }
    }

    final void addTransition(int src, int dst, String label, ArrayList<String> aVocab, HashMap<String, Integer> hVocab) {
        int idLabel;
        ParameterCheck.mandatoryString("label", label);
        ParameterCheck.mandatoryCollection("aVocab", aVocab);
        if (hVocab.containsKey(label)) {
            idLabel = hVocab.get(label);
        } else {
            aVocab.add(label);
            idLabel = aVocab.size() - 1;
            hVocab.put(label, idLabel);
        }
        this.states.get(src).addTrans(dst, idLabel);
    }

    static Gram addOutput(Gram grm1, String labelOutput, ArrayList<String> aVocab, HashMap<String, Integer> hVocab) {
        int idLabel;
        ParameterCheck.mandatory("grm1", grm1);
        ParameterCheck.mandatoryString("labelOutput", labelOutput);
        ParameterCheck.mandatoryCollection("aVocab", aVocab);
        Gram grmOut = new Gram(2);
        String label = "<E>/" + labelOutput;
        if (hVocab.containsKey(label)) {
            idLabel = hVocab.get(label);
        } else {
            aVocab.add(label);
            idLabel = aVocab.size() - 1;
            hVocab.put(label, idLabel);
        }
        grmOut.states.get(0).addTrans(1, idLabel);
        return grmOut.concatenation(grm1);
    }

    final void addTransition(int src, int dst, int idLabel) {
        this.states.get(src).addTrans(dst, idLabel);
    }

    final void transfer(Gram grm1, int anchor, int inode) {
        ParameterCheck.mandatory("grm1", grm1);
        int istate = 0;
        while (istate < grm1.states.size()) {
            State st = grm1.states.get(istate);
            int nst = istate + anchor;
            int itrans = 0;
            while (itrans < st.Dests.size()) {
                int dst = st.Dests.get(itrans);
                int idl = st.IdLabels.get(itrans);
                int ndst = dst + anchor;
                this.states.get(nst).addTrans(ndst, idl);
                this.states.get((int)nst).GraphNodeNumber = inode;
                ++itrans;
            }
            ++istate;
        }
    }

    static Gram token(String token, ArrayList<String> aVocab, HashMap<String, Integer> hVocab) {
        ParameterCheck.mandatoryString("token", token);
        ParameterCheck.mandatoryCollection("aVocab", aVocab);
        Gram grm = new Gram(2);
        grm.addTransition(0, 1, token, aVocab, hVocab);
        return grm;
    }

    final Gram concatenation(Gram grm2) {
        int dst;
        int itrans;
        State st;
        ParameterCheck.mandatory("grm2", grm2);
        int grm1InitialNbOfStates = this.states.size();
        this.states.add(0, new State());
        this.states.add(0, new State());
        int istate = 2;
        while (istate < this.states.size()) {
            st = this.states.get(istate);
            int itrans2 = 0;
            while (itrans2 < st.Dests.size()) {
                int dst2 = st.Dests.get(itrans2);
                st.Dests.set(itrans2, dst2 + 2);
                ++itrans2;
            }
            for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                itrans = 0;
                while (itrans < outgoingTransitions.size()) {
                    dst = outgoingTransitions.get(itrans);
                    outgoingTransitions.set(itrans, dst + 2);
                    ++itrans;
                }
            }
            ++istate;
        }
        int i = 0;
        while (i < grm2.states.size()) {
            st = grm2.states.get(i);
            int itrans3 = 0;
            while (itrans3 < st.Dests.size()) {
                int dst3 = st.Dests.get(itrans3);
                int ndst = dst3 + grm1InitialNbOfStates + 2;
                st.Dests.set(itrans3, ndst);
                ++itrans3;
            }
            for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                itrans = 0;
                while (itrans < outgoingTransitions.size()) {
                    dst = outgoingTransitions.get(itrans);
                    outgoingTransitions.set(itrans, dst + grm1InitialNbOfStates + 2);
                    ++itrans;
                }
            }
            this.states.add(st);
            ++i;
        }
        this.states.get(0).addTrans(2, 0);
        this.states.get(3).addTrans(grm1InitialNbOfStates + 2, 0);
        this.states.get(grm1InitialNbOfStates + 3).addTrans(1, 0);
        return this;
    }

    final Gram disjunction(Gram grm2) {
        int dst;
        int itrans;
        State st;
        ParameterCheck.mandatory("grm2", grm2);
        int grm1InitialNbOfStates = this.states.size();
        this.states.add(0, new State());
        this.states.add(0, new State());
        int istate = 2;
        while (istate < this.states.size()) {
            st = this.states.get(istate);
            int itrans2 = 0;
            while (itrans2 < st.Dests.size()) {
                int dst2 = st.Dests.get(itrans2);
                st.Dests.set(itrans2, dst2 + 2);
                ++itrans2;
            }
            for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                itrans = 0;
                while (itrans < outgoingTransitions.size()) {
                    dst = outgoingTransitions.get(itrans);
                    outgoingTransitions.set(itrans, dst + 2);
                    ++itrans;
                }
            }
            ++istate;
        }
        int i = 0;
        while (i < grm2.states.size()) {
            st = grm2.states.get(i);
            int itrans3 = 0;
            while (itrans3 < st.Dests.size()) {
                int dst3 = st.Dests.get(itrans3);
                int ndst = dst3 + grm1InitialNbOfStates + 2;
                st.Dests.set(itrans3, ndst);
                ++itrans3;
            }
            for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                itrans = 0;
                while (itrans < outgoingTransitions.size()) {
                    dst = outgoingTransitions.get(itrans);
                    outgoingTransitions.set(itrans, dst + grm1InitialNbOfStates + 2);
                    ++itrans;
                }
            }
            this.states.add(st);
            ++i;
        }
        this.states.get(0).addTrans(2, 0);
        this.states.get(0).addTrans(grm1InitialNbOfStates + 2, 0);
        this.states.get(3).addTrans(1, 0);
        this.states.get(grm1InitialNbOfStates + 3).addTrans(1, 0);
        return this;
    }

    final Gram disjunctions(ArrayList<Gram> grms2) {
        ParameterCheck.mandatoryCollection("grms2", grms2);
        this.states.add(0, new State());
        this.states.add(0, new State());
        int istate = 2;
        while (istate < this.states.size()) {
            State st = this.states.get(istate);
            int itrans = 0;
            while (itrans < st.Dests.size()) {
                int dst = st.Dests.get(itrans);
                st.Dests.set(itrans, dst + 2);
                ++itrans;
            }
            for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                int itrans2 = 0;
                while (itrans2 < outgoingTransitions.size()) {
                    int dst = outgoingTransitions.get(itrans2);
                    outgoingTransitions.set(itrans2, dst + 2);
                    ++itrans2;
                }
            }
            ++istate;
        }
        this.states.get(0).addTrans(2, 0);
        this.states.get(3).addTrans(1, 0);
        for (Gram grm2 : grms2) {
            int anchorStNb = this.states.size();
            int i = 0;
            while (i < grm2.states.size()) {
                State st = grm2.states.get(i);
                int itrans = 0;
                while (itrans < st.Dests.size()) {
                    int dst = st.Dests.get(itrans);
                    int ndst = dst + anchorStNb;
                    st.Dests.set(itrans, ndst);
                    ++itrans;
                }
                for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                    int itrans3 = 0;
                    while (itrans3 < outgoingTransitions.size()) {
                        int dst = outgoingTransitions.get(itrans3);
                        outgoingTransitions.set(itrans3, dst + anchorStNb);
                        ++itrans3;
                    }
                }
                this.states.add(st);
                ++i;
            }
            this.states.get(0).addTrans(anchorStNb, 0);
            this.states.get(anchorStNb + 1).addTrans(1, 0);
        }
        return this;
    }

    /*
     * Could not resolve type clashes
     */
    final Gram concatenations(ArrayList<Gram> grms2) {
        this.states.add(0, new State());
        this.states.add(0, new State());
        int istate = 2;
        while (istate < this.states.size()) {
            State st = this.states.get(istate);
            int itrans = 0;
            while (itrans < st.Dests.size()) {
                int dst = st.Dests.get(itrans);
                st.Dests.set(itrans, dst + 2);
                ++itrans;
            }
            for (ArrayList outgoingTransitions : st.AllIdLabels.values()) {
                int itrans2 = 0;
                while (itrans2 < outgoingTransitions.size()) {
                    int dst = (Integer)outgoingTransitions.get(itrans2);
                    outgoingTransitions.set(itrans2, dst + 2);
                    ++itrans2;
                }
            }
            ++istate;
        }
        int previousTerminalNode = 3;
        this.states.get(0).addTrans(2, 0);
        int anchorStNb = this.states.size();
        for (Gram grm2 : grms2) {
            anchorStNb = this.states.size();
            int i = 0;
            while (i < grm2.states.size()) {
                State st = grm2.states.get(i);
                int itrans = 0;
                while (itrans < st.Dests.size()) {
                    int dst = st.Dests.get(itrans);
                    int ndst = dst + anchorStNb;
                    st.Dests.set(itrans, ndst);
                    ++itrans;
                }
                for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                    int itrans3 = 0;
                    while (itrans3 < outgoingTransitions.size()) {
                        int dst = outgoingTransitions.get(itrans3);
                        outgoingTransitions.set(itrans3, dst + anchorStNb);
                        ++itrans3;
                    }
                }
                this.states.add(st);
                ++i;
            }
            this.states.get(previousTerminalNode).addTrans(anchorStNb, 0);
            previousTerminalNode = anchorStNb + 1;
        }
        this.states.get(anchorStNb + 1).addTrans(1, 0);
        return this;
    }

    final Gram kleene() {
        this.states.add(0, new State());
        this.states.add(0, new State());
        int istate = 2;
        while (istate < this.states.size()) {
            State st = this.states.get(istate);
            int itrans = 0;
            while (itrans < st.Dests.size()) {
                int dst = st.Dests.get(itrans);
                st.Dests.set(itrans, dst + 2);
                ++itrans;
            }
            for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                int itrans2 = 0;
                while (itrans2 < outgoingTransitions.size()) {
                    int dst = outgoingTransitions.get(itrans2);
                    outgoingTransitions.set(itrans2, dst + 2);
                    ++itrans2;
                }
            }
            ++istate;
        }
        this.states.get(0).addTrans(2, 0);
        this.states.get(0).addTrans(1, 0);
        this.states.get(3).addTrans(1, 0);
        this.states.get(1).addTrans(0, 0);
        return this;
    }

    private void prepareVocabs() {
        this.vocabIn = new ArrayList();
        this.vocabOut = new ArrayList();
        int iv = 0;
        while (iv < this.vocab.size()) {
            String label = this.vocab.get(iv);
            int i = 0;
            while (i < label.length() && label.charAt(i) != '/') {
                if (label.charAt(i) == '\\') {
                    ++i;
                } else if (label.charAt(i) == '\"') {
                    ++i;
                    while (i < label.length() && label.charAt(i) != '\"') {
                        ++i;
                    }
                }
                ++i;
            }
            if (i < label.length()) {
                String input = label.substring(0, i);
                String output = label.substring(i + 1);
                this.vocabIn.add(input);
                this.vocabOut.add(output);
            } else {
                this.vocabIn.add(label);
                this.vocabOut.add(null);
            }
            ++iv;
        }
    }

    public final void prepareForParsing() {
        this.prepareVocabs();
    }

    private boolean epsilonStateClosure(int istate, RefObject<HashMap<Integer, ArrayList<State>>> closure) {
        HashMap<Integer, ArrayList<Integer>> allIdLabels = this.states.get((int)istate).AllIdLabels;
        if (!allIdLabels.containsKey(0)) {
            return false;
        }
        ArrayList<Integer> allDests = allIdLabels.get(0);
        boolean modified = false;
        for (int dst : allDests) {
            if (((HashMap)closure.argvalue).containsKey(dst)) continue;
            ((HashMap)closure.argvalue).put(dst, null);
            this.epsilonStateClosure(dst, closure);
            modified = true;
        }
        return modified;
    }

    private HashMap<Integer, ArrayList<State>> epsilonStateClosure(HashMap<Integer, ArrayList<State>> aSetOfStates) {
        HashMap closure = new HashMap(aSetOfStates);
        boolean modified = true;
        while (modified) {
            modified = false;
            ArrayList<Integer> theStates = new ArrayList<Integer>(closure.keySet());
            for (int istate : theStates) {
                RefObject<HashMap<Integer, ArrayList<State>>> tempRef_closure = new RefObject<HashMap<Integer, ArrayList<State>>>(closure);
                boolean tempVar = this.epsilonStateClosure(istate, tempRef_closure);
                closure = (HashMap)tempRef_closure.argvalue;
                if (!tempVar) continue;
                modified = true;
            }
        }
        return closure;
    }

    private void stateClosure(int istate, int ilet, RefObject<HashMap<Integer, ArrayList<State>>> closure) {
        HashMap<Integer, ArrayList<Integer>> allIdLabels = this.states.get((int)istate).AllIdLabels;
        if (!allIdLabels.containsKey(ilet)) {
            return;
        }
        ArrayList<Integer> allDests = allIdLabels.get(ilet);
        for (int dst : allDests) {
            if (((HashMap)closure.argvalue).containsKey(dst)) continue;
            ((HashMap)closure.argvalue).put(dst, null);
        }
    }

    private boolean sameSets(HashMap<Integer, ArrayList<State>> aSet, HashMap<Integer, ArrayList<State>> anotherSet) {
        if (aSet.size() != anotherSet.size()) {
            return false;
        }
        for (int istate : aSet.keySet()) {
            if (anotherSet.containsKey(istate)) continue;
            return false;
        }
        return true;
    }

    private final void determ() {
        Gram detGram = new Gram();
        HashMap setOfStates = new HashMap();
        setOfStates.put(0, null);
        HashMap closure = this.epsilonStateClosure(setOfStates);
        ArrayList<HashMap<Integer, ArrayList<State>>> stack = new ArrayList<HashMap<Integer, ArrayList<State>>>();
        stack.add(closure);
        detGram.states.add(new State());
        int istack = 0;
        while (istack < stack.size()) {
            setOfStates = (HashMap)stack.get(istack);
            int ilet = 1;
            while (ilet < this.vocab.size()) {
                closure = new HashMap();
                Iterator iterator = setOfStates.keySet().iterator();
                while (iterator.hasNext()) {
                    int istate = (Integer)iterator.next();
                    RefObject<HashMap<Integer, ArrayList<State>>> tempRef_closure = new RefObject<HashMap<Integer, ArrayList<State>>>(closure);
                    this.stateClosure(istate, ilet, tempRef_closure);
                    closure = (HashMap)tempRef_closure.argvalue;
                }
                HashMap<Integer, ArrayList<State>> closure2 = this.epsilonStateClosure(closure);
                if (!closure2.isEmpty()) {
                    int index = -1;
                    int j = 0;
                    while (j < stack.size()) {
                        HashMap aset = (HashMap)stack.get(j);
                        if (this.sameSets(aset, closure2)) {
                            index = j;
                            break;
                        }
                        ++j;
                    }
                    if (index == -1) {
                        stack.add(new HashMap<Integer, ArrayList<State>>(closure2));
                        detGram.states.add(new State());
                        index = detGram.states.size() - 1;
                    }
                    detGram.addTransition(istack, index, ilet);
                }
                ++ilet;
            }
            ++istack;
        }
        detGram.isTerminal = new ArrayList();
        istack = 0;
        while (istack < stack.size()) {
            HashMap aset = (HashMap)stack.get(istack);
            boolean terminal = aset.containsKey(1);
            detGram.isTerminal.add(terminal);
            ++istack;
        }
        this.states = detGram.states;
        this.isTerminal = detGram.isTerminal;
    }

    private final int lookForVariable(String varName) {
        ParameterCheck.mandatoryString("varName", varName);
        int istate = 0;
        while (istate < this.states.size()) {
            State state = this.states.get(istate);
            int itrans = 0;
            while (itrans < state.Dests.size()) {
                int lbl = state.IdLabels.get(itrans);
                String ilabel0 = this.vocabIn.get(lbl);
                if (ilabel0.equals("$(" + varName)) {
                    return istate;
                }
                ++itrans;
            }
            ++istate;
        }
        return -1;
    }

    private final void exploreForVariable(int initialState, int stateNb, String varName, int recLevel, RefObject<Gram> resGram) {
        ParameterCheck.mandatoryString("varName", varName);
        State state = this.states.get(stateNb);
        int itrans = 0;
        while (itrans < state.Dests.size()) {
            int iNewState;
            int dst = state.Dests.get(itrans);
            int lbl = state.IdLabels.get(itrans);
            if (dst == 1) {
                ((Gram)resGram.argvalue).addTransition(initialState, 1, lbl);
            }
            String ilabel0 = this.vocabIn.get(lbl);
            if (recLevel == 0) {
                if (ilabel0.equals("$(" + varName)) {
                    ((Gram)resGram.argvalue).states.add(new State());
                    iNewState = ((Gram)resGram.argvalue).states.size() - 1;
                    ((Gram)resGram.argvalue).addTransition(initialState, iNewState, 0);
                    this.exploreForVariable(iNewState, dst, varName, recLevel + 1, resGram);
                }
            } else if (ilabel0.length() >= 2 && ilabel0.substring(0, 2).equals("$(")) {
                ((Gram)resGram.argvalue).states.add(new State());
                iNewState = ((Gram)resGram.argvalue).states.size() - 1;
                ((Gram)resGram.argvalue).addTransition(initialState, iNewState, lbl);
                this.exploreForVariable(iNewState, dst, varName, recLevel + 1, resGram);
            } else if (ilabel0.length() >= 2 && ilabel0.substring(0, 2).equals("$)")) {
                if (recLevel <= 1) {
                    ((Gram)resGram.argvalue).addTransition(initialState, 1, 0);
                } else {
                    ((Gram)resGram.argvalue).states.add(new State());
                    iNewState = ((Gram)resGram.argvalue).states.size() - 1;
                    ((Gram)resGram.argvalue).addTransition(initialState, iNewState, lbl);
                    this.exploreForVariable(iNewState, dst, varName, recLevel - 1, resGram);
                }
            } else {
                ((Gram)resGram.argvalue).states.add(new State());
                iNewState = ((Gram)resGram.argvalue).states.size() - 1;
                ((Gram)resGram.argvalue).addTransition(initialState, iNewState, lbl);
                this.exploreForVariable(iNewState, dst, varName, recLevel, resGram);
            }
            ++itrans;
        }
    }

    final Gram getGramFromVariableDefinition(String varName) {
        ParameterCheck.mandatoryString("varName", varName);
        int iStateVar = this.lookForVariable(varName);
        if (iStateVar == -1) {
            return null;
        }
        Gram resgram = new Gram();
        resgram.states.add(new State());
        resgram.states.add(new State());
        RefObject<Gram> tempRef_resgram = new RefObject<Gram>(resgram);
        this.exploreForVariable(0, iStateVar, varName, 0, tempRef_resgram);
        resgram = (Gram)tempRef_resgram.argvalue;
        resgram.vocab = this.vocab;
        resgram.vocabIn = this.vocabIn;
        resgram.vocabOut = this.vocabOut;
        resgram.isTerminal = new ArrayList();
        int i = 0;
        while (i < resgram.states.size()) {
            resgram.isTerminal.add(false);
            ++i;
        }
        resgram.isTerminal.set(1, true);
        return resgram;
    }

    private static int argnum(String commands, int ic) {
        ParameterCheck.mandatoryString("commands", commands);
        if (commands.charAt(ic) == '>') {
            return 1;
        }
        if (commands.charAt(ic) == 'W' && commands.charAt(ic + 1) == '>') {
            return -1;
        }
        int val = 0;
        while (ic < commands.length() && commands.charAt(ic) != '>') {
            if (!Character.isDigit(commands.charAt(ic))) {
                return 0;
            }
            val = val * 10 + commands.charAt(ic) - 48;
            ++ic;
        }
        return val;
    }

    /*
     * Unable to fully structure code
     */
    public static String processInflection(Language lan, String lemma, String commands, RefObject<Integer> ires) {
        res = new StringBuilder(lemma);
        ires.argvalue = res.length();
        ic = 0;
        while (ic < commands.length()) {
            block71: {
                block70: {
                    if (commands.charAt(ic) == '\\') {
                        res.insert((int)((Integer)ires.argvalue), String.valueOf(commands.charAt(ic + 1)));
                        ires.argvalue = (Integer)ires.argvalue + 1;
                        ic += 2;
                        continue;
                    }
                    if (commands.charAt(ic) == '\"') {
                        ++ic;
                        while (ic < commands.length() && commands.charAt(ic) != '\"') {
                            res.insert((int)((Integer)ires.argvalue), String.valueOf(commands.charAt(ic)));
                            ires.argvalue = (Integer)ires.argvalue + 1;
                            ++ic;
                        }
                        ++ic;
                        continue;
                    }
                    if (commands.charAt(ic) != '<') {
                        res.insert((int)((Integer)ires.argvalue), String.valueOf(commands.charAt(ic)));
                        ires.argvalue = (Integer)ires.argvalue + 1;
                        ++ic;
                        continue;
                    }
                    if (commands.charAt(ic + 1) == 'B') {
                        val = Gram.argnum(commands, ic + 2);
                        if (val == -1) {
                            val = (Integer)ires.argvalue;
                        } else {
                            if (val == 0) {
                                res.insert((int)((Integer)ires.argvalue), "<B:UNKNOWN ARG=" + commands.charAt(ic + 2) + ">");
                                return res.toString();
                            }
                            if ((Integer)ires.argvalue - val < 0) {
                                res.insert((int)((Integer)ires.argvalue), "<B:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                                return res.toString();
                            }
                        }
                        ires.argvalue = (Integer)ires.argvalue - val;
                        res.delete((Integer)ires.argvalue, (Integer)ires.argvalue + val);
                        ++ic;
                        while (ic < commands.length() && commands.charAt(ic) != '>') {
                            ++ic;
                        }
                        ++ic;
                        continue;
                    }
                    if (commands.charAt(ic + 1) == 'C') {
                        val = Gram.argnum(commands, ic + 2);
                        if (val != 1) {
                            res.insert((int)((Integer)ires.argvalue), "<C:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                            return res.toString();
                        }
                        if (Character.isUpperCase(res.charAt((Integer)ires.argvalue - 1))) {
                            res.setCharAt((Integer)ires.argvalue - 1, Character.toLowerCase(res.charAt((Integer)ires.argvalue - 1)));
                        } else if (Character.isLowerCase(res.charAt((Integer)ires.argvalue - 1))) {
                            res.setCharAt((Integer)ires.argvalue - 1, Character.toUpperCase(res.charAt((Integer)ires.argvalue - 1)));
                        }
                        ++ic;
                        while (ic < commands.length() && commands.charAt(ic) != '>') {
                            ++ic;
                        }
                        ++ic;
                        continue;
                    }
                    if (commands.charAt(ic + 1) == 'D') {
                        val = Gram.argnum(commands, ic + 2);
                        if (val == 0 || val == -1 || (Integer)ires.argvalue - val < 0) {
                            res.insert((int)((Integer)ires.argvalue), "<D:ERROR=" + commands.charAt(ic + 2) + ">");
                            return res.toString();
                        }
                        if (lan.isoName.equals("br") || lan.isoName.equals("hu")) {
                            ires.argvalue = lan.processInflection(commands, res, ic, (Integer)ires.argvalue);
                            if ((Integer)ires.argvalue == -1) {
                                res.insert(res.length(), "<INVALID CMD=" + commands.charAt(ic + 1) + ">");
                                ires.argvalue = res.length();
                                return res.toString();
                            }
                            ++ic;
                            while (ic < commands.length() && commands.charAt(ic) != '>') {
                                ++ic;
                            }
                            ++ic;
                            continue;
                        }
                        i = 0;
                        while (i < val) {
                            res.insert((int)((Integer)ires.argvalue), String.valueOf(res.charAt((Integer)ires.argvalue - val)));
                            ires.argvalue = (Integer)ires.argvalue + 1;
                            ++i;
                        }
                        ++ic;
                        while (ic < commands.length() && commands.charAt(ic) != '>') {
                            ++ic;
                        }
                        ++ic;
                        continue;
                    }
                    if (commands.charAt(ic + 1) == 'E') {
                        val = Gram.argnum(commands, ic + 2);
                        if (val != 1) {
                            res.insert((int)((Integer)ires.argvalue), "<E:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                            return res.toString();
                        }
                        ++ic;
                        while (ic < commands.length() && commands.charAt(ic) != '>') {
                            ++ic;
                        }
                        ++ic;
                        continue;
                    }
                    if (commands.charAt(ic + 1) == 'L') {
                        val = Gram.argnum(commands, ic + 2);
                        if (val == -1) {
                            ires.argvalue = (Integer)ires.argvalue - 1;
                            while ((Integer)ires.argvalue >= 0 && Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                                ires.argvalue = (Integer)ires.argvalue - 1;
                            }
                            ires.argvalue = (Integer)ires.argvalue + 1;
                            ++ic;
                            while (ic < commands.length() && commands.charAt(ic) != '>') {
                                ++ic;
                            }
                            ++ic;
                            continue;
                        }
                        if (val == 0) {
                            res.insert((int)((Integer)ires.argvalue), "<L:UNKNOWN ARG=" + commands.charAt(ic + 2) + ">");
                            return res.toString();
                        }
                        if ((Integer)ires.argvalue - val < 0) {
                            res.insert((int)((Integer)ires.argvalue), "<L:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                            return res.toString();
                        }
                        if (lan.isoName.equals("he")) {
                            val = Language.nbOfDagueshShinSinDotsIn(res, (Integer)ires.argvalue, val);
                        }
                        ires.argvalue = (Integer)ires.argvalue - val;
                        ++ic;
                        while (ic < commands.length() && commands.charAt(ic) != '>') {
                            ++ic;
                        }
                        ++ic;
                        continue;
                    }
                    if (commands.charAt(ic + 1) != 'P') break block70;
                    val = Gram.argnum(commands, ic + 2);
                    if (val == -1) {
                        ires.argvalue = 0;
                        while ((Integer)ires.argvalue < res.length() && !Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                            ires.argvalue = (Integer)ires.argvalue + 1;
                        }
                        while ((Integer)ires.argvalue < res.length() && Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                            ires.argvalue = (Integer)ires.argvalue + 1;
                        }
                        if ((Integer)ires.argvalue < res.length() && (Integer)ires.argvalue > 0) {
                            ++ic;
                            while (ic < commands.length() && commands.charAt(ic) != '>') {
                                ++ic;
                            }
                            ++ic;
                            continue;
                        }
                        res.insert((int)((Integer)ires.argvalue), "<P:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                        return res.toString();
                    }
                    if (val != 0) ** GOTO lbl173
                    res.insert((int)((Integer)ires.argvalue), "<P:UNKNOWN ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
lbl-1000:
                    // 1 sources

                    {
                        ires.argvalue = (Integer)ires.argvalue - 1;
                        while ((Integer)ires.argvalue >= 0 && Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                            ires.argvalue = (Integer)ires.argvalue - 1;
                        }
                        while ((Integer)ires.argvalue >= 0 && !Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                            ires.argvalue = (Integer)ires.argvalue - 1;
                        }
                        --val;
lbl173:
                        // 2 sources

                        ** while (val > 0)
                    }
lbl174:
                    // 1 sources

                    ires.argvalue = (Integer)ires.argvalue + 1;
                    if ((Integer)ires.argvalue < 0) {
                        res.insert((int)((Integer)ires.argvalue), "<P:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                        return res.toString();
                    }
                    ++ic;
                    while (ic < commands.length() && commands.charAt(ic) != '>') {
                        ++ic;
                    }
                    ++ic;
                    continue;
                }
                if (commands.charAt(ic + 1) == 'R') {
                    val = Gram.argnum(commands, ic + 2);
                    if (val == -1) {
                        while ((Integer)ires.argvalue < res.length() && Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                            ires.argvalue = (Integer)ires.argvalue + 1;
                        }
                        ++ic;
                        while (ic < commands.length() && commands.charAt(ic) != '>') {
                            ++ic;
                        }
                        ++ic;
                        continue;
                    }
                    if (val == 0) {
                        res.insert((int)((Integer)ires.argvalue), "<R:UNKNOWN ARG=" + commands.charAt(ic + 2) + ">");
                        return res.toString();
                    }
                    if ((Integer)ires.argvalue + val > res.length()) {
                        res.insert((int)((Integer)ires.argvalue), "<R:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                        return res.toString();
                    }
                    ires.argvalue = (Integer)ires.argvalue + val;
                    ++ic;
                    while (ic < commands.length() && commands.charAt(ic) != '>') {
                        ++ic;
                    }
                    ++ic;
                    continue;
                }
                if (commands.charAt(ic + 1) != 'N') break block71;
                val = Gram.argnum(commands, ic + 2);
                if (val == -1) {
                    ires.argvalue = res.length() - 1;
                    while ((Integer)ires.argvalue >= 0 && !Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                        ires.argvalue = (Integer)ires.argvalue - 1;
                    }
                    if ((Integer)ires.argvalue >= 0) {
                        ires.argvalue = (Integer)ires.argvalue + 1;
                        ++ic;
                        while (ic < commands.length() && commands.charAt(ic) != '>') {
                            ++ic;
                        }
                        ++ic;
                        continue;
                    }
                    res.insert((int)((Integer)ires.argvalue), "<N:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                if (val != 0) ** GOTO lbl245
                res.insert((int)((Integer)ires.argvalue), "<N:UNKNOWN ARG=" + commands.charAt(ic + 2) + ">");
                return res.toString();
                {
                    ires.argvalue = (Integer)ires.argvalue + 1;
                    do {
                        if ((Integer)ires.argvalue < res.length() && Language.isLetter(res.charAt((Integer)ires.argvalue))) continue block23;
                        while ((Integer)ires.argvalue < res.length() && !Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                            ires.argvalue = (Integer)ires.argvalue + 1;
                        }
                        while ((Integer)ires.argvalue < res.length() && Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                            ires.argvalue = (Integer)ires.argvalue + 1;
                        }
                        --val;
lbl245:
                        // 2 sources

                    } while (val > 0);
                }
                if ((Integer)ires.argvalue > res.length()) {
                    res.insert((int)((Integer)ires.argvalue), "<N:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                ++ic;
                while (ic < commands.length() && commands.charAt(ic) != '>') {
                    ++ic;
                }
                ++ic;
                continue;
            }
            if (commands.charAt(ic + 1) == 'S') {
                val = Gram.argnum(commands, ic + 2);
                if (val == -1) {
                    val = res.length() - (Integer)ires.argvalue;
                } else {
                    if (val == 0) {
                        res.insert((int)((Integer)ires.argvalue), "<S:UNKNOWN ARG=" + commands.charAt(ic + 2) + ">");
                        return res.toString();
                    }
                    if ((Integer)ires.argvalue + val > res.length()) {
                        res.insert((int)((Integer)ires.argvalue), "<S:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                        return res.toString();
                    }
                }
                res.delete((Integer)ires.argvalue, (Integer)ires.argvalue + val);
                ++ic;
                while (ic < commands.length() && commands.charAt(ic) != '>') {
                    ++ic;
                }
                ++ic;
                continue;
            }
            ires.argvalue = lan.processInflection(commands, res, ic, (Integer)ires.argvalue);
            if ((Integer)ires.argvalue == -1) {
                res.insert(res.length(), "<INVALID CMD=" + commands.charAt(ic + 1) + ">");
                ires.argvalue = res.length();
                return res.toString();
            }
            ++ic;
            while (ic < commands.length() && commands.charAt(ic) != '>') {
                ++ic;
            }
            ++ic;
        }
        return res.toString();
    }

    private boolean alreadyInSols(ArrayList<String> sols, String newInput, String newOutput) {
        int i = 0;
        while (i < sols.size()) {
            String cOutput;
            String cInput = sols.get(i);
            if (newInput.equals(cInput) && newOutput.equals(cOutput = sols.get(i + 1))) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private Date getMaxDate() {
        Calendar c = Calendar.getInstance();
        c.set(9999, 11, 31, 23, 59, 59);
        c.set(14, 999);
        Date maxDate = c.getTime();
        return maxDate;
    }

    public final String[] generateParaphrases(int recLevel, HashMap<String, Gram> allGrammars, int matchLimit, Date dateLimit, GramType gt, Language lan, boolean keepVariables) {
        ArrayList<String> sols = null;
        Stack<MTrace> stack = new Stack<MTrace>();
        stack.push(new MTrace());
        block0: while (stack.size() > 0) {
            MTrace curTrc = (MTrace)stack.pop();
            State state = this.states.get(curTrc.Statenb);
            int itrans = 0;
            while (itrans < state.Dests.size()) {
                Date dt = new Date();
                Date maxDate = this.getMaxDate();
                if (!dateLimit.equals(maxDate) && dt.compareTo(dateLimit) > 0) break block0;
                int dst = state.Dests.get(itrans);
                int lbl = state.IdLabels.get(itrans);
                String label = this.vocabIn.get(lbl);
                String labelOut = this.vocabOut.get(lbl);
                MTrace newTrc = new MTrace();
                newTrc.Statenb = dst;
                newTrc.Inputs.addAll(curTrc.Inputs);
                newTrc.Outputs.addAll(curTrc.Outputs);
                if (recLevel != -1 && label.length() > 0 && label.charAt(0) == ':') {
                    Gram rgrm;
                    if (allGrammars != null && (rgrm = allGrammars.get(label.substring(1))) != null) {
                        String[] recSols;
                        if (rgrm.vocabIn == null) {
                            rgrm.prepareForParsing();
                        }
                        if ((recSols = rgrm.generateParaphrases(recLevel + 1, allGrammars, matchLimit, dateLimit, gt, lan, keepVariables)) != null) {
                            if (recSols.length == 2) {
                                newTrc.Inputs.add(recSols[0]);
                                newTrc.Outputs.add(recSols[1]);
                                if (labelOut != null) {
                                    if (gt == GramType.FLX) {
                                        if (labelOut.charAt(0) == '+') {
                                            newTrc.Outputs.add(labelOut);
                                        } else {
                                            newTrc.Outputs.add("+" + labelOut);
                                        }
                                    } else {
                                        newTrc.Outputs.add(labelOut);
                                    }
                                }
                                stack.push(newTrc);
                                if (this.isTerminal.get(dst).booleanValue()) {
                                    String newInput = null;
                                    if (newTrc.Inputs.size() > 0) {
                                        StringBuilder totalInput = new StringBuilder(newTrc.Inputs.get(0));
                                        int i = 1;
                                        while (i < newTrc.Inputs.size()) {
                                            if (gt == GramType.SYNTAX) {
                                                totalInput.append(' ');
                                            }
                                            totalInput.append(newTrc.Inputs.get(i));
                                            ++i;
                                        }
                                        newInput = totalInput.toString();
                                    } else {
                                        newInput = "";
                                    }
                                    String newOutput = null;
                                    if (newTrc.Outputs.size() > 0) {
                                        StringBuilder totalOutput = new StringBuilder(newTrc.Outputs.get(0));
                                        int i = 1;
                                        while (i < newTrc.Outputs.size()) {
                                            totalOutput.append(newTrc.Outputs.get(i));
                                            ++i;
                                        }
                                        newOutput = totalOutput.toString();
                                    } else {
                                        newOutput = "";
                                    }
                                    if (sols == null) {
                                        sols = new ArrayList();
                                    }
                                    if (!(matchLimit != -1 && sols.size() >= matchLimit * 2 || this.alreadyInSols(sols, newInput, newOutput))) {
                                        sols.add(newInput);
                                        sols.add(newOutput);
                                    }
                                    if (recLevel < 2 && matchLimit > 0 && sols.size() > matchLimit * 2) {
                                        break block0;
                                    }
                                }
                            } else if (recSols.length > 2) {
                                int irec = 0;
                                while (irec < recSols.length) {
                                    MTrace newTrc0 = new MTrace();
                                    newTrc0.Statenb = newTrc.Statenb;
                                    newTrc0.Pos = newTrc.Pos;
                                    newTrc0.Inputs.addAll(newTrc.Inputs);
                                    newTrc0.Outputs.addAll(newTrc.Outputs);
                                    newTrc0.Inputs.add(recSols[irec]);
                                    newTrc0.Outputs.add(recSols[irec + 1]);
                                    if (labelOut != null) {
                                        if (gt == GramType.FLX) {
                                            if (labelOut.length() > 0 && labelOut.charAt(0) == '+') {
                                                newTrc.Outputs.add(labelOut);
                                            } else if (labelOut.length() > 0) {
                                                newTrc.Outputs.add("+" + labelOut);
                                            }
                                        } else if (gt == GramType.MORPHO) {
                                            if (labelOut.length() > 0 && labelOut.charAt(0) == '+') {
                                                newTrc.Outputs.add(labelOut);
                                            } else {
                                                int iout = 0;
                                                while (iout < newTrc.Outputs.size()) {
                                                    String ilab = newTrc.Outputs.get(iout);
                                                    if (ilab.length() > 0 && ilab.charAt(0) == '+') break;
                                                    ++iout;
                                                }
                                                if (iout < newTrc.Outputs.size()) {
                                                    newTrc.Outputs.add(iout, labelOut);
                                                } else {
                                                    newTrc.Outputs.add(labelOut);
                                                }
                                            }
                                        } else {
                                            newTrc.Outputs.add(labelOut);
                                        }
                                    }
                                    stack.push(newTrc0);
                                    if (this.isTerminal.get(dst).booleanValue()) {
                                        String newInput = null;
                                        if (newTrc0.Inputs.size() > 0) {
                                            StringBuilder totalInput = new StringBuilder(newTrc0.Inputs.get(0));
                                            int i = 1;
                                            while (i < newTrc0.Inputs.size()) {
                                                if (gt == GramType.SYNTAX) {
                                                    totalInput.append(' ');
                                                }
                                                totalInput.append(newTrc0.Inputs.get(i));
                                                ++i;
                                            }
                                            newInput = totalInput.toString();
                                        } else {
                                            newInput = "";
                                        }
                                        String newOutput = null;
                                        if (newTrc0.Outputs.size() > 0) {
                                            StringBuilder totalOutput = new StringBuilder(newTrc0.Outputs.get(0));
                                            int i = 1;
                                            while (i < newTrc0.Outputs.size()) {
                                                totalOutput.append(newTrc0.Outputs.get(i));
                                                ++i;
                                            }
                                            newOutput = totalOutput.toString();
                                        } else {
                                            newOutput = "";
                                        }
                                        if (sols == null) {
                                            sols = new ArrayList();
                                        }
                                        if (!(matchLimit != -1 && sols.size() >= matchLimit * 2 || this.alreadyInSols(sols, newInput, newOutput))) {
                                            sols.add(newInput);
                                            sols.add(newOutput);
                                        }
                                        if (recLevel < 2 && matchLimit > 0 && sols.size() > matchLimit * 2) break block0;
                                    }
                                    irec += 2;
                                }
                            }
                        }
                    }
                } else {
                    if (!label.equals("<E>") && label != null && !label.equals("")) {
                        if (gt == GramType.SYNTAX) {
                            if (label.length() >= 2 && label.charAt(0) == '$' && (label.charAt(1) == '(' || label.charAt(1) == ')')) {
                                if (keepVariables) {
                                    newTrc.Inputs.add(" " + label);
                                }
                            } else {
                                newTrc.Inputs.add(" " + label);
                            }
                        } else {
                            newTrc.Inputs.add(label);
                        }
                    }
                    if (labelOut != null && labelOut.length() > 0) {
                        if (gt == GramType.FLX) {
                            if (labelOut.charAt(0) == '+') {
                                newTrc.Outputs.add(labelOut);
                            } else {
                                newTrc.Outputs.add("+" + labelOut);
                            }
                        } else if (gt == GramType.MORPHO) {
                            if (labelOut.length() > 0 && labelOut.charAt(0) == '+') {
                                newTrc.Outputs.add(labelOut);
                            } else {
                                int iout = 0;
                                while (iout < newTrc.Outputs.size()) {
                                    String ilab = newTrc.Outputs.get(iout);
                                    if (ilab.length() > 0 && ilab.charAt(0) == '+') break;
                                    ++iout;
                                }
                                if (iout < newTrc.Outputs.size()) {
                                    newTrc.Outputs.add(iout, labelOut);
                                } else {
                                    newTrc.Outputs.add(labelOut);
                                }
                            }
                        } else {
                            newTrc.Outputs.add(labelOut);
                        }
                    }
                    stack.push(newTrc);
                    if (this.isTerminal.get(dst).booleanValue()) {
                        String newInput = null;
                        if (newTrc.Inputs.size() > 0) {
                            StringBuilder totalInput = new StringBuilder(newTrc.Inputs.get(0));
                            int i = 1;
                            while (i < newTrc.Inputs.size()) {
                                if (gt == GramType.SYNTAX) {
                                    totalInput.append(' ');
                                }
                                totalInput.append(newTrc.Inputs.get(i));
                                ++i;
                            }
                            newInput = totalInput.toString();
                        } else {
                            newInput = "";
                        }
                        String newoutput = null;
                        if (newTrc.Outputs.size() > 0) {
                            StringBuilder totaloutput = new StringBuilder(newTrc.Outputs.get(0));
                            int i = 1;
                            while (i < newTrc.Outputs.size()) {
                                totaloutput.append(newTrc.Outputs.get(i));
                                ++i;
                            }
                            newoutput = totaloutput.toString();
                        } else {
                            newoutput = "";
                        }
                        if (sols == null) {
                            sols = new ArrayList<String>();
                        }
                        if (!(matchLimit != -1 && sols.size() >= matchLimit * 2 || this.alreadyInSols(sols, newInput, newoutput))) {
                            sols.add(newInput);
                            sols.add(newoutput);
                        }
                        if (recLevel < 2 && matchLimit > 0 && sols.size() > matchLimit * 2) break block0;
                    }
                }
                ++itrans;
            }
        }
        if (sols != null && sols.size() > 0) {
            String[] forms = sols.toArray(new String[sols.size()]);
            int iform = 0;
            while (iform < forms.length) {
                if (forms[iform] != null) {
                    forms[iform] = forms[iform].trim();
                }
                ++iform;
            }
            return forms;
        }
        return null;
    }

    private String[] inflect(HashMap<String, Gram> allGrammars) {
        ArrayList<String> sols = null;
        Stack<MTrace> stack = new Stack<MTrace>();
        stack.push(new MTrace());
        while (stack.size() > 0) {
            MTrace curTrc = (MTrace)stack.pop();
            State state = this.states.get(curTrc.Statenb);
            int itrans = 0;
            while (itrans < state.Dests.size()) {
                int dst = state.Dests.get(itrans);
                int lbl = state.IdLabels.get(itrans);
                String label = this.vocabIn.get(lbl);
                String labelOut = this.vocabOut.get(lbl);
                MTrace newTrc = new MTrace();
                newTrc.Statenb = dst;
                newTrc.Inputs.addAll(curTrc.Inputs);
                newTrc.Outputs.addAll(curTrc.Outputs);
                if (label.length() > 0 && label.charAt(0) == ':') {
                    Gram rGrm;
                    if (allGrammars != null && (rGrm = allGrammars.get(label.substring(1))) != null) {
                        String[] recSols;
                        if (rGrm.vocabIn == null) {
                            rGrm.prepareForParsing();
                        }
                        if ((recSols = rGrm.inflect(allGrammars)).length == 2) {
                            newTrc.Inputs.add(recSols[0]);
                            newTrc.Outputs.add(recSols[1]);
                            if (labelOut != null) {
                                if (labelOut.charAt(0) == '+') {
                                    newTrc.Outputs.add(labelOut);
                                } else {
                                    newTrc.Outputs.add("+" + labelOut);
                                }
                            }
                            stack.push(newTrc);
                            if (this.isTerminal.get(dst).booleanValue()) {
                                if (sols == null) {
                                    sols = new ArrayList();
                                }
                                String totalInput = "";
                                String totalOutput = "";
                                int i = 0;
                                while (i < newTrc.Inputs.size()) {
                                    totalInput = String.valueOf(totalInput) + newTrc.Inputs.get(i);
                                    ++i;
                                }
                                i = 0;
                                while (i < newTrc.Outputs.size()) {
                                    totalOutput = String.valueOf(totalOutput) + newTrc.Outputs.get(i);
                                    ++i;
                                }
                                sols.add(totalInput);
                                sols.add(totalOutput);
                            }
                        } else if (recSols.length > 2) {
                            int irec = 0;
                            while (irec < recSols.length) {
                                MTrace newTrc0 = new MTrace();
                                newTrc0.Statenb = newTrc.Statenb;
                                newTrc0.Pos = newTrc.Pos;
                                newTrc0.Inputs.addAll(newTrc.Inputs);
                                newTrc0.Outputs.addAll(newTrc.Outputs);
                                newTrc0.Inputs.add(recSols[irec]);
                                newTrc0.Outputs.add(recSols[irec + 1]);
                                if (labelOut != null) {
                                    if (labelOut.charAt(0) == '+') {
                                        newTrc0.Outputs.add(labelOut);
                                    } else {
                                        newTrc0.Outputs.add("+" + labelOut);
                                    }
                                }
                                stack.push(newTrc0);
                                if (this.isTerminal.get(dst).booleanValue()) {
                                    if (sols == null) {
                                        sols = new ArrayList();
                                    }
                                    String totalInput = "";
                                    String totalOutput = "";
                                    int i = 0;
                                    while (i < newTrc0.Inputs.size()) {
                                        totalInput = String.valueOf(totalInput) + newTrc0.Inputs.get(i);
                                        ++i;
                                    }
                                    i = 0;
                                    while (i < newTrc0.Outputs.size()) {
                                        totalOutput = String.valueOf(totalOutput) + newTrc0.Outputs.get(i);
                                        ++i;
                                    }
                                    sols.add(totalInput);
                                    sols.add(totalOutput);
                                }
                                irec += 2;
                            }
                        }
                    }
                } else {
                    if (!label.equals("<E>")) {
                        newTrc.Inputs.add(label);
                    }
                    if (labelOut != null && labelOut.length() > 0) {
                        if (labelOut.charAt(0) == '+') {
                            newTrc.Outputs.add(labelOut);
                        } else {
                            newTrc.Outputs.add("+" + labelOut);
                        }
                    }
                    stack.push(newTrc);
                    if (this.isTerminal.get(dst).booleanValue()) {
                        if (sols == null) {
                            sols = new ArrayList<String>();
                        }
                        String totalInput = "";
                        String totalOutput = "";
                        int i = 0;
                        while (i < newTrc.Inputs.size()) {
                            totalInput = String.valueOf(totalInput) + newTrc.Inputs.get(i);
                            ++i;
                        }
                        i = 0;
                        while (i < newTrc.Outputs.size()) {
                            totalOutput = String.valueOf(totalOutput) + newTrc.Outputs.get(i);
                            ++i;
                        }
                        sols.add(totalInput);
                        sols.add(totalOutput);
                    }
                }
                ++itrans;
            }
        }
        if (sols != null && sols.size() > 0) {
            return sols.toArray(new String[sols.size()]);
        }
        return null;
    }

    public final void inflect(Language lan, String word, RefObject<String[]> forms, RefObject<String[]> outputs, HashMap<String, Gram> allGrammars) {
        forms.argvalue = null;
        outputs.argvalue = null;
        if (this.InflectionsCommands == null) {
            this.InflectionsCommands = this.inflect(allGrammars);
            this.cleanup();
        }
        if (this.InflectionsCommands == null) {
            return;
        }
        int pos = 0;
        forms.argvalue = new String[this.InflectionsCommands.length / 2];
        outputs.argvalue = new String[this.InflectionsCommands.length / 2];
        int i = 0;
        while (i < this.InflectionsCommands.length) {
            RefObject<Integer> tempRef_pos = new RefObject<Integer>(pos);
            ((String[])forms.argvalue)[i / 2] = Gram.processInflection(lan, word, this.InflectionsCommands[i], tempRef_pos);
            pos = (Integer)tempRef_pos.argvalue;
            ((String[])outputs.argvalue)[i / 2] = this.InflectionsCommands[i + 1].length() > 0 && this.InflectionsCommands[i + 1].charAt(0) == '+' ? this.InflectionsCommands[i + 1] : "+" + this.InflectionsCommands[i + 1];
            if (((String[])outputs.argvalue)[i / 2].equals("+<E>")) {
                ((String[])outputs.argvalue)[i / 2] = "";
            }
            i += 2;
        }
    }
}

