/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import com.itextpdf.text.Font;
import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.MTrace;
import net.nooj4nlp.engine.MatchType;
import net.nooj4nlp.engine.Mft;
import net.nooj4nlp.engine.Preferences;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.Regexps;
import net.nooj4nlp.engine.STrace;
import net.nooj4nlp.engine.State;
import net.nooj4nlp.engine.helper.ParameterCheck;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class Grammar
implements Serializable {
    private static final long serialVersionUID = 2937834300602472387L;
    public ArrayList<Graph> graphs;
    public transient HashMap<String, Gram> grams;
    public transient String fullName;
    private transient Engine engine;
    private transient boolean isTextual;
    public int windowHeight = 0;
    public int windowWidth = 0;
    public GramType gramType = GramType.forValue(0);
    public String author;
    public String institution;
    public int lockType;
    public String checkText = null;
    public String iLanguage;
    public String oLanguage;
    private transient Language iLan;
    private ArrayList<Object> extraParams;
    public String iFontName;
    public float iFontSize;
    public int iFontStyle;
    public String oFontName;
    public float oFontSize;
    public int oFontStyle;
    public String cFontName;
    public float cFontSize;
    public int cFontStyle;
    public Color cColor;
    public Color aColor;
    public Color bColor;
    public Color fColor;
    public Color sColor;
    public Color vColor;
    public boolean dispFrame;
    public boolean dispFile;
    public boolean dispDir;
    public boolean dispDate;
    public boolean dispBox = false;
    public boolean dispState = false;
    public boolean dispAuthor = false;
    public boolean dispInstitution = false;
    public boolean dispGrid = false;
    private static transient String epsilon;
    private static transient ArrayList<String> lepsilon;
    private static transient ArrayList<Object> lnull;
    private static transient ArrayList<Integer> l0;
    private static transient ArrayList<Integer> l1;
    private static transient HashMap<String, String[]> hlemmas;
    private static transient HashMap<String, Pattern> perlpatterns;

    public static boolean isItTextual(String filePath) {
        String firstLine;
        ParameterCheck.mandatoryString("filePath", filePath);
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF8"));
                firstLine = reader.readLine();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while closing reader file!", "NooJ Error!", 0);
                    }
                }
                return false;
            }
            catch (IOException e) {
                block18: {
                    e.printStackTrace();
                    if (reader == null) break block18;
                    try {
                        reader.close();
                    }
                    catch (IOException e3) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while closing reader file!", "NooJ Error!", 0);
                    }
                }
                return false;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while closing reader file!", "NooJ Error!", 0);
                }
            }
        }
        return firstLine.length() == 9 && firstLine.substring(0, 6).equals("# NooJ");
    }

    public Grammar() {
        this.graphs = new ArrayList();
        this.grams = new HashMap();
    }

    Grammar(Language ilan, GramType gt, Engine eng) {
        this.iLan = ilan;
        this.gramType = gt;
        this.engine = eng;
    }

    public Grammar(GramType gt, String author, String institution, String password, int locktype, String ilanguage, String olanguage, Preferences preferences) {
        this.gramType = gt;
        this.author = author;
        this.institution = institution;
        this.lockType = locktype;
        this.iLanguage = ilanguage;
        this.iLan = new Language(this.iLanguage);
        this.oLanguage = olanguage;
        this.graphs = new ArrayList();
        this.grams = null;
        if (preferences != null) {
            this.iFontName = preferences.IFont.getName();
            this.iFontSize = preferences.IFont.getSize2D();
            this.iFontStyle = preferences.IFont.getStyle();
            this.oFontName = preferences.OFont.getName();
            this.oFontSize = preferences.OFont.getSize2D();
            this.oFontStyle = preferences.OFont.getStyle();
            this.cFontName = preferences.CFont.getName();
            this.cFontSize = preferences.CFont.getSize2D();
            this.cFontStyle = preferences.CFont.getStyle();
            this.aColor = preferences.AColor;
            this.bColor = preferences.BColor;
            this.cColor = preferences.CColor;
            this.fColor = preferences.FColor;
            this.sColor = preferences.SColor;
            this.vColor = preferences.VColor;
            this.dispFrame = preferences.DispFrame;
            this.dispFile = preferences.DispFile;
            this.dispDir = preferences.DispDir;
            this.dispDate = preferences.DispDate;
        }
    }

    public static Grammar importWithAllEmbeddedGraphs(String fullname, GramType gt, String ilanguage, String olanguage, String encodingcode, Preferences preferences) {
        Grammar grm = new Grammar(gt, null, null, null, 0, ilanguage, olanguage, preferences);
        grm.fullName = fullname;
        Graph grf = Graph.loadIntex(grm, fullname, encodingcode, gt);
        if (grf == null) {
            return null;
        }
        grf.wholeGrammar = grm;
        grf.name = FilenameUtils.removeExtension(fullname);
        grm.graphs.add(grf);
        ArrayList<String> recGraph = new ArrayList<String>();
        recGraph.add(grf.name);
        File f = new File(fullname);
        String dname = f.getParentFile().getAbsolutePath();
        if (!grm.importEmbeddedGraphs(dname, grf, recGraph, encodingcode, gt)) {
            return null;
        }
        grm.gramType = gt;
        return grm;
    }

    public final boolean importEmbeddedGraphs(String dname, Graph grf, ArrayList<String> recGraph, String encodingcode, GramType gt) {
        int nbofnodes = grf.label.size();
        ArrayList<String> embeddedGraphs = new ArrayList<String>();
        int inode = 0;
        while (inode < nbofnodes) {
            ArrayList<Integer> child;
            if (!(inode == 1 || grf.commentNode(inode) || grf.areaNode(inode) || (child = grf.child.get(inode)).isEmpty())) {
                String output = null;
                RefObject<Object> tempRef_output = new RefObject<Object>(output);
                String[] terms = Graph.inLineLabel(grf.label.get(inode), tempRef_output);
                output = (String)tempRef_output.argvalue;
                int iterm = 0;
                while (iterm < terms.length) {
                    String gname;
                    int index;
                    if (terms[iterm].length() > 1 && terms[iterm].charAt(0) == ':' && (index = embeddedGraphs.indexOf(gname = terms[iterm].substring(1))) == -1) {
                        embeddedGraphs.add(gname);
                        index = recGraph.indexOf(gname);
                        if (index == -1) {
                            Graph grf2;
                            recGraph.add(gname);
                            index = -1;
                            int ig = 0;
                            while (ig < this.graphs.size()) {
                                grf2 = this.graphs.get(ig);
                                if (grf2 != null && grf2.name.equals(gname)) {
                                    index = ig;
                                    break;
                                }
                                ++ig;
                            }
                            if (index == -1) {
                                File targetFile = new File(dname, String.valueOf(gname) + ".grf");
                                String fullgname = targetFile.getPath();
                                if (targetFile.isFile() && (grf2 = Graph.loadIntex(this, fullgname, encodingcode, gt)) != null) {
                                    if (!this.importEmbeddedGraphs(dname, grf2, recGraph, encodingcode, gt)) {
                                        return false;
                                    }
                                    this.graphs.add(grf2);
                                }
                            }
                        }
                    }
                    ++iterm;
                }
            }
            ++inode;
        }
        return true;
    }

    private final void getDataFromSerialization() {
    }

    private final void storeDataForSerialization() {
        this.extraParams = null;
    }

    public static Grammar loadTextual(String fullname, GramType gt, RefObject<String> errmessage) {
        Grammar grammar = null;
        errmessage.argvalue = null;
        String ilanguagename = null;
        String olanguagename = null;
        RefObject<Object> tempRef_ilanguagename = new RefObject<Object>(ilanguagename);
        RefObject<Object> tempRef_olanguagename = new RefObject<Object>(olanguagename);
        Regexps rs = Regexps.load(fullname, errmessage, tempRef_ilanguagename, tempRef_olanguagename);
        ilanguagename = (String)tempRef_ilanguagename.argvalue;
        olanguagename = (String)tempRef_olanguagename.argvalue;
        if (rs == null) {
            errmessage.argvalue = "Invalid statements:\n" + (String)errmessage.argvalue;
            Dic.writeLog((String)errmessage.argvalue);
            return null;
        }
        if (rs.grammar.grams.isEmpty()) {
            errmessage.argvalue = "Grammar is empty: " + (String)errmessage.argvalue;
            Dic.writeLog((String)errmessage.argvalue);
            return null;
        }
        Set<String> keySet = rs.grammar.grams.keySet();
        for (String expname : keySet) {
            Gram grm = rs.grammar.grams.get(expname);
            if (grm == null) {
                errmessage.argvalue = "Error in grammar rule " + expname;
                Dic.writeLog((String)errmessage.argvalue);
                return null;
            }
            if (grm.vocabIn != null) continue;
            grm.prepareForParsing();
        }
        grammar = rs.grammar;
        if (grammar != null) {
            grammar.gramType = gt;
            grammar.isTextual = true;
            grammar.iLanguage = ilanguagename;
            grammar.iLan = new Language(ilanguagename);
            grammar.oLanguage = olanguagename;
        }
        return grammar;
    }

    public static Grammar loadGraphical(String fullname, boolean fromCSharp) {
        Grammar gram = null;
        FileInputStream fs = null;
        if (!fromCSharp) {
            try {
                fs = new FileInputStream(fullname);
                ObjectInputStream serializer = new ObjectInputStream(fs);
                gram = (Grammar)serializer.readObject();
                serializer.close();
            }
            catch (Exception e) {
                if (fs != null) {
                    try {
                        fs.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                System.out.println("Grammar.Load Exception: " + e.getMessage());
                return null;
            }
        }
        if (gram == null) {
            return null;
        }
        super.getDataFromSerialization();
        gram.fullName = fullname;
        int i = 0;
        while (i < gram.graphs.size()) {
            Graph grf = gram.graphs.get(i);
            if (grf == null || grf.name == null || grf.name.equals("")) {
                gram.graphs.remove(i);
                continue;
            }
            grf.getDataFromSerialization(gram);
            ++i;
        }
        Language ILan = new Language(gram.iLanguage);
        if (ILan != null && !gram.iLanguage.equals(ILan.isoName)) {
            gram.iLanguage = ILan.isoName;
        }
        gram.iLan = ILan;
        Language OLan = new Language(gram.oLanguage);
        if (OLan != null && !gram.oLanguage.equals(OLan.isoName)) {
            gram.oLanguage = OLan.isoName;
        }
        gram.isTextual = false;
        return gram;
    }

    public final void save(String fullname) {
        block7: {
            this.fullName = fullname;
            this.storeDataForSerialization();
            int i = 0;
            while (i < this.graphs.size()) {
                Graph grf = this.graphs.get(i);
                if (grf == null || grf.name == null || grf.name.equals("")) {
                    this.graphs.remove(i);
                    continue;
                }
                grf.storeDataForSerialization0();
                ++i;
            }
            FileOutputStream fs = null;
            try {
                File file = new File(fullname);
                String path = file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separator));
                File filePath = new File(path);
                if (!filePath.exists()) {
                    filePath.mkdirs();
                }
                fs = new FileOutputStream(fullname);
                ObjectOutputStream serializer = new ObjectOutputStream(fs);
                serializer.writeObject(this);
                serializer.close();
            }
            catch (Exception e) {
                if (fs == null) break block7;
                try {
                    fs.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private String compileAllGraphical(Engine eng) {
        this.grams = new HashMap();
        Language Lan = new Language(this.iLanguage);
        this.engine = eng;
        int ig = 0;
        while (ig < this.graphs.size()) {
            Graph grf = this.graphs.get(ig);
            grf.wholeGrammar = this;
            ArrayList<String> aVocab = new ArrayList<String>();
            aVocab.add("<E>");
            HashMap<String, Integer> hVocab = new HashMap<String, Integer>();
            hVocab.put("<E>", 0);
            Gram grm = grf.compile(Lan, this.gramType, aVocab, hVocab, this.engine);
            if (grm != null) {
                grm.vocab = aVocab;
                hVocab = null;
                grm.prepareForParsing();
                if (!this.grams.containsKey(grf.name)) {
                    this.grams.put(grf.name, grm);
                }
            }
            ++ig;
        }
        return null;
    }

    private String compileAllTextual(Engine eng) {
        this.engine = eng;
        Set<String> keySet = this.grams.keySet();
        for (String expname : keySet) {
            Gram grm = this.grams.get(expname);
            if (grm == null) {
                return "Error in rule " + expname;
            }
            if (grm.vocabIn != null) continue;
            grm.prepareForParsing();
        }
        return null;
    }

    public String compileAndComputeFirst(Engine engine) {
        if (this.isTextual) {
            return this.compileAllTextual(engine);
        }
        return this.compileAllGraphical(engine);
    }

    final String addGrams(Grammar cgrammar) {
        Set<String> keySet = cgrammar.grams.keySet();
        for (String expname : keySet) {
            Gram grm = cgrammar.grams.get(expname);
            if (this.grams.containsKey(expname)) {
                return "Paradigm " + expname + " is defined more than once.";
            }
            this.grams.put(expname, grm);
        }
        return null;
    }

    public final String compileAll(Engine eng) {
        if (this.isTextual) {
            return this.compileAllTextual(eng);
        }
        return this.compileAllGraphical(eng);
    }

    private static void setConstants() {
        epsilon = "<E>";
        lepsilon = new ArrayList();
        lepsilon.add(epsilon);
        lnull = new ArrayList();
        lnull.add(null);
        l0 = new ArrayList();
        l0.add(0);
        l1 = new ArrayList();
        l1.add(1);
        hlemmas = null;
    }

    private StringBuilder getValue(String varname, ArrayList<String> input, int ipos) {
        int index = -1;
        int iinput = ipos;
        while (iinput >= 0) {
            String si = input.get(iinput);
            if (si != null && si.length() != 0 && si.equals("$(" + varname)) {
                index = iinput;
                break;
            }
            --iinput;
        }
        if (index == -1) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        int reclevel = 0;
        String sj = null;
        int jinput = index + 1;
        while (jinput < input.size()) {
            sj = input.get(jinput);
            if (sj != null && sj.length() != 0) {
                if (sj.length() >= 2 && sj.charAt(0) == '$' && sj.charAt(1) == '(') {
                    ++reclevel;
                } else if (sj.length() >= 2 && sj.charAt(0) == '$' && sj.charAt(1) == ')') {
                    if (reclevel == 0) break;
                    --reclevel;
                } else {
                    res.append(sj);
                }
            }
            ++jinput;
        }
        if (sj.length() > 2) {
            res = new StringBuilder(sj.substring(2));
        }
        return res;
    }

    public final StringBuilder processVariablesInOutputs(ArrayList<String> input, ArrayList<String> output) {
        StringBuilder result = new StringBuilder();
        int ipos = 0;
        while (ipos < output.size()) {
            String so = output.get(ipos);
            if (so != null && !so.equals("")) {
                StringBuilder res = new StringBuilder();
                int i = 0;
                while (i < so.length()) {
                    StringBuilder val;
                    if (so.charAt(i) == '\\') {
                        res.append(so.charAt(i));
                        res.append(so.charAt(i + 1));
                        i += 2;
                        continue;
                    }
                    if (so.charAt(i) != '$') {
                        res.append(so.charAt(i));
                        ++i;
                        continue;
                    }
                    ++i;
                    int j = 0;
                    while (i + j < so.length() && !Character.isWhitespace(so.charAt(i + j)) && so.charAt(i + j) != '#' && so.charAt(i + j) != '=' && so.charAt(i + j) != '+' && so.charAt(i + j) != ',' && so.charAt(i + j) != '$' && so.charAt(i + j) != '>' && so.charAt(i + j) != '}') {
                        ++j;
                    }
                    String varname = so.toString().substring(i, i + j);
                    if (i + j < so.length() && so.charAt(i + j) == '#') {
                        ++j;
                    }
                    if ((val = this.getValue(varname, input, ipos)) == null) {
                        res.append("$" + varname);
                    } else {
                        res.append((CharSequence)val);
                    }
                    i += j;
                }
                i = 0;
                while (i < res.length()) {
                    if (res.charAt(i) != '#') {
                        result.append(res.charAt(i));
                    }
                    ++i;
                }
            }
            ++ipos;
        }
        return result;
    }

    private boolean morphoMatchTermLabel(String ilabel, String token, int ipos, RefObject<Integer> length) {
        length.argvalue = 0;
        if (ilabel.equals("<E>")) {
            return true;
        }
        if (ilabel.charAt(0) == '$' && (ilabel.length() > 2 && ilabel.charAt(1) == '(' || ilabel.length() >= 2 && ilabel.charAt(1) == ')')) {
            return true;
        }
        if (ipos >= token.length()) {
            return false;
        }
        boolean match = false;
        if (ilabel.charAt(0) == '<') {
            if (ilabel.equals("<L>")) {
                match = Language.isLetter(token.charAt(ipos));
            } else if (ilabel.equals("<U>")) {
                match = Character.isUpperCase(token.charAt(ipos));
            } else if (ilabel.equals("<W>")) {
                match = Character.isLowerCase(token.charAt(ipos));
            } else if (ilabel.equals("<A>")) {
                match = Language.isAccented(token.charAt(ipos));
            } else if (ilabel.equals("<N>")) {
                match = !Language.isAccented(token.charAt(ipos));
            } else if (ilabel.equals("<C>")) {
                match = !Language.isVowel(token.charAt(ipos));
            } else if (ilabel.equals("<V>")) {
                match = Language.isVowel(token.charAt(ipos));
            }
            length.argvalue = 1;
            return match;
        }
        if (ilabel.charAt(0) == '\"') {
            int i = 1;
            while (i < ilabel.length() - 1) {
                if (token.charAt(ipos + i - 1) != ilabel.charAt(i)) {
                    return false;
                }
                ++i;
            }
            length.argvalue = ilabel.length() - 2;
            return true;
        }
        if (ilabel.length() > 1) {
            if (token.length() - ipos < ilabel.length()) {
                return false;
            }
            int i = 0;
            while (i < ilabel.length()) {
                if (token.charAt(ipos + i) != ilabel.charAt(i)) {
                    return false;
                }
                ++i;
            }
            length.argvalue = ilabel.length();
            return true;
        }
        match = this.iLan.doLettersMatch(token.charAt(ipos), ilabel.charAt(0));
        length.argvalue = 1;
        return match;
    }

    private int morphoMatchLabel(String ilabel, String olabel, String text, int ipos, RefObject<ArrayList<Integer>> lengths, RefObject<ArrayList<ArrayList<String>>> inputs, RefObject<ArrayList<ArrayList<String>>> outputs) {
        lengths.argvalue = null;
        inputs.argvalue = null;
        outputs.argvalue = null;
        if (ilabel.charAt(0) == ':') {
            Gram grm = this.grams.get(ilabel.substring(1));
            if (grm == null) {
                Graph grf = null;
                int i = 0;
                while (i < this.graphs.size()) {
                    grf = this.graphs.get(i);
                    if (grf != null && grf.name.equals(ilabel.substring(1))) break;
                    ++i;
                }
                if (grf != null) {
                    ArrayList<String> aVocab = new ArrayList<String>();
                    aVocab.add("<E>");
                    HashMap<String, Integer> hVocab = new HashMap<String, Integer>();
                    hVocab.put("<E>", 0);
                    grm = grf.compile(this.iLan, this.gramType, aVocab, hVocab, this.engine);
                    if (grm != null) {
                        grm.vocab = aVocab;
                        hVocab = null;
                        grm.prepareForParsing();
                    }
                    this.grams.put(grf.name, grm);
                } else {
                    return 0;
                }
            }
            int da = this.morphoMatch(text.substring(ipos), grm, false, lengths, inputs, outputs);
            return da;
        }
        int l = 0;
        RefObject<Integer> tempRef_l = new RefObject<Integer>(l);
        boolean tempVar = this.morphoMatchTermLabel(ilabel, text, ipos, tempRef_l);
        l = (Integer)tempRef_l.argvalue;
        if (tempVar) {
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(l);
            ArrayList<String> i = new ArrayList<String>();
            if (ilabel.charAt(0) == '$' && (ilabel.charAt(1) == '(' || ilabel.charAt(1) == ')')) {
                i.add(ilabel);
            } else {
                i.add(text.substring(ipos, ipos + l));
            }
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(i);
            ArrayList<String> o = new ArrayList<String>();
            o.add(olabel);
            outputs.argvalue = new ArrayList();
            ((ArrayList)outputs.argvalue).add(o);
            return 1;
        }
        return 0;
    }

    private int morphoMatchLabel(int graphnode, String ilabel, String olabel, String text, int ipos, RefObject<ArrayList<Integer>> lengths, RefObject<ArrayList<ArrayList<String>>> inputs, RefObject<ArrayList<ArrayList<String>>> outputs, RefObject<ArrayList<ArrayList<Object>>> nodes) {
        lengths.argvalue = null;
        outputs.argvalue = null;
        inputs.argvalue = null;
        nodes.argvalue = null;
        if (ilabel.charAt(0) == ':') {
            int da;
            String graphname = ilabel.substring(1);
            Gram grm = this.grams.get(graphname);
            if (grm == null) {
                Graph grf = null;
                int i = 0;
                while (i < this.graphs.size()) {
                    grf = this.graphs.get(i);
                    if (grf != null && grf.name.equals(graphname)) break;
                    ++i;
                }
                if (grf != null) {
                    ArrayList<String> aVocab = new ArrayList<String>();
                    aVocab.add("<E>");
                    HashMap<String, Integer> hVocab = new HashMap<String, Integer>();
                    hVocab.put("<E>", 0);
                    grm = grf.compile(this.iLan, this.gramType, aVocab, hVocab, this.engine);
                    if (grm != null) {
                        grm.vocab = aVocab;
                        hVocab = null;
                        grm.prepareForParsing();
                    }
                    this.grams.put(grf.name, grm);
                } else {
                    return 0;
                }
            }
            if ((da = this.morphoMatch(graphname, text.substring(ipos), grm, lengths, inputs, outputs, nodes)) > 0) {
                int isol = 0;
                while (isol < da) {
                    ArrayList i2 = (ArrayList)((ArrayList)inputs.argvalue).get(isol);
                    i2.add(0, "");
                    ArrayList o2 = (ArrayList)((ArrayList)outputs.argvalue).get(isol);
                    o2.add(0, olabel);
                    ArrayList n2 = (ArrayList)((ArrayList)nodes.argvalue).get(isol);
                    n2.add(0, graphnode);
                    ++isol;
                }
            }
            return da;
        }
        int l = 0;
        RefObject<Integer> tempRef_l = new RefObject<Integer>(l);
        boolean tempVar = this.morphoMatchTermLabel(ilabel, text, ipos, tempRef_l);
        l = (Integer)tempRef_l.argvalue;
        if (tempVar) {
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(l);
            ArrayList<String> i = new ArrayList<String>();
            if (ilabel.charAt(0) == '$' && (ilabel.charAt(1) == '(' || ilabel.charAt(1) == ')')) {
                i.add(ilabel);
            } else {
                i.add(text.substring(ipos, ipos + l));
            }
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(i);
            ArrayList<String> o = new ArrayList<String>();
            o.add(olabel);
            outputs.argvalue = new ArrayList();
            ((ArrayList)outputs.argvalue).add(o);
            ArrayList<Integer> n = new ArrayList<Integer>();
            n.add(graphnode);
            nodes.argvalue = new ArrayList();
            ((ArrayList)nodes.argvalue).add(n);
            return 1;
        }
        return 0;
    }

    public static StringBuilder computeInput(ArrayList<String> inputs) {
        StringBuilder itrace = new StringBuilder();
        int i = 0;
        while (i < inputs.size()) {
            String si = inputs.get(i);
            if (!(si == null || si.equals("") || si.equals("<E>") || si.equals("$)") || si.charAt(0) == '$' && si.charAt(1) == '(')) {
                itrace.append(si);
            }
            ++i;
        }
        return itrace;
    }

    private final int morphoMatch(String text, Gram grm, boolean totheend, RefObject<ArrayList<Integer>> sollengths, RefObject<ArrayList<ArrayList<String>>> solinputs, RefObject<ArrayList<ArrayList<String>>> soloutputs) {
        if (!epsilon.equals("<E>")) {
            Grammar.setConstants();
        }
        sollengths.argvalue = null;
        soloutputs.argvalue = null;
        solinputs.argvalue = null;
        Stack<MTrace> stack = new Stack<MTrace>();
        stack.push(new MTrace());
        while (stack.size() > 0) {
            MTrace curtrc = (MTrace)stack.pop();
            State state = grm.states.get(curtrc.Statenb);
            int ipos = curtrc.Pos;
            ArrayList<String> inputs = curtrc.Inputs;
            ArrayList<String> outputs = curtrc.Outputs;
            int itrans = 0;
            while (itrans < state.Dests.size()) {
                int dst = state.Dests.get(itrans);
                int lbl = state.IdLabels.get(itrans);
                String ilabel0 = grm.vocabIn.get(lbl);
                String olabel = grm.vocabOut.get(lbl);
                String ilabel = this.engine.thereIsAVariableInLabel(ilabel0) ? this.engine.processVariableInMorphoLabel(ilabel0, inputs) : ilabel0;
                ArrayList i2 = null;
                ArrayList o2 = null;
                ArrayList l2 = null;
                RefObject<Object> tempRef_l2 = new RefObject<Object>(l2);
                RefObject<Object> tempRef_i2 = new RefObject<Object>(i2);
                RefObject<Object> tempRef_o2 = new RefObject<Object>(o2);
                int da = this.morphoMatchLabel(ilabel, olabel, text, ipos, tempRef_l2, tempRef_i2, tempRef_o2);
                l2 = (ArrayList)tempRef_l2.argvalue;
                i2 = (ArrayList)tempRef_i2.argvalue;
                o2 = (ArrayList)tempRef_o2.argvalue;
                int iamb = 0;
                while (iamb < da) {
                    int newpos = ipos + (Integer)l2.get(iamb);
                    MTrace newtrc = new MTrace();
                    newtrc.Statenb = dst;
                    newtrc.Pos = newpos;
                    newtrc.Inputs.addAll(inputs);
                    newtrc.Inputs.addAll((Collection)i2.get(iamb));
                    newtrc.Outputs.addAll(outputs);
                    newtrc.Outputs.addAll((Collection)o2.get(iamb));
                    if (newtrc.Inputs == null || newtrc.Inputs.size() < 1000) {
                        stack.push(newtrc);
                    }
                    if (!(!grm.isTerminal.get(dst).booleanValue() || totheend && newpos < text.length() && Language.isLetter(text.charAt(newpos)))) {
                        if (sollengths.argvalue == null) {
                            sollengths.argvalue = new ArrayList();
                            solinputs.argvalue = new ArrayList();
                            soloutputs.argvalue = new ArrayList();
                        }
                        ((ArrayList)sollengths.argvalue).add(newpos);
                        ((ArrayList)solinputs.argvalue).add(newtrc.Inputs);
                        ((ArrayList)soloutputs.argvalue).add(newtrc.Outputs);
                    }
                    ++iamb;
                }
                ++itrans;
            }
        }
        if (sollengths.argvalue == null) {
            return 0;
        }
        return ((ArrayList)sollengths.argvalue).size();
    }

    public final int morphoMatch(String graphname, String text, Gram grm, RefObject<ArrayList<Integer>> sollengths, RefObject<ArrayList<ArrayList<String>>> solinputs, RefObject<ArrayList<ArrayList<String>>> soloutputs, RefObject<ArrayList<ArrayList<Object>>> solnodes) {
        if (!epsilon.equals("<E>")) {
            Grammar.setConstants();
        }
        sollengths.argvalue = null;
        soloutputs.argvalue = null;
        solinputs.argvalue = null;
        solnodes.argvalue = null;
        Stack<MTrace> stack = new Stack<MTrace>();
        stack.push(new MTrace(0, graphname));
        while (stack.size() > 0) {
            MTrace curtrc = (MTrace)stack.pop();
            State state = grm.states.get(curtrc.Statenb);
            int ipos = curtrc.Pos;
            int graphnode = state.GraphNodeNumber;
            ArrayList<String> inputs = curtrc.Inputs;
            ArrayList<String> outputs = curtrc.Outputs;
            ArrayList<Object> nodes = curtrc.Nodes;
            int itrans = 0;
            while (itrans < state.Dests.size()) {
                int dst = state.Dests.get(itrans);
                int lbl = state.IdLabels.get(itrans);
                String ilabel0 = grm.vocabIn.get(lbl);
                String olabel = grm.vocabOut.get(lbl);
                String ilabel = this.engine.thereIsAVariableInLabel(ilabel0) ? this.engine.processVariableInMorphoLabel(ilabel0, inputs) : ilabel0;
                ArrayList l2 = null;
                ArrayList i2 = null;
                ArrayList o2 = null;
                ArrayList n2 = null;
                RefObject<Object> tempRef_l2 = new RefObject<Object>(l2);
                RefObject<Object> tempRef_i2 = new RefObject<Object>(i2);
                RefObject<Object> tempRef_o2 = new RefObject<Object>(o2);
                RefObject<Object> tempRef_n2 = new RefObject<Object>(n2);
                int da = this.morphoMatchLabel(graphnode, ilabel, olabel, text, ipos, tempRef_l2, tempRef_i2, tempRef_o2, tempRef_n2);
                l2 = (ArrayList)tempRef_l2.argvalue;
                i2 = (ArrayList)tempRef_i2.argvalue;
                o2 = (ArrayList)tempRef_o2.argvalue;
                n2 = (ArrayList)tempRef_n2.argvalue;
                int iamb = 0;
                while (iamb < da) {
                    int newpos = ipos + (Integer)l2.get(iamb);
                    MTrace newtrc = new MTrace();
                    newtrc.Statenb = dst;
                    newtrc.Pos = newpos;
                    newtrc.Inputs.addAll(inputs);
                    newtrc.Inputs.addAll((Collection)i2.get(iamb));
                    newtrc.Outputs.addAll(outputs);
                    newtrc.Outputs.addAll((Collection)o2.get(iamb));
                    newtrc.Nodes.addAll(nodes);
                    newtrc.Nodes.addAll((Collection)n2.get(iamb));
                    if (newtrc.Inputs == null || newtrc.Inputs.size() < 1000) {
                        stack.push(newtrc);
                    }
                    if (dst == 1) {
                        newtrc.Nodes.add(1);
                        newtrc.Inputs.add("");
                        newtrc.Outputs.add(null);
                        if (sollengths.argvalue == null) {
                            sollengths.argvalue = new ArrayList();
                            solinputs.argvalue = new ArrayList();
                            soloutputs.argvalue = new ArrayList();
                            solnodes.argvalue = new ArrayList();
                        }
                        ((ArrayList)sollengths.argvalue).add(newpos);
                        ((ArrayList)solinputs.argvalue).add(newtrc.Inputs);
                        ((ArrayList)soloutputs.argvalue).add(newtrc.Outputs);
                        ((ArrayList)solnodes.argvalue).add(newtrc.Nodes);
                    }
                    ++iamb;
                }
                ++itrans;
            }
        }
        if (sollengths.argvalue == null) {
            return 0;
        }
        return ((ArrayList)sollengths.argvalue).size();
    }

    public final ArrayList<String> matchWord(String text, Engine eng, boolean morethanoneword, String currentline, int cpos) {
        int da;
        Gram grm;
        this.engine = eng;
        if (!epsilon.equals("<E>")) {
            Grammar.setConstants();
        }
        if ((grm = this.grams.get("Main")) == null) {
            return null;
        }
        if (this.engine.BackgroundWorking && this.engine.backgroundWorker.isCancellationPending()) {
            return null;
        }
        ArrayList slengths = null;
        ArrayList sinputs = null;
        ArrayList soutputs = null;
        RefObject<Object> tempRef_slengths2 = null;
        RefObject<Object> tempRef_sinputs2 = null;
        RefObject<Object> tempRef_soutputs2 = null;
        if (this.engine.Lan.isoName.equals("ar") || this.engine.Lan.isoName.equals("he") || this.engine.Lan.isoName.equals("vi")) {
            String text0 = currentline.substring(cpos);
            RefObject<Object> tempRef_slengths = new RefObject<Object>(slengths);
            RefObject<Object> tempRef_sinputs = new RefObject<Object>(sinputs);
            RefObject<Object> tempRef_soutputs = new RefObject<Object>(soutputs);
            da = this.morphoMatch(text0, grm, true, tempRef_slengths, tempRef_sinputs, tempRef_soutputs);
            slengths = (ArrayList)tempRef_slengths.argvalue;
            sinputs = (ArrayList)tempRef_sinputs.argvalue;
            soutputs = (ArrayList)tempRef_soutputs.argvalue;
        } else {
            tempRef_slengths2 = new RefObject<Object>(slengths);
            tempRef_sinputs2 = new RefObject<Object>(sinputs);
            tempRef_soutputs2 = new RefObject<Object>(soutputs);
            da = this.morphoMatch(text, grm, true, tempRef_slengths2, tempRef_sinputs2, tempRef_soutputs2);
        }
        slengths = (ArrayList)tempRef_slengths2.argvalue;
        sinputs = (ArrayList)tempRef_sinputs2.argvalue;
        soutputs = (ArrayList)tempRef_soutputs2.argvalue;
        if (da == 0) {
            return null;
        }
        ArrayList<String> sols = new ArrayList<String>();
        int isol = 0;
        while (isol < da) {
            String sol;
            int stl = (Integer)slengths.get(isol);
            ArrayList sti = (ArrayList)sinputs.get(isol);
            ArrayList sto = (ArrayList)soutputs.get(isol);
            StringBuilder otrace = this.processVariablesInOutputs(sti, sto);
            StringBuilder itrace = Grammar.computeInput(sti);
            if (Grammar.isComplex(otrace)) {
                if (morethanoneword || !Grammar.hasMoreThanOneWord(otrace)) {
                    String errmessage = null;
                    RefObject<Object> tempRef_errmessage = new RefObject<Object>(errmessage);
                    ArrayList<ArrayList<String>> csols = this.processConstraints(otrace.toString(), tempRef_errmessage);
                    errmessage = (String)tempRef_errmessage.argvalue;
                    if (csols != null && !csols.isEmpty()) {
                        ArrayList<ArrayList<String>> listofsols = this.defactorize(csols);
                        int icsol = 0;
                        while (icsol < listofsols.size()) {
                            ArrayList<String> asol = listofsols.get(icsol);
                            this.engine.processELCSFVariables(asol, text);
                            ArrayList<String> asol2 = this.engine.getRidOfConstraints(asol);
                            StringBuilder restrace = Grammar.computeInput(asol2);
                            sol = String.valueOf(text) + "," + restrace.toString();
                            if (stl > text.length()) {
                                sols.add(Integer.toString(stl));
                            }
                            sols.add(sol);
                            ++icsol;
                        }
                    }
                }
            } else {
                int count = 0;
                int i = 0;
                while (i < otrace.length()) {
                    if (otrace.charAt(i) == '\\') {
                        ++i;
                    } else if (otrace.charAt(i) == ',') {
                        ++count;
                    }
                    ++i;
                }
                sol = count == 0 ? String.valueOf(text.substring(0, stl)) + "," + itrace.toString() + "," + otrace.toString() : String.valueOf(itrace.toString()) + "," + otrace.toString();
                sols.add(sol);
            }
            ++isol;
        }
        return sols;
    }

    public static boolean isComplex(StringBuilder output) {
        int i = 0;
        while (i < output.length()) {
            if (output.charAt(i) == '\\') {
                ++i;
            } else if (output.charAt(i) == '<' || output.charAt(i) == '{') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasMoreThanOneWord(StringBuilder output) {
        int cpt = 0;
        int i = 0;
        while (i < output.length()) {
            if (output.charAt(i) == '\\') {
                ++i;
            } else if (output.charAt(i) == '{') {
                ++cpt;
            } else if (output.charAt(i) == '<') {
                int j = 0;
                while (i + j < output.length() && output.charAt(j) != '>') {
                    ++j;
                }
                String lexeme = output.toString().substring(i, i + j);
                String entry = null;
                String lemma = null;
                String category = null;
                String[] features = null;
                boolean negation = false;
                RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                RefObject<Object> tempRef_category = new RefObject<Object>(category);
                RefObject<Object> tempRef_features = new RefObject<Object>(features);
                RefObject<Boolean> tempRef_negation = new RefObject<Boolean>(negation);
                boolean tempVar = Dic.parseSymbolFeatureArray(lexeme, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features, tempRef_negation);
                entry = (String)tempRef_entry.argvalue;
                lemma = (String)tempRef_lemma.argvalue;
                category = (String)tempRef_category.argvalue;
                features = (String[])tempRef_features.argvalue;
                negation = (Boolean)tempRef_negation.argvalue;
                if (tempVar) {
                    ++cpt;
                    i += j;
                }
            }
            ++i;
        }
        return cpt > 1;
    }

    private static boolean perlMatch(String wordform, String pattern) {
        Pattern p;
        String rpat;
        if (pattern.charAt(0) == '\"' && pattern.charAt(pattern.length() - 1) == '\"') {
            rpat = pattern.substring(1, 1 + pattern.length() - 2);
        } else {
            if (pattern.charAt(0) == '\"' || pattern.charAt(pattern.length() - 1) == '\"') {
                return false;
            }
            rpat = pattern;
        }
        if (perlpatterns == null) {
            perlpatterns = new HashMap();
            p = Pattern.compile(rpat);
            perlpatterns.put(rpat, p);
        } else if (perlpatterns.containsKey(rpat)) {
            p = perlpatterns.get(rpat);
        } else {
            p = Pattern.compile(rpat);
            perlpatterns.put(rpat, p);
        }
        Matcher m = p.matcher(wordform);
        return m.find();
    }

    private static String[] extractPerlQueries(String[] features) {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < features.length) {
            if (features[i].length() > 4 && (features[i].substring(0, 4).equals("+MP=") || features[i].substring(0, 4).equals("-MP="))) {
                if (res == null) {
                    res = new ArrayList();
                }
                res.add(features[i]);
            }
            ++i;
        }
        return res.toArray(new String[res.size()]);
    }

    private static String[] removePerlQueries(String[] features) {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < features.length) {
            if (features[i].length() < 4 || !features[i].substring(0, 4).equals("+MP=") && !features[i].substring(0, 4).equals("-MP=")) {
                if (res == null) {
                    res = new ArrayList();
                }
                res.add(features[i]);
            }
            ++i;
        }
        return res.toArray(new String[res.size()]);
    }

    static void filterConstraint(ArrayList<String> sols, String entry, String lemma, String category, String[] features, boolean negation) {
        String lentry = null;
        String llemma = null;
        String lcategory = null;
        String[] lfeatures = null;
        int i = 0;
        while (i < sols.size()) {
            int jfeat;
            int ifeat;
            boolean compatible;
            RefObject<Object> tempRef_lentry = new RefObject<Object>(lentry);
            RefObject<Object> tempRef_llemma = new RefObject<Object>(llemma);
            RefObject<Object> tempRef_lcategory = new RefObject<Object>(lcategory);
            RefObject<Object> tempRef_lfeatures = new RefObject<Object>(lfeatures);
            Dic.parseDELAFFeatureArray(sols.get(i), tempRef_lentry, tempRef_llemma, tempRef_lcategory, tempRef_lfeatures);
            lentry = (String)tempRef_lentry.argvalue;
            llemma = (String)tempRef_llemma.argvalue;
            lcategory = (String)tempRef_lcategory.argvalue;
            lfeatures = (String[])tempRef_lfeatures.argvalue;
            if (!negation) {
                if (category != null && !category.equals("DIC") && !category.equals(lcategory)) {
                    sols.subList(i, 1 + i).clear();
                    continue;
                }
                if (lemma != null && !lemma.equals(llemma)) {
                    sols.subList(i, 1 + i).clear();
                    continue;
                }
                if (features == null || features.length == 0) {
                    ++i;
                    continue;
                }
                compatible = true;
                ifeat = 0;
                while (ifeat < features.length) {
                    int index;
                    if (features[ifeat].charAt(0) == '+') {
                        if (features[ifeat].length() > 4 && features[ifeat].substring(0, 4).equals("+MP=")) {
                            compatible = Grammar.perlMatch(lentry, features[ifeat].substring(4));
                            if (!compatible) {
                                break;
                            }
                        } else {
                            compatible = false;
                            if (lfeatures == null) break;
                            jfeat = 0;
                            while (jfeat < lfeatures.length) {
                                if (lfeatures[jfeat].equals(features[ifeat].substring(1))) {
                                    compatible = true;
                                    break;
                                }
                                index = lfeatures[jfeat].indexOf(61);
                                if (index != -1 && features[ifeat].substring(1) == lfeatures[jfeat].substring(index + 1)) {
                                    compatible = true;
                                    break;
                                }
                                ++jfeat;
                            }
                            if (!compatible) {
                                break;
                            }
                        }
                    } else {
                        compatible = true;
                        if (lfeatures == null) break;
                        jfeat = 0;
                        while (jfeat < lfeatures.length) {
                            if (lfeatures[jfeat].equals(features[ifeat].substring(1))) {
                                compatible = false;
                                break;
                            }
                            if (features[ifeat].length() > 5 && features[ifeat].substring(0, 4).equals("-MP=")) {
                                compatible = !Grammar.perlMatch(entry, features[ifeat].substring(4));
                            } else {
                                index = lfeatures[jfeat].indexOf(61);
                                if (index != -1 && features[ifeat].substring(1) == lfeatures[jfeat].substring(index + 1)) {
                                    compatible = false;
                                    break;
                                }
                            }
                            ++jfeat;
                        }
                        if (!compatible) break;
                    }
                    ++ifeat;
                }
                if (!compatible) {
                    sols.subList(i, 1 + i).clear();
                    continue;
                }
                ++i;
                continue;
            }
            if (category != null && !category.equals("DIC") && !category.equals(lcategory)) {
                ++i;
                continue;
            }
            if (lemma != null && !lemma.equals(llemma)) {
                ++i;
                continue;
            }
            if (features == null || features.length == 0) {
                sols.subList(i, 1 + i).clear();
                continue;
            }
            compatible = true;
            ifeat = 0;
            while (ifeat < features.length) {
                if (features[ifeat].charAt(0) == '+') {
                    compatible = false;
                    if (lfeatures == null) break;
                    jfeat = 0;
                    while (jfeat < lfeatures.length) {
                        if (lfeatures[jfeat].equals(features[ifeat].substring(1))) {
                            compatible = true;
                            break;
                        }
                        if (features[ifeat].length() > 5 && features[ifeat].substring(0, 4).equals("+MP=")) {
                            compatible = Grammar.perlMatch(entry, features[ifeat].substring(4));
                        }
                        ++jfeat;
                    }
                    if (!compatible) {
                        break;
                    }
                } else {
                    compatible = true;
                    if (lfeatures == null) break;
                    jfeat = 0;
                    while (jfeat < lfeatures.length) {
                        if (lfeatures[jfeat].equals(features[ifeat].substring(1))) {
                            compatible = false;
                            break;
                        }
                        if (features[ifeat].length() > 5 && features[ifeat].substring(0, 4).equals("-MP=")) {
                            compatible = !Grammar.perlMatch(entry, features[ifeat].substring(4));
                        }
                        ++jfeat;
                    }
                    if (!compatible) break;
                }
                ++ifeat;
            }
            if (compatible) {
                sols.subList(i, 1 + i).clear();
                continue;
            }
            ++i;
        }
    }

    static ArrayList<String> addBracketsAround(ArrayList<String> sols) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < sols.size()) {
            result.add("{" + sols.get(i) + "}");
            ++i;
        }
        return result;
    }

    private static ArrayList<String> transformConstraintIntoLU(ArrayList<String> sols) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < sols.size()) {
            String sol = sols.get(i);
            if (sol.charAt(0) == '<' || sol.charAt(0) == '{') {
                sol = sol.substring(1, 1 + sol.length() - 2);
            }
            String entry = null;
            String lemma = null;
            String category = null;
            String features = null;
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
            RefObject<Object> tempRef_category = new RefObject<Object>(category);
            RefObject<Object> tempRef_features = new RefObject<Object>(features);
            Dic.parseDELAF(sol, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
            entry = (String)tempRef_entry.argvalue;
            lemma = (String)tempRef_lemma.argvalue;
            category = (String)tempRef_category.argvalue;
            features = (String)tempRef_features.argvalue;
            if (entry == null || entry.equals("")) {
                entry = "NA";
            }
            result.add("<LU=" + entry + "," + lemma + "," + category + features + ">");
            ++i;
        }
        return result;
    }

    static ArrayList<String> transformConstraintIntoLUNoLU(ArrayList<String> sols) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < sols.size()) {
            String sol = sols.get(i);
            if (sol.charAt(0) == '<' || sol.charAt(0) == '{') {
                sol = sol.substring(1, 1 + sol.length() - 2);
            }
            String entry = null;
            String lemma = null;
            String category = null;
            String features = null;
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
            RefObject<Object> tempRef_category = new RefObject<Object>(category);
            RefObject<Object> tempRef_features = new RefObject<Object>(features);
            Dic.parseDELAF(sol, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
            entry = (String)tempRef_entry.argvalue;
            lemma = (String)tempRef_lemma.argvalue;
            category = (String)tempRef_category.argvalue;
            features = (String)tempRef_features.argvalue;
            if (entry == null || entry.equals("")) {
                entry = "NA";
            }
            result.add("<" + entry + "," + lemma + "," + category + features + ">");
            ++i;
        }
        return result;
    }

    public final ArrayList<ArrayList<String>> processConstraints(String tokenSequence, RefObject<String> errmessage) {
        ArrayList<ArrayList<String>> result = null;
        String[] tokens = this.iLan.parseSequenceOfTokens(tokenSequence);
        if (tokens == null) {
            errmessage.argvalue = "Invalid syntax in info '" + tokenSequence + "'";
            Dic.writeLog((String)errmessage.argvalue);
            return null;
        }
        int i = 0;
        while (i < tokens.length) {
            block20: {
                ArrayList<String> csols;
                block21: {
                    block19: {
                        String entry = null;
                        String lemma = null;
                        String category = null;
                        String[] features = null;
                        String op = null;
                        boolean negation = false;
                        if (!Dic.isALexicalConstraint(tokens[i])) break block19;
                        ArrayList<String> csols0 = null;
                        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                        RefObject<Object> tempRef_category = new RefObject<Object>(category);
                        RefObject<Object> tempRef_features = new RefObject<Object>(features);
                        RefObject<Object> tempRef_op = new RefObject<Object>(op);
                        RefObject<Boolean> tempRef_negation = new RefObject<Boolean>(negation);
                        boolean tempVar = !Dic.parseLexicalConstraint(tokens[i], tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features, tempRef_op, tempRef_negation);
                        entry = (String)tempRef_entry.argvalue;
                        lemma = (String)tempRef_lemma.argvalue;
                        category = (String)tempRef_category.argvalue;
                        features = (String[])tempRef_features.argvalue;
                        op = (String)tempRef_op.argvalue;
                        negation = (Boolean)tempRef_negation.argvalue;
                        if (tempVar) break block20;
                        if (!op.equals("=:")) {
                            errmessage.argvalue = "Morphological parser cannot process operator '" + op + "' in " + tokens[i];
                            Dic.writeLog((String)errmessage.argvalue);
                            return null;
                        }
                        if (category != null && category.length() >= 1) {
                            if (this.engine.recursiveMorphology == null) {
                                this.engine.recursiveMorphology = new HashMap();
                            } else if (this.engine.recursiveMorphology.containsKey(entry)) {
                                errmessage.argvalue = "Infinite recursivity while parsing '" + entry + "' for constraint '" + tokens[i] + "'";
                                Dic.writeLog((String)errmessage.argvalue);
                                return null;
                            }
                            this.engine.recursiveMorphology.put(entry, null);
                            csols0 = this.engine.lookupAllLexsAndMorphsForSimples(entry, false, entry, 0);
                            this.engine.recursiveMorphology.remove(entry);
                        } else if (lemma != null && lemma.length() >= 1) {
                            if (this.engine.recursiveMorphology == null) {
                                this.engine.recursiveMorphology = new HashMap();
                            } else if (this.engine.recursiveMorphology.containsKey(entry)) {
                                errmessage.argvalue = "Infinite recursivity while parsing '" + entry + "' for constraint '" + tokens[i] + "'";
                                Dic.writeLog((String)errmessage.argvalue);
                                return null;
                            }
                            this.engine.recursiveMorphology.put(entry, null);
                            csols0 = this.engine.lookupAllLexsAndMorphsForSimples(entry, false, entry, 0);
                            this.engine.recursiveMorphology.remove(entry);
                        } else {
                            errmessage.argvalue = "Constraint '" + tokens[i] + "' has no lemma nor category?";
                            Dic.writeLog((String)errmessage.argvalue);
                            return null;
                        }
                        if (csols0 == null || csols0.isEmpty()) {
                            errmessage.argvalue = "Cannot find lexical entry '" + entry + "' for constraint '" + tokens[i] + "'";
                            Dic.writeLog((String)errmessage.argvalue);
                            return null;
                        }
                        ArrayList<String> csols2 = new ArrayList<String>(csols0);
                        if (lemma != null || category != null) {
                            Grammar.filterConstraint(csols2, entry, lemma, category, features, negation);
                        }
                        if (csols2.isEmpty()) {
                            errmessage.argvalue = "Constraint '" + tokens[i] + "' is not satisfied";
                            Dic.writeLog((String)errmessage.argvalue);
                            return null;
                        }
                        csols = Grammar.transformConstraintIntoLU(csols2);
                        break block21;
                    }
                    if (tokens[i].charAt(0) == '<' || tokens[i].charAt(0) == '{') {
                        csols = new ArrayList<String>();
                        csols.add(tokens[i]);
                    } else {
                        csols = new ArrayList();
                        csols.add(tokens[i]);
                    }
                }
                if (result == null) {
                    result = new ArrayList<ArrayList<String>>();
                }
                result.add(csols);
            }
            ++i;
        }
        errmessage.argvalue = null;
        return result;
    }

    private void recDefact(ArrayList<String> prefix, ArrayList<ArrayList<String>> exp, ArrayList<ArrayList<String>> res) {
        if (exp.isEmpty()) {
            res.add(new ArrayList<String>(prefix));
        } else {
            ArrayList<String> fact = exp.get(0);
            int iterm = 0;
            while (iterm < fact.size()) {
                ArrayList<String> tmp = new ArrayList<String>(prefix);
                tmp.add(fact.get(iterm));
                ArrayList expSublist = new ArrayList();
                if (exp.size() == 1) {
                    expSublist = new ArrayList();
                } else if (exp.size() == 2) {
                    expSublist.add(exp.get(1));
                } else {
                    expSublist = (ArrayList)exp.subList(1, exp.size() - 1);
                }
                this.recDefact(tmp, expSublist, res);
                ++iterm;
            }
        }
    }

    public final ArrayList<ArrayList<String>> defactorize(ArrayList<ArrayList<String>> expression) {
        ArrayList<ArrayList<String>> res = new ArrayList<ArrayList<String>>();
        this.recDefact(new ArrayList<String>(), expression, res);
        return res;
    }

    final void xmlFilterMatches(ArrayList<String> lexs, ArrayList<Double> lengths, String[] symbols, RefObject<ArrayList<String>> reslex, RefObject<ArrayList<Double>> reslen) {
        reslex.argvalue = new ArrayList();
        reslen.argvalue = new ArrayList();
        String[] stringArray = symbols;
        int n = symbols.length;
        int n2 = 0;
        while (n2 < n) {
            String symbol = stringArray[n2];
            String entry = null;
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            String lemma = null;
            RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
            String category = null;
            RefObject<Object> tempRef_category = new RefObject<Object>(category);
            String[] features = null;
            RefObject<Object> tempRef_features = new RefObject<Object>(features);
            boolean negation = false;
            RefObject<Boolean> tempRef_negation = new RefObject<Boolean>(negation);
            boolean tempVar = !Dic.parseSymbolFeatureArray(symbol, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features, tempRef_negation);
            entry = (String)tempRef_entry.argvalue;
            lemma = (String)tempRef_lemma.argvalue;
            category = (String)tempRef_category.argvalue;
            features = (String[])tempRef_features.argvalue;
            negation = (Boolean)tempRef_negation.argvalue;
            if (!tempVar) {
                ArrayList sols = new ArrayList(lexs);
                ArrayList lens = new ArrayList(lengths);
                RefObject<ArrayList<String>> tempRef_sols = new RefObject<ArrayList<String>>(sols);
                RefObject<ArrayList<Double>> tempRef_lens = new RefObject<ArrayList<Double>>(lens);
                this.filterLexemes(tempRef_sols, tempRef_lens, lemma, category, features, negation);
                sols = (ArrayList)tempRef_sols.argvalue;
                lens = (ArrayList)tempRef_lens.argvalue;
                if (sols.size() > 0) {
                    ((ArrayList)reslex.argvalue).addAll(sols);
                    ((ArrayList)reslen.argvalue).addAll(lens);
                }
            }
            ++n2;
        }
    }

    public final boolean matchLexeme(String lexentry, String lexlemma, String lexcategory, String[] lexfeatures, String constraint) {
        String consentry = null;
        String conslemma = null;
        String conscategory = null;
        String[] consfeatures = null;
        boolean consnegation = false;
        RefObject<Object> tempRef_consentry = new RefObject<Object>(consentry);
        RefObject<Object> tempRef_conslemma = new RefObject<Object>(conslemma);
        RefObject<Object> tempRef_conscategory = new RefObject<Object>(conscategory);
        RefObject<Object> tempRef_consfeatures = new RefObject<Object>(consfeatures);
        RefObject<Boolean> tempRef_consnegation = new RefObject<Boolean>(consnegation);
        Dic.parseSymbolFeatureArray(constraint, tempRef_consentry, tempRef_conslemma, tempRef_conscategory, tempRef_consfeatures, tempRef_consnegation);
        consentry = (String)tempRef_consentry.argvalue;
        conslemma = (String)tempRef_conslemma.argvalue;
        conscategory = (String)tempRef_conscategory.argvalue;
        consfeatures = (String[])tempRef_consfeatures.argvalue;
        consnegation = (Boolean)tempRef_consnegation.argvalue;
        if (!consnegation) {
            if (consentry != null && !lexentry.equals(consentry)) {
                return false;
            }
            if (conslemma != null && !lexlemma.equals(conslemma)) {
                return false;
            }
            if (conscategory != null && !lexcategory.equals(conscategory)) {
                return false;
            }
            if (consfeatures != null) {
                boolean compatible = true;
                int ifeat = 0;
                while (ifeat < consfeatures.length) {
                    int index;
                    int jfeat;
                    if (consfeatures[ifeat].charAt(0) == '+') {
                        if (consfeatures[ifeat].length() > 4 && consfeatures[ifeat].substring(0, 4).equals("+MP=")) {
                            compatible = Grammar.perlMatch(lexentry, consfeatures[ifeat].substring(4));
                            if (!compatible) {
                                return false;
                            }
                        } else {
                            compatible = false;
                            if (lexfeatures != null) {
                                jfeat = 0;
                                while (jfeat < lexfeatures.length) {
                                    if (lexfeatures[jfeat].equals(consfeatures[ifeat])) {
                                        compatible = true;
                                        break;
                                    }
                                    index = lexfeatures[jfeat].indexOf(61);
                                    if (index != -1 && consfeatures[ifeat].substring(1) == lexfeatures[jfeat].substring(index + 1)) {
                                        compatible = true;
                                        break;
                                    }
                                    ++jfeat;
                                }
                            }
                            if (!compatible) {
                                return false;
                            }
                        }
                    } else if (consfeatures[ifeat].length() > 4 && consfeatures[ifeat].substring(0, 4).equals("-MP=")) {
                        boolean bl = compatible = !Grammar.perlMatch(lexentry, consfeatures[ifeat].substring(4));
                        if (!compatible) {
                            return false;
                        }
                    } else {
                        compatible = true;
                        if (lexfeatures != null) {
                            jfeat = 0;
                            while (jfeat < lexfeatures.length) {
                                if (consfeatures[ifeat].substring(1) == lexfeatures[jfeat].substring(1)) {
                                    compatible = false;
                                    return false;
                                }
                                index = lexfeatures[jfeat].indexOf(61);
                                if (index != -1 && consfeatures[ifeat].substring(1) == lexfeatures[jfeat].substring(index + 1)) {
                                    compatible = false;
                                    return false;
                                }
                                ++jfeat;
                            }
                        }
                        if (!compatible) {
                            return false;
                        }
                    }
                    ++ifeat;
                }
                if (!compatible) {
                    return false;
                }
            }
        }
        return true;
    }

    private final void filterLexemes(RefObject<ArrayList<String>> sols, RefObject<ArrayList<Double>> lens, String lemma, String category, String[] features, boolean negation) {
        String lentry = null;
        String llemma = null;
        String lcategory = null;
        String[] lfeatures = null;
        String[] lemmas = null;
        if (lemma != null) {
            if (hlemmas == null) {
                hlemmas = new HashMap();
            }
            if (hlemmas.containsKey(lemma)) {
                lemmas = hlemmas.get(lemma);
            } else if (lemma.equals("SYNTAX") && (lemmas = new String[]{"SYNTAX"}) != null) {
                hlemmas.put(lemma, (String[])lemmas.clone());
            }
        }
        int i = 0;
        while (i < ((ArrayList)sols.argvalue).size()) {
            int index;
            int jfeat;
            int ifeat;
            boolean compatible;
            int ilemma;
            boolean foundsuperlemma;
            RefObject<Object> tempRef_lentry = new RefObject<Object>(lentry);
            RefObject<Object> tempRef_llemma = new RefObject<Object>(llemma);
            RefObject<Object> tempRef_lcategory = new RefObject<Object>(lcategory);
            RefObject<Object> tempRef_lfeatures = new RefObject<Object>(lfeatures);
            Dic.parseDELAFFeatureArray((String)((ArrayList)sols.argvalue).get(i), tempRef_lentry, tempRef_llemma, tempRef_lcategory, tempRef_lfeatures);
            lentry = (String)tempRef_lentry.argvalue;
            llemma = (String)tempRef_llemma.argvalue;
            lcategory = (String)tempRef_lcategory.argvalue;
            lfeatures = (String[])tempRef_lfeatures.argvalue;
            if (!negation) {
                if (lemma != null) {
                    foundsuperlemma = false;
                    if (lemmas != null) {
                        ilemma = 0;
                        while (ilemma < lemmas.length) {
                            if (llemma.equals(lemmas[ilemma])) {
                                foundsuperlemma = true;
                                break;
                            }
                            ++ilemma;
                        }
                    }
                    if (!foundsuperlemma) {
                        ((ArrayList)sols.argvalue).subList(i, 1 + i).clear();
                        ((ArrayList)lens.argvalue).subList(i, 1 + i).clear();
                        continue;
                    }
                }
                if (category != null && category.equals("SYNTAX") && llemma != null && llemma.equals("SYNTAX")) {
                    ++i;
                    continue;
                }
                if (category != null && !category.equals("DIC") && !category.equals(lcategory)) {
                    ((ArrayList)sols.argvalue).subList(i, 1 + i).clear();
                    ((ArrayList)lens.argvalue).subList(i, 1 + i).clear();
                    continue;
                }
                if (features == null) {
                    ++i;
                    continue;
                }
                compatible = true;
                ifeat = 0;
                while (ifeat < features.length) {
                    if (features[ifeat].charAt(0) == '+') {
                        if (features[ifeat].length() > 4 && features[ifeat].substring(0, 4).equals("+MP=")) {
                            compatible = Grammar.perlMatch(lentry, features[ifeat].substring(4));
                            if (!compatible) {
                                break;
                            }
                        } else {
                            compatible = false;
                            if (lfeatures != null) {
                                jfeat = 0;
                                while (jfeat < lfeatures.length) {
                                    if (lfeatures[jfeat].equals(features[ifeat].substring(1))) {
                                        compatible = true;
                                        break;
                                    }
                                    index = lfeatures[jfeat].indexOf(61);
                                    if (index != -1) {
                                        if (features[ifeat].substring(1) == lfeatures[jfeat].substring(index + 1)) {
                                            compatible = true;
                                            break;
                                        }
                                        if (features[ifeat].substring(1) == lfeatures[jfeat].substring(0, index)) {
                                            compatible = true;
                                            break;
                                        }
                                    }
                                    ++jfeat;
                                }
                            }
                            if (!compatible) {
                                break;
                            }
                        }
                    } else if (features[ifeat].length() > 4 && features[ifeat].substring(0, 4).equals("-MP=")) {
                        boolean bl = compatible = !Grammar.perlMatch(lentry, features[ifeat].substring(4));
                        if (!compatible) {
                            break;
                        }
                    } else {
                        compatible = true;
                        if (lfeatures != null) {
                            jfeat = 0;
                            while (jfeat < lfeatures.length) {
                                if (lfeatures[jfeat].equals(features[ifeat].substring(1))) {
                                    compatible = false;
                                    break;
                                }
                                index = lfeatures[jfeat].indexOf(61);
                                if (index != -1) {
                                    if (features[ifeat].substring(1) == lfeatures[jfeat].substring(0, index)) {
                                        compatible = false;
                                        break;
                                    }
                                    if (features[ifeat].substring(1) == lfeatures[jfeat].substring(index + 1)) {
                                        compatible = false;
                                        break;
                                    }
                                }
                                ++jfeat;
                            }
                        }
                        if (!compatible) break;
                    }
                    ++ifeat;
                }
                if (!compatible) {
                    ((ArrayList)sols.argvalue).subList(i, 1 + i).clear();
                    ((ArrayList)lens.argvalue).subList(i, 1 + i).clear();
                    continue;
                }
                ++i;
                continue;
            }
            if (lemma != null) {
                foundsuperlemma = false;
                if (lemmas != null) {
                    ilemma = 0;
                    while (ilemma < lemmas.length) {
                        if (llemma.equals(lemmas[ilemma])) {
                            foundsuperlemma = true;
                            break;
                        }
                        ++ilemma;
                    }
                }
                if (!foundsuperlemma) {
                    ++i;
                    continue;
                }
            }
            if (category != null && !category.equals("DIC") && !category.equals(lcategory)) {
                ++i;
                continue;
            }
            if (features == null) {
                ((ArrayList)sols.argvalue).subList(i, 1 + i).clear();
                ((ArrayList)lens.argvalue).subList(i, 1 + i).clear();
                continue;
            }
            compatible = true;
            ifeat = 0;
            while (ifeat < features.length) {
                if (features[ifeat].charAt(0) == '+') {
                    if (features[ifeat].length() > 4 && features[ifeat].substring(0, 4).equals("+MP=")) {
                        compatible = Grammar.perlMatch(lentry, features[ifeat].substring(4));
                        if (!compatible) {
                            break;
                        }
                    } else {
                        compatible = false;
                        if (lfeatures != null) {
                            jfeat = 0;
                            while (jfeat < lfeatures.length) {
                                if (lfeatures[jfeat].equals(features[ifeat].substring(1))) {
                                    compatible = true;
                                    break;
                                }
                                index = lfeatures[jfeat].indexOf(61);
                                if (index != -1) {
                                    if (features[ifeat].substring(1) == lfeatures[jfeat].substring(0, index)) {
                                        compatible = true;
                                        break;
                                    }
                                    if (features[ifeat].substring(1) == lfeatures[jfeat].substring(index + 1)) {
                                        compatible = true;
                                        break;
                                    }
                                }
                                ++jfeat;
                            }
                        }
                        if (!compatible) {
                            break;
                        }
                    }
                } else if (features[ifeat].length() > 4 && features[ifeat].substring(0, 4).equals("-MP=")) {
                    boolean bl = compatible = !Grammar.perlMatch(lentry, features[ifeat].substring(4));
                    if (!compatible) {
                        break;
                    }
                } else {
                    compatible = true;
                    if (lfeatures != null) {
                        jfeat = 0;
                        while (jfeat < lfeatures.length) {
                            if (lfeatures[jfeat].equals(features[ifeat].substring(1))) {
                                compatible = false;
                                break;
                            }
                            index = lfeatures[jfeat].indexOf(61);
                            if (index != -1) {
                                if (features[ifeat].substring(1) == lfeatures[jfeat].substring(0, index)) {
                                    compatible = false;
                                    break;
                                }
                                if (features[ifeat].substring(1) == lfeatures[jfeat].substring(index + 1)) {
                                    compatible = false;
                                    break;
                                }
                            }
                            ++jfeat;
                        }
                    }
                    if (!compatible) break;
                }
                ++ifeat;
            }
            if (compatible) {
                ((ArrayList)sols.argvalue).subList(i, 1 + i).clear();
                ((ArrayList)lens.argvalue).subList(i, 1 + i).clear();
                continue;
            }
            ++i;
        }
    }

    final void filterLexemes(RefObject<ArrayList<String>> sols, String lemma, String category, String[] features, boolean negation) {
        String lentry = null;
        String llemma = null;
        String lcategory = null;
        String[] lfeatures = null;
        String[] lemmas = null;
        if (lemma != null) {
            if (hlemmas == null) {
                hlemmas = new HashMap();
            }
            if (hlemmas.containsKey(lemma)) {
                lemmas = hlemmas.get(lemma);
            }
        }
        int i = 0;
        while (i < ((ArrayList)sols.argvalue).size()) {
            int index;
            int jfeat;
            int ifeat;
            boolean compatible;
            int ilemma;
            boolean foundsuperlemma;
            RefObject<Object> tempRef_lentry = new RefObject<Object>(lentry);
            RefObject<Object> tempRef_llemma = new RefObject<Object>(llemma);
            RefObject<Object> tempRef_lcategory = new RefObject<Object>(lcategory);
            RefObject<Object> tempRef_lfeatures = new RefObject<Object>(lfeatures);
            Dic.parseDELAFFeatureArray((String)((ArrayList)sols.argvalue).get(i), tempRef_lentry, tempRef_llemma, tempRef_lcategory, tempRef_lfeatures);
            lentry = (String)tempRef_lentry.argvalue;
            llemma = (String)tempRef_llemma.argvalue;
            lcategory = (String)tempRef_lcategory.argvalue;
            lfeatures = (String[])tempRef_lfeatures.argvalue;
            if (!negation) {
                if (lemma != null) {
                    foundsuperlemma = false;
                    if (lemmas != null) {
                        ilemma = 0;
                        while (ilemma < lemmas.length) {
                            if (llemma.equals(lemmas[ilemma])) {
                                foundsuperlemma = true;
                                break;
                            }
                            ++ilemma;
                        }
                    }
                    if (!foundsuperlemma) {
                        ((ArrayList)sols.argvalue).subList(i, 1 + i).clear();
                        continue;
                    }
                }
                if (category != null && !category.equals("DIC") && !category.equals(lcategory)) {
                    ((ArrayList)sols.argvalue).subList(i, 1 + i).clear();
                    continue;
                }
                if (features == null) {
                    ++i;
                    continue;
                }
                compatible = true;
                ifeat = 0;
                while (ifeat < features.length) {
                    if (features[ifeat].charAt(0) == '+') {
                        if (features[ifeat].length() > 4 && features[ifeat].substring(0, 4).equals("+MP=")) {
                            compatible = Grammar.perlMatch(lentry, features[ifeat].substring(4));
                            if (!compatible) {
                                break;
                            }
                        } else {
                            compatible = false;
                            if (lfeatures != null) {
                                jfeat = 0;
                                while (jfeat < lfeatures.length) {
                                    if (lfeatures[jfeat].equals(features[ifeat].substring(1))) {
                                        compatible = true;
                                        break;
                                    }
                                    index = lfeatures[jfeat].indexOf(61);
                                    if (index != -1) {
                                        if (features[ifeat].substring(1) == lfeatures[jfeat].substring(0, index)) {
                                            compatible = true;
                                            break;
                                        }
                                        if (features[ifeat].substring(1) == lfeatures[jfeat].substring(index + 1)) {
                                            compatible = true;
                                            break;
                                        }
                                    }
                                    ++jfeat;
                                }
                            }
                            if (!compatible) {
                                break;
                            }
                        }
                    } else if (features[ifeat].length() > 4 && features[ifeat].substring(0, 4).equals("-MP=")) {
                        boolean bl = compatible = !Grammar.perlMatch(lentry, features[ifeat].substring(4));
                        if (!compatible) {
                            break;
                        }
                    } else {
                        compatible = true;
                        if (lfeatures != null) {
                            jfeat = 0;
                            while (jfeat < lfeatures.length) {
                                if (lfeatures[jfeat].equals(features[ifeat].substring(1))) {
                                    compatible = false;
                                    break;
                                }
                                index = lfeatures[jfeat].indexOf(61);
                                if (index != -1) {
                                    if (features[ifeat].substring(1) == lfeatures[jfeat].substring(0, index)) {
                                        compatible = false;
                                        break;
                                    }
                                    if (features[ifeat].substring(1) == lfeatures[jfeat].substring(index + 1)) {
                                        compatible = false;
                                        break;
                                    }
                                }
                                ++jfeat;
                            }
                        }
                        if (!compatible) break;
                    }
                    ++ifeat;
                }
                if (!compatible) {
                    ((ArrayList)sols.argvalue).subList(i, 1 + i).clear();
                    continue;
                }
                ++i;
                continue;
            }
            if (lemma != null) {
                foundsuperlemma = false;
                if (lemmas != null) {
                    ilemma = 0;
                    while (ilemma < lemmas.length) {
                        if (llemma.equals(lemmas[ilemma])) {
                            foundsuperlemma = true;
                            break;
                        }
                        ++ilemma;
                    }
                }
                if (!foundsuperlemma) {
                    ++i;
                    continue;
                }
            }
            if (category != null && !category.equals("DIC") && !category.equals(lcategory)) {
                ++i;
                continue;
            }
            if (features == null) {
                ((ArrayList)sols.argvalue).subList(i, 1 + i).clear();
                continue;
            }
            compatible = true;
            ifeat = 0;
            while (ifeat < features.length) {
                if (features[ifeat].charAt(0) == '+') {
                    if (features[ifeat].length() > 4 && features[ifeat].substring(0, 4).equals("+MP=")) {
                        compatible = Grammar.perlMatch(lentry, features[ifeat].substring(4));
                        if (!compatible) {
                            break;
                        }
                    } else {
                        compatible = false;
                        if (lfeatures != null) {
                            jfeat = 0;
                            while (jfeat < lfeatures.length) {
                                if (lfeatures[jfeat].equals(features[ifeat].substring(1))) {
                                    compatible = true;
                                    break;
                                }
                                index = lfeatures[jfeat].indexOf(61);
                                if (index != -1) {
                                    if (features[ifeat].substring(1) == lfeatures[jfeat].substring(0, index)) {
                                        compatible = true;
                                        break;
                                    }
                                    if (features[ifeat].substring(1) == lfeatures[jfeat].substring(index + 1)) {
                                        compatible = true;
                                        break;
                                    }
                                }
                                ++jfeat;
                            }
                        }
                        if (!compatible) {
                            break;
                        }
                    }
                } else if (features[ifeat].length() > 4 && features[ifeat].substring(0, 4).equals("-MP=")) {
                    boolean bl = compatible = !Grammar.perlMatch(lentry, features[ifeat].substring(4));
                    if (!compatible) {
                        break;
                    }
                } else {
                    compatible = true;
                    if (lfeatures != null) {
                        jfeat = 0;
                        while (jfeat < lfeatures.length) {
                            if (lfeatures[jfeat].equals(features[ifeat].substring(1))) {
                                compatible = false;
                                break;
                            }
                            index = lfeatures[jfeat].indexOf(61);
                            if (index != -1) {
                                if (features[ifeat].substring(1) == lfeatures[jfeat].substring(0, index)) {
                                    compatible = false;
                                    break;
                                }
                                if (features[ifeat].substring(1) == lfeatures[jfeat].substring(index + 1)) {
                                    compatible = false;
                                    break;
                                }
                            }
                            ++jfeat;
                        }
                    }
                    if (!compatible) break;
                }
                ++ifeat;
            }
            if (compatible) {
                ((ArrayList)sols.argvalue).subList(i, 1 + i).clear();
                continue;
            }
            ++i;
        }
    }

    private final void filterNonMatches(RefObject<ArrayList<String>> sols, RefObject<ArrayList<Double>> lens, String lemma, String category, String[] features) {
        String lentry = null;
        String llemma = null;
        String lcategory = null;
        String[] lfeatures = null;
        int i = 0;
        while (i < ((ArrayList)sols.argvalue).size()) {
            RefObject<Object> tempRef_lentry = new RefObject<Object>(lentry);
            RefObject<Object> tempRef_llemma = new RefObject<Object>(llemma);
            RefObject<Object> tempRef_lcategory = new RefObject<Object>(lcategory);
            RefObject<Object> tempRef_lfeatures = new RefObject<Object>(lfeatures);
            Dic.parseDELAFFeatureArray((String)((ArrayList)sols.argvalue).get(i), tempRef_lentry, tempRef_llemma, tempRef_lcategory, tempRef_lfeatures);
            lentry = (String)tempRef_lentry.argvalue;
            llemma = (String)tempRef_llemma.argvalue;
            lcategory = (String)tempRef_lcategory.argvalue;
            lfeatures = (String[])tempRef_lfeatures.argvalue;
            if (lemma != null && !lemma.equals(llemma)) {
                ++i;
                continue;
            }
            if (category != null) {
                if (category.equals("UNK")) {
                    ++i;
                    continue;
                }
                if (!category.equals("DIC") && !category.equals(lcategory)) {
                    ++i;
                    continue;
                }
            }
            if (features == null) {
                sols.argvalue = null;
                lens.argvalue = null;
                return;
            }
            boolean compatible = true;
            int ifeat = 0;
            while (ifeat < features.length) {
                int jfeat;
                if (features[ifeat].charAt(0) == '+') {
                    compatible = false;
                    if (lfeatures != null) {
                        jfeat = 0;
                        while (jfeat < lfeatures.length) {
                            if (lfeatures[jfeat].equals(features[ifeat].substring(1))) {
                                compatible = true;
                                break;
                            }
                            if (features[ifeat].length() > 5 && features[ifeat].substring(0, 4).equals("+MP=")) {
                                compatible = Grammar.perlMatch(lentry, features[ifeat].substring(4));
                            }
                            ++jfeat;
                        }
                    }
                    if (!compatible) {
                        break;
                    }
                } else {
                    compatible = true;
                    if (lfeatures != null) {
                        jfeat = 0;
                        while (jfeat < lfeatures.length) {
                            if (lfeatures[jfeat].equals(features[ifeat].substring(1))) {
                                compatible = false;
                                break;
                            }
                            if (features[ifeat].length() > 5 && features[ifeat].substring(0, 4).equals("-MP=")) {
                                compatible = !Grammar.perlMatch(lentry, features[ifeat].substring(4));
                            }
                            ++jfeat;
                        }
                    }
                    if (!compatible) break;
                }
                ++ifeat;
            }
            if (!compatible) {
                ++i;
                continue;
            }
            sols.argvalue = null;
            lens.argvalue = null;
            return;
        }
    }

    private boolean thereIsPlusUnambIn(String[] features) {
        if (features == null) {
            return false;
        }
        int i = 0;
        while (i < features.length) {
            if (features[i].equals("+UNAMB")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean thereIsMinusUnambIn(String[] features) {
        if (features == null) {
            return false;
        }
        int i = 0;
        while (i < features.length) {
            if (features[i].equals("-UNAMB")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String[] removeUnamb(String[] features) {
        ArrayList<String> ares = new ArrayList<String>();
        int i = 0;
        while (i < features.length) {
            if (!features[i].equals("-UNAMB") && !features[i].equals("+UNAMB")) {
                ares.add(features[i]);
            }
            ++i;
        }
        if (ares.size() > 0) {
            return ares.toArray(new String[ares.size()]);
        }
        return null;
    }

    private int matchlexeme(String lemma, String category, String[] features, String text, double cpos, int tunb, Mft textmft, ArrayList<Object> annotations, RefObject<ArrayList<Double>> lengths, RefObject<ArrayList<ArrayList<Double>>> inputs, RefObject<ArrayList<ArrayList<String>>> variables) {
        lengths.argvalue = null;
        inputs.argvalue = null;
        variables.argvalue = null;
        ArrayList lens = null;
        ArrayList lexids = null;
        RefObject<Object> tempRef_lexids = new RefObject<Object>(lexids);
        RefObject<Object> tempRef_lens = new RefObject<Object>(lens);
        int da = textmft.getAllLexIds(tunb, cpos, tempRef_lexids, tempRef_lens);
        lexids = (ArrayList)tempRef_lexids.argvalue;
        lens = (ArrayList)tempRef_lens.argvalue;
        if (da == 0) {
            if (category != null && category.equals("UNK")) {
                double length = 0.0;
                while (cpos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)(cpos + length)))) {
                    length += 1.0;
                }
                if (length == 0.0) {
                    return 0;
                }
                lengths.argvalue = new ArrayList();
                ((ArrayList)lengths.argvalue).add(length);
                ArrayList<Double> input = new ArrayList<Double>();
                input.add(cpos);
                inputs.argvalue = new ArrayList();
                ((ArrayList)inputs.argvalue).add(input);
                ArrayList<Object> variable = new ArrayList<Object>();
                variable.add(null);
                variables.argvalue = new ArrayList();
                ((ArrayList)variables.argvalue).add(variable);
                return 1;
            }
            return 0;
        }
        if (this.thereIsPlusUnambIn(features)) {
            if (da > 1) {
                return 0;
            }
            features = this.removeUnamb(features);
        } else if (this.thereIsMinusUnambIn(features)) {
            if (da == 1) {
                return 0;
            }
            features = this.removeUnamb(features);
        }
        ArrayList sols = new ArrayList();
        int i = 0;
        while (i < da) {
            String lex;
            int tkid = (Integer)lexids.get(i);
            if (tkid < annotations.size() && (lex = (String)annotations.get(tkid)) != null) {
                sols.add(lex);
            }
            ++i;
        }
        RefObject<ArrayList<String>> tempRef_sols = null;
        RefObject<ArrayList<Double>> tempRef_lens2 = null;
        if (da > 0) {
            tempRef_sols = new RefObject<ArrayList<String>>(sols);
            tempRef_lens2 = new RefObject<ArrayList<Double>>(lens);
            this.filterLexemes(tempRef_sols, tempRef_lens2, lemma, category, features, false);
        }
        sols = (ArrayList)tempRef_sols.argvalue;
        lens = (ArrayList)tempRef_lens2.argvalue;
        if (sols == null) {
            return 0;
        }
        if (sols.size() > 0) {
            inputs.argvalue = new ArrayList();
            variables.argvalue = new ArrayList();
            lengths.argvalue = new ArrayList();
            int i2 = 0;
            while (i2 < sols.size()) {
                ArrayList<Double> input = new ArrayList<Double>();
                input.add(cpos);
                ((ArrayList)inputs.argvalue).add(input);
                ArrayList<String> variable = new ArrayList<String>();
                variable.add((String)sols.get(i2));
                ((ArrayList)variables.argvalue).add(variable);
                long hund_len = (long)(100.0 * (Double)lens.get(i2));
                double len = (double)hund_len / 100.0;
                ((ArrayList)lengths.argvalue).add(len);
                ++i2;
            }
        }
        return sols.size();
    }

    private int dontMatchlexeme(String lemma, String category, String[] features, String text, double cpos, int startaddr, Mft textmft, ArrayList<Object> annotations, RefObject<ArrayList<Double>> lengths, RefObject<ArrayList<ArrayList<Double>>> inputs, RefObject<ArrayList<ArrayList<String>>> variables) {
        lengths.argvalue = null;
        inputs.argvalue = null;
        variables.argvalue = null;
        ArrayList lens = null;
        ArrayList lexids = null;
        double ipos = cpos;
        RefObject<Object> tempRef_lexids = new RefObject<Object>(lexids);
        RefObject<Object> tempRef_lens = new RefObject<Object>(lens);
        int da = textmft.getAllLexIds(startaddr, ipos, tempRef_lexids, tempRef_lens);
        lexids = (ArrayList)tempRef_lexids.argvalue;
        lens = (ArrayList)tempRef_lens.argvalue;
        if (da == 0 && !category.equals("UNK")) {
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            if (length == 0.0) {
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length += ipos - cpos);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (this.thereIsPlusUnambIn(features)) {
            if (da > 1) {
                return 0;
            }
            features = this.removeUnamb(features);
        } else if (this.thereIsMinusUnambIn(features)) {
            if (da == 1) {
                return 0;
            }
            features = this.removeUnamb(features);
        }
        ArrayList sols = new ArrayList();
        int i = 0;
        while (i < da) {
            int tkid = (Integer)lexids.get(i);
            String lex = (String)annotations.get(tkid);
            if (lex != null) {
                sols.add(lex);
            }
            ++i;
        }
        RefObject<ArrayList<String>> tempRef_sols = null;
        RefObject<ArrayList<Double>> tempRef_lens2 = null;
        if (da > 0) {
            tempRef_sols = new RefObject<ArrayList<String>>(sols);
            tempRef_lens2 = new RefObject<ArrayList<Double>>(lens);
            this.filterNonMatches(tempRef_sols, tempRef_lens2, lemma, category, features);
        }
        sols = (ArrayList)tempRef_sols.argvalue;
        lens = (ArrayList)tempRef_lens2.argvalue;
        if (sols == null) {
            return 0;
        }
        if (sols.size() > 0) {
            inputs.argvalue = new ArrayList();
            variables.argvalue = new ArrayList();
            lengths.argvalue = new ArrayList();
            int i2 = 0;
            while (i2 < sols.size()) {
                ArrayList<Double> input = new ArrayList<Double>();
                input.add(cpos);
                ((ArrayList)inputs.argvalue).add(input);
                ArrayList<String> variable = new ArrayList<String>();
                variable.add((String)sols.get(i2));
                ((ArrayList)variables.argvalue).add(variable);
                ((ArrayList)lengths.argvalue).add((Double)lens.get(i2));
                ++i2;
            }
        }
        return sols.size();
    }

    /*
     * Unable to fully structure code
     */
    static boolean skipSpaces(String text, RefObject<Double> dpos, boolean xmltext) {
        block7: {
            ipos = (int)((Double)dpos.argvalue).doubleValue();
            if (!xmltext) ** GOTO lbl19
            while (ipos < text.length() && (Character.isWhitespace(text.charAt(ipos)) || text.charAt(ipos) == '<')) {
                if (Character.isWhitespace(text.charAt(ipos))) {
                    while (ipos < text.length() && Character.isWhitespace(text.charAt(ipos))) {
                        ++ipos;
                    }
                }
                if (ipos >= text.length() || text.charAt(ipos) != '<') continue;
                while (ipos < text.length() && text.charAt(ipos) != '>') {
                    ++ipos;
                }
                ++ipos;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                if (!Character.isWhitespace(text.charAt(ipos))) continue;
                while (ipos < text.length() && Character.isWhitespace(text.charAt(ipos))) {
                    ++ipos;
                }
lbl19:
                // 3 sources

                ** while (ipos < text.length() && Character.isWhitespace((char)text.charAt((int)ipos)))
            }
        }
        if (ipos > (int)((Double)dpos.argvalue).doubleValue()) {
            dpos.argvalue = (double)ipos;
        }
        return ipos < text.length();
    }

    private int syntaxMatchSymbol(String ilabel, String text, double cpos, int tunb, Mft textmft, ArrayList<Object> annotations, RefObject<ArrayList<Double>> lengths, RefObject<ArrayList<ArrayList<Double>>> inputs, RefObject<ArrayList<ArrayList<String>>> variables, boolean xmltext) {
        int isol;
        int k;
        int match = 0;
        double ipos = cpos;
        RefObject<Double> tempRef_ipos = new RefObject<Double>(ipos);
        boolean tempVar = !Grammar.skipSpaces(text, tempRef_ipos, xmltext);
        ipos = (Double)tempRef_ipos.argvalue;
        if (tempVar) {
            inputs.argvalue = null;
            variables.argvalue = null;
            lengths.argvalue = null;
            return 0;
        }
        String entry = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        String lemma = null;
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        String category = null;
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        String[] features = null;
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        boolean negation = false;
        RefObject<Boolean> tempRef_negation = new RefObject<Boolean>(negation);
        boolean tempVar2 = !Dic.parseSymbolFeatureArray(ilabel, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features, tempRef_negation);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        negation = (Boolean)tempRef_negation.argvalue;
        if (tempVar2) {
            inputs.argvalue = null;
            variables.argvalue = null;
            lengths.argvalue = null;
            return 0;
        }
        if (lemma != null && (lemma.equals("^") || lemma.equals("$")) && category == null) {
            category = lemma;
        }
        String[] pfeatures = null;
        if (features != null) {
            pfeatures = Grammar.extractPerlQueries(features);
        }
        if (pfeatures != null && pfeatures.length > 0) {
            int plen = 0;
            if (this.iLan.asianTokenizer) {
                plen = 1;
            } else if (Character.isDigit(text.charAt((int)ipos)) && category.equals("NB")) {
                plen = 0;
                while (ipos + (double)plen < (double)text.length() && Character.isDigit(text.charAt((int)ipos + plen))) {
                    ++plen;
                }
            } else if (Language.isLetter(text.charAt((int)ipos))) {
                plen = 0;
                while (ipos + (double)plen < (double)text.length() && Language.isLetter(text.charAt((int)ipos + plen))) {
                    ++plen;
                }
            } else {
                plen = 1;
            }
            String tok = text.substring((int)ipos, (int)ipos + plen);
            int iperl = 0;
            while (iperl < pfeatures.length) {
                boolean pm = Grammar.perlMatch(tok, pfeatures[iperl].substring(4));
                if (pfeatures[iperl].charAt(0) == '+' && !pm) {
                    inputs.argvalue = null;
                    variables.argvalue = null;
                    lengths.argvalue = null;
                    return 0;
                }
                if (pfeatures[iperl].charAt(0) == '-' && pm) {
                    inputs.argvalue = null;
                    variables.argvalue = null;
                    lengths.argvalue = null;
                    return 0;
                }
                ++iperl;
            }
            features = Grammar.removePerlQueries(features);
        }
        if (category != null && category.equals("WF")) {
            double length;
            String token;
            if (this.iLan.asianTokenizer) {
                if (Language.isLetter(text.charAt((int)ipos))) {
                    token = text.substring((int)ipos, (int)ipos + 1);
                    length = 1.0;
                } else {
                    token = "";
                    length = 0.0;
                }
            } else {
                length = 0.0;
                while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                    length += 1.0;
                }
                token = text.substring((int)ipos, (int)ipos + (int)length);
            }
            if (length == 0.0) {
                inputs.argvalue = null;
                variables.argvalue = null;
                lengths.argvalue = null;
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length += ipos - cpos);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<String> variable = new ArrayList<String>();
            variable.add(String.valueOf(token) + "," + token + "," + "WF");
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category != null && category.equals("^")) {
            k = (int)ipos - 1;
            while (k > 0) {
                if (!Character.isWhitespace(text.charAt(k))) {
                    inputs.argvalue = null;
                    variables.argvalue = null;
                    lengths.argvalue = null;
                    return 0;
                }
                --k;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(0.0);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category != null && category.equals("$")) {
            k = (int)ipos;
            while (k < text.length()) {
                if (!Character.isWhitespace(text.charAt(k))) {
                    inputs.argvalue = null;
                    variables.argvalue = null;
                    lengths.argvalue = null;
                    return 0;
                }
                ++k;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(0.0);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category != null && category.equals("UPP")) {
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            String token = text.substring((int)ipos, (int)ipos + (int)length);
            length += ipos - cpos;
            if (!Language.isUpper(token)) {
                inputs.argvalue = null;
                variables.argvalue = null;
                lengths.argvalue = null;
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<String> variable = new ArrayList<String>();
            variable.add(String.valueOf(token) + "," + token + "," + "UPP");
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category != null && category.equals("U")) {
            if (this.iLan.isoName.equals("ja")) {
                double length;
                String token;
                if (Language.isUniHan(text.charAt((int)ipos))) {
                    token = text.substring((int)ipos, (int)ipos + 1);
                    length = 1.0;
                } else {
                    token = "";
                    length = 0.0;
                }
                length += ipos - cpos;
                if (token.length() != 1) {
                    inputs.argvalue = null;
                    variables.argvalue = null;
                    lengths.argvalue = null;
                    return 0;
                }
                lengths.argvalue = new ArrayList();
                ((ArrayList)lengths.argvalue).add(length);
                ArrayList<Double> input = new ArrayList<Double>();
                input.add(ipos);
                inputs.argvalue = new ArrayList();
                ((ArrayList)inputs.argvalue).add(input);
                ArrayList<String> variable = new ArrayList<String>();
                variable.add(String.valueOf(token) + "," + token + "," + "L");
                variables.argvalue = new ArrayList();
                ((ArrayList)variables.argvalue).add(variable);
                return 1;
            }
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            String token = text.substring((int)ipos, (int)ipos + (int)length);
            length += ipos - cpos;
            if (!Language.isUpper(token) || token.length() != 1) {
                inputs.argvalue = null;
                variables.argvalue = null;
                lengths.argvalue = null;
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<String> variable = new ArrayList<String>();
            variable.add(String.valueOf(token) + "," + token + "," + "U");
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category != null && category.equals("H")) {
            if (this.iLan.isoName.equals("ja")) {
                double length;
                String token;
                if (Language.isHiragana(text.charAt((int)ipos))) {
                    token = text.substring((int)ipos, (int)ipos + 1);
                    length = 1.0;
                } else {
                    token = "";
                    length = 0.0;
                }
                length += ipos - cpos;
                if (token.length() != 1) {
                    inputs.argvalue = null;
                    variables.argvalue = null;
                    lengths.argvalue = null;
                    return 0;
                }
                lengths.argvalue = new ArrayList();
                ((ArrayList)lengths.argvalue).add(length);
                ArrayList<Double> input = new ArrayList<Double>();
                input.add(ipos);
                inputs.argvalue = new ArrayList();
                ((ArrayList)inputs.argvalue).add(input);
                ArrayList<String> variable = new ArrayList<String>();
                variable.add(String.valueOf(token) + "," + token + "," + "L");
                variables.argvalue = new ArrayList();
                ((ArrayList)variables.argvalue).add(variable);
                return 1;
            }
            match = this.matchlexeme(lemma, category, features, text, ipos, tunb, textmft, annotations, lengths, inputs, variables);
            if (match == 0) {
                return 0;
            }
            isol = 0;
            while (isol < ((ArrayList)lengths.argvalue).size()) {
                double len = (Double)((ArrayList)lengths.argvalue).get(isol);
                ((ArrayList)lengths.argvalue).set(isol, len + ipos - cpos);
                ++isol;
            }
            return match;
        }
        if (category != null && category.equals("K")) {
            if (this.iLan.isoName.equals("ja")) {
                double length;
                String token;
                if (Language.isKatakana(text.charAt((int)ipos))) {
                    token = text.substring((int)ipos, (int)ipos + 1);
                    length = 1.0;
                } else {
                    token = "";
                    length = 0.0;
                }
                length += ipos - cpos;
                if (token.length() != 1) {
                    inputs.argvalue = null;
                    variables.argvalue = null;
                    lengths.argvalue = null;
                    return 0;
                }
                lengths.argvalue = new ArrayList();
                ((ArrayList)lengths.argvalue).add(length);
                ArrayList<Double> input = new ArrayList<Double>();
                input.add(ipos);
                inputs.argvalue = new ArrayList();
                ((ArrayList)inputs.argvalue).add(input);
                ArrayList<String> variable = new ArrayList<String>();
                variable.add(String.valueOf(token) + "," + token + "," + "L");
                variables.argvalue = new ArrayList();
                ((ArrayList)variables.argvalue).add(variable);
                return 1;
            }
            match = this.matchlexeme(lemma, category, features, text, ipos, tunb, textmft, annotations, lengths, inputs, variables);
            if (match == 0) {
                return 0;
            }
            isol = 0;
            while (isol < ((ArrayList)lengths.argvalue).size()) {
                double len = (Double)((ArrayList)lengths.argvalue).get(isol);
                ((ArrayList)lengths.argvalue).set(isol, len + ipos - cpos);
                ++isol;
            }
            return match;
        }
        if (category != null && category.equals("L")) {
            double length;
            String token;
            if (this.iLan.asianTokenizer) {
                if (Language.isLetter(text.charAt((int)ipos))) {
                    token = text.substring((int)ipos, (int)ipos + 1);
                    length = 1.0;
                } else {
                    token = "";
                    length = 0.0;
                }
            } else {
                length = 0.0;
                while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                    length += 1.0;
                }
                token = text.substring((int)ipos, (int)ipos + (int)length);
            }
            length += ipos - cpos;
            if (token.length() != 1) {
                inputs.argvalue = null;
                variables.argvalue = null;
                lengths.argvalue = null;
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<String> variable = new ArrayList<String>();
            variable.add(String.valueOf(token) + "," + token + "," + "L");
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category != null && category.equals("W")) {
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            String token = text.substring((int)ipos, (int)ipos + (int)length);
            length += ipos - cpos;
            if (!Language.isLower(token) || token.length() != 1) {
                inputs.argvalue = null;
                variables.argvalue = null;
                lengths.argvalue = null;
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<String> variable = new ArrayList<String>();
            variable.add(String.valueOf(token) + "," + token + "," + "W");
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category != null && category.equals("LOW")) {
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            String token = text.substring((int)ipos, (int)ipos + (int)length);
            length += ipos - cpos;
            if (!Language.isLower(token)) {
                inputs.argvalue = null;
                variables.argvalue = null;
                lengths.argvalue = null;
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<String> variable = new ArrayList<String>();
            variable.add(String.valueOf(token) + "," + token + "," + "LOW");
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category != null && category.equals("CAP")) {
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            String token = text.substring((int)ipos, (int)ipos + (int)length);
            length += ipos - cpos;
            if (!Language.isCapital(token)) {
                inputs.argvalue = null;
                variables.argvalue = null;
                lengths.argvalue = null;
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<String> variable = new ArrayList<String>();
            variable.add(String.valueOf(token) + "," + token + "," + "CAP");
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category != null && category.equals("P")) {
            int n = match = ipos < (double)text.length() && !Language.isLetter(text.charAt((int)ipos)) && !Character.isDigit(text.charAt((int)ipos)) ? 1 : 0;
            if (match == 0) {
                inputs.argvalue = null;
                variables.argvalue = null;
                lengths.argvalue = null;
                return 0;
            }
            String token = text.substring((int)ipos, (int)ipos + 1);
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(1.0 + ipos - cpos);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<String> variable = new ArrayList<String>();
            variable.add(String.valueOf(token) + "," + token + "," + "P");
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category != null && category.equals("D")) {
            int n = match = ipos < (double)text.length() && Character.isDigit(text.charAt((int)ipos)) ? 1 : 0;
            if (match == 0) {
                inputs.argvalue = null;
                variables.argvalue = null;
                lengths.argvalue = null;
                return 0;
            }
            String token = text.substring((int)ipos, (int)ipos + 1);
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(1.0 + ipos - cpos);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<String> variable = new ArrayList<String>();
            variable.add(String.valueOf(token) + "," + token + "," + "D");
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category != null && category.equals("NB")) {
            int n = match = ipos < (double)text.length() && Character.isDigit(text.charAt((int)ipos)) ? 1 : 0;
            if (match == 0) {
                inputs.argvalue = null;
                variables.argvalue = null;
                lengths.argvalue = null;
                return 0;
            }
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Character.isDigit(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            String token = text.substring((int)ipos, (int)ipos + (int)length);
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length + ipos - cpos);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<String> variable = new ArrayList<String>();
            variable.add(String.valueOf(token) + "," + token + "," + "NB");
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        match = this.matchlexeme(lemma, category, features, text, ipos, tunb, textmft, annotations, lengths, inputs, variables);
        if (match == 0) {
            return 0;
        }
        isol = 0;
        while (isol < ((ArrayList)lengths.argvalue).size()) {
            double len = (Double)((ArrayList)lengths.argvalue).get(isol);
            ((ArrayList)lengths.argvalue).set(isol, len + ipos - cpos);
            ++isol;
        }
        return match;
    }

    private int syntaxDontMatchSymbol(String ilabel, String text, double cpos, int startaddr, Mft textmft, ArrayList<Object> annotations, RefObject<ArrayList<Double>> lengths, RefObject<ArrayList<ArrayList<Double>>> inputs, RefObject<ArrayList<ArrayList<String>>> variables, boolean xmltext) {
        boolean foundanonspace;
        int match = 0;
        inputs.argvalue = null;
        variables.argvalue = null;
        lengths.argvalue = null;
        double ipos = cpos;
        RefObject<Double> tempRef_ipos = new RefObject<Double>(ipos);
        boolean tempVar = !Grammar.skipSpaces(text, tempRef_ipos, xmltext);
        ipos = (Double)tempRef_ipos.argvalue;
        if (tempVar) {
            return 0;
        }
        String entry = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        String lemma = null;
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        String category = null;
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        String[] features = null;
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        boolean negation = false;
        RefObject<Boolean> tempRef_negation = new RefObject<Boolean>(negation);
        boolean tempVar2 = !Dic.parseSymbolFeatureArray(ilabel, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features, tempRef_negation);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        negation = (Boolean)tempRef_negation.argvalue;
        if (tempVar2) {
            return 0;
        }
        String[] pfeatures = null;
        if (features != null) {
            pfeatures = Grammar.extractPerlQueries(features);
        }
        if (pfeatures != null && pfeatures.length > 0) {
            int plen;
            if (this.iLan.asianTokenizer) {
                plen = 1;
            } else if (Character.isDigit(text.charAt((int)ipos)) && category.equals("NB")) {
                plen = 0;
                while (ipos + (double)plen < (double)text.length() && Character.isDigit(text.charAt((int)ipos + plen))) {
                    ++plen;
                }
            } else if (Language.isLetter(text.charAt((int)ipos))) {
                plen = 0;
                while (ipos + (double)plen < (double)text.length() && Language.isLetter(text.charAt((int)ipos + plen))) {
                    ++plen;
                }
            } else {
                plen = 1;
            }
            String tok = text.substring((int)ipos, (int)ipos + plen);
            int iperl = 0;
            while (iperl < pfeatures.length) {
                boolean pm = Grammar.perlMatch(tok, pfeatures[iperl].substring(4));
                if (features[iperl].charAt(0) == '+' && pm) {
                    return 0;
                }
                if (features[iperl].charAt(0) == '-' && !pm) {
                    return 0;
                }
                ++iperl;
            }
            features = Grammar.removePerlQueries(features);
        }
        if (category.equals("WF")) {
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            if (length > 0.0 && (pfeatures == null || pfeatures.length == 0)) {
                return 0;
            }
            String token = text.substring((int)ipos, (int)ipos + (int)length);
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length += ipos - cpos);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category.equals("^")) {
            foundanonspace = false;
            int k = (int)ipos - 1;
            while (k > 0) {
                if (!Character.isWhitespace(text.charAt(k))) {
                    foundanonspace = true;
                    break;
                }
                --k;
            }
            if (!foundanonspace) {
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(0.0);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category.equals("$")) {
            foundanonspace = false;
            int k = (int)ipos;
            while (k < text.length()) {
                if (!Character.isWhitespace(text.charAt(k))) {
                    foundanonspace = true;
                    break;
                }
                ++k;
            }
            if (!foundanonspace) {
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(0.0);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category.equals("UPP")) {
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            String token = text.substring((int)ipos, (int)ipos + (int)length);
            length += ipos - cpos;
            if (Language.isUpper(token) && (pfeatures == null || pfeatures.length == 0)) {
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category.equals("U")) {
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            String token = text.substring((int)ipos, (int)ipos + (int)length);
            length += ipos - cpos;
            if (Language.isUpper(token) && token.length() == 1 && (pfeatures == null || pfeatures.length == 0)) {
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category.equals("L")) {
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            String token = text.substring((int)ipos, (int)ipos + (int)length);
            length += ipos - cpos;
            if (token.length() == 1 && (pfeatures == null || pfeatures.length == 0)) {
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category.equals("W")) {
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            String token = text.substring((int)ipos, (int)ipos + (int)length);
            length += ipos - cpos;
            if (Language.isLower(token) && token.length() == 1 && (pfeatures == null || pfeatures.length == 0)) {
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category.equals("LOW")) {
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            String token = text.substring((int)ipos, (int)ipos + (int)length);
            length += ipos - cpos;
            if (Language.isLower(token) && (pfeatures == null || pfeatures.length == 0)) {
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category.equals("CAP")) {
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            String token = text.substring((int)ipos, (int)ipos + (int)length);
            length += ipos - cpos;
            if (Language.isCapital(token) && (pfeatures == null || pfeatures.length == 0)) {
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category.equals("P")) {
            int n = match = ipos < (double)text.length() && !Language.isLetter(text.charAt((int)ipos)) && !Character.isDigit(text.charAt((int)ipos)) ? 1 : 0;
            if (match == 1 && (pfeatures == null || pfeatures.length == 0)) {
                return 0;
            }
            String token = text.substring((int)ipos, (int)ipos + 1);
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(1.0 + ipos - cpos);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category.equals("D")) {
            int n = match = ipos < (double)text.length() && Character.isDigit(text.charAt((int)ipos)) ? 1 : 0;
            if (match == 1 && (pfeatures == null || pfeatures.length == 0)) {
                return 0;
            }
            String token = text.substring((int)ipos, (int)ipos + 1);
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(1.0 + ipos - cpos);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (category.equals("NB")) {
            int n = match = ipos < (double)text.length() && Character.isDigit(text.charAt((int)ipos)) ? 1 : 0;
            if (match == 1 && (pfeatures == null || pfeatures.length == 0)) {
                return 0;
            }
            double length = 0.0;
            while (ipos + (double)((int)length) < (double)text.length() && Character.isDigit(text.charAt((int)ipos + (int)length))) {
                length += 1.0;
            }
            String token = text.substring((int)ipos, (int)ipos + (int)length);
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length + ipos - cpos);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(ipos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<Object> variable = new ArrayList<Object>();
            variable.add(null);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        match = this.dontMatchlexeme(lemma, category, features, text, ipos, startaddr, textmft, annotations, lengths, inputs, variables);
        if (match > 0) {
            int isol = 0;
            while (isol < ((ArrayList)lengths.argvalue).size()) {
                double len = (Double)((ArrayList)lengths.argvalue).get(isol);
                ((ArrayList)lengths.argvalue).set(isol, len + ipos - cpos);
                ++isol;
            }
        }
        return match;
    }

    private int syntaxMatchTermLabel(String ilabel, String text, double cpos, double cposafterspaces, int tunb, Mft textmft, ArrayList<Object> annotations, RefObject<ArrayList<Double>> lengths, RefObject<ArrayList<ArrayList<Double>>> inputs, RefObject<ArrayList<ArrayList<String>>> variables, boolean xmltext) {
        int match;
        if (ilabel.charAt(0) == '<') {
            if (ilabel.length() == 3 && ilabel.charAt(1) == 'E' && ilabel.charAt(2) == '>') {
                lengths.argvalue = new ArrayList();
                ((ArrayList)lengths.argvalue).add(0.0);
                ArrayList<Double> input = new ArrayList<Double>();
                input.add(cpos);
                inputs.argvalue = new ArrayList();
                ((ArrayList)inputs.argvalue).add(input);
                ArrayList<Object> variable = new ArrayList<Object>();
                variable.add(null);
                variables.argvalue = new ArrayList();
                ((ArrayList)variables.argvalue).add(variable);
                return 1;
            }
        } else if (ilabel.charAt(0) == '$' && ilabel.length() >= 2 && (ilabel.charAt(1) == '(' || ilabel.charAt(1) == ')')) {
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(0.0);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(cpos);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<String> variable = new ArrayList<String>();
            variable.add(ilabel);
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (cpos >= (double)text.length()) {
            if (ilabel.equals("<$>")) {
                lengths.argvalue = new ArrayList();
                ((ArrayList)lengths.argvalue).add(1.0);
                ArrayList<Double> input = new ArrayList<Double>();
                input.add(cpos);
                inputs.argvalue = new ArrayList();
                ((ArrayList)inputs.argvalue).add(input);
                ArrayList<String> variable = new ArrayList<String>();
                variable.add("END,WF");
                variables.argvalue = new ArrayList();
                ((ArrayList)variables.argvalue).add(variable);
                return 1;
            }
            inputs.argvalue = null;
            variables.argvalue = null;
            lengths.argvalue = null;
            return 0;
        }
        if (ilabel.charAt(0) == '#' && ilabel.length() == 1) {
            inputs.argvalue = null;
            variables.argvalue = null;
            lengths.argvalue = null;
            if (Character.isWhitespace(text.charAt((int)cpos))) {
                return 0;
            }
            return 1;
        }
        if (ilabel.charAt(0) == '<') {
            if (ilabel.charAt(1) == '!') {
                return this.syntaxDontMatchSymbol(ilabel, text, cpos, tunb, textmft, annotations, lengths, inputs, variables, xmltext);
            }
            return this.syntaxMatchSymbol(ilabel, text, cpos, tunb, textmft, annotations, lengths, inputs, variables, xmltext);
        }
        if (Language.isLetter(ilabel.charAt(0))) {
            int match2;
            double length;
            String token = ilabel;
            if (cposafterspaces >= (double)text.length()) {
                inputs.argvalue = null;
                variables.argvalue = null;
                lengths.argvalue = null;
                return 0;
            }
            if (this.iLan.asianTokenizer) {
                length = 1.0;
                match2 = text.charAt((int)cposafterspaces) == ilabel.charAt(0) ? 1 : 0;
            } else {
                length = 0.0;
                while (cposafterspaces + (double)((int)length) < (double)text.length() && Language.isLetter(text.charAt((int)cposafterspaces + (int)length))) {
                    length += 1.0;
                }
                token = text.substring((int)cposafterspaces, (int)cposafterspaces + (int)length);
                match2 = this.iLan.doWordFormsMatch(token, ilabel) ? 1 : 0;
            }
            length += cposafterspaces - cpos;
            if (match2 != 0) {
                lengths.argvalue = new ArrayList();
                ((ArrayList)lengths.argvalue).add(length);
                ArrayList<Double> input = new ArrayList<Double>();
                input.add(cposafterspaces);
                inputs.argvalue = new ArrayList();
                ((ArrayList)inputs.argvalue).add(input);
                ArrayList<String> variable = new ArrayList<String>();
                variable.add(String.valueOf(token) + ",WF");
                variables.argvalue = new ArrayList();
                ((ArrayList)variables.argvalue).add(variable);
            } else {
                inputs.argvalue = null;
                variables.argvalue = null;
                lengths.argvalue = null;
            }
            return match2;
        }
        if (ilabel.charAt(0) == '\"') {
            int i;
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < ilabel.length()) {
                if (ilabel.charAt(i2) == ',') {
                    sb.append("\\,");
                } else {
                    sb.append(ilabel.charAt(i2));
                }
                ++i2;
            }
            String token = sb.toString();
            if (Character.isWhitespace(ilabel.charAt(1))) {
                if (cpos >= (double)text.length()) {
                    inputs.argvalue = null;
                    variables.argvalue = null;
                    lengths.argvalue = null;
                    return 0;
                }
                i = 0;
                while (i < ilabel.length() - 2) {
                    if (cpos + (double)i >= (double)text.length()) {
                        inputs.argvalue = null;
                        variables.argvalue = null;
                        lengths.argvalue = null;
                        return 0;
                    }
                    if (text.charAt((int)cpos + i) != ilabel.charAt(i + 1)) {
                        inputs.argvalue = null;
                        variables.argvalue = null;
                        lengths.argvalue = null;
                        return 0;
                    }
                    ++i;
                }
                double length = (int)((double)(ilabel.length() - 2) + cposafterspaces - cpos);
                lengths.argvalue = new ArrayList();
                ((ArrayList)lengths.argvalue).add(length + cposafterspaces - cpos);
                ArrayList<Double> input = new ArrayList<Double>();
                input.add(cposafterspaces);
                inputs.argvalue = new ArrayList();
                ((ArrayList)inputs.argvalue).add(input);
                ArrayList<String> variable = new ArrayList<String>();
                variable.add(String.valueOf(token) + ",WF");
                variables.argvalue = new ArrayList();
                ((ArrayList)variables.argvalue).add(variable);
                return 1;
            }
            if (Character.isLetter(ilabel.charAt(1)) && Character.isLetter(ilabel.charAt(ilabel.length() - 2))) {
                if (cposafterspaces + (double)ilabel.length() - 2.0 < (double)text.length() && Character.isLetter(text.charAt((int)cposafterspaces + ilabel.length() - 2))) {
                    inputs.argvalue = null;
                    variables.argvalue = null;
                    lengths.argvalue = null;
                    return 0;
                }
                i = 0;
                while (i < ilabel.length() - 2) {
                    if (cposafterspaces + (double)i >= (double)text.length()) {
                        inputs.argvalue = null;
                        variables.argvalue = null;
                        lengths.argvalue = null;
                        return 0;
                    }
                    if (text.charAt((int)cposafterspaces + i) != ilabel.charAt(i + 1)) {
                        inputs.argvalue = null;
                        variables.argvalue = null;
                        lengths.argvalue = null;
                        return 0;
                    }
                    ++i;
                }
            } else if (!Character.isWhitespace(ilabel.charAt(1))) {
                if (cposafterspaces >= (double)text.length()) {
                    inputs.argvalue = null;
                    variables.argvalue = null;
                    lengths.argvalue = null;
                    return 0;
                }
                i = 0;
                while (i < ilabel.length() - 2) {
                    if (cposafterspaces + (double)i >= (double)text.length()) {
                        inputs.argvalue = null;
                        variables.argvalue = null;
                        lengths.argvalue = null;
                        return 0;
                    }
                    if (text.charAt((int)cposafterspaces + i) != ilabel.charAt(i + 1)) {
                        inputs.argvalue = null;
                        variables.argvalue = null;
                        lengths.argvalue = null;
                        return 0;
                    }
                    ++i;
                }
            }
            double length = (int)((double)(ilabel.length() - 2) + cposafterspaces - cpos);
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(length + cposafterspaces - cpos);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(cposafterspaces);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<String> variable = new ArrayList<String>();
            variable.add(String.valueOf(token) + ",WF");
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return 1;
        }
        if (ilabel.charAt(0) == '\\') {
            int match3;
            String token = ilabel;
            if (!Character.isWhitespace(ilabel.charAt(1)) && cposafterspaces >= (double)text.length()) {
                inputs.argvalue = null;
                variables.argvalue = null;
                lengths.argvalue = null;
                return 0;
            }
            int n = match3 = text.charAt((int)cposafterspaces) == ilabel.charAt(1) ? 1 : 0;
            if (match3 == 0) {
                inputs.argvalue = null;
                variables.argvalue = null;
                lengths.argvalue = null;
                return 0;
            }
            lengths.argvalue = new ArrayList();
            ((ArrayList)lengths.argvalue).add(1.0 + cposafterspaces - cpos);
            ArrayList<Double> input = new ArrayList<Double>();
            input.add(cposafterspaces);
            inputs.argvalue = new ArrayList();
            ((ArrayList)inputs.argvalue).add(input);
            ArrayList<String> variable = new ArrayList<String>();
            variable.add(String.valueOf(token) + ",WF");
            variables.argvalue = new ArrayList();
            ((ArrayList)variables.argvalue).add(variable);
            return match3;
        }
        String token = ilabel.equals(",") ? "\\," : ilabel;
        if (cposafterspaces >= (double)text.length()) {
            inputs.argvalue = null;
            variables.argvalue = null;
            lengths.argvalue = null;
            return 0;
        }
        int n = match = text.charAt((int)cposafterspaces) == ilabel.charAt(0) ? 1 : 0;
        if (match == 0) {
            inputs.argvalue = null;
            variables.argvalue = null;
            lengths.argvalue = null;
            return 0;
        }
        lengths.argvalue = new ArrayList();
        ((ArrayList)lengths.argvalue).add(1.0 + cposafterspaces - cpos);
        ArrayList<Double> input = new ArrayList<Double>();
        input.add(cposafterspaces);
        inputs.argvalue = new ArrayList();
        ((ArrayList)inputs.argvalue).add(input);
        ArrayList<String> variable = new ArrayList<String>();
        variable.add(String.valueOf(token) + ",WF");
        variables.argvalue = new ArrayList();
        ((ArrayList)variables.argvalue).add(variable);
        return match;
    }

    private int syntaxMatchLabel(int graphnode, String ilabel, String olabel, String text, double cpos, double cposafterspaces, int tunb, Mft textmft, ArrayList<Object> annotations, RefObject<ArrayList<Double>> lengths, RefObject<ArrayList<ArrayList<Double>>> inputs, RefObject<ArrayList<ArrayList<String>>> variables, RefObject<ArrayList<ArrayList<String>>> outputs, RefObject<ArrayList<ArrayList<Object>>> nodes, boolean xmltext, ArrayList<String> recursiveCalls, Gram currentgram) {
        lengths.argvalue = null;
        inputs.argvalue = null;
        variables.argvalue = null;
        outputs.argvalue = null;
        nodes.argvalue = null;
        if (ilabel.charAt(0) == ':' || ilabel.charAt(0) == '$' && ilabel.length() >= 2 && ilabel.charAt(1) != '(' && ilabel.charAt(1) != ')') {
            String graphname = ilabel.substring(1);
            Gram grm = null;
            if (!this.grams.containsKey(graphname)) {
                grm = currentgram.getGramFromVariableDefinition(graphname);
                this.grams.put(graphname, grm);
            } else {
                grm = this.grams.get(graphname);
            }
            if (this.nbOfRecursiveCalls(ilabel, recursiveCalls) > 10) {
                return 0;
            }
            if (grm == null) {
                Graph grf = null;
                if (this.graphs != null) {
                    int i = 0;
                    while (i < this.graphs.size()) {
                        Graph cgrf = this.graphs.get(i);
                        if (cgrf != null && cgrf.name.equals(graphname)) {
                            grf = cgrf;
                            break;
                        }
                        ++i;
                    }
                }
                if (grf != null) {
                    ArrayList<String> aVocab = new ArrayList<String>();
                    aVocab.add("<E>");
                    HashMap<String, Integer> hVocab = new HashMap<String, Integer>();
                    hVocab.put("<E>", 0);
                    grm = grf.compile(this.iLan, this.gramType, aVocab, hVocab, this.engine);
                    if (grm != null) {
                        grm.vocab = aVocab;
                        hVocab = null;
                        grm.prepareForParsing();
                    }
                    this.grams.put(grf.name, grm);
                } else {
                    return 0;
                }
            }
            if (this.nbOfRecursiveCalls(ilabel, recursiveCalls) > 3) {
                return 0;
            }
            recursiveCalls.add(ilabel);
            int da = this.syntaxMatch(graphname, graphnode, text, cpos, tunb, textmft, annotations, grm, lengths, inputs, variables, outputs, nodes, MatchType.ALL, false, xmltext, recursiveCalls);
            recursiveCalls.remove(recursiveCalls.size() - 1);
            if (da > 0) {
                int isol = 0;
                while (isol < da) {
                    ArrayList i2 = (ArrayList)((ArrayList)inputs.argvalue).get(isol);
                    i2.add(0, cpos);
                    ArrayList v2 = (ArrayList)((ArrayList)variables.argvalue).get(isol);
                    v2.add(0, null);
                    ArrayList o2 = (ArrayList)((ArrayList)outputs.argvalue).get(isol);
                    o2.add(0, olabel);
                    ArrayList n2 = (ArrayList)((ArrayList)nodes.argvalue).get(isol);
                    n2.add(0, graphnode);
                    ++isol;
                }
            }
            return da;
        }
        int da = this.syntaxMatchTermLabel(ilabel, text, cpos, cposafterspaces, tunb, textmft, annotations, lengths, inputs, variables, xmltext);
        if (da > 0) {
            outputs.argvalue = new ArrayList();
            ArrayList<String> o2 = new ArrayList<String>();
            o2.add(olabel);
            nodes.argvalue = new ArrayList();
            ArrayList<Integer> n2 = new ArrayList<Integer>();
            n2.add(graphnode);
            int isol = 0;
            while (isol < da) {
                ((ArrayList)outputs.argvalue).add(o2);
                ((ArrayList)nodes.argvalue).add(n2);
                ++isol;
            }
        }
        return da;
    }

    private int syntaxMatchSequenceOfLabels(int graphnode, String ilabel, String[] ilabels, String olabel, String text, double cpos, double cposafterspaces, int tunb, Mft textmft, ArrayList<Object> annotations, RefObject<ArrayList<Double>> lengths, RefObject<ArrayList<ArrayList<Double>>> inputs, RefObject<ArrayList<ArrayList<String>>> variables, RefObject<ArrayList<ArrayList<String>>> outputs, RefObject<ArrayList<ArrayList<Object>>> nodes, boolean xmltext, ArrayList<String> recursiveCalls) {
        Gram grm;
        lengths.argvalue = null;
        inputs.argvalue = null;
        variables.argvalue = null;
        outputs.argvalue = null;
        nodes.argvalue = null;
        if (!this.grams.containsKey(ilabel)) {
            Gram grm0 = null;
            ArrayList<String> aVocab = new ArrayList<String>();
            aVocab.add("<E>");
            HashMap<String, Integer> hVocab = new HashMap<String, Integer>();
            hVocab.put("<E>", 0);
            if (ilabels.length == 1) {
                grm0 = new Gram(2);
                grm0.addTransition(0, 1, ilabels[ilabels.length - 1], aVocab, hVocab);
            } else {
                grm0 = new Gram(ilabels.length + 1);
                int src = 0;
                int dst = 2;
                int itok = 0;
                while (itok < ilabels.length - 1) {
                    grm0.addTransition(src, dst, ilabels[itok], aVocab, hVocab);
                    src = dst++;
                    ++itok;
                }
                grm0.addTransition(src, 1, ilabels[ilabels.length - 1], aVocab, hVocab);
            }
            grm0.vocab = aVocab;
            grm0.prepareForParsing();
            this.grams.put(ilabel, grm0);
        }
        if ((grm = this.grams.get(ilabel)) == null) {
            return 0;
        }
        if (this.nbOfRecursiveCalls(ilabel, recursiveCalls) > 3) {
            return 0;
        }
        recursiveCalls.add(ilabel);
        int da = this.syntaxMatch(ilabel, graphnode, text, cpos, tunb, textmft, annotations, grm, lengths, inputs, variables, outputs, nodes, MatchType.ALL, false, xmltext, recursiveCalls);
        recursiveCalls.remove(recursiveCalls.size() - 1);
        if (da > 0) {
            int isol = 0;
            while (isol < da) {
                ArrayList i2 = (ArrayList)((ArrayList)inputs.argvalue).get(isol);
                i2.add(0, cpos);
                ArrayList v2 = (ArrayList)((ArrayList)variables.argvalue).get(isol);
                v2.add(0, null);
                ArrayList o2 = (ArrayList)((ArrayList)outputs.argvalue).get(isol);
                o2.add(0, olabel);
                ArrayList n2 = (ArrayList)((ArrayList)nodes.argvalue).get(isol);
                n2.add(0, graphnode);
                ++isol;
            }
        }
        return da;
    }

    private int syntaxFailureMatchLabel(int graphnode, String ilabel, String olabel, String text, double cpos, double cposafterspaces, int tunb, Mft textmft, ArrayList<Object> annotations, RefObject<ArrayList<Double>> lengths, RefObject<ArrayList<ArrayList<Double>>> inputs, RefObject<ArrayList<ArrayList<String>>> variables, RefObject<ArrayList<ArrayList<String>>> outputs, RefObject<ArrayList<ArrayList<Object>>> nodes, boolean xmltext, ArrayList<String> recursiveCalls, Gram currentgram) {
        lengths.argvalue = null;
        inputs.argvalue = null;
        variables.argvalue = null;
        outputs.argvalue = null;
        nodes.argvalue = null;
        if (ilabel.charAt(0) == ':' || ilabel.charAt(0) == '$' && ilabel.length() >= 2 && ilabel.charAt(1) != '(' && ilabel.charAt(1) != ')') {
            String graphname = ilabel.substring(1);
            Gram grm = null;
            if (!this.grams.containsKey(graphname)) {
                grm = currentgram.getGramFromVariableDefinition(graphname);
                this.grams.put(graphname, grm);
            } else {
                grm = this.grams.get(graphname);
            }
            if (grm == null) {
                Graph grf = null;
                if (this.graphs != null) {
                    int i = 0;
                    while (i < this.graphs.size()) {
                        Graph cgrf = this.graphs.get(i);
                        if (cgrf != null && cgrf.name.equals(graphname)) {
                            grf = cgrf;
                            break;
                        }
                        ++i;
                    }
                }
                if (grf != null) {
                    ArrayList<String> aVocab = new ArrayList<String>();
                    aVocab.add("<E>");
                    HashMap<String, Integer> hVocab = new HashMap<String, Integer>();
                    hVocab.put("<E>", 0);
                    grm = grf.compile(this.iLan, this.gramType, aVocab, hVocab, this.engine);
                    if (grm != null) {
                        grm.vocab = aVocab;
                        hVocab = null;
                        grm.prepareForParsing();
                    }
                    this.grams.put(grf.name, grm);
                } else {
                    return 0;
                }
            }
            if (this.nbOfRecursiveCalls(ilabel, recursiveCalls) > 3) {
                return 0;
            }
            recursiveCalls.add(ilabel);
            int da = this.syntaxMatch(graphname, graphnode, text, cpos, tunb, textmft, annotations, grm, lengths, inputs, variables, outputs, nodes, MatchType.ALL, false, xmltext, recursiveCalls);
            recursiveCalls.remove(recursiveCalls.size() - 1);
            if (da == 0) {
                recursiveCalls.add(ilabel);
                da = this.failureSyntaxMatch(graphname, graphnode, text, cpos, tunb, textmft, annotations, grm, lengths, inputs, variables, outputs, nodes, MatchType.LONGEST, false, xmltext, recursiveCalls);
                da *= -1;
                recursiveCalls.remove(recursiveCalls.size() - 1);
            }
            if (da != 0) {
                int isol = 0;
                while (isol < Math.abs(da)) {
                    ArrayList i2 = (ArrayList)((ArrayList)inputs.argvalue).get(isol);
                    i2.add(0, cpos);
                    ArrayList v2 = (ArrayList)((ArrayList)variables.argvalue).get(isol);
                    v2.add(0, null);
                    ArrayList o2 = (ArrayList)((ArrayList)outputs.argvalue).get(isol);
                    o2.add(0, olabel);
                    ArrayList n2 = (ArrayList)((ArrayList)nodes.argvalue).get(isol);
                    n2.add(0, graphnode);
                    ++isol;
                }
            }
            return da;
        }
        int da = this.syntaxMatchTermLabel(ilabel, text, cpos, cposafterspaces, tunb, textmft, annotations, lengths, inputs, variables, xmltext);
        if (da > 0) {
            outputs.argvalue = new ArrayList();
            ArrayList<String> o2 = new ArrayList<String>();
            o2.add(olabel);
            nodes.argvalue = new ArrayList();
            ArrayList<Integer> n2 = new ArrayList<Integer>();
            n2.add(graphnode);
            int isol = 0;
            while (isol < da) {
                ((ArrayList)outputs.argvalue).add(o2);
                ((ArrayList)nodes.argvalue).add(n2);
                ++isol;
            }
        }
        return da;
    }

    private int syntaxFailureMatchSequenceOfLabels(int graphnode, String ilabel, String[] ilabels, String olabel, String text, double cpos, double cposafterspaces, int tunb, Mft textmft, ArrayList<Object> annotations, RefObject<ArrayList<Double>> lengths, RefObject<ArrayList<ArrayList<Double>>> inputs, RefObject<ArrayList<ArrayList<String>>> variables, RefObject<ArrayList<ArrayList<String>>> outputs, RefObject<ArrayList<ArrayList<Object>>> nodes, boolean xmltext, ArrayList<String> recursiveCalls) {
        Gram grm;
        lengths.argvalue = null;
        inputs.argvalue = null;
        variables.argvalue = null;
        outputs.argvalue = null;
        nodes.argvalue = null;
        if (!this.grams.containsKey(ilabel)) {
            Gram grm0 = null;
            ArrayList<String> aVocab = new ArrayList<String>();
            aVocab.add("<E>");
            HashMap<String, Integer> hVocab = new HashMap<String, Integer>();
            hVocab.put("<E>", 0);
            if (ilabels.length == 1) {
                grm0 = new Gram(2);
                grm0.addTransition(0, 1, ilabels[ilabels.length - 1], aVocab, hVocab);
            } else {
                grm0 = new Gram(ilabels.length + 1);
                int src = 0;
                int dst = 2;
                int itok = 0;
                while (itok < ilabels.length - 1) {
                    grm0.addTransition(src, dst, ilabels[itok], aVocab, hVocab);
                    src = dst++;
                    ++itok;
                }
                grm0.addTransition(src, 1, ilabels[ilabels.length - 1], aVocab, hVocab);
            }
            grm0.vocab = aVocab;
            grm0.prepareForParsing();
            this.grams.put(ilabel, grm0);
        }
        if ((grm = this.grams.get(ilabel)) == null) {
            return 0;
        }
        recursiveCalls.add(ilabel);
        int da = this.syntaxMatch(ilabel, graphnode, text, cpos, tunb, textmft, annotations, grm, lengths, inputs, variables, outputs, nodes, MatchType.ALL, false, xmltext, recursiveCalls);
        recursiveCalls.remove(recursiveCalls.size() - 1);
        if (da == 0) {
            recursiveCalls.add(ilabel);
            da = this.failureSyntaxMatch(ilabel, graphnode, text, cpos, tunb, textmft, annotations, grm, lengths, inputs, variables, outputs, nodes, MatchType.LONGEST, false, xmltext, recursiveCalls);
            da *= -1;
            recursiveCalls.remove(recursiveCalls.size() - 1);
        }
        if (da != 0) {
            int isol = 0;
            while (isol < Math.abs(da)) {
                ArrayList i2 = (ArrayList)((ArrayList)inputs.argvalue).get(isol);
                i2.add(0, cpos);
                ArrayList v2 = (ArrayList)((ArrayList)variables.argvalue).get(isol);
                v2.add(0, null);
                ArrayList o2 = (ArrayList)((ArrayList)outputs.argvalue).get(isol);
                o2.add(0, olabel);
                ArrayList n2 = (ArrayList)((ArrayList)nodes.argvalue).get(isol);
                n2.add(0, graphnode);
                ++isol;
            }
        }
        return da;
    }

    private int nbOfRecursiveCalls(String gname, ArrayList<String> recursivecalls) {
        int nb = 0;
        for (String cgname : recursivecalls) {
            if (!gname.equals(cgname)) continue;
            ++nb;
        }
        return nb;
    }

    private boolean alreadyThereFailure(ArrayList<Double> lengths, double length, ArrayList<ArrayList<Double>> positions, ArrayList<Double> position, ArrayList<ArrayList<String>> variables, ArrayList<String> variable, ArrayList<ArrayList<String>> outputs, ArrayList<String> output) {
        if (lengths == null || lengths.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < lengths.size()) {
            block11: {
                block14: {
                    ArrayList<String> o;
                    block13: {
                        ArrayList<String> v;
                        block12: {
                            ArrayList<Double> p;
                            double l = lengths.get(i);
                            if (length != l || (p = positions.get(i)) == null && position != null || p != null && position == null) break block11;
                            if (position == null) break block12;
                            if (position.size() != p.size()) break block11;
                            boolean identical = true;
                            int j = 0;
                            while (j < position.size()) {
                                double cp = p.get(j);
                                double cposition = position.get(j);
                                if (cposition != cp) {
                                    identical = false;
                                    break;
                                }
                                ++j;
                            }
                            if (!identical) break block11;
                        }
                        if ((v = variables.get(i)) == null && variable != null || v != null && variable == null) break block11;
                        if (variable == null) break block13;
                        if (variable.size() != v.size()) break block11;
                        boolean identical = true;
                        int j = 0;
                        while (j < variable.size()) {
                            String cvariable;
                            String cv = v.get(j);
                            if (!cv.equals(cvariable = variable.get(j))) {
                                identical = false;
                                break;
                            }
                            ++j;
                        }
                        if (!identical) break block11;
                    }
                    if ((o = outputs.get(i)) == null && output != null || o != null && output == null) break block11;
                    if (output == null) break block14;
                    if (output.size() != o.size()) break block11;
                    boolean identical = true;
                    int j = 0;
                    while (j < output.size()) {
                        String coutput;
                        String co = o.get(j);
                        if (!co.equals(coutput = output.get(j))) {
                            identical = false;
                            break;
                        }
                        ++j;
                    }
                    if (!identical) break block11;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean alreadyThere(ArrayList<Double> lengths, double length, ArrayList<ArrayList<Double>> positions, ArrayList<Double> position, ArrayList<ArrayList<String>> variables, ArrayList<String> variable, ArrayList<ArrayList<String>> outputs, ArrayList<String> output, ArrayList<ArrayList<Object>> nodes, ArrayList<Object> node) {
        if (lengths == null || lengths.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < lengths.size()) {
            block18: {
                block22: {
                    ArrayList<Object> n;
                    block21: {
                        ArrayList<String> o;
                        block20: {
                            ArrayList<String> v;
                            block19: {
                                ArrayList<Double> p;
                                double l = lengths.get(i);
                                if (length != l || (p = positions.get(i)) == null && position != null || p != null && position == null) break block18;
                                if (position == null) break block19;
                                if (position.size() != p.size()) break block18;
                                boolean identical = true;
                                int j = 0;
                                while (j < position.size()) {
                                    double cp = p.get(j);
                                    double cposition = position.get(j);
                                    if (cposition != cp) {
                                        identical = false;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!identical) break block18;
                            }
                            if ((v = variables.get(i)) == null && variable != null || v != null && variable == null) break block18;
                            if (variable == null) break block20;
                            if (variable.size() != v.size()) break block18;
                            boolean identical = true;
                            int j = 0;
                            while (j < variable.size()) {
                                String cv = v.get(j);
                                String cvariable = variable.get(j);
                                if (cv != null && cvariable == null || cv == null && cvariable != null || cv != null && cvariable != null && !cv.equals(cvariable)) {
                                    identical = false;
                                    break;
                                }
                                ++j;
                            }
                            if (!identical) break block18;
                        }
                        if ((o = outputs.get(i)) == null && output != null || o != null && output == null) break block18;
                        if (output == null) break block21;
                        if (output.size() != o.size()) break block18;
                        boolean identical = true;
                        int j = 0;
                        while (j < output.size()) {
                            String co = o.get(j);
                            String coutput = output.get(j);
                            if (co != null && coutput == null || co == null && coutput != null || co != null && coutput != null && !co.equals(coutput)) {
                                identical = false;
                                break;
                            }
                            ++j;
                        }
                        if (!identical) break block18;
                    }
                    if ((n = nodes.get(i)) == null && node != null || n != null && node == null) break block18;
                    if (node == null) break block22;
                    if (node.size() != n.size()) break block18;
                    boolean identical = true;
                    int j = 0;
                    while (j < node.size()) {
                        if (n.get(j) instanceof Integer) {
                            int cn = (Integer)n.get(j);
                            int cnode = (Integer)node.get(j);
                            if (cnode != cn) {
                                identical = false;
                                break;
                            }
                        } else {
                            String cn = (String)n.get(j);
                            if (node.get(j) instanceof Integer) {
                                identical = false;
                                break;
                            }
                            String cnode = (String)node.get(j);
                            if (cn != null && cnode == null || cn == null && cnode != null || cn != null && cnode != null && !cn.equals(cnode)) {
                                identical = false;
                                break;
                            }
                        }
                        ++j;
                    }
                    if (!identical) break block18;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public final int syntaxMatch(String graphname, int graphnode, String text, double currentpos, int tunb, Mft textmft, ArrayList<Object> annotations, Gram grm, RefObject<ArrayList<Double>> sollengths, RefObject<ArrayList<ArrayList<Double>>> solpositions, RefObject<ArrayList<ArrayList<String>>> solvariables, RefObject<ArrayList<ArrayList<String>>> soloutputs, RefObject<ArrayList<ArrayList<Object>>> solnodes, MatchType typeofmatch, boolean topcall, boolean xmltext, ArrayList<String> recursiveCalls) {
        if (epsilon == null) {
            Grammar.setConstants();
        }
        sollengths.argvalue = null;
        solpositions.argvalue = null;
        solvariables.argvalue = null;
        soloutputs.argvalue = null;
        solnodes.argvalue = null;
        Stack<STrace> stack = new Stack<STrace>();
        stack.push(new STrace(currentpos, graphname));
        while (stack.size() > 0) {
            STrace curtrc = (STrace)stack.pop();
            State state = grm.states.get(curtrc.Statenb);
            double cpos = curtrc.Pos;
            if (cpos > (double)text.length()) continue;
            ArrayList<Double> inputs = curtrc.Inputs;
            ArrayList<String> outputs = curtrc.Outputs;
            ArrayList<Object> nodes = curtrc.Nodes;
            ArrayList<String> variables = curtrc.Variables;
            double cposafterspaces = cpos;
            RefObject<Double> tempRef_cposafterspaces = new RefObject<Double>(cposafterspaces);
            Grammar.skipSpaces(text, tempRef_cposafterspaces, xmltext);
            cposafterspaces = (Double)tempRef_cposafterspaces.argvalue;
            int itrans = 0;
            while (itrans < state.Dests.size()) {
                block26: {
                    String olabel;
                    int lbl;
                    int dst;
                    block25: {
                        dst = state.Dests.get(itrans);
                        lbl = state.IdLabels.get(itrans);
                        olabel = grm.vocabOut.get(lbl);
                        if (olabel == null || olabel.length() <= 5 || !olabel.substring(0, 5).equals("<ONCE")) break block25;
                        boolean foundalready = false;
                        for (String oz : outputs) {
                            if (!olabel.equals(oz)) continue;
                            foundalready = true;
                            break;
                        }
                        if (foundalready) break block26;
                    }
                    String ilabel0 = grm.vocabIn.get(lbl);
                    boolean avariable = false;
                    String[] ilabel = new String[]{ilabel0};
                    int ilbl = 0;
                    while (ilbl < ilabel.length) {
                        String[] seqlabels = this.iLan.parseSequenceOfTokensAndMetaNodes(ilabel[ilbl]);
                        if (seqlabels != null) {
                            int da;
                            ArrayList l2 = null;
                            ArrayList i2 = null;
                            ArrayList v2 = null;
                            ArrayList o2 = null;
                            ArrayList n2 = null;
                            if (seqlabels == null || !avariable) {
                                RefObject<Object> tempRef_l2 = new RefObject<Object>(l2);
                                RefObject<Object> tempRef_i2 = new RefObject<Object>(i2);
                                RefObject<Object> tempRef_v2 = new RefObject<Object>(v2);
                                RefObject<Object> tempRef_o2 = new RefObject<Object>(o2);
                                RefObject<Object> tempRef_n2 = new RefObject<Object>(n2);
                                da = this.syntaxMatchLabel(state.GraphNodeNumber, ilabel[ilbl], olabel, text, cpos, cposafterspaces, tunb, textmft, annotations, tempRef_l2, tempRef_i2, tempRef_v2, tempRef_o2, tempRef_n2, xmltext, recursiveCalls, grm);
                                l2 = (ArrayList)tempRef_l2.argvalue;
                                i2 = (ArrayList)tempRef_i2.argvalue;
                                v2 = (ArrayList)tempRef_v2.argvalue;
                                o2 = (ArrayList)tempRef_o2.argvalue;
                                n2 = (ArrayList)tempRef_n2.argvalue;
                            } else {
                                RefObject<Object> tempRef_l22 = new RefObject<Object>(l2);
                                RefObject<Object> tempRef_i22 = new RefObject<Object>(i2);
                                RefObject<Object> tempRef_v22 = new RefObject<Object>(v2);
                                RefObject<Object> tempRef_o22 = new RefObject<Object>(o2);
                                RefObject<Object> tempRef_n22 = new RefObject<Object>(n2);
                                da = this.syntaxMatchSequenceOfLabels(state.GraphNodeNumber, ilabel[ilbl], seqlabels, olabel, text, cpos, cposafterspaces, tunb, textmft, annotations, tempRef_l22, tempRef_i22, tempRef_v22, tempRef_o22, tempRef_n22, xmltext, recursiveCalls);
                                l2 = (ArrayList)tempRef_l22.argvalue;
                                i2 = (ArrayList)tempRef_i22.argvalue;
                                v2 = (ArrayList)tempRef_v22.argvalue;
                                o2 = (ArrayList)tempRef_o22.argvalue;
                                n2 = (ArrayList)tempRef_n22.argvalue;
                            }
                            int iamb = 0;
                            while (iamb < da) {
                                double newpos = cpos;
                                if (l2 != null) {
                                    newpos += ((Double)l2.get(iamb)).doubleValue();
                                }
                                STrace newtrc = new STrace();
                                newtrc.Statenb = dst;
                                newtrc.Pos = newpos;
                                newtrc.Inputs.addAll(inputs);
                                newtrc.Variables.addAll(variables);
                                newtrc.Outputs.addAll(outputs);
                                newtrc.Nodes.addAll(nodes);
                                if (i2 != null) {
                                    newtrc.Inputs.addAll((Collection)i2.get(iamb));
                                    newtrc.Variables.addAll((Collection)v2.get(iamb));
                                    newtrc.Outputs.addAll((Collection)o2.get(iamb));
                                    newtrc.Nodes.addAll((Collection)n2.get(iamb));
                                }
                                if (newtrc.Inputs == null || newtrc.Inputs.size() < 1000) {
                                    stack.push(newtrc);
                                }
                                if (dst == 1) {
                                    double sollength = newpos - currentpos;
                                    newtrc.Inputs.add(0.0);
                                    newtrc.Variables.add(null);
                                    newtrc.Outputs.add(null);
                                    newtrc.Nodes.add(1);
                                    if (sollengths.argvalue == null) {
                                        sollengths.argvalue = new ArrayList();
                                        solpositions.argvalue = new ArrayList();
                                        solvariables.argvalue = new ArrayList();
                                        soloutputs.argvalue = new ArrayList();
                                        solnodes.argvalue = new ArrayList();
                                        ((ArrayList)sollengths.argvalue).add(sollength);
                                        ((ArrayList)solpositions.argvalue).add(newtrc.Inputs);
                                        ((ArrayList)solvariables.argvalue).add(newtrc.Variables);
                                        ((ArrayList)soloutputs.argvalue).add(newtrc.Outputs);
                                        ((ArrayList)solnodes.argvalue).add(newtrc.Nodes);
                                    } else if (topcall && typeofmatch == MatchType.LONGEST) {
                                        if (sollength > (Double)((ArrayList)sollengths.argvalue).get(0)) {
                                            ((ArrayList)sollengths.argvalue).set(0, sollength);
                                            ((ArrayList)solpositions.argvalue).set(0, newtrc.Inputs);
                                            ((ArrayList)solvariables.argvalue).set(0, newtrc.Variables);
                                            ((ArrayList)soloutputs.argvalue).set(0, newtrc.Outputs);
                                            ((ArrayList)solnodes.argvalue).set(0, newtrc.Nodes);
                                            int size = ((ArrayList)sollengths.argvalue).size() - 1;
                                            if (size > 0) {
                                                ((ArrayList)sollengths.argvalue).subList(1, size + 1).clear();
                                                ((ArrayList)solpositions.argvalue).subList(1, size + 1).clear();
                                                ((ArrayList)solvariables.argvalue).subList(1, size + 1).clear();
                                                ((ArrayList)soloutputs.argvalue).subList(1, size + 1).clear();
                                                ((ArrayList)solnodes.argvalue).subList(1, size + 1).clear();
                                            }
                                        } else if (sollength == (Double)((ArrayList)sollengths.argvalue).get(0)) {
                                            ((ArrayList)sollengths.argvalue).add(sollength);
                                            ((ArrayList)solpositions.argvalue).add(newtrc.Inputs);
                                            ((ArrayList)solvariables.argvalue).add(newtrc.Variables);
                                            ((ArrayList)soloutputs.argvalue).add(newtrc.Outputs);
                                            ((ArrayList)solnodes.argvalue).add(newtrc.Nodes);
                                        }
                                    } else {
                                        ((ArrayList)sollengths.argvalue).add(sollength);
                                        ((ArrayList)solpositions.argvalue).add(newtrc.Inputs);
                                        ((ArrayList)solvariables.argvalue).add(newtrc.Variables);
                                        ((ArrayList)soloutputs.argvalue).add(newtrc.Outputs);
                                        ((ArrayList)solnodes.argvalue).add(newtrc.Nodes);
                                    }
                                }
                                ++iamb;
                            }
                        }
                        ++ilbl;
                    }
                }
                ++itrans;
            }
        }
        if (sollengths.argvalue == null) {
            return 0;
        }
        return ((ArrayList)sollengths.argvalue).size();
    }

    public final int failureSyntaxMatch(String graphname, int graphnode, String text, double currentpos, int tunb, Mft textmft, ArrayList<Object> annotations, Gram grm, RefObject<ArrayList<Double>> sollengths, RefObject<ArrayList<ArrayList<Double>>> solpositions, RefObject<ArrayList<ArrayList<String>>> solvariables, RefObject<ArrayList<ArrayList<String>>> soloutputs, RefObject<ArrayList<ArrayList<Object>>> solnodes, MatchType typeofmatch, boolean topcall, boolean xmltext, ArrayList<String> recursiveCalls) {
        if (!epsilon.equals("<E>")) {
            Grammar.setConstants();
        }
        sollengths.argvalue = null;
        solpositions.argvalue = null;
        solvariables.argvalue = null;
        soloutputs.argvalue = null;
        solnodes.argvalue = null;
        Stack<STrace> stack = new Stack<STrace>();
        stack.push(new STrace(currentpos, graphname));
        while (stack.size() > 0) {
            STrace curtrc = (STrace)stack.pop();
            State state = grm.states.get(curtrc.Statenb);
            double cpos = curtrc.Pos;
            ArrayList<Double> inputs = curtrc.Inputs;
            ArrayList<String> outputs = curtrc.Outputs;
            ArrayList<Object> nodes = curtrc.Nodes;
            ArrayList<String> variables = curtrc.Variables;
            double cposafterspaces = cpos;
            RefObject<Double> tempRef_cposafterspaces = new RefObject<Double>(cposafterspaces);
            Grammar.skipSpaces(text, tempRef_cposafterspaces, xmltext);
            cposafterspaces = (Double)tempRef_cposafterspaces.argvalue;
            int itrans = 0;
            while (itrans < state.Dests.size()) {
                block27: {
                    String olabel;
                    int lbl;
                    int dst;
                    block26: {
                        dst = state.Dests.get(itrans);
                        lbl = state.IdLabels.get(itrans);
                        olabel = grm.vocabOut.get(lbl);
                        if (olabel == null || olabel.length() <= 5 || !olabel.substring(0, 5).equals("<ONCE")) break block26;
                        boolean foundalready = false;
                        for (String oz : outputs) {
                            if (!olabel.equals(oz)) continue;
                            foundalready = true;
                            break;
                        }
                        if (foundalready) break block27;
                    }
                    String ilabel0 = grm.vocabIn.get(lbl);
                    boolean avariable = false;
                    String[] ilabel = new String[]{ilabel0};
                    int ilbl = 0;
                    while (ilbl < ilabel.length) {
                        String[] seqlabels = this.iLan.parseSequenceOfTokensAndMetaNodes(ilabel[ilbl]);
                        if (seqlabels != null) {
                            int da;
                            ArrayList l2 = null;
                            ArrayList i2 = null;
                            ArrayList v2 = null;
                            ArrayList o2 = null;
                            ArrayList n2 = null;
                            if (seqlabels == null || !avariable) {
                                RefObject<Object> tempRef_l2 = new RefObject<Object>(l2);
                                RefObject<Object> tempRef_i2 = new RefObject<Object>(i2);
                                RefObject<Object> tempRef_v2 = new RefObject<Object>(v2);
                                RefObject<Object> tempRef_o2 = new RefObject<Object>(o2);
                                RefObject<Object> tempRef_n2 = new RefObject<Object>(n2);
                                da = this.syntaxFailureMatchLabel(state.GraphNodeNumber, ilabel[ilbl], olabel, text, cpos, cposafterspaces, tunb, textmft, annotations, tempRef_l2, tempRef_i2, tempRef_v2, tempRef_o2, tempRef_n2, xmltext, recursiveCalls, grm);
                                l2 = (ArrayList)tempRef_l2.argvalue;
                                i2 = (ArrayList)tempRef_i2.argvalue;
                                v2 = (ArrayList)tempRef_v2.argvalue;
                                o2 = (ArrayList)tempRef_o2.argvalue;
                                n2 = (ArrayList)tempRef_n2.argvalue;
                            } else {
                                RefObject<Object> tempRef_l22 = new RefObject<Object>(l2);
                                RefObject<Object> tempRef_i22 = new RefObject<Object>(i2);
                                RefObject<Object> tempRef_v22 = new RefObject<Object>(v2);
                                RefObject<Object> tempRef_o22 = new RefObject<Object>(o2);
                                RefObject<Object> tempRef_n22 = new RefObject<Object>(n2);
                                da = this.syntaxFailureMatchSequenceOfLabels(state.GraphNodeNumber, ilabel[ilbl], seqlabels, olabel, text, cpos, cposafterspaces, tunb, textmft, annotations, tempRef_l22, tempRef_i22, tempRef_v22, tempRef_o22, tempRef_n22, xmltext, recursiveCalls);
                                l2 = (ArrayList)tempRef_l22.argvalue;
                                i2 = (ArrayList)tempRef_i22.argvalue;
                                v2 = (ArrayList)tempRef_v22.argvalue;
                                o2 = (ArrayList)tempRef_o22.argvalue;
                                n2 = (ArrayList)tempRef_n22.argvalue;
                            }
                            int iamb = 0;
                            while (iamb < Math.abs(da)) {
                                double newpos = cpos;
                                if (l2 != null) {
                                    newpos += ((Double)l2.get(iamb)).doubleValue();
                                }
                                STrace newtrc = new STrace();
                                newtrc.Statenb = dst;
                                newtrc.Pos = newpos;
                                newtrc.Inputs.addAll(inputs);
                                newtrc.Variables.addAll(variables);
                                newtrc.Outputs.addAll(outputs);
                                newtrc.Nodes.addAll(nodes);
                                if (i2 != null) {
                                    newtrc.Inputs.addAll((Collection)i2.get(iamb));
                                    newtrc.Variables.addAll((Collection)v2.get(iamb));
                                    newtrc.Outputs.addAll((Collection)o2.get(iamb));
                                    newtrc.Nodes.addAll((Collection)n2.get(iamb));
                                }
                                if (dst == 1 && da > 0) {
                                    newtrc.Inputs.add(cpos);
                                    newtrc.Variables.add(null);
                                    newtrc.Outputs.add(null);
                                    newtrc.Nodes.add(1);
                                }
                                if (da > 0 && (newtrc.Inputs == null || newtrc.Inputs.size() < 1000)) {
                                    stack.push(newtrc);
                                }
                                double sollength = newpos - currentpos;
                                if (sollengths.argvalue == null) {
                                    sollengths.argvalue = new ArrayList();
                                    solpositions.argvalue = new ArrayList();
                                    solvariables.argvalue = new ArrayList();
                                    soloutputs.argvalue = new ArrayList();
                                    solnodes.argvalue = new ArrayList();
                                    ((ArrayList)sollengths.argvalue).add(sollength);
                                    ((ArrayList)solpositions.argvalue).add(newtrc.Inputs);
                                    ((ArrayList)solvariables.argvalue).add(newtrc.Variables);
                                    ((ArrayList)soloutputs.argvalue).add(newtrc.Outputs);
                                    ((ArrayList)solnodes.argvalue).add(newtrc.Nodes);
                                } else if (typeofmatch == MatchType.LONGEST) {
                                    if (sollength > (Double)((ArrayList)sollengths.argvalue).get(0) || newtrc.Nodes.size() > ((ArrayList)((ArrayList)solnodes.argvalue).get(0)).size()) {
                                        ((ArrayList)sollengths.argvalue).set(0, sollength);
                                        ((ArrayList)solpositions.argvalue).set(0, newtrc.Inputs);
                                        ((ArrayList)solvariables.argvalue).set(0, newtrc.Variables);
                                        ((ArrayList)soloutputs.argvalue).set(0, newtrc.Outputs);
                                        ((ArrayList)solnodes.argvalue).set(0, newtrc.Nodes);
                                        int size = ((ArrayList)sollengths.argvalue).size() - 1;
                                        if (size > 0) {
                                            ((ArrayList)sollengths.argvalue).subList(1, size + 1).clear();
                                            ((ArrayList)solpositions.argvalue).subList(1, size + 1).clear();
                                            ((ArrayList)solvariables.argvalue).subList(1, size + 1).clear();
                                            ((ArrayList)soloutputs.argvalue).subList(1, size + 1).clear();
                                            ((ArrayList)solnodes.argvalue).subList(1, size + 1).clear();
                                        }
                                    } else if (sollength == (Double)((ArrayList)sollengths.argvalue).get(0) && !this.alreadyThere((ArrayList)sollengths.argvalue, sollength, (ArrayList)solpositions.argvalue, newtrc.Inputs, (ArrayList)solvariables.argvalue, newtrc.Variables, (ArrayList)soloutputs.argvalue, newtrc.Outputs, (ArrayList)solnodes.argvalue, newtrc.Nodes)) {
                                        ((ArrayList)sollengths.argvalue).add(sollength);
                                        ((ArrayList)solpositions.argvalue).add(newtrc.Inputs);
                                        ((ArrayList)solvariables.argvalue).add(newtrc.Variables);
                                        ((ArrayList)soloutputs.argvalue).add(newtrc.Outputs);
                                        ((ArrayList)solnodes.argvalue).add(newtrc.Nodes);
                                    }
                                } else if (!this.alreadyThereFailure((ArrayList)sollengths.argvalue, sollength, (ArrayList)solpositions.argvalue, newtrc.Inputs, (ArrayList)solvariables.argvalue, newtrc.Variables, (ArrayList)soloutputs.argvalue, newtrc.Outputs)) {
                                    ((ArrayList)sollengths.argvalue).add(sollength);
                                    ((ArrayList)solpositions.argvalue).add(newtrc.Inputs);
                                    ((ArrayList)solvariables.argvalue).add(newtrc.Variables);
                                    ((ArrayList)soloutputs.argvalue).add(newtrc.Outputs);
                                    ((ArrayList)solnodes.argvalue).add(newtrc.Nodes);
                                }
                                ++iamb;
                            }
                        }
                        ++ilbl;
                    }
                }
                ++itrans;
            }
        }
        if (sollengths.argvalue == null) {
            return 0;
        }
        return ((ArrayList)sollengths.argvalue).size();
    }

    public static Grammar loadONooJGrammar(String fullname) {
        String line;
        BufferedReader reader;
        Grammar gram;
        int scale;
        Dimension size;
        int nbofgraphs;
        String[] fparams;
        String[] fields;
        String sep2;
        String sep;
        block36: {
            sep = " ";
            sep2 = ":";
            fields = null;
            fparams = null;
            nbofgraphs = 0;
            size = new Dimension(0, 0);
            scale = 0;
            gram = new Grammar();
            gram.fullName = fullname;
            FileInputStream sr = new FileInputStream(fullname);
            reader = new BufferedReader(new InputStreamReader((InputStream)sr, "UTF8"));
            line = reader.readLine();
            if (line.equals("#OpenNooJ 1.0")) break block36;
            reader.close();
            sr.close();
            return null;
        }
        try {
            while (!(line = reader.readLine()).equals("#")) {
                String line2;
                fields = line.split(sep);
                if (fields[0].equals("TYPE")) {
                    if (fields[1].equals("SYNTAX")) {
                        gram.gramType = GramType.SYNTAX;
                        continue;
                    }
                    if (fields[1].equals("INFLECTION")) {
                        gram.gramType = GramType.FLX;
                        continue;
                    }
                    if (!fields[1].equals("MORPHOLOGY")) continue;
                    gram.gramType = GramType.MORPHO;
                    continue;
                }
                if (fields[0].equals("ILANGUAGE")) {
                    gram.iLan = new Language(fields[1]);
                    gram.iLanguage = gram.iLan.isoName;
                    continue;
                }
                if (fields[0].equals("OLANGUAGE")) {
                    gram.oLanguage = fields[1];
                    continue;
                }
                if (fields[0].equals("NUMBEROFGRAPHS")) {
                    nbofgraphs = Integer.parseInt(fields[1]);
                    continue;
                }
                if (fields[0].equals("SIZE")) {
                    size = new Dimension(Integer.parseInt(fields[1]), Integer.parseInt(fields[2]));
                    continue;
                }
                if (fields[0].equals("SCALE")) {
                    scale = Integer.parseInt(fields[1]);
                    continue;
                }
                if (fields[0].equals("IFONT")) {
                    line2 = line.substring(fields[0].length() + 1);
                    fparams = line2.split(sep2);
                    gram.iFontName = fparams[0];
                    gram.iFontStyle = Font.FontStyle.NORMAL.ordinal();
                    if (fparams[1].equals("B")) {
                        gram.iFontStyle = Font.FontStyle.BOLD.ordinal();
                    } else if (fparams[1].equals("I")) {
                        gram.iFontStyle = Font.FontStyle.ITALIC.ordinal();
                    }
                    gram.iFontSize = Float.parseFloat(fparams[2]);
                    continue;
                }
                if (fields[0].equals("OFONT")) {
                    line2 = line.substring(fields[0].length() + 1);
                    fparams = line2.split(sep2);
                    gram.oFontName = fparams[0];
                    gram.oFontStyle = Font.FontStyle.NORMAL.ordinal();
                    if (fparams[1].equals("B")) {
                        gram.oFontStyle = Font.FontStyle.BOLD.ordinal();
                    } else if (fparams[1].equals("I")) {
                        gram.oFontStyle = Font.FontStyle.ITALIC.ordinal();
                    }
                    gram.oFontSize = Float.parseFloat(fparams[2]);
                    continue;
                }
                if (fields[0].equals("CFONT")) {
                    line2 = line.substring(fields[0].length() + 1);
                    fparams = line2.split(sep2);
                    gram.cFontName = fparams[0];
                    gram.cFontStyle = Font.FontStyle.NORMAL.ordinal();
                    if (fparams[1].equals("B")) {
                        gram.cFontStyle = Font.FontStyle.BOLD.ordinal();
                    } else if (fparams[1].equals("I")) {
                        gram.cFontStyle = Font.FontStyle.ITALIC.ordinal();
                    }
                    gram.cFontSize = Float.parseFloat(fparams[2]);
                    continue;
                }
                if (fields[0].equals("AUXICOLOR")) {
                    gram.aColor = Graph.convertColor(Integer.parseInt(fields[1]));
                    continue;
                }
                if (fields[0].equals("BACKCOLOR")) {
                    gram.bColor = Graph.convertColor(Integer.parseInt(fields[1]));
                    continue;
                }
                if (fields[0].equals("COMMCOLOR")) {
                    gram.cColor = Graph.convertColor(Integer.parseInt(fields[1]));
                    continue;
                }
                if (fields[0].equals("FORECOLOR")) {
                    gram.fColor = Graph.convertColor(Integer.parseInt(fields[1]));
                    continue;
                }
                if (fields[0].equals("SELECOLOR")) {
                    gram.sColor = Graph.convertColor(Integer.parseInt(fields[1]));
                    continue;
                }
                if (fields[0].equals("VARCOLOR")) {
                    gram.vColor = Graph.convertColor(Integer.parseInt(fields[1]));
                    continue;
                }
                if (fields[0].equals("DISPFRAME")) {
                    gram.dispFrame = fields[1].equals("y");
                    continue;
                }
                if (fields[0].equals("DISPDATE")) {
                    gram.dispDate = fields[1].equals("y");
                    continue;
                }
                if (fields[0].equals("DISPFILENAME")) {
                    gram.dispFile = fields[1].equals("y");
                    continue;
                }
                if (!fields[0].equals("DISPDIRNAME")) continue;
                gram.dispDir = fields[1].equals("y");
            }
            int i = 0;
            while (i < nbofgraphs) {
                Graph grf = new Graph(size);
                grf.wholeGrammar = gram;
                grf.fits = scale;
                grf.loadONooJ(reader);
                gram.graphs.add(grf);
                ++i;
            }
            String helperLine = null;
            StringBuilder checkText = new StringBuilder();
            while ((helperLine = reader.readLine()) != null) {
                checkText.append(helperLine);
                checkText.append('\n');
            }
            gram.checkText = checkText.toString();
            reader.close();
            gram.isTextual = false;
            return gram;
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "File not found: " + fullname, "NooJ", 0);
            return null;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while getting file stream! Input-output error!", "NooJ", 0);
            return null;
        }
    }

    public void saveONooJGrammar(String fullname) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullname, false), "UTF8"));
            writer.write("#OpenNooJ 1.0");
            writer.write(10);
            if (this.gramType == GramType.SYNTAX) {
                writer.write("TYPE SYNTAX");
                writer.write(10);
            } else if (this.gramType == GramType.FLX) {
                writer.write("TYPE INFLECTION");
                writer.write(10);
            } else {
                writer.write("TYPE MORPHOLOGY");
                writer.write(10);
            }
            writer.write("ILANGUAGE " + this.iLan.isoName);
            writer.write(10);
            writer.write("OLANGUAGE " + this.oLanguage);
            writer.write(10);
            writer.write("NUMBEROFGRAPHS " + this.graphs.size());
            writer.write(10);
            Graph g = this.graphs.get(0);
            writer.write("SIZE " + g.size.width + " " + g.size.height);
            writer.write(10);
            writer.write("SCALE " + g.fits);
            writer.write(10);
            String fstyle = "R";
            if (this.iFontStyle == Font.FontStyle.BOLD.ordinal()) {
                fstyle = "B";
            } else if (this.iFontStyle == Font.FontStyle.ITALIC.ordinal()) {
                fstyle = "I";
            }
            writer.write("IFONT " + this.iFontName + ":" + fstyle + ":" + (int)this.iFontSize);
            writer.write(10);
            fstyle = "R";
            if (this.oFontStyle == Font.FontStyle.BOLD.ordinal()) {
                fstyle = "B";
            } else if (this.oFontStyle == Font.FontStyle.ITALIC.ordinal()) {
                fstyle = "I";
            }
            writer.write("OFONT " + this.oFontName + ":" + fstyle + ":" + (int)this.oFontSize);
            writer.write(10);
            fstyle = "R";
            if (this.cFontStyle == Font.FontStyle.BOLD.ordinal()) {
                fstyle = "B";
            } else if (this.cFontStyle == Font.FontStyle.ITALIC.ordinal()) {
                fstyle = "I";
            }
            writer.write("CFONT " + this.cFontName + ":" + fstyle + ":" + (int)this.cFontSize);
            writer.write(10);
            int color = (int)Graph.convertColor(this.aColor);
            writer.write("AUXICOLOR " + color);
            writer.write(10);
            color = (int)Graph.convertColor(this.bColor);
            writer.write("BACKCOLOR " + color);
            writer.write(10);
            color = (int)Graph.convertColor(this.cColor);
            writer.write("COMMCOLOR " + color);
            writer.write(10);
            color = (int)Graph.convertColor(this.fColor);
            writer.write("FORECOLOR " + color);
            writer.write(10);
            color = (int)Graph.convertColor(this.sColor);
            writer.write("SELECOLOR " + color);
            writer.write(10);
            color = (int)Graph.convertColor(this.vColor);
            writer.write("VARCOLOR " + color);
            writer.write(10);
            writer.write("DISPFRAME " + (this.dispFrame ? "y" : "n"));
            writer.write(10);
            writer.write("DISPDATE " + (this.dispDate ? "y" : "n"));
            writer.write(10);
            writer.write("DISPFILENAME " + (this.dispFile ? "y" : "n"));
            writer.write(10);
            writer.write("DISPDIRNAME " + (this.dispDir ? "y" : "n"));
            writer.write(10);
            writer.write("#");
            writer.write(10);
            for (Graph grf : this.graphs) {
                grf.saveONooJGraph(grf.name, writer);
            }
            writer.write(this.checkText);
            writer.write(10);
            writer.close();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "File not found: " + fullname, "NooJ", 0);
            return;
        }
        catch (UnsupportedEncodingException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while encoding! Unsupported encoding!", "NooJ", 0);
            return;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while getting file stream! Input-output error!", "NooJ", 0);
            return;
        }
    }

    public ArrayList<Object> getExtraParams() {
        return this.extraParams;
    }

    public void setExtraParams(ArrayList<Object> extraParams) {
        this.extraParams = extraParams;
    }
}

