/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.Regexp;
import net.nooj4nlp.engine.helper.PenAttributes;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class Graph
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String name = null;
    public Dimension size;
    public int fits;
    private int[] arrHei;
    private int[] arrWid;
    private int[] arrPosX;
    private int[] arrPosY;
    private String[] arrLabel;
    private int[][] arrChild;
    private ArrayList<ArrayList<Object>> extraParams;
    private HashMap<String, PenAttributes<Color, Float>> pen;
    public transient Grammar wholeGrammar;
    public transient ArrayList<Integer> hei;
    public transient ArrayList<Integer> wid;
    public transient ArrayList<String> label;
    public transient ArrayList<Integer> posX;
    public transient ArrayList<Integer> posY;
    public transient ArrayList<ArrayList<Integer>> child;
    public transient ArrayList<Boolean> selected;
    public transient ArrayList<Object> history;
    public transient ArrayList<Integer> widB;
    public transient int iHistory;
    private transient Color aColor;
    private transient Color cColor;
    private transient Color fColor;
    private transient Color vColor;
    private transient int e5;
    private transient int e10;
    private transient int e20;
    public transient int interline;
    private transient int vinterline;
    private transient int x;
    private transient int y;
    public transient float scale;
    public transient Font cfont;
    public transient Font ffont;
    public transient Font ofont;
    public transient Font vfont;
    public transient Font ifont;
    public transient int epsilonHei;
    public transient int epsilonWid;
    public transient int epsilonwidB;
    public transient Color tColor;
    public transient int nbofnodesmoved = 0;
    public transient int inodemoved = 0;
    public transient int nbofnodesdeleted = 0;
    public transient int inodedeleted = 0;
    public transient int nbofnodesconnected = 0;
    public transient int inodeconnected = 0;
    public transient boolean oneconnectionatleast = false;
    public transient boolean onedisconnectionatleast = false;
    private transient ArrayList<Boolean> inDebugNode;
    private transient ArrayList<Integer> inDebugConnection;
    public transient boolean debugInvisible = false;

    public Graph() {
        this.size = new Dimension(1047, 763);
        this.fits = 100;
        this.scale = 1.0f;
        this.vfont = null;
        this.ofont = null;
        this.ifont = null;
        this.ffont = null;
        this.cfont = null;
        this.tColor = Color.BLACK;
        this.label = new ArrayList();
        this.selected = new ArrayList();
        this.posX = new ArrayList();
        this.posY = new ArrayList();
        this.hei = new ArrayList();
        this.wid = new ArrayList();
        this.widB = new ArrayList();
        this.child = new ArrayList();
        this.pen = new HashMap();
        this.history = new ArrayList();
        this.iHistory = 0;
        this.inodemoved = -1;
        this.inodeconnected = -1;
    }

    public Graph(Dimension givenSize) {
        this.size = givenSize;
        this.fits = 100;
        this.scale = 1.0f;
        this.vfont = null;
        this.ofont = null;
        this.ifont = null;
        this.ffont = null;
        this.cfont = null;
        this.tColor = Color.BLACK;
        this.label = new ArrayList();
        this.selected = new ArrayList();
        this.posX = new ArrayList();
        this.posY = new ArrayList();
        this.hei = new ArrayList();
        this.wid = new ArrayList();
        this.widB = new ArrayList();
        this.child = new ArrayList();
        this.pen = new HashMap();
        this.history = new ArrayList();
        this.iHistory = 0;
        this.inodemoved = -1;
        this.inodeconnected = -1;
    }

    public static Graph loadIntex(Grammar grm, String fullPath, String encodingCode, GramType gt) {
        File graphFile = new File(fullPath);
        if (!graphFile.exists()) {
            return null;
        }
        BufferedReader reader = null;
        Graph grf = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fullPath), encodingCode));
            String line = "";
            line = reader.readLine();
            String sep = " ";
            String sep2 = ":";
            String[] fields = line.split(sep);
            if (fields[0].charAt(0) != '#') {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e2.getMessage(), "Error while getting file stream! Input-output error!", 0);
                    }
                    return null;
                }
                return null;
            }
            grf = new Graph();
            grf.name = FilenameUtils.removeExtension(graphFile.getName());
            grf.wholeGrammar = grm;
            line = reader.readLine();
            while (true) {
                String fontType;
                String fontName;
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                if (line.charAt(0) == '#') break;
                fields = line.split(sep);
                if ("SIZE".equals(fields[0])) {
                    grf.size = new Dimension(Integer.parseInt(fields[1]), Integer.parseInt(fields[2]));
                } else if ("FONT".equals(fields[0])) {
                    line = line.substring(fields[0].length() + 1);
                    fields = line.split(sep2);
                    fontName = fields[0].trim();
                    fontType = fields[1].trim();
                    grm.iFontName = fontName;
                    if (fontType.charAt(0) == 'B') {
                        grm.iFontStyle = 1;
                        grm.iFontSize = Float.parseFloat(fontType.substring(1));
                    } else if (fontType.charAt(0) == 'I') {
                        grm.iFontStyle = 2;
                        grm.iFontSize = Float.parseFloat(fontType.substring(1));
                    } else {
                        grm.iFontStyle = 0;
                        grm.iFontSize = Float.parseFloat(fontType);
                    }
                } else if ("OFONT".equals(fields[0])) {
                    line = line.substring(fields[0].length() + 1);
                    fields = line.split(sep2);
                    fontName = fields[0].trim();
                    fontType = fields[1].trim();
                    grm.oFontName = fontName;
                    if (fontType.charAt(0) == 'B') {
                        grm.oFontStyle = 1;
                        grm.oFontSize = Float.parseFloat(fontType.substring(1));
                    } else if (fontType.charAt(0) == 'I') {
                        grm.oFontStyle = 2;
                        grm.oFontSize = Float.parseFloat(fontType.substring(1));
                    } else {
                        grm.oFontStyle = 0;
                        grm.oFontSize = Float.parseFloat(fontType);
                    }
                } else if ("ACOLOR".equals(fields[0])) {
                    grm.aColor = Graph.convertColor(Integer.parseInt(fields[1]));
                } else if ("BCOLOR".equals(fields[0])) {
                    grm.bColor = Graph.convertColor(Integer.parseInt(fields[1]));
                } else if ("CCOLOR".equals(fields[0])) {
                    grm.cColor = Graph.convertColor(Integer.parseInt(fields[1]));
                } else if ("FCOLOR".equals(fields[0])) {
                    grm.fColor = Graph.convertColor(Integer.parseInt(fields[1]));
                } else if ("SCOLOR".equals(fields[0])) {
                    grm.sColor = Graph.convertColor(Integer.parseInt(fields[1]));
                } else if ("DBOXES".equals(fields[0])) {
                    grm.dispBox = fields[1].charAt(0) == 'y';
                } else if ("DFRAME".equals(fields[0])) {
                    grm.dispFrame = fields[1].charAt(0) == 'y';
                } else if ("DDATE".equals(fields[0])) {
                    grm.dispDate = fields[1].charAt(0) == 'y';
                } else if ("DDIR".equals(fields[0])) {
                    grm.dispDir = fields[1].charAt(0) == 'y';
                } else if ("DFILE".equals(fields[0])) {
                    grm.dispFile = fields[1].charAt(0) == 'y';
                } else if (!"DRIG".equals(fields[0])) {
                    if ("DRST".equals(fields[0])) {
                        grm.dispState = fields[1].charAt(0) == 'y';
                    } else if ("FITS".equals(fields[0])) {
                        grf.fits = Integer.parseInt(fields[1]);
                        if (grf.fits == 2) {
                            grf.fits = 1;
                        }
                    } else if (!"PORIENT".equals(fields[0])) {
                        return null;
                    }
                }
                line = reader.readLine();
            }
            grm.cFontName = grm.iFontName;
            grm.cFontSize = grm.iFontSize;
            grm.cFontStyle = grm.iFontStyle;
            grm.vColor = Color.RED;
            line = reader.readLine();
            int nbOfNodes = Integer.parseInt(line);
            int iNode = 0;
            while (iNode < nbOfNodes) {
                line = reader.readLine();
                StringBuilder label = new StringBuilder();
                int isTrt = 0;
                while (line.charAt(isTrt) != '\"') {
                    ++isTrt;
                }
                ++isTrt;
                int length = 0;
                while (isTrt + length < line.length() && line.charAt(isTrt + length) != '\"') {
                    if (line.charAt(isTrt + length) == '\\') {
                        char character = line.charAt(isTrt + length + 1);
                        if (character == '+' || character == ':' || character == '<' || character == '/' || character == '\\') {
                            label.append('\\');
                            label.append(line.charAt(isTrt + length + 1));
                            length += 2;
                            continue;
                        }
                        label.append(line.charAt(isTrt + length + 1));
                        length += 2;
                        continue;
                    }
                    label.append(line.charAt(isTrt + length));
                    ++length;
                }
                if (isTrt + length >= line.length()) {
                    return null;
                }
                try {
                    StringBuilder labelNooJ = Graph.convert(label, gt);
                    grf.label.add(labelNooJ.toString());
                    grf.selected.add(false);
                    ++length;
                    while (Character.isWhitespace(line.charAt(isTrt + length))) {
                        ++length;
                    }
                    String connections = line.substring(isTrt + length);
                    fields = connections.split(sep);
                    int x = 0;
                    int y = 0;
                    int n = 0;
                    try {
                        x = Integer.parseInt(fields[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        y = Integer.parseInt(fields[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        n = Integer.parseInt(fields[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    grf.posX.add(x);
                    grf.posY.add(y);
                    grf.hei.add(-1);
                    grf.wid.add(-1);
                    grf.widB.add(-1);
                    int nbOfChildren = n;
                    grf.child.add(new ArrayList());
                    int iChild = 0;
                    while (iChild < nbOfChildren) {
                        n = 0;
                        try {
                            n = Integer.parseInt(fields[iChild + 3]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        grf.child.get(iNode).add(n);
                        ++iChild;
                    }
                    ++iNode;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                    return null;
                }
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
        }
        return grf;
    }

    public boolean commentNode(int inode) {
        if (inode < 2) {
            return false;
        }
        String lbl = this.label.get(inode);
        if (lbl.length() == 0 || lbl.charAt(0) == ':') {
            return false;
        }
        ArrayList<Integer> children = this.child.get(inode);
        if (children.size() == 0) {
            return true;
        }
        int jnode = 0;
        while (jnode < this.child.size()) {
            children = this.child.get(jnode);
            int ic = 0;
            while (ic < children.size()) {
                if (children.get(ic) == inode) {
                    return false;
                }
                ++ic;
            }
            ++jnode;
        }
        return true;
    }

    public boolean areaNode(int inode) {
        if (inode < 2) {
            return false;
        }
        String lbl = this.label.get(inode);
        if (lbl.length() == 0 || lbl.charAt(0) != ':') {
            return false;
        }
        ArrayList<Integer> children = this.child.get(inode);
        if (children.size() > 0) {
            return false;
        }
        int jnode = 0;
        while (jnode < this.child.size()) {
            children = this.child.get(jnode);
            int ic = 0;
            while (ic < children.size()) {
                if (children.get(ic) == inode) {
                    return false;
                }
                ++ic;
            }
            ++jnode;
        }
        return true;
    }

    private boolean variableNode(int inode) {
        String lbl = this.label.get(inode);
        if (lbl == null || lbl.length() < 2) {
            return false;
        }
        if (lbl.charAt(0) != '$') {
            return false;
        }
        return lbl.charAt(1) == '(' || lbl.charAt(1) == ')';
    }

    private void drawConnection(int inode, int ilength, int iheight, int jheight, int jnode, Graphics2D g) {
        int destination;
        if (this.inDebugConnection != null && this.debugInvisible && inode < this.inDebugConnection.size() && jnode == (destination = this.inDebugConnection.get(inode).intValue())) {
            return;
        }
        int xi = this.x + ilength;
        int yi = this.y;
        int xj = (int)((float)this.posX.get(jnode).intValue() * this.scale);
        int yj = (int)((float)this.posY.get(jnode).intValue() * this.scale);
        g.setColor((Color)this.pen.get((Object)"penC").color);
        g.setStroke(new BasicStroke(this.pen.get((Object)"penC").stroke));
        if (xi <= xj) {
            g.drawLine(xi, yi, xj, yj);
            return;
        }
        if (yi - iheight >= yj + jheight) {
            Point[] pt = new Point[]{new Point(xi, yi), new Point(xi + this.e10, yi - iheight - this.e10), new Point(xj - this.e10, yj + iheight + this.e10), new Point(xj, yj)};
            g.drawLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y);
            g.drawLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y);
            g.drawLine(pt[2].x, pt[2].y, pt[3].x, pt[3].y);
        } else if (yi + iheight <= yj - jheight) {
            Point[] pt = new Point[]{new Point(xi, yi), new Point(xi + this.e10, yi + iheight + this.e10), new Point(xj - this.e10, yj - iheight - this.e10), new Point(xj, yj)};
            g.drawLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y);
            g.drawLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y);
            g.drawLine(pt[2].x, pt[2].y, pt[3].x, pt[3].y);
        } else {
            Point[] pt = new Point[]{new Point(xi, yi), new Point(xi + this.e10, yi - iheight - this.e10), new Point(xj - this.e10, yj - iheight - this.e10), new Point(xj, yj)};
            g.drawLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y);
            g.drawLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y);
            g.drawLine(pt[2].x, pt[2].y, pt[3].x, pt[3].y);
        }
    }

    private void drawLoop(int inode, Graphics2D g) {
        int xi = this.x + this.wid.get(inode);
        int radius = this.hei.get(inode) / 2 + this.e5;
        g.setColor((Color)this.pen.get((Object)"pen").color);
        g.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
        g.drawArc(xi - radius, this.y - 2 * radius, 2 * radius, 2 * radius, 270, 180);
        g.drawLine(this.x, this.y - 2 * radius, xi, this.y - 2 * radius);
        g.drawArc(this.x - radius, this.y - 2 * radius, 2 * radius, 2 * radius, 90, 180);
    }

    private void ParseLabel(String label, RefObject<String> labelin, RefObject<String> labelout, Engine engine) {
        labelout = null;
        labelin = null;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < label.length() && label.charAt(i) != '/') {
            if (label.charAt(i) == '\\') {
                sb.append(label.charAt(i));
                sb.append(label.charAt(++i));
            } else if (label.charAt(i) == '\"') {
                sb.append(label.charAt(i));
                ++i;
                while (i < label.length() && label.charAt(i) != '\"') {
                    sb.append(label.charAt(i));
                    ++i;
                }
                sb.append(label.charAt(i));
            } else if (label.charAt(i) == '<') {
                int reclevel = 1;
                int j = 1;
                while (i + j < label.length() && label.charAt(i + j) != '/') {
                    if (label.charAt(i + j) == '<') {
                        ++reclevel;
                    } else if (label.charAt(i + j) == '>' && --reclevel == 0) break;
                    ++j;
                }
                String symbol = label.substring(i, i + j + 1);
                String entry = null;
                String lemma = null;
                String category = null;
                String[] features = null;
                RefObject<Object> entryRef = new RefObject<Object>(entry);
                RefObject<Object> lemmaRef = new RefObject<Object>(lemma);
                RefObject<Object> categoryRef = new RefObject<Object>(category);
                RefObject<Object> featuresRef = new RefObject<Object>(features);
                boolean parseLexemeSymbol = Dic.parseLexemeSymbol(symbol, entryRef, lemmaRef, categoryRef, featuresRef);
                entry = (String)entryRef.argvalue;
                lemma = (String)lemmaRef.argvalue;
                category = (String)categoryRef.argvalue;
                features = (String[])featuresRef.argvalue;
                if (!parseLexemeSymbol) {
                    sb.append(symbol);
                } else {
                    ArrayList<String> infos = Dic.normalizeInformation(category, features, engine.properties);
                    if (infos == null || infos.size() == 0) {
                        sb.append(symbol);
                    } else {
                        if (lemma == null) {
                            lemma = entry;
                        }
                        sb.append("<" + entry + "," + lemma + "," + infos.get(0) + ">");
                        int ii = 1;
                        while (ii < infos.size()) {
                            sb.append("\n<" + entry + "," + lemma + "," + infos.get(ii) + ">");
                            ++ii;
                        }
                    }
                }
                i += j;
            } else {
                sb.append(label.charAt(i));
            }
            ++i;
        }
        labelin = new RefObject<String>(sb.toString().trim());
        if (i < label.length()) {
            StringBuilder sbo = new StringBuilder();
            int io = i + 1;
            while (io < label.length()) {
                if (label.charAt(io) != '\n' && label.charAt(io) != '\r' && label.charAt(io) != '\t') {
                    sbo.append(label.charAt(io));
                }
                ++io;
            }
            labelout = new RefObject<String>(sbo.toString());
        }
    }

    public Gram compile(Language lan, GramType grmType, ArrayList<String> aVocab, HashMap<String, Integer> hVocab, Engine engine) {
        int totalnbofstates = 0;
        int NbOfNodes = this.label.size();
        if (NbOfNodes == 0) {
            return null;
        }
        ArrayList<Gram> grms = new ArrayList<Gram>();
        int inode = 0;
        while (inode < NbOfNodes) {
            String label = this.label.get(inode);
            if (inode == 1 || label.length() == 0 || this.commentNode(inode) || this.areaNode(inode)) {
                label = "<E>";
            }
            String labelin = null;
            String labelout = null;
            RefObject<Object> labelinRef = new RefObject<Object>(labelin);
            RefObject<Object> labeloutRef = new RefObject<Object>(labelout);
            this.ParseLabel(label, labelinRef, labeloutRef, engine);
            labelin = (String)labelinRef.argvalue;
            labelout = (String)labeloutRef.argvalue;
            Regexp r = labelout != null ? new Regexp(lan, labelin, labelout, grmType, aVocab, hVocab) : new Regexp(lan, label, null, grmType, aVocab, hVocab);
            grms.add(r.Grm);
            if (r.Grm != null) {
                totalnbofstates += r.Grm.states.size();
            }
            ++inode;
        }
        Gram grm = new Gram(totalnbofstates + 2);
        int[] anchor = new int[NbOfNodes];
        anchor[0] = 2;
        Gram g = (Gram)grms.get(0);
        if (g != null) {
            grm.transfer(g, 2, 0);
        }
        int inode2 = 1;
        while (inode2 < NbOfNodes) {
            anchor[inode2] = grms.get(inode2 - 1) == null ? anchor[inode2 - 1] : anchor[inode2 - 1] + ((Gram)grms.get((int)(inode2 - 1))).states.size();
            g = (Gram)grms.get(inode2);
            if (g != null) {
                grm.transfer(g, anchor[inode2], inode2);
            }
            ++inode2;
        }
        grm.addTransition(0, 2, 0);
        inode2 = 0;
        while (inode2 < NbOfNodes) {
            int ichild = 0;
            while (ichild < this.child.get(inode2).size()) {
                int idest = this.child.get(inode2).get(ichild);
                if (idest == 1) {
                    grm.addTransition(anchor[inode2] + 1, 1, 0);
                } else {
                    grm.addTransition(anchor[inode2] + 1, anchor[idest], 0);
                }
                ++ichild;
            }
            ++inode2;
        }
        return grm;
    }

    private void getDataFromSerialization0(Grammar wholegrammar) {
        this.wholeGrammar = wholegrammar;
        this.hei = Graph.convertInts(this.arrHei);
        this.wid = Graph.convertInts(this.arrWid);
        this.label = new ArrayList<String>(Arrays.asList(this.arrLabel));
        this.posX = Graph.convertInts(this.arrPosX);
        this.posY = Graph.convertInts(this.arrPosY);
        this.arrPosY = null;
        this.arrPosX = null;
        this.arrWid = null;
        this.arrHei = null;
        this.arrLabel = null;
        this.selected = new ArrayList();
        int i = 0;
        while (i < this.label.size()) {
            this.selected.add(false);
            ++i;
        }
        this.child = new ArrayList();
        i = 0;
        while (i < this.arrChild.length) {
            int[] c = this.arrChild[i];
            this.child.add(Graph.convertInts(c));
            ++i;
        }
        this.arrChild = null;
    }

    public void getDataFromSerialization(Grammar gram) {
        this.wholeGrammar = gram;
        this.hei = Graph.convertInts(this.arrHei);
        this.wid = Graph.convertInts(this.arrWid);
        this.label = new ArrayList<String>(Arrays.asList(this.arrLabel));
        this.posX = Graph.convertInts(this.arrPosX);
        this.posY = Graph.convertInts(this.arrPosY);
        this.arrPosY = null;
        this.arrPosX = null;
        this.arrWid = null;
        this.arrHei = null;
        this.arrLabel = null;
        this.selected = new ArrayList();
        int i = 0;
        while (i < this.label.size()) {
            this.selected.add(false);
            ++i;
        }
        this.child = new ArrayList();
        i = 0;
        while (i < this.arrChild.length) {
            int[] c = this.arrChild[i];
            this.child.add(Graph.convertInts(c));
            ++i;
        }
        this.arrChild = null;
        if (this.extraParams != null && this.extraParams.size() > 0) {
            this.history = this.extraParams.get(0);
            this.iHistory = 0;
            if (this.history != null) {
                this.iHistory = this.history.size();
                try {
                    int ih = 0;
                    while (ih < this.history.size()) {
                        Graph hgrf = (Graph)this.history.get(ih + 1);
                        hgrf.getDataFromSerialization0(this.wholeGrammar);
                        hgrf.history = this.history;
                        hgrf.iHistory = this.iHistory;
                        ih += 2;
                    }
                }
                finally {
                    this.history = null;
                    this.iHistory = 0;
                }
            }
            this.inodemoved = -1;
            this.inodeconnected = -1;
        }
    }

    public void storeDataForSerialization0() {
        this.arrHei = Graph.convertIntegers(this.hei);
        this.arrWid = Graph.convertIntegers(this.wid);
        this.arrLabel = this.label.toArray(new String[this.label.size()]);
        this.arrPosX = Graph.convertIntegers(this.posX);
        this.arrPosY = Graph.convertIntegers(this.posY);
        this.arrChild = new int[this.child.size()][];
        int i = 0;
        while (i < this.child.size()) {
            ArrayList<Integer> c = this.child.get(i);
            this.arrChild[i] = Graph.convertIntegers(c);
            ++i;
        }
        this.extraParams = new ArrayList();
    }

    private static StringBuilder convert(StringBuilder intexLabel, GramType gt) {
        StringBuilder res;
        block63: {
            char character;
            int i;
            int iInput;
            StringBuilder input;
            block64: {
                int i2;
                block61: {
                    block62: {
                        input = new StringBuilder();
                        iInput = 0;
                        while (iInput < intexLabel.length() && intexLabel.charAt(iInput) != '/') {
                            char character2 = intexLabel.charAt(iInput);
                            if (character2 == '\\') {
                                if (intexLabel.charAt(iInput + 1) != '+') {
                                    input.append(character2);
                                }
                                input.append(intexLabel.charAt(++iInput));
                            } else if (character2 == '+') {
                                input.append('\n');
                            } else if (character2 == '\"') {
                                input.append(character2);
                                ++iInput;
                                while (iInput < intexLabel.length() && intexLabel.charAt(iInput) != '\"') {
                                    input.append(intexLabel.charAt(iInput));
                                    ++iInput;
                                }
                                if (iInput < intexLabel.length()) {
                                    input.append(intexLabel.charAt(iInput));
                                } else {
                                    input.append('\"');
                                }
                            } else if (character2 == '<') {
                                input.append(character2);
                                ++iInput;
                                while (iInput < intexLabel.length() && intexLabel.charAt(iInput) != '>') {
                                    input.append(intexLabel.charAt(iInput));
                                    ++iInput;
                                }
                                if (iInput < intexLabel.length()) {
                                    input.append(intexLabel.charAt(iInput));
                                } else {
                                    input.append('>');
                                }
                            } else {
                                input.append(character2);
                            }
                            ++iInput;
                        }
                        if (gt != GramType.FLX) break block61;
                        if (input.length() <= 0 || input.charAt(0) != ':') break block62;
                        res = input;
                        break block63;
                    }
                    res = new StringBuilder();
                    int i3 = 0;
                    while (i3 < input.length()) {
                        char character3 = input.charAt(i3);
                        if ("C".equals(Character.valueOf(character3))) {
                            res.append("<R>");
                        } else if ("D".equals(Character.valueOf(character3))) {
                            res.append("<D>");
                        } else if ("L".equals(Character.valueOf(character3))) {
                            res.append("<B>");
                        } else if ("R".equals(Character.valueOf(character3))) {
                            res.append("<R>");
                        } else if (Character.isDigit(character3)) {
                            int nb = Character.digit(character3, 36);
                            ++i3;
                            while (i3 < input.length() && Character.isDigit(input.charAt(i3))) {
                                nb *= 10;
                                int helpNb = Character.digit(input.charAt(i3), 36);
                                nb += helpNb;
                                ++i3;
                            }
                            --i3;
                            res.append("<B" + nb + ">");
                        } else {
                            res.append(input.charAt(i3));
                        }
                        ++i3;
                    }
                    if (iInput >= intexLabel.length()) break block63;
                    res.append('/');
                    i3 = 1;
                    while (iInput + i3 < intexLabel.length() && intexLabel.charAt(iInput + i3) != ':') {
                        if (i3 > 1) {
                            res.append('+');
                        }
                        res.append(intexLabel.charAt(iInput + i3));
                        ++i3;
                    }
                    break block63;
                }
                if (gt != GramType.MORPHO) break block64;
                if (input.length() > 0 && input.charAt(0) == ':') {
                    res = input;
                } else {
                    res = new StringBuilder();
                    i2 = 0;
                    while (i2 < input.length()) {
                        if (input.charAt(i2) == '.') {
                            res.append(',');
                        } else {
                            res.append(input.charAt(i2));
                        }
                        ++i2;
                    }
                }
                if (iInput >= intexLabel.length()) break block63;
                res.append('/');
                i2 = 1;
                while (iInput + i2 < intexLabel.length()) {
                    if (intexLabel.charAt(iInput + i2) == '.') {
                        res.append(',');
                    } else {
                        res.append(intexLabel.charAt(iInput + i2));
                    }
                    ++i2;
                }
                break block63;
            }
            if (input.length() > 0 && input.charAt(0) == ':') {
                res = input;
            } else {
                res = new StringBuilder();
                i = 0;
                while (i < input.length()) {
                    character = input.charAt(i);
                    if (character == '.') {
                        res.append(',');
                    } else if (character == '\\') {
                        res.append("\\" + input.charAt(i + 1));
                        ++i;
                    } else if (character == '<') {
                        if (input.charAt(i + 1) == 'M' && input.charAt(i + 2) == 'O' && input.charAt(i + 3) == 'T' && input.charAt(i + 4) == '>') {
                            res.append("<WF>");
                            i += 4;
                        } else if (input.charAt(i + 1) == 'M' && input.charAt(i + 2) == 'I' && input.charAt(i + 3) == 'N' && input.charAt(i + 4) == '>') {
                            res.append("<LOW>");
                            i += 4;
                        } else if (input.charAt(i + 1) == 'M' && input.charAt(i + 2) == 'A' && input.charAt(i + 3) == 'J' && input.charAt(i + 4) == '>') {
                            res.append("<UPP>");
                            i += 4;
                        } else if (input.charAt(i + 1) == 'P' && input.charAt(i + 2) == 'R' && input.charAt(i + 3) == 'E' && input.charAt(i + 4) == '>') {
                            res.append("<CAP>");
                            i += 4;
                        } else if (input.charAt(i + 1) == 'P' && input.charAt(i + 2) == 'N' && input.charAt(i + 3) == 'C' && input.charAt(i + 4) == '>') {
                            res.append("<P>");
                            i += 4;
                        } else {
                            res.append('<');
                        }
                    } else {
                        res.append(character);
                    }
                    ++i;
                }
            }
            if (iInput < intexLabel.length()) {
                // empty if block
            }
            res.append('/');
            i = 1;
            while (iInput + i < intexLabel.length()) {
                character = intexLabel.charAt(iInput + i);
                if (character == '.') {
                    res.append(',');
                } else {
                    res.append(character);
                }
                ++i;
            }
        }
        return res;
    }

    private static int[] convertIntegers(ArrayList<Integer> integers) {
        int[] ret = new int[integers.size()];
        Iterator<Integer> iterator = integers.iterator();
        int i = 0;
        while (i < ret.length) {
            ret[i] = iterator.next();
            ++i;
        }
        return ret;
    }

    private static ArrayList<Integer> convertInts(int[] oldArray) {
        Integer[] newArray = new Integer[oldArray.length];
        int i = 0;
        int[] nArray = oldArray;
        int n = oldArray.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            newArray[i++] = value;
            ++n2;
        }
        return new ArrayList<Integer>(Arrays.asList(newArray));
    }

    public static Color convertColor(int n) {
        Color c = new Color(n);
        int r = c.getRed();
        int b = c.getBlue();
        int g = c.getGreen();
        Color c2 = new Color(r, g, b, 255);
        return c2;
    }

    public static long convertColor(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        long res = b;
        res += (long)g * 256L;
        return res += (long)r * 256L * 256L;
    }

    public int addNode(String lbl, int x, int y) {
        this.label.add(lbl);
        int inode = this.label.size() - 1;
        this.selected.add(false);
        this.posX.add(x);
        this.posY.add(y);
        this.hei.add(-1);
        this.wid.add(-1);
        this.widB.add(-1);
        this.child.add(new ArrayList());
        return inode;
    }

    public void deleteNode(int inode) {
        this.label.remove(inode);
        this.selected.remove(inode);
        this.posX.remove(inode);
        this.posY.remove(inode);
        this.hei.remove(inode);
        this.wid.remove(inode);
        this.widB.remove(inode);
        this.child.set(inode, null);
        this.child.remove(inode);
        int i = 0;
        while (i < this.child.size()) {
            ArrayList<Integer> children = this.child.get(i);
            int ic = 0;
            while (ic < children.size()) {
                int dnode = children.get(ic);
                if (dnode == inode) {
                    children.remove(ic);
                    --ic;
                } else if (dnode > inode) {
                    children.set(ic, dnode - 1);
                }
                ++ic;
            }
            ++i;
        }
    }

    public void saveIntex(String fullName, boolean NoojRightToLeft) {
        PrintWriter pw = null;
        try {
            try {
                pw = new PrintWriter(fullName);
                pw.write("#FSGraph 4.0\n");
                pw.write("SIZE " + this.size.width + " " + this.size.height + "\n");
                String fStyle = "";
                if (this.ifont.isBold()) {
                    fStyle = "B";
                }
                if (this.ifont.isItalic()) {
                    fStyle = String.valueOf(fStyle) + "I";
                }
                if (fStyle == "") {
                    fStyle = " ";
                }
                pw.write("FONT " + this.wholeGrammar.iFontName + ":" + fStyle + " " + this.wholeGrammar.iFontSize + "\n");
                fStyle = "";
                if (this.ofont.isBold()) {
                    fStyle = "B";
                }
                if (this.ofont.isItalic()) {
                    fStyle = String.valueOf(fStyle) + "I";
                }
                if (fStyle == "") {
                    fStyle = " ";
                }
                pw.write("OFONT " + this.wholeGrammar.oFontName + ":" + fStyle + " " + this.wholeGrammar.oFontSize + "\n");
                long color = Graph.convertColor(this.wholeGrammar.aColor);
                pw.write("ACOLOR " + color + "\n");
                color = Graph.convertColor(this.wholeGrammar.bColor);
                pw.write("BCOLOR " + color + "\n");
                color = Graph.convertColor(this.wholeGrammar.cColor);
                pw.write("CCOLOR " + color + "\n");
                color = Graph.convertColor(this.wholeGrammar.fColor);
                pw.write("FCOLOR " + color + "\n");
                color = Graph.convertColor(this.wholeGrammar.sColor);
                pw.write("SCOLOR " + color + "\n");
                pw.write("DBOXES y\n");
                pw.write("DFRAME " + (this.wholeGrammar.dispFrame ? "y" : "n") + "\n");
                pw.write("DDATE " + (this.wholeGrammar.dispDate ? "y" : "n") + "\n");
                pw.write("DFILE " + (this.wholeGrammar.dispFile ? "y" : "n") + "\n");
                pw.write("DDIR " + (this.wholeGrammar.dispDir ? "y" : "n") + "\n");
                pw.write("DRIG " + (NoojRightToLeft ? "y" : "n") + "\n");
                pw.write("DRST " + (this.wholeGrammar.dispState ? "y" : "n") + "\n");
                pw.write("FITS " + this.fits + "\n");
                pw.write("PORIENT " + (this.size.width > this.size.height ? "L" : "P") + "\n");
                pw.write("#\n");
                pw.write(String.valueOf(this.label.size()) + "\n");
                int iNode = 0;
                while (iNode < this.label.size()) {
                    pw.write("\"");
                    pw.write(this.protectChars(this.label.get(iNode)));
                    pw.write("\" ");
                    pw.write(this.posX.get(iNode) + " ");
                    pw.write(this.posY.get(iNode) + " ");
                    ArrayList<Integer> lc = this.child.get(iNode);
                    pw.write(String.valueOf(lc.size()) + " ");
                    int iChild = 0;
                    while (iChild < lc.size()) {
                        int c = lc.get(iChild);
                        pw.write(String.valueOf(c) + " ");
                        ++iChild;
                    }
                    pw.write("\n");
                    ++iNode;
                }
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream!", 0);
                pw.close();
            }
        }
        finally {
            pw.close();
        }
    }

    public void saveCurrentGraphInHistory(String modification) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        if (this.history.size() > this.iHistory) {
            this.history.subList(this.iHistory, this.iHistory + (this.history.size() - this.iHistory)).clear();
        }
        this.history.add(modification);
        this.history.add(this.clone());
        this.iHistory += 2;
    }

    public void purgeHistory() {
        if (this.iHistory >= 2) {
            this.history.subList(0, this.iHistory - 2);
            this.iHistory = 2;
            this.history.set(0, "Initial");
            Graph cgrf = (Graph)this.history.get(this.iHistory - 1);
            this.getGraphFromHistory(cgrf);
            if (this.history.size() > 2) {
                this.history.subList(2, this.history.size());
            }
        } else {
            this.history = new ArrayList();
            this.history.add("Initial");
            this.history.add(this);
            this.iHistory = 2;
        }
    }

    public void undo() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.iHistory == 2) {
            return;
        }
        this.iHistory -= 2;
        Graph cgrf = (Graph)this.history.get(this.iHistory - 1);
        this.getGraphFromHistory(cgrf);
    }

    public void reset() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.iHistory == 2) {
            return;
        }
        this.iHistory = 2;
        Graph cgrf = (Graph)this.history.get(1);
        this.getGraphFromHistory(cgrf);
    }

    public void redo() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.iHistory >= this.history.size()) {
            return;
        }
        this.iHistory += 2;
        Graph cgrf = (Graph)this.history.get(this.iHistory - 1);
        this.getGraphFromHistory(cgrf);
    }

    public void redoEnd() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.iHistory >= this.history.size()) {
            return;
        }
        this.iHistory = this.history.size();
        Graph cgrf = (Graph)this.history.get(this.iHistory - 1);
        this.getGraphFromHistory(cgrf);
    }

    public void Do(int ihistory) {
        this.iHistory = ihistory;
        Graph cgrf = (Graph)this.history.get(this.iHistory - 1);
        this.getGraphFromHistory(cgrf);
    }

    private void getGraphFromHistory(Graph cgrf) {
        this.wholeGrammar = cgrf.wholeGrammar;
        this.hei = new ArrayList();
        int i = 0;
        while (i < cgrf.hei.size()) {
            this.hei.add(cgrf.hei.get(i));
            ++i;
        }
        this.wid = new ArrayList();
        i = 0;
        while (i < cgrf.wid.size()) {
            this.wid.add(cgrf.wid.get(i));
            ++i;
        }
        this.widB = new ArrayList();
        i = 0;
        while (i < cgrf.wid.size()) {
            this.widB.add(cgrf.wid.get(i));
            ++i;
        }
        this.label = new ArrayList();
        i = 0;
        while (i < cgrf.label.size()) {
            this.label.add(cgrf.label.get(i));
            ++i;
        }
        this.selected = new ArrayList();
        i = 0;
        while (i < cgrf.selected.size()) {
            this.selected.add(cgrf.selected.get(i));
            ++i;
        }
        this.posX = new ArrayList();
        i = 0;
        while (i < cgrf.posX.size()) {
            this.posX.add(cgrf.posX.get(i));
            ++i;
        }
        this.posY = new ArrayList();
        i = 0;
        while (i < cgrf.posY.size()) {
            this.posY.add(cgrf.posY.get(i));
            ++i;
        }
        this.child = new ArrayList();
        i = 0;
        while (i < cgrf.child.size()) {
            ArrayList<Integer> children = cgrf.child.get(i);
            ArrayList<Integer> cchildren = new ArrayList<Integer>();
            int j = 0;
            while (j < children.size()) {
                cchildren.add(children.get(j));
                ++j;
            }
            this.child.add(cchildren);
            ++i;
        }
    }

    public Graph clone() {
        Graph grf = new Graph();
        grf.wholeGrammar = this.wholeGrammar;
        grf.hei = new ArrayList();
        int i = 0;
        while (i < this.hei.size()) {
            grf.hei.add(this.hei.get(i));
            ++i;
        }
        grf.wid = new ArrayList();
        i = 0;
        while (i < this.wid.size()) {
            grf.wid.add(this.wid.get(i));
            ++i;
        }
        grf.widB = new ArrayList();
        i = 0;
        while (i < this.wid.size()) {
            grf.widB.add(this.wid.get(i));
            ++i;
        }
        grf.label = new ArrayList();
        i = 0;
        while (i < this.label.size()) {
            grf.label.add(this.label.get(i));
            ++i;
        }
        grf.selected = new ArrayList();
        i = 0;
        while (i < this.selected.size()) {
            grf.selected.add(this.selected.get(i));
            ++i;
        }
        grf.posX = new ArrayList();
        i = 0;
        while (i < this.posX.size()) {
            grf.posX.add(this.posX.get(i));
            ++i;
        }
        grf.posY = new ArrayList();
        i = 0;
        while (i < this.posY.size()) {
            grf.posY.add(this.posY.get(i));
            ++i;
        }
        grf.child = new ArrayList();
        i = 0;
        while (i < this.child.size()) {
            ArrayList<Integer> children = this.child.get(i);
            ArrayList<Integer> cchildren = new ArrayList<Integer>();
            int j = 0;
            while (j < children.size()) {
                cchildren.add(children.get(j));
                ++j;
            }
            grf.child.add(cchildren);
            ++i;
        }
        return grf;
    }

    public static ArrayList<String> embGraphsLabel(String label) {
        String output = null;
        ArrayList<String> embedded = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(label, outputRef);
        output = (String)outputRef.argvalue;
        int i = 0;
        while (i < terms.length) {
            if (terms[i].length() > 1 && terms[i].charAt(0) == ':') {
                if (embedded == null) {
                    embedded = new ArrayList<String>();
                }
                embedded.add(terms[i].substring(1));
            }
            ++i;
        }
        return embedded;
    }

    public static String[] inLineLabel(String label, RefObject<String> output) {
        String input;
        int i = 0;
        while (i < label.length() && label.charAt(i) != '/') {
            if (label.charAt(i) == '\\') {
                ++i;
            } else if (label.charAt(i) == '\"') {
                ++i;
                while (i < label.length() && label.charAt(i) != '\"') {
                    ++i;
                }
            } else if (label.charAt(i) == '<') {
                ++i;
                while (i < label.length() && label.charAt(i) != '>') {
                    ++i;
                }
            }
            ++i;
        }
        if (i > label.length()) {
            input = "ERROR";
            output.argvalue = null;
        } else if (i == label.length()) {
            input = label;
            output.argvalue = null;
        } else {
            input = label.substring(0, i);
            output.argvalue = label.substring(i + 1);
        }
        ArrayList<String> aterms = new ArrayList<String>();
        int iterm = 0;
        while (iterm < input.length()) {
            int len = 0;
            while (iterm + len < input.length() && input.charAt(iterm + len) != '\n') {
                if (input.charAt(iterm + len) == '\\') {
                    len += 2;
                    continue;
                }
                if (input.charAt(iterm + len) == '\"') {
                    ++len;
                    while (iterm + len < input.length() && input.charAt(iterm + len) != '\"') {
                        if (input.charAt(iterm + len) == '\\') {
                            ++len;
                        }
                        ++len;
                    }
                    if (iterm + len >= input.length()) continue;
                    ++len;
                    continue;
                }
                if (input.charAt(iterm + len) == '<') {
                    ++len;
                    while (iterm + len < input.length() && input.charAt(iterm + len) != '>') {
                        if (input.charAt(iterm + len) == '\\') {
                            ++len;
                        }
                        ++len;
                    }
                    if (iterm + len >= input.length()) continue;
                    ++len;
                    continue;
                }
                ++len;
            }
            String cterm = input.substring(iterm, iterm + len);
            String noslash = "";
            int ict = 0;
            while (ict < cterm.length()) {
                if (cterm.charAt(ict) != '\\') {
                    noslash = String.valueOf(noslash) + cterm.charAt(ict);
                }
                ++ict;
            }
            aterms.add(noslash);
            if ((iterm += len) >= input.length() || input.charAt(iterm) != '\n') continue;
            ++iterm;
        }
        String[] terms = aterms.toArray(new String[aterms.size()]);
        return terms;
    }

    public void paint(JPanel p, Graphics g, boolean moving) {
        File file;
        this.widB = new ArrayList();
        int i = 0;
        while (i < this.label.size()) {
            this.widB.add(-1);
            ++i;
        }
        this.aColor = this.wholeGrammar.aColor;
        this.cColor = this.wholeGrammar.cColor;
        this.fColor = this.wholeGrammar.fColor;
        this.vColor = this.wholeGrammar.vColor;
        Graphics2D graphics = (Graphics2D)g;
        p.setBackground(this.wholeGrammar.bColor);
        this.e5 = (int)(5.0f * this.scale);
        this.e10 = (int)(10.0f * this.scale);
        this.e20 = (int)(20.0f * this.scale);
        FontMetrics iMetrics = graphics.getFontMetrics(this.ifont);
        this.interline = iMetrics.getHeight();
        FontMetrics vMetrics = graphics.getFontMetrics(this.vfont);
        this.vinterline = vMetrics.getHeight();
        this.epsilonHei = this.interline / 2;
        this.epsilonwidB = this.epsilonWid = iMetrics.stringWidth("<E>");
        this.pen.put("pen", new PenAttributes(this.wholeGrammar.fColor, 1.0f));
        this.pen.put("penC", new PenAttributes(this.wholeGrammar.fColor, 1.0f));
        this.pen.put("penS", new PenAttributes(this.tColor, 2.0f));
        this.pen.put("penF", new PenAttributes(this.wholeGrammar.fColor, 2.0f));
        this.pen.put("penD", new PenAttributes(this.wholeGrammar.cColor, 1.0f));
        graphics.setColor(this.wholeGrammar.bColor);
        graphics.fillRect(0, 0, (int)((float)this.size.width * this.scale), (int)((float)this.size.height * this.scale));
        if (this.name != "Main") {
            graphics.setFont(this.ffont);
            graphics.setColor(this.wholeGrammar.fColor);
            graphics.drawString(this.name, this.e20, this.e20);
        }
        if (this.wholeGrammar.dispFrame) {
            graphics.setColor((Color)this.pen.get((Object)"penF").color);
            graphics.setStroke(new BasicStroke(this.pen.get((Object)"penF").stroke));
            graphics.drawRect(this.e10, this.e10, (int)((float)this.size.width * this.scale) - this.e20, (int)((float)this.size.height * this.scale) - this.e20);
        }
        int line = 2;
        if (this.wholeGrammar.dispDate && this.wholeGrammar.fullName != null && (file = new File(this.wholeGrammar.fullName)).exists()) {
            Date dt = new Date(file.lastModified());
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy, hh:mm:ss");
            graphics.setFont(this.ffont);
            graphics.setColor(this.wholeGrammar.fColor);
            graphics.drawString(dateFormat.format(dt), this.e20, (int)((float)this.size.height * this.scale) - this.e20 * line++);
        }
        if (this.wholeGrammar.dispFile) {
            graphics.setFont(this.ffont);
            graphics.setColor(this.wholeGrammar.fColor);
            if (this.wholeGrammar.fullName != null) {
                if (this.wholeGrammar.dispDir) {
                    graphics.drawString(this.wholeGrammar.fullName, this.e20, (int)((float)this.size.height * this.scale) - this.e20 * line++);
                } else {
                    graphics.drawString(FilenameUtils.removeExtension(new File(this.wholeGrammar.fullName).getName()), this.e20, (int)((float)this.size.height * this.scale) - this.e20 * line++);
                }
            }
        }
        if (this.wholeGrammar.dispInstitution && this.wholeGrammar.institution != null) {
            String institution = this.wholeGrammar.institution;
            if (institution.equals("")) {
                institution = "Unknown (set Preferences)";
            }
            graphics.setFont(this.ffont);
            graphics.setColor(this.wholeGrammar.fColor);
            graphics.drawString(institution, this.e20, (int)((float)this.size.height * this.scale) - this.e20 * line++);
        }
        if (this.wholeGrammar.dispAuthor && this.wholeGrammar.author != null) {
            String author = this.wholeGrammar.author;
            if (author.equals("")) {
                author = "Unknown (set Preferences)";
            }
            graphics.setFont(this.ffont);
            graphics.setColor(this.wholeGrammar.fColor);
            graphics.drawString(author, this.e20, (int)((float)this.size.height * this.scale) - this.e20 * line++);
        }
        if (this.wholeGrammar.dispGrid) {
            int GridSize;
            int i2 = GridSize = 20;
            while (i2 < this.size.width) {
                int j = GridSize;
                while (j < this.size.height) {
                    graphics.setColor((Color)this.pen.get((Object)"penF").color);
                    graphics.setStroke(new BasicStroke(this.pen.get((Object)"penF").stroke));
                    graphics.drawLine((int)((float)i2 * this.scale), (int)((float)j * this.scale), i2 + 1, j + 1);
                    j += GridSize;
                }
                i2 += GridSize;
            }
        }
        int NbOfNodes = this.label.size();
        if (p.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            int inode = 0;
            while (inode < NbOfNodes) {
                if (inode == 1) {
                    this.paintTerminalNode(inode, graphics);
                } else if (this.variableNode(inode)) {
                    this.paintVariableNode(inode, graphics);
                } else if (this.commentNode(inode)) {
                    this.paintCommentNode(inode, graphics);
                } else if (this.areaNode(inode)) {
                    this.paintAreaNode(inode, graphics);
                } else {
                    this.paintRegularNode(inode, graphics);
                }
                ++inode;
            }
        } else {
            int inode = 0;
            while (inode < NbOfNodes) {
                if (inode == 1) {
                    this.paintTerminalNode(inode, graphics);
                } else if (this.variableNode(inode)) {
                    this.paintVariableNode2(inode, graphics);
                } else if (this.commentNode(inode)) {
                    this.paintCommentNode2(inode, graphics);
                } else if (this.areaNode(inode)) {
                    this.paintAreaNode(inode, graphics);
                } else {
                    this.paintRegularNode2(inode, graphics);
                }
                ++inode;
            }
        }
    }

    private void paintRegularNode2(int inode, Graphics2D g) {
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(this.label.get(inode), outputRef);
        output = (String)outputRef.argvalue;
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        Color b = this.fColor;
        FontMetrics iMetrics = g.getFontMetrics(this.ifont);
        FontMetrics oMetrics = g.getFontMetrics(this.ofont);
        if (terms.length == 1 && terms[0].equals("<E>")) {
            int maxlen = iMetrics.stringWidth("E");
            this.wid.set(inode, maxlen + this.e5);
            this.hei.set(inode, this.interline / 2);
            g.setColor((Color)this.pen.get((Object)"pen").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
            if (this.inDebugNode == null || !this.debugInvisible || inode >= this.inDebugNode.size() || !this.inDebugNode.get(inode).booleanValue()) {
                g.drawLine(this.x, this.y, this.x + maxlen, this.y);
            }
            g.drawLine(this.x - this.e5, this.y, this.x, this.y - this.interline / 2);
            g.drawLine(this.x - this.e5, this.y, this.x, this.y + this.interline / 2);
            g.drawLine(this.x, this.y - this.interline / 2, this.x, this.y + this.interline / 2);
            if (output != null) {
                g.setFont(this.ofont);
                g.setColor(b);
                System.out.println(g.getColor());
                g.drawString(output, this.x, this.y + this.hei.get(inode) * 2);
                if (oMetrics.stringWidth("/" + output) > maxlen) {
                    this.widB.set(inode, oMetrics.stringWidth("/" + output));
                } else {
                    this.widB.set(inode, maxlen);
                }
            } else {
                this.widB.set(inode, maxlen);
            }
            if (inode == 0) {
                if (this.inDebugNode == null || !this.debugInvisible || inode >= this.inDebugNode.size() || !this.inDebugNode.get(inode).booleanValue()) {
                    g.setColor((Color)this.pen.get((Object)"penF").color);
                }
                g.setStroke(new BasicStroke(this.pen.get((Object)"penF").stroke));
                g.drawLine(this.x + maxlen, this.y, this.x + maxlen + this.e10, this.y);
            }
        } else {
            this.hei.set(inode, this.interline * terms.length / 2);
            int line0 = this.y - this.hei.get(inode);
            int maxlen = 0;
            int i = 0;
            while (i < terms.length) {
                if (terms[i].length() > 0 && terms[i].charAt(0) == ':') {
                    g.setColor(this.aColor);
                    g.fillRect(this.x, line0 + this.interline * i, iMetrics.stringWidth(terms[i].substring(1)), this.interline);
                    g.setFont(this.ifont);
                    g.setColor(b);
                    g.drawString(terms[i].substring(1), this.x, line0 + this.interline * (i + 1));
                    if (iMetrics.stringWidth(terms[i].substring(1)) > maxlen) {
                        maxlen = iMetrics.stringWidth(terms[i].substring(1));
                    }
                } else {
                    g.setFont(this.ifont);
                    g.setColor(b);
                    g.drawString(terms[i], this.x, line0 + this.interline * (i + 1));
                    int w = iMetrics.stringWidth(terms[i]);
                    if (w > maxlen) {
                        maxlen = w;
                    }
                }
                ++i;
            }
            this.wid.set(inode, (maxlen += this.e5) + this.e5);
            if (output != null) {
                g.setFont(this.ofont);
                g.setColor(b);
                g.drawString(output, this.x, line0 + this.interline * (terms.length + 1));
                if (oMetrics.stringWidth("/" + output) > maxlen) {
                    this.widB.set(inode, oMetrics.stringWidth("/" + output));
                } else {
                    this.widB.set(inode, maxlen);
                }
            } else {
                this.widB.set(inode, maxlen);
            }
            g.setColor((Color)this.pen.get((Object)"pen").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
            if (this.inDebugNode == null || !this.debugInvisible || inode >= this.inDebugNode.size() || !this.inDebugNode.get(inode).booleanValue()) {
                g.drawRect(this.x, line0, maxlen, this.interline * terms.length);
            }
            g.drawLine(this.x - this.e5, this.y, this.x, line0);
            g.drawLine(this.x - this.e5, this.y, this.x, line0 + this.interline * terms.length);
            if (!(inode != 0 || this.inDebugNode != null && this.debugInvisible && inode < this.inDebugNode.size() && this.inDebugNode.get(inode).booleanValue())) {
                g.setColor((Color)this.pen.get((Object)"penF").color);
                g.setStroke(new BasicStroke(this.pen.get((Object)"penF").stroke));
                g.drawLine(this.x + maxlen, this.y, this.x + maxlen + this.e10, this.y);
            }
        }
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + this.hei.get(inode), 10, 10);
            Rectangle rect3 = new Rectangle(this.x + this.wid.get(inode), this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect4 = new Rectangle(this.x + this.wid.get(inode), this.y + this.hei.get(inode), 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x - rect1.width / 2, rect1.y + rect1.height / 2, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x - rect2.width / 2, rect2.y + rect2.height / 2, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x - rect3.width / 2, rect3.y + rect3.height / 2, rect3.width, rect3.height, 0, 360);
            g.drawArc(rect4.x - rect4.width / 2, rect4.y + rect4.height / 2, rect4.width, rect4.height, 0, 360);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
        int i = 0;
        while (i < this.child.get(inode).size()) {
            int jnode = this.child.get(inode).get(i);
            if (inode == jnode) {
                this.drawLoop(inode, g);
            } else {
                this.drawConnection2(inode, this.wid.get(inode), this.hei.get(inode), this.hei.get(jnode), jnode, g);
            }
            ++i;
        }
    }

    private void drawConnection2(int inode, int ilength, int iheight, int jheight, int jnode, Graphics2D g) {
        int destination;
        if (this.inDebugConnection != null && this.debugInvisible && inode < this.inDebugConnection.size() && jnode == (destination = this.inDebugConnection.get(inode).intValue())) {
            return;
        }
        int xi = this.x - this.e5;
        int yi = this.y;
        int xj = (int)((float)this.posX.get(jnode).intValue() * this.scale) + this.wid.get(jnode) - this.e5;
        if (jnode == 1) {
            xj += this.e5;
        }
        int yj = (int)((float)this.posY.get(jnode).intValue() * this.scale);
        g.setColor((Color)this.pen.get((Object)"penC").color);
        g.setStroke(new BasicStroke(this.pen.get((Object)"penC").stroke));
        if (xi >= xj) {
            g.drawLine(xi, yi, xj, yj);
            return;
        }
        if (yi - iheight >= yj + jheight) {
            Point[] pt = new Point[]{new Point(xi, yi), new Point(xi - this.e10, yi - iheight - this.e10), new Point(xj + this.e10, yj + iheight + this.e10), new Point(xj, yj)};
            g.drawLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y);
            g.drawLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y);
            g.drawLine(pt[2].x, pt[2].y, pt[3].x, pt[3].y);
        } else if (yi + iheight <= yj - jheight) {
            Point[] pt = new Point[]{new Point(xi, yi), new Point(xi - this.e10, yi + iheight + this.e10), new Point(xj + this.e10, yj - iheight - this.e10), new Point(xj, yj)};
            g.drawLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y);
            g.drawLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y);
            g.drawLine(pt[2].x, pt[2].y, pt[3].x, pt[3].y);
        } else {
            Point[] pt = new Point[]{new Point(xi, yi), new Point(xi - this.e10, yi - iheight - this.e10), new Point(xj + this.e10, yj - iheight - this.e10), new Point(xj, yj)};
            g.drawLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y);
            g.drawLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y);
            g.drawLine(pt[2].x, pt[2].y, pt[3].x, pt[3].y);
        }
    }

    private void paintVariableNode2(int inode, Graphics2D g) {
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(this.label.get(inode), outputRef);
        output = (String)outputRef.argvalue;
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        FontMetrics oMetrics = g.getFontMetrics(this.ofont);
        FontMetrics vMetrics = g.getFontMetrics(this.vfont);
        String parenthesis = terms[0].substring(1, 2);
        g.setFont(this.vfont);
        g.setColor(this.vColor);
        if (parenthesis.equals("(")) {
            g.drawString(")", this.x, this.y - this.vinterline / 2);
        } else if (parenthesis.equals(")")) {
            g.drawString("(", this.x, this.y - this.vinterline / 2);
        } else {
            g.drawString(terms[0].substring(1, 2), this.x, this.y - this.vinterline / 2);
        }
        if (terms[0].length() > 2) {
            g.setFont(this.ofont);
            g.drawString(terms[0].substring(2), this.x + this.e5, this.y + this.vinterline / 2);
        }
        int maxlen = vMetrics.stringWidth("(");
        this.wid.set(inode, maxlen + this.e5);
        this.widB.set(inode, maxlen + oMetrics.stringWidth(terms[0].substring(2)));
        this.hei.set(inode, this.vinterline / 2);
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + this.hei.get(inode), 10, 10);
            Rectangle rect3 = new Rectangle(this.x + this.wid.get(inode), this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect4 = new Rectangle(this.x + this.wid.get(inode), this.y + this.hei.get(inode), 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x - rect1.width / 2, rect1.y + rect1.height / 2, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x - rect2.width / 2, rect2.y + rect2.height / 2, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x - rect3.width / 2, rect3.y + rect3.height / 2, rect3.width, rect3.height, 0, 360);
            g.drawArc(rect4.x - rect4.width / 2, rect4.y + rect4.height / 2, rect4.width, rect4.height, 0, 360);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
        if (inode == 0) {
            g.setColor((Color)this.pen.get((Object)"penF").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penF").stroke));
            g.drawLine(this.x - this.e10, this.y, this.x, this.y);
        }
        int i = 0;
        while (i < this.child.get(inode).size()) {
            int jnode = this.child.get(inode).get(i);
            if (inode == jnode) {
                this.drawLoop(inode, g);
            } else {
                this.drawConnection2(inode, this.wid.get(inode), this.hei.get(inode), this.hei.get(jnode), jnode, g);
            }
            ++i;
        }
    }

    private void paintRegularNode(int inode, Graphics2D g) {
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(this.label.get(inode), outputRef);
        output = (String)outputRef.argvalue;
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        Color b = this.fColor;
        FontMetrics iMetrics = g.getFontMetrics(this.ifont);
        FontMetrics oMetrics = g.getFontMetrics(this.ofont);
        if (terms.length == 1 && terms[0].equals("<E>")) {
            int maxlen = iMetrics.stringWidth("<E>");
            this.wid.set(inode, maxlen + this.e5);
            this.hei.set(inode, this.interline / 2);
            g.setColor((Color)this.pen.get((Object)"pen").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
            if (this.inDebugNode == null || !this.debugInvisible || inode >= this.inDebugNode.size() || !this.inDebugNode.get(inode).booleanValue()) {
                g.drawLine(this.x, this.y, this.x + maxlen, this.y);
            }
            g.drawLine(this.x + maxlen + this.e5, this.y, this.x + maxlen, this.y - this.interline / 2);
            g.drawLine(this.x + maxlen + this.e5, this.y, this.x + maxlen, this.y + this.interline / 2);
            g.drawLine(this.x + maxlen, this.y - this.interline / 2, this.x + maxlen, this.y + this.interline / 2);
            if (output != null) {
                g.setFont(this.ofont);
                g.setColor(b);
                g.drawString(output, this.x, this.y + this.hei.get(inode) * 2);
                if (oMetrics.stringWidth("/" + output) > maxlen) {
                    this.widB.set(inode, oMetrics.stringWidth("/" + output));
                } else {
                    this.widB.set(inode, maxlen);
                }
            } else {
                this.widB.set(inode, maxlen);
            }
        } else {
            this.hei.set(inode, this.interline * terms.length / 2);
            int line0 = this.y - this.hei.get(inode);
            int maxlen = 0;
            int i = 0;
            while (i < terms.length) {
                int w;
                if (terms[i].length() > 0 && terms[i].charAt(0) == ':') {
                    g.setColor(this.aColor);
                    g.fillRect(this.x, line0 + this.interline * i, iMetrics.stringWidth(terms[i].substring(1)), this.interline);
                    g.setColor(b);
                    g.setFont(this.ifont);
                    g.drawString(terms[i].substring(1), this.x, line0 + this.interline * (i + 1));
                    if (iMetrics.stringWidth(terms[i].substring(1)) > maxlen) {
                        maxlen = iMetrics.stringWidth(terms[i].substring(1));
                    }
                } else if (terms[i].length() > 0 & terms[i].charAt(0) == '$') {
                    g.setFont(this.ofont);
                    g.setColor(this.vColor);
                    g.drawString(terms[i].substring(1), this.x, line0 + this.interline * i);
                    w = oMetrics.stringWidth(terms[i].substring(1));
                    if (w > maxlen) {
                        maxlen = w;
                    }
                } else {
                    g.setFont(this.ifont);
                    g.setColor(b);
                    g.drawString(terms[i], this.x, line0 + this.interline * (i + 1));
                    w = iMetrics.stringWidth(terms[i]);
                    if (w > maxlen) {
                        maxlen = w;
                    }
                }
                ++i;
            }
            this.wid.set(inode, (maxlen += this.e5) + this.e5);
            if (output != null) {
                g.setFont(this.ofont);
                g.setColor(b);
                g.drawString(output, this.x, line0 + this.interline * (terms.length + 1));
                if (oMetrics.stringWidth("/" + output) > maxlen) {
                    this.widB.set(inode, oMetrics.stringWidth("/" + output));
                } else {
                    this.widB.set(inode, maxlen);
                }
            } else {
                this.widB.set(inode, maxlen);
            }
            g.setColor((Color)this.pen.get((Object)"pen").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
            if (this.inDebugNode == null || !this.debugInvisible || inode >= this.inDebugNode.size() || !this.inDebugNode.get(inode).booleanValue()) {
                g.drawRect(this.x, line0, maxlen, this.interline * terms.length);
            }
            g.drawLine(this.x + maxlen + this.e5, this.y, this.x + maxlen, line0);
            g.drawLine(this.x + maxlen + this.e5, this.y, this.x + maxlen, line0 + this.interline * terms.length);
        }
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + this.hei.get(inode), 10, 10);
            Rectangle rect3 = new Rectangle(this.x + this.wid.get(inode), this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect4 = new Rectangle(this.x + this.wid.get(inode), this.y + this.hei.get(inode), 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x - rect1.width / 2, rect1.y, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x - rect2.width / 2, rect2.y, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x - rect3.width / 2, rect3.y, rect3.width, rect3.height, 0, 360);
            g.drawArc(rect4.x - rect4.width / 2, rect4.y, rect4.width, rect4.height, 0, 360);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
        if (!(inode != 0 || this.inDebugNode != null && this.debugInvisible && inode < this.inDebugNode.size() && this.inDebugNode.get(inode).booleanValue())) {
            g.setColor((Color)this.pen.get((Object)"penF").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penF").stroke));
            g.drawLine(this.x - this.e10, this.y, this.x, this.y);
        }
        int i = 0;
        while (i < this.child.get(inode).size()) {
            int jnode = this.child.get(inode).get(i);
            if (inode == jnode) {
                this.drawLoop(inode, g);
            } else {
                this.drawConnection(inode, this.wid.get(inode), this.hei.get(inode), this.hei.get(jnode), jnode, g);
            }
            ++i;
        }
    }

    private void paintAreaNode(int inode, Graphics2D g) {
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(this.label.get(inode), outputRef);
        output = (String)outputRef.argvalue;
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        Color b = this.cColor;
        FontMetrics oMetrics = g.getFontMetrics(this.ofont);
        FontMetrics cMetrics = g.getFontMetrics(this.cfont);
        if ((int)((float)this.hei.get(inode).intValue() * this.scale) < this.interline * terms.length / 2) {
            this.hei.set(inode, (int)((float)(this.interline * terms.length / 2) / this.scale));
        }
        int h = (int)((float)this.hei.get(inode).intValue() * this.scale);
        int line0 = this.y - (int)((float)this.hei.get(inode).intValue() * this.scale);
        int maxlen = 0;
        int i = 0;
        while (i < terms.length) {
            if (terms[i].length() > 0) {
                g.setFont(this.cfont);
                g.setColor(b);
                g.drawString(terms[i].substring(1), this.x, line0 + this.interline * (i + 1));
                if (cMetrics.stringWidth(terms[i].substring(1)) > maxlen) {
                    maxlen = cMetrics.stringWidth(terms[i].substring(1));
                }
            }
            ++i;
        }
        maxlen += this.e5;
        if (output != null) {
            g.setFont(this.ofont);
            g.setColor(b);
            g.drawString(output, this.x, line0 + this.interline * (terms.length + 1));
            if (oMetrics.stringWidth("/" + output) > maxlen) {
                this.widB.set(inode, oMetrics.stringWidth("/" + output));
            } else {
                this.widB.set(inode, maxlen);
            }
        } else {
            this.widB.set(inode, maxlen);
        }
        if ((int)((float)this.wid.get(inode).intValue() * this.scale) < this.widB.get(inode)) {
            this.wid.set(inode, (int)((float)this.widB.get(inode).intValue() / this.scale));
        }
        int w = (int)((float)this.wid.get(inode).intValue() * this.scale);
        Rectangle rect = new Rectangle(this.x, line0 + this.interline, w, 2 * (h - this.interline / 2));
        g.setColor((Color)this.pen.get((Object)"penD").color);
        float[] dash1 = new float[]{10.0f};
        BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
        g.setStroke(dashed);
        g.draw(rect);
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - h - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + h, 10, 10);
            Rectangle rect3 = new Rectangle(this.x + w, this.y - h - 10, 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x - rect1.width / 2, rect1.y + rect1.height / 2, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x - rect2.width / 2, rect2.y + rect2.height / 2, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x - rect3.width / 2, rect3.y + rect3.height / 2, rect3.width, rect3.height, 0, 360);
            g.drawLine(this.x + w, this.y + h, this.x + w + 10, this.y + h);
            g.drawLine(this.x + w, this.y + h, this.x + w, this.y + h + 10);
            g.drawLine(this.x + w, this.y + h + 10, this.x + w + 10, this.y + h);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
    }

    private void paintCommentNode(int inode, Graphics2D g) {
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(this.label.get(inode), outputRef);
        output = (String)outputRef.argvalue;
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        Color b = this.cColor;
        FontMetrics oMetrics = g.getFontMetrics(this.ofont);
        FontMetrics cMetrics = g.getFontMetrics(this.cfont);
        this.hei.set(inode, this.interline * terms.length / 2);
        int line0 = this.y - this.hei.get(inode);
        int maxlen = 0;
        int i = 0;
        while (i < terms.length) {
            g.setFont(this.cfont);
            g.setColor(b);
            g.drawString(terms[i], this.x, line0 + this.interline * (i + 1));
            int w = cMetrics.stringWidth(terms[i]);
            if (w > maxlen) {
                maxlen = w;
            }
            ++i;
        }
        this.wid.set(inode, (maxlen += this.e5) + this.e5);
        if (output != null) {
            g.setFont(this.ofont);
            g.setColor(b);
            g.drawString(output, this.x, line0 + this.interline * (terms.length + 1));
            if (oMetrics.stringWidth("/" + output) > maxlen) {
                this.widB.set(inode, oMetrics.stringWidth("/" + output));
            } else {
                this.widB.set(inode, maxlen);
            }
        } else {
            this.widB.set(inode, maxlen);
        }
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + this.hei.get(inode), 10, 10);
            Rectangle rect3 = new Rectangle(this.x + this.wid.get(inode), this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect4 = new Rectangle(this.x + this.wid.get(inode), this.y + this.hei.get(inode), 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x - rect1.width / 2, rect1.y + rect1.height / 2, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x - rect2.width / 2, rect2.y + rect2.height / 2, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x - rect3.width / 2, rect3.y + rect3.height / 2, rect3.width, rect3.height, 0, 360);
            g.drawArc(rect4.x - rect4.width / 2, rect4.y + rect4.height / 2, rect4.width, rect4.height, 0, 360);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
        i = 0;
        while (i < this.child.get(inode).size()) {
            int jnode = this.child.get(inode).get(i);
            if (inode == jnode) {
                this.drawLoop(inode, g);
            } else {
                this.drawConnection(inode, this.wid.get(inode), this.hei.get(inode), this.hei.get(jnode), jnode, g);
            }
            ++i;
        }
    }

    private void paintVariableNode(int inode, Graphics2D g) {
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(this.label.get(inode), outputRef);
        output = (String)outputRef.argvalue;
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        FontMetrics oMetrics = g.getFontMetrics(this.ofont);
        FontMetrics vMetrics = g.getFontMetrics(this.vfont);
        g.setColor(this.vColor);
        g.setFont(this.vfont);
        g.drawString(terms[0].substring(1, 2), this.x, this.y + this.vinterline / 2);
        if (terms[0].length() > 2) {
            g.setFont(this.ofont);
            g.drawString(terms[0].substring(2), this.x + this.e5, this.y + this.vinterline / 2);
        }
        int maxlen = vMetrics.stringWidth("(");
        this.wid.set(inode, maxlen + this.e5);
        this.widB.set(inode, maxlen + oMetrics.stringWidth(terms[0].substring(2)));
        this.hei.set(inode, this.vinterline / 2);
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + this.hei.get(inode), 10, 10);
            Rectangle rect3 = new Rectangle(this.x + this.wid.get(inode), this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect4 = new Rectangle(this.x + this.wid.get(inode), this.y + this.hei.get(inode), 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x - rect1.width / 2, rect1.y + rect1.height / 2, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x - rect2.width / 2, rect2.y + rect2.height / 2, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x - rect3.width / 2, rect3.y + rect3.height / 2, rect3.width, rect3.height, 0, 360);
            g.drawArc(rect4.x - rect4.width / 2, rect4.y + rect4.height / 2, rect4.width, rect4.height, 0, 360);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
        if (inode == 0) {
            g.setColor((Color)this.pen.get((Object)"penF").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penF").stroke));
            g.drawLine(this.x - this.e10, this.y, this.x, this.y);
        }
        int i = 0;
        while (i < this.child.get(inode).size()) {
            int jnode = this.child.get(inode).get(i);
            if (inode == jnode) {
                this.drawLoop(inode, g);
            } else {
                this.drawConnection(inode, this.wid.get(inode), this.hei.get(inode), this.hei.get(jnode), jnode, g);
            }
            ++i;
        }
    }

    private void paintCommentNode2(int inode, Graphics2D g) {
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String[] terms = Graph.inLineLabel(this.label.get(inode), outputRef);
        output = (String)outputRef.argvalue;
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        Color b = this.cColor;
        FontMetrics oMetrics = g.getFontMetrics(this.ofont);
        FontMetrics cMetrics = g.getFontMetrics(this.cfont);
        this.hei.set(inode, this.interline * terms.length / 2);
        int line0 = this.y - this.hei.get(inode);
        int maxlen = 0;
        int i = 0;
        while (i < terms.length) {
            g.setColor(b);
            g.setFont(this.cfont);
            g.drawString(terms[i], this.x, line0 + this.interline * (i + 1));
            int w = cMetrics.stringWidth(terms[i]);
            if (w > maxlen) {
                maxlen = w;
            }
            ++i;
        }
        this.wid.set(inode, (maxlen += this.e5) + this.e5);
        if (output != null) {
            g.setFont(this.ofont);
            g.setColor(b);
            g.drawString(output, this.x, line0 + this.interline * (terms.length + 1));
            if (oMetrics.stringWidth("/" + output) > maxlen) {
                this.widB.set(inode, oMetrics.stringWidth("/" + output));
            } else {
                this.widB.set(inode, maxlen);
            }
        } else {
            this.widB.set(inode, maxlen);
        }
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + this.hei.get(inode), 10, 10);
            Rectangle rect3 = new Rectangle(this.x + this.wid.get(inode), this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect4 = new Rectangle(this.x + this.wid.get(inode), this.y + this.hei.get(inode), 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x - rect1.width / 2, rect1.y + rect1.height / 2, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x - rect2.width / 2, rect2.y + rect2.height / 2, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x - rect3.width / 2, rect3.y + rect3.height / 2, rect3.width, rect3.height, 0, 360);
            g.drawArc(rect4.x - rect4.width / 2, rect4.y + rect4.height / 2, rect4.width, rect4.height, 0, 360);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
        i = 0;
        while (i < this.child.get(inode).size()) {
            int jnode = this.child.get(inode).get(i);
            if (inode == jnode) {
                this.drawLoop(inode, g);
            } else {
                this.drawConnection2(inode, this.wid.get(inode), this.hei.get(inode), this.hei.get(jnode), jnode, g);
            }
            ++i;
        }
    }

    private void paintTerminalNode(int inode, Graphics2D g) {
        this.x = (int)((float)this.posX.get(inode).intValue() * this.scale);
        this.y = (int)((float)this.posY.get(inode).intValue() * this.scale);
        g.setColor((Color)this.pen.get((Object)"pen").color);
        g.setStroke(new BasicStroke(this.pen.get((Object)"pen").stroke));
        if (this.inDebugNode == null || !this.debugInvisible || inode >= this.inDebugNode.size() || !this.inDebugNode.get(inode).booleanValue()) {
            g.draw(new Ellipse2D.Double(this.x, this.y - this.interline / 2, this.interline, this.interline));
        }
        g.drawLine(this.x, this.y, this.x + this.interline, this.y);
        g.drawLine(this.x + this.interline / 2, this.y - this.interline / 2, this.x + this.interline / 2, this.y + this.interline);
        g.drawLine((int)((float)this.x + (float)this.interline * 0.3f), this.y + this.interline, (int)((float)this.x + (float)this.interline * 0.7f), this.y + this.interline);
        this.hei.set(inode, this.interline / 2);
        this.wid.set(inode, this.interline);
        this.widB.set(inode, -1);
        if (this.selected != null && this.selected.get(inode).booleanValue()) {
            Rectangle rect1 = new Rectangle(this.x - 10, this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect2 = new Rectangle(this.x - 10, this.y + this.hei.get(inode), 10, 10);
            Rectangle rect3 = new Rectangle(this.x + this.wid.get(inode), this.y - this.hei.get(inode) - 10, 10, 10);
            Rectangle rect4 = new Rectangle(this.x + this.wid.get(inode), this.y + this.hei.get(inode), 10, 10);
            g.setColor((Color)this.pen.get((Object)"penS").color);
            g.setStroke(new BasicStroke(this.pen.get((Object)"penS").stroke));
            g.drawArc(rect1.x, rect1.y + rect1.height / 2, rect1.width, rect1.height, 0, 360);
            g.drawArc(rect2.x, rect2.y + rect2.height / 2, rect2.width, rect2.height, 0, 360);
            g.drawArc(rect3.x, rect3.y + rect3.height / 2, rect3.width, rect3.height, 0, 360);
            g.drawArc(rect4.x, rect4.y + rect4.height / 2, rect4.width, rect4.height, 0, 360);
            g.setColor((Color)this.pen.get((Object)"pen").color);
        }
    }

    public void renameEmbeddedGraphInLabel(int inode, String oldname, String newname) {
        String output = null;
        RefObject<Object> outputRef = new RefObject<Object>(output);
        String lbl = this.label.get(inode);
        String[] terms = Graph.inLineLabel(lbl, outputRef);
        output = (String)outputRef.argvalue;
        boolean modif = false;
        int i = 0;
        while (i < terms.length) {
            if (terms[i].charAt(0) == ':' && terms[i].substring(1) == oldname) {
                terms[i] = ":" + newname;
                modif = true;
            }
            ++i;
        }
        if (modif) {
            this.label.set(inode, this.outLineLabel(terms, output));
        }
    }

    private String outLineLabel(String[] terms, String output) {
        StringBuilder res = new StringBuilder();
        res.append(terms[0]);
        int i = 1;
        while (i < terms.length) {
            res.append(String.valueOf('\n') + terms[i]);
            ++i;
        }
        return res.toString();
    }

    public void stopDebug() {
        this.inDebugNode = null;
        this.inDebugConnection = null;
    }

    public void setDebug(ArrayList<Object> trace) {
        this.inDebugNode = new ArrayList();
        int i = 0;
        while (i < this.selected.size()) {
            this.inDebugNode.add(false);
            ++i;
        }
        i = 0;
        while (i < trace.size()) {
            int iNode;
            if (!(trace.get(i) instanceof String) && (iNode = ((Integer)trace.get(i)).intValue()) != -1) {
                this.inDebugNode.set(iNode, true);
            }
            ++i;
        }
        this.inDebugConnection = new ArrayList();
        i = 0;
        while (i < this.selected.size()) {
            this.inDebugConnection.add(-1);
            ++i;
        }
        int lastTrace = 0;
        int i2 = 0;
        while (i2 < trace.size()) {
            int iNode;
            if (!(trace.get(i2) instanceof String) && (iNode = ((Integer)trace.get(i2)).intValue()) != -1) {
                this.inDebugConnection.set(lastTrace, iNode);
                lastTrace = iNode;
            }
            ++i2;
        }
    }

    private String protectChars(String label) {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < label.length()) {
            char characterLabel = label.charAt(i);
            if (characterLabel == '\"') {
                res.append("\\\"");
            } else if (characterLabel == '+') {
                res.append("\\+");
            } else if (characterLabel == '\n') {
                if (i + 1 < label.length() && label.charAt(i + 1) == '/') {
                    res.append("/");
                    ++i;
                } else {
                    res.append("+");
                }
            } else {
                res.append(characterLabel);
            }
            ++i;
        }
        return res.toString();
    }

    private String unProtectChars(StringBuilder label) {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < label.length()) {
            char characterLabel = label.charAt(i);
            if (characterLabel == '+') {
                res.append("\n");
            } else if (characterLabel == '/') {
                res.append("\n/");
            } else if (characterLabel == '\\') {
                if (i + 1 < label.length() && label.charAt(i + 1) == '\"') {
                    res.append("\"");
                    ++i;
                } else if (i + 1 < label.length() && label.charAt(i + 1) == '+') {
                    res.append("+");
                    ++i;
                }
            } else {
                res.append(characterLabel);
            }
            ++i;
        }
        return res.toString();
    }

    public void saveONooJGraph(String fullname, BufferedWriter writer) {
        try {
            writer.write("#");
            writer.write(10);
            writer.write(this.name);
            writer.write(10);
            writer.write(Integer.toString(this.label.size()));
            writer.write(10);
            int inode = 0;
            while (inode < this.label.size()) {
                writer.write("\"");
                writer.write(this.protectChars(this.label.get(inode)));
                writer.write("\" ");
                writer.write(String.valueOf(this.posX.get(inode).toString()) + " ");
                writer.write(String.valueOf(this.posY.get(inode).toString()) + " ");
                ArrayList<Integer> lc = this.child.get(inode);
                writer.write(String.valueOf(Integer.toString(lc.size())) + " ");
                int ichild = 0;
                while (ichild < lc.size()) {
                    int c = lc.get(ichild);
                    writer.write(String.valueOf(Integer.toString(c)) + " ");
                    ++ichild;
                }
                writer.write(10);
                ++inode;
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while getting file stream! Input-output error!", "NooJ", 0);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadONooJ(BufferedReader reader) {
        String line = "";
        try {
            line = reader.readLine();
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while getting file stream! Input-output error!", "NooJ", 0);
            return false;
        }
        if (line == "") return false;
        if (line.charAt(0) != '#') {
            return false;
        }
        try {
            this.name = line = reader.readLine();
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while getting file stream! Input-output error!", "NooJ", 0);
            return false;
        }
        try {
            line = reader.readLine();
            int NbOfNodes = Integer.parseInt(line);
            String sep = " ";
            int inode = 0;
            while (inode < NbOfNodes) {
                line = reader.readLine();
                StringBuilder label = new StringBuilder();
                int istrt = 0;
                while (line.charAt(istrt) != '\"') {
                    ++istrt;
                }
                ++istrt;
                int len = 0;
                while (istrt + len < line.length() && line.charAt(istrt + len) != '\"') {
                    if (line.charAt(istrt + len) != '\\') continue;
                    if (line.charAt(istrt + len + 1) == '+') {
                        label.append('\\');
                        label.append(line.charAt(istrt + len + 1));
                        len += 2;
                        continue;
                    }
                    label.append(line.charAt(istrt + len));
                    ++len;
                }
                if (istrt + len >= line.length()) {
                    return false;
                }
                this.label.add(this.unProtectChars(label));
                ++len;
                this.selected.add(false);
                while (Character.isWhitespace(line.charAt(istrt + len))) {
                    ++len;
                }
                String connections = line.substring(istrt + len);
                String[] fields = connections.split(sep);
                int x = 0;
                int y = 0;
                int n = 0;
                try {
                    x = Integer.parseInt(fields[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    y = Integer.parseInt(fields[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    n = Integer.parseInt(fields[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.posX.add(x);
                this.posY.add(y);
                this.hei.add(-1);
                this.wid.add(-1);
                this.widB.add(-1);
                int NbOfChildren = n;
                this.child.add(new ArrayList());
                int ichild = 0;
                while (ichild < NbOfChildren) {
                    n = 0;
                    try {
                        n = Integer.parseInt(fields[ichild + 3]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.child.get(inode).add(n);
                    ++ichild;
                }
                ++inode;
            }
            return true;
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while getting file stream! Input-output error!", "NooJ", 0);
            return false;
        }
    }

    public static String convert(StringBuilder label) {
        StringBuilder input = new StringBuilder();
        int iinput = 0;
        while (iinput < label.length() && label.charAt(iinput) != '/') {
            if (label.charAt(iinput) == '\\') {
                if (label.charAt(iinput + 1) != '+') {
                    input.append(label.charAt(iinput));
                }
                input.append(label.charAt(++iinput));
            } else if (label.charAt(iinput) == '+') {
                input.append('\n');
            } else if (label.charAt(iinput) == '\"') {
                input.append('\"');
                ++iinput;
                while (iinput < label.length() && label.charAt(iinput) != '\"') {
                    input.append(label.charAt(iinput));
                    ++iinput;
                }
                if (iinput < label.length()) {
                    input.append(label.charAt(iinput));
                } else {
                    input.append('\"');
                }
            } else if (label.charAt(iinput) == '<') {
                input.append(label.charAt(iinput));
                ++iinput;
                while (iinput < label.length() && label.charAt(iinput) != '>') {
                    input.append(label.charAt(iinput));
                    ++iinput;
                }
                if (iinput < label.length()) {
                    input.append(label.charAt(iinput));
                } else {
                    input.append('>');
                }
            } else {
                input.append(label.charAt(iinput));
            }
            ++iinput;
        }
        return input.toString();
    }

    public int[] getArrHei() {
        return this.arrHei;
    }

    public int[] getArrWid() {
        return this.arrWid;
    }

    public int[] getArrPosX() {
        return this.arrPosX;
    }

    public int[] getArrPosY() {
        return this.arrPosY;
    }

    public String[] getArrLabel() {
        return this.arrLabel;
    }

    public int[][] getArrChild() {
        return this.arrChild;
    }

    public ArrayList<ArrayList<Object>> getExtraParams() {
        return this.extraParams;
    }

    public void setArrHei(int[] arrHei) {
        this.arrHei = arrHei;
    }

    public void setArrWid(int[] arrWid) {
        this.arrWid = arrWid;
    }

    public void setArrPosX(int[] arrPosX) {
        this.arrPosX = arrPosX;
    }

    public void setArrPosY(int[] arrPosY) {
        this.arrPosY = arrPosY;
    }

    public void setArrLabel(String[] arrLabel) {
        this.arrLabel = arrLabel;
    }

    public void setArrChild(int[][] arrChild) {
        this.arrChild = arrChild;
    }

    public void setExtraParams(ArrayList<ArrayList<Object>> extraParams) {
        this.extraParams = extraParams;
    }
}

