/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Locale;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.helper.ParameterCheck;
import org.apache.commons.lang3.StringUtils;

public class Language
implements Serializable {
    private static final long serialVersionUID = 849794032433789267L;
    public String isoName;
    public String natName;
    public String engName;
    public boolean rightToLeft;
    public boolean asianTokenizer;
    public boolean russianTokenizer;
    public Locale locale;
    public ArrayList<String> chartable;
    public static final String UTF8_BOM = "\ufeff";

    public Language(String isoname) {
        this.isoName = isoname;
        this.chartable = null;
        this.natName = null;
        this.engName = null;
        if (isoname == null) {
            return;
        }
        if (isoname.equals("ac")) {
            this.natName = "Acadien";
            this.engName = "Acadian";
            this.locale = new Locale("fr", "CA");
            this.rightToLeft = false;
        } else if (isoname.equals("ar")) {
            this.engName = "Arabic";
            this.locale = new Locale("ar", "SA");
            this.rightToLeft = true;
        } else if (isoname.equals("bg")) {
            this.locale = new Locale("bg", "BG");
            this.rightToLeft = false;
        } else if (isoname.equals("br")) {
            this.natName = "Berber";
            this.engName = "Berber";
            this.locale = new Locale("en", "US");
            this.rightToLeft = false;
        } else if (isoname.equals("be")) {
            this.locale = new Locale("be", "BY");
            this.rightToLeft = false;
            this.russianTokenizer = true;
        } else if (isoname.equals("ca")) {
            this.locale = new Locale("ca", "ES");
            this.rightToLeft = false;
        } else if (isoname.equals("cz")) {
            this.locale = new Locale("cs", "CZ");
            this.rightToLeft = false;
        } else if (isoname.equals("da")) {
            this.locale = new Locale("da", "DK");
            this.rightToLeft = false;
        } else if (isoname.equals("de")) {
            this.locale = new Locale("de", "DE");
            this.rightToLeft = false;
        } else if (isoname.equals("el")) {
            this.locale = new Locale("el", "GR");
            this.rightToLeft = false;
        } else if (isoname.equals("en")) {
            this.locale = new Locale("en", "US");
            this.rightToLeft = false;
        } else if (isoname.equals("fa")) {
            this.locale = new Locale("fa", "IR");
            this.rightToLeft = true;
        } else if (isoname.equals("fi")) {
            this.locale = new Locale("fi", "FI");
            this.rightToLeft = false;
        } else if (isoname.equals("fr")) {
            this.locale = new Locale("fr", "FR");
            this.rightToLeft = false;
        } else if (isoname.equals("he")) {
            this.locale = new Locale("he", "IL");
            this.rightToLeft = true;
        } else if (isoname.equals("hi")) {
            this.locale = new Locale("hi", "IN");
            this.rightToLeft = false;
        } else if (isoname.equals("hr")) {
            this.locale = new Locale("hr", "HR");
            this.rightToLeft = false;
        } else if (isoname.equals("hu")) {
            this.locale = new Locale("hu", "HU");
            this.rightToLeft = false;
        } else if (isoname.equals("hy")) {
            this.locale = new Locale("hy", "AM");
            this.rightToLeft = false;
        } else if (isoname.equals("ma")) {
            this.natName = "kreol morisyen";
            this.engName = "Mauritian";
            this.locale = new Locale("fr", "FR");
            this.rightToLeft = false;
        } else if (isoname.equals("it")) {
            this.locale = new Locale("it", "IT");
            this.rightToLeft = false;
        } else if (isoname.equals("ja")) {
            this.locale = new Locale("ja", "JP");
            this.rightToLeft = false;
            this.asianTokenizer = true;
        } else if (isoname.equals("ko")) {
            this.locale = new Locale("ko", "KR");
            this.rightToLeft = false;
        } else if (isoname.equals("ku")) {
            this.natName = "kurmanc\u00ee";
            this.engName = "Kurdish";
            this.locale = new Locale("en", "US");
            this.rightToLeft = false;
        } else if (isoname.equals("ks")) {
            this.natName = "Kurdish (sorani dialect)";
            this.engName = "\u06a9\u0648\u0631\u062f\u064a";
            this.locale = new Locale("fa", "IR");
            this.rightToLeft = true;
        } else if (isoname.equals("la")) {
            this.natName = "Lingva Latina";
            this.engName = "Latin";
            this.locale = new Locale("en", "US");
            this.rightToLeft = false;
        } else if (isoname.equals("mg")) {
            this.natName = "Malagasy";
            this.engName = "Malagasy";
            this.locale = new Locale("en", "US");
            this.rightToLeft = false;
        } else if (isoname.equals("mk")) {
            this.locale = new Locale("mk", "MK");
            this.rightToLeft = false;
        } else if (isoname.equals("np")) {
            this.natName = "Nimipuu";
            this.engName = "Nez Perce";
            this.locale = new Locale("en", "US");
            this.rightToLeft = false;
        } else if (isoname.equals("pt")) {
            this.locale = new Locale("pt", "PT");
            this.rightToLeft = false;
        } else if (isoname.equals("ro")) {
            this.locale = new Locale("ro", "RO");
            this.rightToLeft = false;
        } else if (isoname.equals("ru")) {
            this.locale = new Locale("ru", "RU");
            this.rightToLeft = false;
            this.russianTokenizer = true;
        } else if (isoname.equals("pl")) {
            this.locale = new Locale("pl", "PL");
            this.rightToLeft = false;
        } else if (isoname.equals("sa")) {
            this.locale = new Locale("sa", "IN");
            this.rightToLeft = false;
        } else if (isoname.equals("sy")) {
            this.natName = "Syriac";
            this.engName = "Syriac";
            this.locale = new Locale("ar", "SA");
            this.rightToLeft = true;
        } else if (isoname.equals("sp")) {
            this.locale = new Locale("es", "ES");
            this.rightToLeft = false;
        } else if (isoname.equals("sq")) {
            this.locale = new Locale("sq", "AL");
            this.rightToLeft = false;
        } else if (isoname.equals("sr")) {
            this.locale = new Locale("sr", "RS");
            this.rightToLeft = false;
        } else if (isoname.equals("sw")) {
            this.natName = "Kiswahili";
            this.engName = "Kiswahili";
            this.locale = new Locale("sw", "KE");
            this.rightToLeft = false;
        } else if (isoname.equals("th")) {
            this.locale = new Locale("th", "TH");
            this.rightToLeft = false;
            this.asianTokenizer = true;
        } else if (isoname.equals("tm")) {
            this.natName = "Tamajaq";
            this.engName = "Tamajaq";
            this.locale = new Locale("en", "US");
            this.rightToLeft = false;
        } else if (isoname.equals("tr")) {
            this.locale = new Locale("tr", "TR");
            this.rightToLeft = false;
        } else if (isoname.equals("uk")) {
            this.locale = new Locale("uk", "UA");
            this.rightToLeft = false;
        } else if (isoname.equals("vi")) {
            this.locale = new Locale("vi", "VN");
            this.rightToLeft = false;
        } else if (isoname.equals("wo")) {
            this.locale = new Locale("wo", "SN");
            this.rightToLeft = false;
        } else if (isoname.equals("zh")) {
            this.locale = new Locale("zh", "TW");
            this.rightToLeft = false;
            this.asianTokenizer = true;
        }
        if (this.natName == null) {
            if (this.locale == null) {
                this.locale = new Locale("en", "US");
                this.natName = "Unknown";
                this.engName = "Unknown";
            } else {
                this.natName = this.locale.getDisplayName(this.locale);
                this.engName = this.locale.getDisplayName(Locale.ENGLISH);
            }
        }
    }

    public static String[] getAllLanguages() {
        ArrayList<String> all = new ArrayList<String>();
        all.add("ac");
        all.add("ar");
        all.add("be");
        all.add("bg");
        all.add("br");
        all.add("ca");
        all.add("cz");
        all.add("da");
        all.add("de");
        all.add("el");
        all.add("en");
        all.add("fa");
        all.add("fi");
        all.add("fr");
        all.add("he");
        all.add("hr");
        all.add("hi");
        all.add("hu");
        all.add("hy");
        all.add("it");
        all.add("ja");
        all.add("ko");
        all.add("ku");
        all.add("ks");
        all.add("la");
        all.add("mk");
        all.add("ma");
        all.add("mg");
        all.add("np");
        all.add("pl");
        all.add("pt");
        all.add("ro");
        all.add("ru");
        all.add("sa");
        all.add("sy");
        all.add("sp");
        all.add("sq");
        all.add("sr");
        all.add("sw");
        all.add("th");
        all.add("tm");
        all.add("tr");
        all.add("uk");
        all.add("vi");
        all.add("wo");
        all.add("zh");
        return all.toArray(new String[all.size()]);
    }

    public static boolean isALanguage(String isoName) {
        String[] alllanguages = Language.getAllLanguages();
        int index = -1;
        int i = 0;
        while (i < alllanguages.length) {
            if (isoName.equals(alllanguages[i])) {
                index = i;
            }
            ++i;
        }
        return index != -1;
    }

    static boolean isVowel(char c) {
        switch (c) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': {
                return true;
            }
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return true;
            }
            case '\u05b0': 
            case '\u05b1': 
            case '\u05b2': 
            case '\u05b3': 
            case '\u05b4': 
            case '\u05b5': 
            case '\u05b6': 
            case '\u05b7': 
            case '\u05b8': 
            case '\u05b9': 
            case '\u05bb': 
            case '\u05bc': 
            case '\u05c1': 
            case '\u05c2': {
                return true;
            }
            case '\u064b': 
            case '\u064c': 
            case '\u064d': 
            case '\u064e': 
            case '\u064f': 
            case '\u0650': 
            case '\u0651': 
            case '\u0652': {
                return true;
            }
        }
        return false;
    }

    public static boolean isLetter(char c) {
        if (Character.isLetter(c)) {
            return true;
        }
        switch (c) {
            case '\u00b7': {
                return true;
            }
            case '\u055c': {
                return true;
            }
            case '\u055e': {
                return true;
            }
            case '\u055b': {
                return true;
            }
            case '\u05b0': {
                return true;
            }
            case '\u05b1': {
                return true;
            }
            case '\u05b2': {
                return true;
            }
            case '\u05b3': {
                return true;
            }
            case '\u05b4': {
                return true;
            }
            case '\u05b5': {
                return true;
            }
            case '\u05b6': {
                return true;
            }
            case '\u05b7': {
                return true;
            }
            case '\u05b8': {
                return true;
            }
            case '\u05c2': {
                return true;
            }
            case '\u05c1': {
                return true;
            }
            case '\u05b9': {
                return true;
            }
            case '\u05bc': {
                return true;
            }
            case '\u05bb': {
                return true;
            }
            case '\u064c': {
                return true;
            }
            case '\u064b': {
                return true;
            }
            case '\u064d': {
                return true;
            }
            case '\u064f': {
                return true;
            }
            case '\u064e': {
                return true;
            }
            case '\u0650': {
                return true;
            }
            case '\u0652': {
                return true;
            }
            case '\u0651': {
                return true;
            }
            case '\u0301': {
                return true;
            }
            case '\u0300': {
                return true;
            }
            case '\u0303': {
                return true;
            }
            case '\u0309': {
                return true;
            }
            case '\u0323': {
                return true;
            }
            case '\u01a0': {
                return true;
            }
            case '\u0901': {
                return true;
            }
            case '\u0902': {
                return true;
            }
            case '\u0903': {
                return true;
            }
            case '\u093c': {
                return true;
            }
            case '\u093e': {
                return true;
            }
            case '\u093f': {
                return true;
            }
            case '\u0940': {
                return true;
            }
            case '\u0941': {
                return true;
            }
            case '\u0942': {
                return true;
            }
            case '\u0943': {
                return true;
            }
            case '\u0945': {
                return true;
            }
            case '\u0947': {
                return true;
            }
            case '\u0948': {
                return true;
            }
            case '\u0949': {
                return true;
            }
            case '\u094b': {
                return true;
            }
            case '\u094c': {
                return true;
            }
            case '\u094d': {
                return true;
            }
            case '\u0341': {
                return true;
            }
            case '\u030c': {
                return true;
            }
        }
        return false;
    }

    private static boolean isNotAccented(char c) {
        switch (c) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': 
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return true;
            }
            case '\u0389': 
            case '\u0391': 
            case '\u0395': 
            case '\u0399': 
            case '\u039f': 
            case '\u03a5': 
            case '\u03a9': 
            case '\u03b1': 
            case '\u03b5': 
            case '\u03b7': 
            case '\u03b9': 
            case '\u03bf': 
            case '\u03c5': 
            case '\u03c9': {
                return true;
            }
        }
        return false;
    }

    static boolean isAccented(char c) {
        switch (c) {
            case '\u00e0': 
            case '\u00e1': 
            case '\u00e2': 
            case '\u00e4': 
            case '\u00e8': 
            case '\u00e9': 
            case '\u00ea': 
            case '\u00eb': 
            case '\u00ec': 
            case '\u00ed': 
            case '\u00ee': 
            case '\u00ef': 
            case '\u00f2': 
            case '\u00f3': 
            case '\u00f4': 
            case '\u00f6': 
            case '\u00f9': 
            case '\u00fa': 
            case '\u00fb': 
            case '\u00fc': 
            case '\u0151': 
            case '\u0171': {
                return true;
            }
            case '\u00c0': 
            case '\u00c1': 
            case '\u00c2': 
            case '\u00c4': 
            case '\u00c8': 
            case '\u00c9': 
            case '\u00ca': 
            case '\u00cb': 
            case '\u00cc': 
            case '\u00ce': 
            case '\u00cf': 
            case '\u00d2': 
            case '\u00d3': 
            case '\u00d4': 
            case '\u00d6': 
            case '\u00d9': 
            case '\u00da': 
            case '\u00db': 
            case '\u00dc': {
                return true;
            }
            case '\u0390': 
            case '\u03b0': 
            case '\u03ca': 
            case '\u03cb': 
            case '\u03cd': 
            case '\u03ce': 
            case '\u1f00': 
            case '\u1f08': 
            case '\u1f10': 
            case '\u1f18': 
            case '\u1f20': 
            case '\u1f28': 
            case '\u1f30': 
            case '\u1f38': 
            case '\u1f40': 
            case '\u1f48': 
            case '\u1f68': {
                return true;
            }
            case '\u1f01': 
            case '\u1f09': 
            case '\u1f11': 
            case '\u1f19': 
            case '\u1f21': 
            case '\u1f29': 
            case '\u1f31': 
            case '\u1f39': 
            case '\u1f41': 
            case '\u1f49': 
            case '\u1f51': 
            case '\u1f59': 
            case '\u1f61': 
            case '\u1f69': 
            case '\u1fe5': 
            case '\u1fec': {
                return true;
            }
            case '\u1fb6': 
            case '\u1fc6': 
            case '\u1fe6': 
            case '\u1ff6': {
                return true;
            }
            case '\u1fb3': 
            case '\u1fc3': 
            case '\u1fcc': 
            case '\u1ff3': 
            case '\u1ffc': {
                return true;
            }
            case '\u1f70': 
            case '\u1f72': 
            case '\u1f74': 
            case '\u1f76': 
            case '\u1f78': 
            case '\u1f7a': 
            case '\u1f7c': {
                return true;
            }
            case '\u1fba': 
            case '\u1fc8': 
            case '\u1fca': 
            case '\u1fda': 
            case '\u1fea': 
            case '\u1ff8': 
            case '\u1ffa': {
                return true;
            }
            case '\u1f71': 
            case '\u1f73': 
            case '\u1f75': 
            case '\u1f77': 
            case '\u1f79': 
            case '\u1f7b': 
            case '\u1f7d': {
                return true;
            }
            case '\u1fbb': 
            case '\u1fc9': 
            case '\u1fcb': 
            case '\u1fdb': 
            case '\u1ff9': 
            case '\u1ffb': {
                return true;
            }
            case '\u0451': {
                return true;
            }
            case '\u0401': {
                return true;
            }
        }
        return false;
    }

    static boolean isKatakana(char c) {
        return c >= '\u30a0' && c <= '\u30ff';
    }

    static boolean isUniHan(char c) {
        return c >= '\u4e00' && c <= '\u9fcf' || c >= '\u3400' && c <= '\u4dbf';
    }

    static boolean isHiragana(char c) {
        return c >= '\u3040' && c <= '\u309f';
    }

    private static char finalize(char c) {
        switch (c) {
            case '\u05db': {
                return '\u05da';
            }
            case '\u05de': {
                return '\u05dd';
            }
            case '\u05e0': {
                return '\u05df';
            }
            case '\u05e4': {
                return '\u05e3';
            }
            case '\u05e6': {
                return '\u05e5';
            }
            case '\u05da': {
                return '\u05db';
            }
            case '\u05dd': {
                return '\u05de';
            }
            case '\u05df': {
                return '\u05e0';
            }
            case '\u05e3': {
                return '\u05e4';
            }
            case '\u05e5': {
                return '\u05e6';
            }
        }
        return c;
    }

    private static char toNoAccent(char u) {
        switch (u) {
            case '\u00c0': 
            case '\u00c1': 
            case '\u00c2': 
            case '\u00c4': {
                return 'A';
            }
            case '\u00c8': 
            case '\u00c9': 
            case '\u00ca': 
            case '\u00cb': {
                return 'E';
            }
            case '\u00cc': 
            case '\u00cd': 
            case '\u00ce': 
            case '\u00cf': {
                return 'I';
            }
            case '\u00d2': 
            case '\u00d3': 
            case '\u00d4': 
            case '\u00d6': {
                return 'O';
            }
            case '\u0150': {
                return '\u00d6';
            }
            case '\u00d9': 
            case '\u00da': 
            case '\u00db': 
            case '\u00dc': {
                return 'U';
            }
            case '\u0170': {
                return '\u00dc';
            }
            case '\u00e0': 
            case '\u00e1': 
            case '\u00e2': 
            case '\u00e4': {
                return 'a';
            }
            case '\u00e8': 
            case '\u00e9': 
            case '\u00ea': 
            case '\u00eb': {
                return 'e';
            }
            case '\u00ec': 
            case '\u00ed': 
            case '\u00ee': 
            case '\u00ef': {
                return 'i';
            }
            case '\u00f2': 
            case '\u00f3': 
            case '\u00f4': 
            case '\u00f6': {
                return 'o';
            }
            case '\u0151': {
                return '\u00f6';
            }
            case '\u00f9': 
            case '\u00fa': 
            case '\u00fb': 
            case '\u00fc': {
                return 'u';
            }
            case '\u0171': {
                return '\u00fc';
            }
            case '\u1f08': {
                return '\u0391';
            }
            case '\u1f18': {
                return '\u0395';
            }
            case '\u1f28': {
                return '\u0397';
            }
            case '\u1f38': {
                return '\u0399';
            }
            case '\u1f48': {
                return '\u039f';
            }
            case '\u1f68': {
                return '\u03a9';
            }
            case '\u1f00': {
                return '\u03b1';
            }
            case '\u1f10': {
                return '\u03b5';
            }
            case '\u1f20': {
                return '\u03b7';
            }
            case '\u1f30': {
                return '\u03b9';
            }
            case '\u1f40': {
                return '\u03bf';
            }
            case '\u03cd': {
                return '\u03c5';
            }
            case '\u03ce': {
                return '\u03c9';
            }
            case '\u0390': {
                return '\u03ca';
            }
            case '\u03b0': {
                return '\u03cb';
            }
            case '\u03ca': {
                return '\u03b9';
            }
            case '\u03cb': {
                return '\u03c5';
            }
            case '\u1f09': {
                return '\u0391';
            }
            case '\u1f19': {
                return '\u0395';
            }
            case '\u1f29': {
                return '\u0397';
            }
            case '\u1f39': {
                return '\u0399';
            }
            case '\u1f49': {
                return '\u039f';
            }
            case '\u1fec': {
                return '\u03a1';
            }
            case '\u1f59': {
                return '\u03a5';
            }
            case '\u1f69': {
                return '\u03a9';
            }
            case '\u1f01': {
                return '\u03b1';
            }
            case '\u1f11': {
                return '\u03b5';
            }
            case '\u1f21': {
                return '\u03b7';
            }
            case '\u1f31': {
                return '\u03b9';
            }
            case '\u1f41': {
                return '\u03bf';
            }
            case '\u1fe5': {
                return '\u03c1';
            }
            case '\u1f51': {
                return '\u03c5';
            }
            case '\u1f61': {
                return '\u03c9';
            }
            case '\u1fb6': {
                return '\u03b1';
            }
            case '\u1fc6': {
                return '\u03b7';
            }
            case '\u1fe6': {
                return '\u03c5';
            }
            case '\u1ff6': {
                return '\u03c9';
            }
            case '\u1fcc': {
                return '\u0397';
            }
            case '\u1ffc': {
                return '\u03a9';
            }
            case '\u1fb3': {
                return '\u03b1';
            }
            case '\u1fc3': {
                return '\u03b7';
            }
            case '\u1ff3': {
                return '\u03c9';
            }
            case '\u1f70': {
                return '\u03b1';
            }
            case '\u1f72': {
                return '\u03b5';
            }
            case '\u1f74': {
                return '\u03b7';
            }
            case '\u1f76': {
                return '\u03b9';
            }
            case '\u1f78': {
                return '\u03bf';
            }
            case '\u1f7a': {
                return '\u03c5';
            }
            case '\u1f7c': {
                return '\u03c9';
            }
            case '\u1fba': {
                return '\u0391';
            }
            case '\u1fc8': {
                return '\u0395';
            }
            case '\u1fca': {
                return '\u0397';
            }
            case '\u1fda': {
                return '\u0399';
            }
            case '\u1ff8': {
                return '\u039f';
            }
            case '\u1fea': {
                return '\u03a5';
            }
            case '\u1ffa': {
                return '\u03a9';
            }
            case '\u1f71': {
                return '\u03b1';
            }
            case '\u1f73': {
                return '\u03b5';
            }
            case '\u1f75': {
                return '\u03b7';
            }
            case '\u1f77': {
                return '\u03b9';
            }
            case '\u1f79': {
                return '\u03bf';
            }
            case '\u1f7b': {
                return '\u03c5';
            }
            case '\u1f7d': {
                return '\u03c9';
            }
            case '\u1fbb': {
                return '\u0391';
            }
            case '\u1fc9': {
                return '\u0395';
            }
            case '\u1fcb': {
                return '\u0397';
            }
            case '\u1fdb': {
                return '\u0399';
            }
            case '\u1ff9': {
                return '\u039f';
            }
            case '\u1ffb': {
                return '\u03a9';
            }
            case '\u0451': {
                return '\u0435';
            }
            case '\u0401': {
                return '\u0415';
            }
        }
        return u;
    }

    private char toAcute(char u) {
        switch (u) {
            case 'A': {
                return '\u00c1';
            }
            case 'E': {
                return '\u00c9';
            }
            case 'I': {
                return '\u00cd';
            }
            case 'O': {
                return '\u00d3';
            }
            case 'U': {
                return '\u00da';
            }
            case 'a': {
                return '\u00e1';
            }
            case 'e': {
                return '\u00e9';
            }
            case 'i': {
                return '\u00ed';
            }
            case 'o': {
                return '\u00f3';
            }
            case 'u': {
                return '\u00fa';
            }
            case '\u0391': {
                return '\u0386';
            }
            case '\u0395': {
                return '\u0388';
            }
            case '\u0397': {
                return '\u0389';
            }
            case '\u0399': {
                return '\u038a';
            }
            case '\u039f': {
                return '\u038c';
            }
            case '\u03a5': {
                return '\u038e';
            }
            case '\u03a9': {
                return '\u038f';
            }
            case '\u03b1': {
                return '\u03ac';
            }
            case '\u03b5': {
                return '\u03ad';
            }
            case '\u03b7': {
                return '\u03ae';
            }
            case '\u03b9': {
                return '\u03af';
            }
            case '\u03bf': {
                return '\u03cc';
            }
            case '\u03c5': {
                return '\u03cd';
            }
            case '\u03c9': {
                return '\u03ce';
            }
            case '\u03ca': {
                return '\u0390';
            }
            case '\u03cb': {
                return '\u03b0';
            }
        }
        return u;
    }

    private char toGrave(char u) {
        switch (u) {
            case 'A': {
                return '\u00c0';
            }
            case 'E': {
                return '\u00c8';
            }
            case 'I': {
                return '\u00cc';
            }
            case 'O': {
                return '\u00d2';
            }
            case 'U': {
                return '\u00d9';
            }
            case 'a': {
                return '\u00e0';
            }
            case 'e': {
                return '\u00e8';
            }
            case 'i': {
                return '\u00ec';
            }
            case 'o': {
                return '\u00f2';
            }
            case 'u': {
                return '\u00f9';
            }
            case '\u0391': {
                return '\u1fba';
            }
            case '\u0395': {
                return '\u1fc8';
            }
            case '\u0389': {
                return '\u1fca';
            }
            case '\u0399': {
                return '\u1fda';
            }
            case '\u039f': {
                return '\u1ff8';
            }
            case '\u03a5': {
                return '\u1fea';
            }
            case '\u03a9': {
                return '\u1ffa';
            }
            case '\u03b1': {
                return '\u1f70';
            }
            case '\u03b5': {
                return '\u1f72';
            }
            case '\u03b7': {
                return '\u1f74';
            }
            case '\u03b9': {
                return '\u1f76';
            }
            case '\u03bf': {
                return '\u1f78';
            }
            case '\u03c5': {
                return '\u1f7a';
            }
            case '\u03c9': {
                return '\u1f7c';
            }
        }
        return u;
    }

    private char toCircumflex(char u) {
        switch (u) {
            case 'A': {
                return '\u00c2';
            }
            case 'E': {
                return '\u00ca';
            }
            case 'I': {
                return '\u00ce';
            }
            case 'O': {
                return '\u00d4';
            }
            case 'U': {
                return '\u00db';
            }
            case 'a': {
                return '\u00e2';
            }
            case 'e': {
                return '\u00ea';
            }
            case 'i': {
                return '\u00ee';
            }
            case 'o': {
                return '\u00f4';
            }
            case 'u': {
                return '\u00fb';
            }
            case '\u03b1': {
                return '\u1fb6';
            }
            case '\u03b7': {
                return '\u1fc6';
            }
            case '\u03c5': {
                return '\u1fe6';
            }
            case '\u03c9': {
                return '\u1ff6';
            }
        }
        return u;
    }

    private char toTrema(char u) {
        switch (u) {
            case 'A': {
                return '\u00c4';
            }
            case 'E': {
                return '\u00cb';
            }
            case 'I': {
                return '\u00cf';
            }
            case 'O': {
                return '\u00d6';
            }
            case 'U': {
                return '\u00dc';
            }
            case 'a': {
                return '\u00e4';
            }
            case 'e': {
                return '\u00eb';
            }
            case 'i': {
                return '\u00ef';
            }
            case 'o': {
                return '\u00f6';
            }
            case 'u': {
                return '\u00fc';
            }
            case '\u0391': {
                return '\u1f08';
            }
            case '\u0395': {
                return '\u1f18';
            }
            case '\u0397': {
                return '\u1f28';
            }
            case '\u0399': {
                return '\u1f38';
            }
            case '\u039f': {
                return '\u1f48';
            }
            case '\u03a9': {
                return '\u1f68';
            }
            case '\u03b1': {
                return '\u1f00';
            }
            case '\u03b5': {
                return '\u1f10';
            }
            case '\u03b7': {
                return '\u1f20';
            }
            case '\u03b9': {
                return '\u03ca';
            }
            case '\u03bf': {
                return '\u1f40';
            }
            case '\u03c9': {
                return '\u03ce';
            }
            case '\u03c5': {
                return '\u03cb';
            }
        }
        return u;
    }

    private char toIota(char u) {
        switch (u) {
            case '\u03b1': {
                return '\u1fb3';
            }
            case '\u1f00': {
                return '\u1f80';
            }
            case '\u1f01': {
                return '\u1f81';
            }
            case '\u1f02': {
                return '\u1f82';
            }
            case '\u1f03': {
                return '\u1f83';
            }
            case '\u1f04': {
                return '\u1f84';
            }
            case '\u1f05': {
                return '\u1f85';
            }
            case '\u1f06': {
                return '\u1f86';
            }
            case '\u1f07': {
                return '\u1f87';
            }
            case '\u1f08': {
                return '\u1f88';
            }
            case '\u1f09': {
                return '\u1f89';
            }
            case '\u1f0a': {
                return '\u1f8a';
            }
            case '\u1f0b': {
                return '\u1f8b';
            }
            case '\u1f0c': {
                return '\u1f8c';
            }
            case '\u1f0d': {
                return '\u1f8d';
            }
            case '\u1f0e': {
                return '\u1f8e';
            }
            case '\u1f0f': {
                return '\u1f8f';
            }
            case '\u03c9': {
                return '\u1ff3';
            }
            case '\u1f60': {
                return '\u1fa0';
            }
            case '\u1f61': {
                return '\u1fa1';
            }
            case '\u1f62': {
                return '\u1fa2';
            }
            case '\u1f63': {
                return '\u1fa3';
            }
            case '\u1f64': {
                return '\u1fa4';
            }
            case '\u1f65': {
                return '\u1fa5';
            }
            case '\u1f66': {
                return '\u1fa6';
            }
            case '\u1f67': {
                return '\u1fa7';
            }
            case '\u1f68': {
                return '\u1fa8';
            }
            case '\u1f69': {
                return '\u1fa9';
            }
            case '\u1f6a': {
                return '\u1faa';
            }
            case '\u1f6b': {
                return '\u1fab';
            }
            case '\u1f6c': {
                return '\u1fac';
            }
            case '\u1f6d': {
                return '\u1fad';
            }
            case '\u1f6e': {
                return '\u1fae';
            }
            case '\u1f6f': {
                return '\u1faf';
            }
            case '\u03b7': {
                return '\u1fc3';
            }
            case '\u1f20': {
                return '\u1f90';
            }
            case '\u1f21': {
                return '\u1f91';
            }
            case '\u1f22': {
                return '\u1f92';
            }
            case '\u1f23': {
                return '\u1f93';
            }
            case '\u1f24': {
                return '\u1f94';
            }
            case '\u1f25': {
                return '\u1f95';
            }
            case '\u1f26': {
                return '\u1f96';
            }
            case '\u1f27': {
                return '\u1f97';
            }
            case '\u1f74': {
                return '\u1fc2';
            }
            case '\u1f75': {
                return '\u1fc4';
            }
            case '\u1fc6': {
                return '\u1fc7';
            }
            case '\u1f28': {
                return '\u1f98';
            }
            case '\u1f29': {
                return '\u1f99';
            }
            case '\u1f2a': {
                return '\u1f9a';
            }
            case '\u1f2b': {
                return '\u1f9b';
            }
            case '\u1f2c': {
                return '\u1f9c';
            }
            case '\u1f2d': {
                return '\u1f9d';
            }
            case '\u1f2e': {
                return '\u1f9e';
            }
            case '\u1f2f': {
                return '\u1f9f';
            }
        }
        return u;
    }

    static boolean isLower(String word) {
        return StringUtils.isAllLowerCase(word);
    }

    static boolean isUpper(String word) {
        return StringUtils.isAllUpperCase(word);
    }

    static boolean isCapital(String word) {
        if (word == null || word.length() == 0) {
            return false;
        }
        if (!Character.isUpperCase(word.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < word.length()) {
            if (!Character.isLowerCase(word.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    final boolean isACompound(String word) {
        if (word == null || word.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < word.length()) {
            if (!Language.isLetter(word.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final boolean loadCharacterVariants(String filePath, StringBuilder errMessage) throws IOException {
        ParameterCheck.mandatory("errMessage", errMessage);
        boolean thereIsNoError = true;
        this.chartable = new ArrayList();
        errMessage.delete(0, errMessage.length());
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF8"));
            String line = reader.readLine();
            while (line != null) {
                if (!line.equals("")) {
                    if (line.startsWith(UTF8_BOM)) {
                        line = line.substring(1);
                    }
                    if (line.charAt(0) != '#') {
                        if (line.length() < 3) {
                            errMessage.append("Line \"" + line + "\" is too short");
                            Dic.writeLog(errMessage.toString());
                            thereIsNoError = false;
                            break;
                        }
                        int i = 0;
                        while (i < line.length() && line.charAt(i) != ':') {
                            ++i;
                        }
                        if (i >= line.length()) {
                            errMessage.append("Cannot parse line \"" + line + "\" (no colon)");
                            Dic.writeLog(errMessage.toString());
                            thereIsNoError = false;
                            break;
                        }
                        String pattern = line.substring(0, i);
                        String replace = line.substring(i + 1);
                        this.chartable.add(pattern);
                        this.chartable.add(replace);
                    }
                }
                line = reader.readLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return thereIsNoError;
    }

    final boolean doLettersMatch(char ctext, char cdic) {
        if (ctext == cdic) {
            return true;
        }
        if (this.isoName.equals("ar") || this.isoName.equals("he") || this.isoName.equals("ja") || this.isoName.equals("ko") || this.isoName.equals("zh")) {
            return false;
        }
        if (this.isoName.equals("ru")) {
            if (Language.isAccented(cdic)) {
                cdic = Language.toNoAccent(cdic);
            }
            if (ctext == cdic) {
                return true;
            }
        }
        if (Character.isUpperCase(ctext)) {
            char cdicupper = Character.toUpperCase(cdic);
            if (ctext == cdicupper) {
                return true;
            }
            if (!this.isoName.equals("de") && ctext == Language.toNoAccent(cdicupper)) {
                return true;
            }
        }
        return false;
    }

    final boolean doWordFormsMatch(String ctext, String cdic) {
        if (cdic.length() == 0) {
            return ctext.length() == 0;
        }
        if (Character.isUpperCase(cdic.charAt(0))) {
            Collator collator = Collator.getInstance(this.locale);
            return collator.compare(ctext, cdic) == 0;
        }
        Collator collator = Collator.getInstance(this.locale);
        return collator.compare(ctext.toLowerCase(this.locale), cdic.toLowerCase(this.locale)) == 0;
    }

    final String[] parseSequenceOfTokens(String sequence) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < sequence.length()) {
            int j;
            if (sequence.charAt(i) == '\\') {
                result.add(sequence.substring(i, i + 2));
                i += 2;
                continue;
            }
            if (sequence.charAt(i) == '<') {
                int embeddedAngle = 0;
                j = 1;
                while (i + j < sequence.length() && (sequence.charAt(i + j) != '>' || sequence.charAt(i + j) == '>' && embeddedAngle != 0)) {
                    if (sequence.charAt(i + j) == '<') {
                        ++embeddedAngle;
                    } else if (sequence.charAt(i + j) == '>') {
                        --embeddedAngle;
                    }
                    ++j;
                }
                if (i + j >= sequence.length()) {
                    return null;
                }
                result.add(sequence.substring(i, i + ++j));
                i += j;
                continue;
            }
            if (sequence.charAt(i) == '\"') {
                j = 1;
                while (i + j < sequence.length() && sequence.charAt(i + j) != '\"') {
                    ++j;
                }
                if (i + j >= sequence.length()) {
                    return null;
                }
                result.add(sequence.substring(i, i + ++j));
                i += j;
                continue;
            }
            if (Character.isWhitespace(sequence.charAt(i))) {
                ++i;
                continue;
            }
            if (Language.isLetter(sequence.charAt(i))) {
                j = 0;
                while (i + j < sequence.length() && Language.isLetter(sequence.charAt(i + j))) {
                    ++j;
                }
                result.add(sequence.substring(i, i + j));
                i += j;
                continue;
            }
            result.add(String.valueOf(sequence.charAt(i)));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    final String[] parseSequenceOfTokensAndMetaNodes(String sequence) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < sequence.length()) {
            int j;
            if (sequence.charAt(i) == '\\') {
                result.add(sequence.substring(i, i + 2));
                i += 2;
                continue;
            }
            if (sequence.charAt(i) == '<') {
                int embeddedAngle = 0;
                j = 1;
                while (i + j < sequence.length() && (sequence.charAt(i + j) != '>' || sequence.charAt(i + j) == '>' && embeddedAngle != 0)) {
                    if (sequence.charAt(i + j) == '<') {
                        ++embeddedAngle;
                    } else if (sequence.charAt(i + j) == '>') {
                        --embeddedAngle;
                    }
                    ++j;
                }
                if (i + j >= sequence.length()) {
                    return null;
                }
                result.add(sequence.substring(i, i + ++j));
                i += j;
                continue;
            }
            if (sequence.charAt(i) == '\"') {
                j = 1;
                while (i + j < sequence.length() && sequence.charAt(i + j) != '\"') {
                    ++j;
                }
                if (i + j >= sequence.length()) {
                    return null;
                }
                result.add(sequence.substring(i, i + ++j));
                i += j;
                continue;
            }
            if (sequence.charAt(i) == ':') {
                j = 1;
                while (i + j < sequence.length() && sequence.charAt(i + j) != '#') {
                    ++j;
                }
                if (j < sequence.length()) {
                    result.add(sequence.substring(i, i + ++j));
                } else {
                    result.add(sequence.substring(i));
                }
                i += j;
                continue;
            }
            if (sequence.charAt(i) == '$') {
                j = 1;
                while (i + j < sequence.length() && sequence.charAt(i + j) != '#') {
                    ++j;
                }
                if (j < sequence.length()) {
                    result.add(sequence.substring(i, i + ++j));
                } else {
                    result.add(sequence.substring(i));
                }
                i += j;
                continue;
            }
            if (Character.isWhitespace(sequence.charAt(i))) {
                ++i;
                continue;
            }
            if (Language.isLetter(sequence.charAt(i))) {
                j = 0;
                while (i + j < sequence.length() && Language.isLetter(sequence.charAt(i + j))) {
                    ++j;
                }
                result.add(sequence.substring(i, i + j));
                i += j;
                continue;
            }
            result.add(String.valueOf(sequence.charAt(i)));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    static int nbOfDagueshShinSinDotsIn(StringBuilder res, int ipos, int val) {
        ParameterCheck.mandatory("res", res);
        int val0 = val;
        int i = 0;
        while (i < val0 && ipos - i - 1 >= 0) {
            if (res.charAt(ipos - i - 1) == '\u05c1' || res.charAt(ipos - i - 1) == '\u05c2' || res.charAt(ipos - i - 1) == '\u05bc') {
                ++val0;
            }
            ++i;
        }
        return val0;
    }

    final int processInflection(String commands, StringBuilder res, int ic, int ires) {
        if (this.isoName.equals("ar")) {
            if (commands.charAt(ic + 1) == 'T') {
                if (ires - 1 < 0) {
                    return -1;
                }
                if (res.charAt(ires - 1) == '\u0629') {
                    char c = '\u062a';
                    res.setCharAt(ires - 1, c);
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == 'M') {
                if (ires - 1 < 0) {
                    return -1;
                }
                if (res.charAt(ires - 1) == '\u0646') {
                    res.insert(ires, '\u0651');
                    return ires + 1;
                }
                res.insert(ires, '\u0652');
                res.insert(ires + 1, '\u0646');
                return ires + 2;
            }
            if (commands.charAt(ic + 1) == 'Z') {
                if (ires - 1 < 0) {
                    return -1;
                }
                if (res.charAt(ires - 1) == '\u062a') {
                    res.insert(ires, '\u0651');
                    return ires + 1;
                }
                res.insert(ires, '\u0652');
                res.insert(ires + 1, '\u062a');
                return ires + 2;
            }
        } else if (this.isoName.equals("br")) {
            if (commands.charAt(ic + 1) == 'D') {
                if (ires - 1 < 0) {
                    return -1;
                }
                if (res.charAt(ires - 1) == '\u0263') {
                    res.setCharAt(ires - 1, 'q');
                    res.insert(ires, 'q');
                    ++ires;
                } else if (res.charAt(ires - 1) == '\u1e0d') {
                    res.setCharAt(ires - 1, '\u1e6d');
                    res.insert(ires, '\u1e6d');
                    ++ires;
                } else {
                    res.insert(ires, res.charAt(ires - 1));
                    ++ires;
                }
                return ires;
            }
        } else if (this.isoName.equals("hu")) {
            if (commands.charAt(ic + 1) == 'A') {
                if (ires - 1 < 0) {
                    return -1;
                }
                int j = ires - 1;
                while (j >= 0) {
                    if (Language.isAccented(res.charAt(j))) break;
                    --j;
                }
                if (j >= 0) {
                    res.setCharAt(j, Language.toNoAccent(res.charAt(j)));
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == '\u00c1') {
                if (ires - 1 < 0) {
                    return -1;
                }
                if (res.charAt(ires - 1) == 'a') {
                    res.setCharAt(ires - 1, '\u00e1');
                } else if (res.charAt(ires - 1) == 'e') {
                    res.setCharAt(ires - 1, '\u00e9');
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == 'D') {
                if (ires - 1 < 0) {
                    return -1;
                }
                if (res.charAt(ires - 1) != 'b' || ires < 2 || res.charAt(ires - 2) != res.charAt(ires - 1)) {
                    if (res.charAt(ires - 1) == 'a' || res.charAt(ires - 1) == '\u00e1' || res.charAt(ires - 1) == 'h') {
                        res.setCharAt(ires - 1, '\u00e1');
                        res.insert(ires, 'v');
                        ++ires;
                    } else if (res.charAt(ires - 1) == 'e' || res.charAt(ires - 1) == '\u00e9') {
                        res.setCharAt(ires - 1, '\u00e9');
                        res.insert(ires, 'v');
                        ++ires;
                    } else if (res.charAt(ires - 1) == 'i' || res.charAt(ires - 1) == '\u00ed' || res.charAt(ires - 1) == 'o' || res.charAt(ires - 1) == '\u00f3' || res.charAt(ires - 1) == '\u00f6' || res.charAt(ires - 1) == '\u0151' || res.charAt(ires - 1) == 'u' || res.charAt(ires - 1) == '\u00fa' || res.charAt(ires - 1) == '\u00fc' || res.charAt(ires - 1) == '\u0171') {
                        res.insert(ires, 'v');
                        ++ires;
                    } else if (ires >= 3) {
                        if (!(res.charAt(ires - 3) == 'c' && res.charAt(ires - 2) == 'c' && res.charAt(ires - 1) == 's' || res.charAt(ires - 3) == 'g' && res.charAt(ires - 2) == 'g' && res.charAt(ires - 1) == 'y' || res.charAt(ires - 3) == 'l' && res.charAt(ires - 2) == 'l' && res.charAt(ires - 1) == 'y' || res.charAt(ires - 3) == 'n' && res.charAt(ires - 2) == 'n' && res.charAt(ires - 1) == 'y' || res.charAt(ires - 3) == 't' && res.charAt(ires - 2) == 't' && res.charAt(ires - 1) == 'y' || res.charAt(ires - 3) == 's' && res.charAt(ires - 2) == 's' && res.charAt(ires - 1) == 'z' || res.charAt(ires - 3) == 'z' && res.charAt(ires - 2) == 'z' && res.charAt(ires - 1) == 's' || res.charAt(ires - 3) != 'd' || res.charAt(ires - 2) != 'z' || res.charAt(ires - 1) != 's')) {
                            res.setCharAt(ires - 2, 'd');
                            res.setCharAt(ires - 1, 'z');
                            res.insert(ires, 's');
                            ++ires;
                        }
                    } else if (ires >= 2) {
                        if (res.charAt(ires - 2) == 'c' && res.charAt(ires - 1) == 's') {
                            res.setCharAt(ires - 1, 'c');
                            res.insert(ires, 's');
                            ++ires;
                        } else if (res.charAt(ires - 2) == 'd' && res.charAt(ires - 1) == 'z') {
                            res.setCharAt(ires - 1, 'd');
                            res.insert(ires, 'z');
                            ++ires;
                        } else if (res.charAt(ires - 2) == 'g' && res.charAt(ires - 1) == 'y') {
                            res.setCharAt(ires - 1, 'g');
                            res.insert(ires, 'y');
                            ++ires;
                        } else if (res.charAt(ires - 2) == 'l' && res.charAt(ires - 1) == 'y') {
                            res.setCharAt(ires - 1, 'l');
                            res.insert(ires, 'y');
                            ++ires;
                        } else if (res.charAt(ires - 2) == 'n' && res.charAt(ires - 1) == 'y') {
                            res.setCharAt(ires - 1, 'n');
                            res.insert(ires, 'y');
                            ++ires;
                        } else if (res.charAt(ires - 2) == 's' && res.charAt(ires - 1) == 'z') {
                            res.setCharAt(ires - 1, 's');
                            res.insert(ires, 'z');
                            ++ires;
                        } else if (res.charAt(ires - 2) == 't' && res.charAt(ires - 1) == 'y') {
                            res.setCharAt(ires - 1, 't');
                            res.insert(ires, 'y');
                            ++ires;
                        } else if (res.charAt(ires - 2) == 'z' && res.charAt(ires - 1) == 's') {
                            res.setCharAt(ires - 1, 'z');
                            res.insert(ires, 's');
                            ++ires;
                        }
                    } else {
                        res.insert(ires, res.charAt(ires - 1));
                        ++ires;
                    }
                }
                return ires;
            }
        } else if (this.isoName.equals("sp")) {
            if (commands.charAt(ic + 1) == 'U') {
                if (ires - 1 < 0) {
                    return -1;
                }
                int j = ires - 1;
                while (j >= 0) {
                    if (res.charAt(j) == 'e' || res.charAt(j) == 'E' || res.charAt(j) == 'o' || res.charAt(j) == 'O') break;
                    --j;
                }
                if (j >= 0) {
                    if (res.charAt(j) == 'e') {
                        res.insert(j, 'i');
                    } else if (res.charAt(j) == 'E') {
                        res.insert(j, 'I');
                    } else if (res.charAt(j) == 'o') {
                        res.setCharAt(j, 'e');
                        res.insert(j, 'u');
                    } else if (res.charAt(j) == 'O') {
                        res.setCharAt(j, 'E');
                        res.insert(j, 'U');
                    }
                    ++ires;
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == 'A') {
                if (ires - 1 < 0) {
                    return -1;
                }
                int j = ires - 1;
                while (j >= 0) {
                    if (Language.isAccented(res.charAt(j))) break;
                    --j;
                }
                if (j >= 0) {
                    res.setCharAt(j, Language.toNoAccent(res.charAt(j)));
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == '\u00c1') {
                if (ires - 1 < 0) {
                    return -1;
                }
                int j = ires - 1;
                while (j >= 0) {
                    if (Language.isNotAccented(res.charAt(j))) break;
                    --j;
                }
                if (j >= 0) {
                    res.setCharAt(j, this.toAcute(res.charAt(j)));
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == '\u00c0') {
                if (ires - 1 < 0) {
                    return -1;
                }
                int j = ires - 1;
                while (j >= 0) {
                    if (Language.isNotAccented(res.charAt(j))) break;
                    --j;
                }
                if (j >= 0) {
                    res.setCharAt(j, this.toGrave(res.charAt(j)));
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == '\u00c2') {
                if (ires - 1 < 0) {
                    return -1;
                }
                int j = ires - 1;
                while (j >= 0) {
                    if (Language.isNotAccented(res.charAt(j))) break;
                    --j;
                }
                if (j >= 0) {
                    res.setCharAt(j, this.toCircumflex(res.charAt(j)));
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == '\u00c4') {
                if (ires - 1 < 0) {
                    return -1;
                }
                int j = ires - 1;
                while (j >= 0) {
                    if (Language.isNotAccented(res.charAt(j))) break;
                    --j;
                }
                if (j >= 0) {
                    res.setCharAt(j, this.toTrema(res.charAt(j)));
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == 'I') {
                if (ires - 1 < 0) {
                    return -1;
                }
                int j = ires - 1;
                while (j >= 0) {
                    if (Language.isNotAccented(res.charAt(j))) break;
                    --j;
                }
                if (j >= 0) {
                    res.setCharAt(j, this.toIota(res.charAt(j)));
                }
                return ires;
            }
        } else if (this.isoName.equals("pt") || this.isoName.equals("ca") || this.isoName.equals("de") || this.isoName.equals("el") || this.isoName.equals("it")) {
            if (commands.charAt(ic + 1) == 'A') {
                if (ires - 1 < 0) {
                    return -1;
                }
                int j = ires - 1;
                while (j >= 0) {
                    if (Language.isAccented(res.charAt(j))) break;
                    --j;
                }
                if (j >= 0) {
                    res.setCharAt(j, Language.toNoAccent(res.charAt(j)));
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == '\u00c1') {
                if (ires - 1 < 0) {
                    return -1;
                }
                int j = ires - 1;
                while (j >= 0) {
                    if (Language.isNotAccented(res.charAt(j))) break;
                    --j;
                }
                if (j >= 0) {
                    res.setCharAt(j, this.toAcute(res.charAt(j)));
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == '\u00c0') {
                if (ires - 1 < 0) {
                    return -1;
                }
                int j = ires - 1;
                while (j >= 0) {
                    if (Language.isNotAccented(res.charAt(j))) break;
                    --j;
                }
                if (j >= 0) {
                    res.setCharAt(j, this.toGrave(res.charAt(j)));
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == '\u00c2') {
                if (ires - 1 < 0) {
                    return -1;
                }
                int j = ires - 1;
                while (j >= 0) {
                    if (Language.isNotAccented(res.charAt(j))) break;
                    --j;
                }
                if (j >= 0) {
                    res.setCharAt(j, this.toCircumflex(res.charAt(j)));
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == '\u00c4') {
                if (ires - 1 < 0) {
                    return -1;
                }
                int j = ires - 1;
                while (j >= 0) {
                    if (Language.isNotAccented(res.charAt(j))) break;
                    --j;
                }
                if (j >= 0) {
                    res.setCharAt(j, this.toTrema(res.charAt(j)));
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == 'I') {
                if (ires - 1 < 0) {
                    return -1;
                }
                int j = ires - 1;
                while (j >= 0) {
                    if (Language.isNotAccented(res.charAt(j))) break;
                    --j;
                }
                if (j >= 0) {
                    res.setCharAt(j, this.toIota(res.charAt(j)));
                }
                return ires;
            }
        } else if (this.isoName.equals("he")) {
            if (commands.charAt(ic + 1) == 'F') {
                if (ires - 1 < 0) {
                    return -1;
                }
                if (res.charAt(ires - 1) == '\u05b0' && res.charAt(ires - 2) == '\u05da') {
                    res.setCharAt(ires - 2, '\u05db');
                    res.deleteCharAt(ires - 1);
                    --ires;
                } else if (res.charAt(ires - 1) == '\u05db') {
                    if (ires - 1 < 0) {
                        return -1;
                    }
                    res.setCharAt(ires - 1, '\u05da');
                    res.insert(ires, '\u05b0');
                    ++ires;
                } else {
                    if (ires - 1 < 0) {
                        return -1;
                    }
                    res.setCharAt(ires - 1, Language.finalize(res.charAt(ires - 1)));
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == 'G') {
                if (ires - 1 < 0) {
                    return -1;
                }
                if (res.charAt(ires - 1) == '\u05d1' || res.charAt(ires - 1) == '\u05d2' || res.charAt(ires - 1) == '\u05d3' || res.charAt(ires - 1) == '\u05db' || res.charAt(ires - 1) == '\u05e4' || res.charAt(ires - 1) == '\u05ea') {
                    res.insert(ires, '\u05bc');
                    ++ires;
                }
                return ires;
            }
            if (commands.charAt(ic + 1) == 'H') {
                if (ires - 1 < 0) {
                    return -1;
                }
                if (res.charAt(ires - 1) == '\u05d0' || res.charAt(ires - 1) == '\u05d4' || res.charAt(ires - 1) == '\u05d7' || res.charAt(ires - 1) == '\u05e2') {
                    res.insert(ires, '\u05b2');
                } else {
                    res.insert(ires, '\u05b0');
                }
                return ires + 1;
            }
            if (commands.charAt(ic + 1) == 'M') {
                if (ires - 1 < 0) {
                    return -1;
                }
                if (res.charAt(ires - 1) == '\u05c1' || res.charAt(ires - 1) == '\u05c2') {
                    res.delete(ires -= 2, 2);
                } else if (ires >= 2 && res.charAt(ires - 2) == '\u05bc') {
                    res.delete(ires -= 2, 2);
                } else {
                    res.deleteCharAt(--ires);
                }
                ++ic;
                while (ic < commands.length() && commands.charAt(ic) != '>') {
                    ++ic;
                }
                ++ic;
                return ires;
            }
        } else {
            return -1;
        }
        return -1;
    }

    public final String inflectionCommands() {
        if (this.isoName.equals("ar")) {
            return "# <T>: replaces Teh marbuta with Teh\n# <M>: processes consonant 'n' for past form, 3rd person, feminine plural\n# <Z>: processes consonant 't' for past form, 1st person, singular\n";
        }
        if (this.isoName.equals("pt")) {
            return "# <A>: remove all accents in the word form\n";
        }
        if (this.isoName.equals("el")) {
            return "# <A>: remove Accent in the current letter AEIOU\n# <\u00c1>: add acute accent to the current letter AEIOU\n# <\u00c0>: add grave accent to the current letter AEIOU\n# <\u00c2>: add circumflexe to the current letter AEIOU\n# <I>: add iota subscript to the current letter A\u0397\u03a9\n# <\u00c4>: add dieresis/trema/umlaut to the current letter AEIOU\n";
        }
        if (this.isoName.equals("hu")) {
            return "# <A>: remove accent from the current letter AEIOU\n# <\u00c1>: add accent to the current letter AEIOU\n# <D>: duplicate consonant\n";
        }
        if (this.isoName.equals("ca") || this.isoName.equals("de") || this.isoName.equals("it")) {
            return "# <A>: remove accute accent in the current letter AEIOU\n# <\u00c1>: add acute accent to the current  letter AEIOU\n# <\u00c0>: add grave accent to the current  letter AEIOU\n# <\u00c2>: add circumflexe to the current  letter AEIOU\n# <\u00c4>: add dieresis/trema/umlaut to the current  letter AEIOU\n";
        }
        if (this.isoName.equals("he")) {
            return "# <F>: replace Final letter with regular, and regular letter with Final\n# <G>: insert dagesh is current letter is begadkefat\n# <H>: insert atef-patah if current letter is guturale; else shwa\n# <M>: delete current letter; takes care of shin/sin dots and dagesh\n";
        }
        if (this.isoName.equals("sp")) {
            return "# <A>: remove accute accent in the current letter AEIOU\n# <\u00c1>: add acute accent to the current  letter AEIOU\n# <\u00c0>: add grave accent to the current  letter AEIOU\n# <\u00c2>: add circumflexe to the current  letter AEIOU\n# <\u00c4>: add dieresis/trema/umlaut to the current  letter AEIOU\n# <U>: replace last 'e' with 'ie' or last 'o' with 'ue'\n";
        }
        return "# (None)\n";
    }

    public final int sortTexts(String text1, String text2, boolean ignoreCase) {
        ParameterCheck.mandatory("text1", text1);
        ParameterCheck.mandatory("text2", text2);
        Collator collator = Collator.getInstance(this.locale);
        if (ignoreCase) {
            return collator.compare(text1.toLowerCase(this.locale), text2.toLowerCase(this.locale));
        }
        return collator.compare(text1, text2);
    }
}

