/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import net.nooj4nlp.engine.AmbiguitiesUnambiguitiesObject;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.TransitionObject;
import net.nooj4nlp.engine.TransitionPair;
import net.nooj4nlp.engine.TuGraph;
import net.nooj4nlp.engine.helper.ParameterCheck;

public class Mft
implements Serializable {
    private static final long serialVersionUID = -7338281112909884406L;
    public int[] tuAddresses;
    public transient int[] tuLengths;
    public transient ArrayList<ArrayList<TransitionObject>> aTransitions;
    public transient double multiplier;
    public transient int nbOfTransitions;
    private int maxRelBegAddress;
    private int maxLenAddress;
    private int maxTokenId;
    private int nboftransitions;
    private int[] nbOfTransPerTu;
    private short[] trans_beg_s;
    private int[] trans_beg_i;
    private byte[] trans_end_b;
    private short[] trans_end_s;
    private int[] trans_end_i;
    private short[] trans_tok_s;
    private int[] trans_tok_i;
    private short[] lengths_s;
    private int[] lengths_i;

    public Mft(int nbOfTus) {
        this.tuAddresses = new int[nbOfTus + 1];
        this.tuLengths = new int[nbOfTus + 1];
        this.aTransitions = new ArrayList();
        this.aTransitions.add(null);
        int itu = 1;
        while (itu < nbOfTus + 1) {
            this.aTransitions.add(new ArrayList());
            ++itu;
        }
        this.maxTokenId = 0;
        this.nboftransitions = 0;
        this.maxLenAddress = 0;
        this.maxRelBegAddress = 0;
        this.multiplier = 100.0;
        this.nbOfTransitions = 0;
    }

    public final void resetTransitions() {
        int itu = 1;
        while (itu < this.aTransitions.size()) {
            this.aTransitions.set(itu, new ArrayList());
            ++itu;
        }
        this.maxTokenId = 0;
        this.nboftransitions = 0;
        this.multiplier = 100.0;
        this.nbOfTransitions = 0;
    }

    final void reSize(int newNbOfTus) {
        if (newNbOfTus > this.tuAddresses.length - 1) {
            return;
        }
        int[] newTuAddresses = new int[newNbOfTus + 1];
        int i = 1;
        while (i <= newNbOfTus) {
            newTuAddresses[i] = this.tuAddresses[i];
            ++i;
        }
        this.tuAddresses = newTuAddresses;
        int[] newtuLengths = new int[newNbOfTus + 1];
        int i2 = 1;
        while (i2 <= newNbOfTus) {
            newtuLengths[i2] = this.tuLengths[i2];
            ++i2;
        }
        this.tuLengths = newtuLengths;
        ArrayList<ArrayList<TransitionObject>> newaTransitions = new ArrayList<ArrayList<TransitionObject>>(newNbOfTus + 1);
        newaTransitions.add(null);
        int i3 = 1;
        while (i3 <= newNbOfTus) {
            newaTransitions.add(this.aTransitions.get(i3));
            ++i3;
        }
        this.aTransitions = newaTransitions;
    }

    public final TuGraph getTuGraph(int tuNb, TuGraph tuGraphToBeUpdated) {
        if (tuGraphToBeUpdated == null) {
            tuGraphToBeUpdated = new TuGraph();
        } else {
            tuGraphToBeUpdated.transitions.clear();
            tuGraphToBeUpdated.setTransitions(new ArrayList<ArrayList<TuGraph.TransCell>>());
            tuGraphToBeUpdated.stPositions.clear();
        }
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int it = 0;
        while (it < transitions.size()) {
            double relbegaddress = transitions.get(it).getRelBegAddress();
            ArrayList<TransitionPair> outgoings = transitions.get(it).getOutgoings();
            int io = 0;
            while (io < outgoings.size()) {
                int tokenId = outgoings.get(io).getTokenId();
                double relEndAddress = outgoings.get(io).getRelEndAddress();
                tuGraphToBeUpdated.addTransition(relbegaddress, tokenId, relEndAddress);
                ++io;
            }
            ++it;
        }
        return tuGraphToBeUpdated;
    }

    public final boolean removeTransition(int tuNb, double theRelBegAddress, int theTokenId, RefObject<Double> relEndAddress) {
        ParameterCheck.mandatory("relEndAddress", relEndAddress);
        relEndAddress.argvalue = 0.0;
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int it = 0;
        while (it < transitions.size()) {
            double relBegAddress = transitions.get(it).getRelBegAddress();
            if (relBegAddress == theRelBegAddress) {
                ArrayList<TransitionPair> outgoings = transitions.get(it).getOutgoings();
                int io = 0;
                while (io < outgoings.size()) {
                    int tokenId = outgoings.get(io).getTokenId();
                    if (tokenId == theTokenId) {
                        Double newRelEndAddressValue = outgoings.get(io).getRelEndAddress();
                        relEndAddress.argvalue = newRelEndAddressValue;
                        outgoings.remove(io);
                        --this.nbOfTransitions;
                        return true;
                    }
                    ++io;
                }
            }
            ++it;
        }
        return false;
    }

    final ArrayList<AmbiguitiesUnambiguitiesObject> getAllAmbiguitiesInTextUnit(int tuNb) {
        ArrayList<AmbiguitiesUnambiguitiesObject> ambiguities = new ArrayList<AmbiguitiesUnambiguitiesObject>();
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int it = 0;
        while (it < transitions.size()) {
            double relBegAddress;
            double relEndAddress = relBegAddress = transitions.get(it).getRelBegAddress().doubleValue();
            ArrayList<TransitionPair> outgoings = transitions.get(it).getOutgoings();
            if (outgoings.size() > 1) {
                ArrayList<Integer> tokenIds = new ArrayList<Integer>();
                int io = 0;
                while (io < outgoings.size()) {
                    int tokenId = outgoings.get(io).getTokenId();
                    tokenIds.add(tokenId);
                    double end = outgoings.get(io).getRelEndAddress();
                    if (relEndAddress < end) {
                        relEndAddress = end;
                    }
                    ++io;
                }
                Collections.sort(tokenIds);
                ambiguities.add(new AmbiguitiesUnambiguitiesObject(relBegAddress, tokenIds, relEndAddress));
            }
            ++it;
        }
        return ambiguities;
    }

    final ArrayList<AmbiguitiesUnambiguitiesObject> getAllUnambiguitiesInTextUnit(int tuNb) {
        ArrayList<AmbiguitiesUnambiguitiesObject> unambiguities = new ArrayList<AmbiguitiesUnambiguitiesObject>();
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int it = 0;
        while (it < transitions.size()) {
            double relBegAddress;
            double relEndAddress = relBegAddress = transitions.get(it).getRelBegAddress().doubleValue();
            ArrayList<TransitionPair> outgoings = transitions.get(it).getOutgoings();
            if (outgoings.size() == 1) {
                ArrayList<Integer> tokenIds = new ArrayList<Integer>();
                int io = 0;
                while (io < outgoings.size()) {
                    int tokenId = outgoings.get(io).getTokenId();
                    tokenIds.add(tokenId);
                    double end = outgoings.get(io).getRelEndAddress();
                    if (relEndAddress < end) {
                        relEndAddress = end;
                    }
                    ++io;
                }
                Collections.sort(tokenIds);
                unambiguities.add(new AmbiguitiesUnambiguitiesObject(relBegAddress, tokenIds, relEndAddress));
            }
            ++it;
        }
        return unambiguities;
    }

    final double getANewVirginAddress(int tuNb, double relBegAddress, double relEndAddress) {
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        double largest = relBegAddress;
        int i = 0;
        while (i < transitions.size()) {
            double current = transitions.get(i).getRelBegAddress();
            if (current >= relBegAddress && current < relEndAddress && current > largest) {
                largest = current;
            }
            ++i;
        }
        int zz = (int)((largest + 0.005) * 100.0) + 1;
        largest = (double)zz / 100.0;
        return largest;
    }

    final ArrayList<TransitionPair> getOutgoingTransitions(int tuNb, double relBegAddress) {
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int index = -1;
        int i = 0;
        while (i < transitions.size()) {
            if (transitions.get(i).getRelBegAddress() == relBegAddress) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return null;
        }
        return transitions.get(index).getOutgoings();
    }

    final void shiftAllTransitions(int[] shift) {
        ParameterCheck.mandatory("shift", shift);
        int[] newAddresses = new int[this.tuAddresses.length];
        int[] newLengths = new int[this.tuLengths.length];
        int itu = 0;
        while (itu < this.tuAddresses.length) {
            int tuAddress = this.tuAddresses[itu];
            int newAddress = shift[tuAddress];
            int tuLength = this.tuLengths[itu];
            int end = tuAddress + tuLength;
            int newend = shift[end];
            int newLength = newend - newAddress;
            newAddresses[itu] = newAddress;
            newLengths[itu] = newLength;
            ++itu;
        }
        itu = 0;
        while (itu < this.tuAddresses.length) {
            ArrayList<TransitionObject> transitions = this.aTransitions.get(itu);
            if (transitions != null) {
                int startAdd = this.tuAddresses[itu];
                int i = 0;
                while (i < transitions.size()) {
                    double relBeg = transitions.get(i).getRelBegAddress();
                    double beg = relBeg + (double)startAdd;
                    int iBeg = (int)beg;
                    double rBeg = beg - (double)iBeg;
                    double newBeg = (double)shift[iBeg] + rBeg;
                    transitions.get(i).setRelBegAddress(newBeg - (double)newAddresses[itu]);
                    ArrayList<TransitionPair> outgoings = transitions.get(i).getOutgoings();
                    int j = 0;
                    while (j < outgoings.size()) {
                        double relEnd = outgoings.get(j).getRelEndAddress();
                        double end = relEnd + (double)startAdd;
                        int iEnd = (int)end;
                        double rEnd = end - (double)iEnd;
                        double newEnd = (double)shift[iEnd] + rEnd;
                        outgoings.get(j).setRelEndAddress(newEnd - (double)newAddresses[itu]);
                        ++j;
                    }
                    ++i;
                }
            }
            ++itu;
        }
        itu = 0;
        while (itu < this.tuAddresses.length) {
            this.tuAddresses[itu] = newAddresses[itu];
            this.tuLengths[itu] = newLengths[itu];
            ++itu;
        }
    }

    public final void addTransition(int tuNb, double relBegAddress, int tokenId, double relEndAddress) {
        if (relBegAddress > (double)this.maxRelBegAddress) {
            this.maxRelBegAddress = (int)relBegAddress;
        }
        if (relEndAddress - relBegAddress > (double)this.maxLenAddress) {
            this.maxLenAddress = (int)(relEndAddress - relBegAddress);
        }
        if (tokenId > this.maxTokenId) {
            this.maxTokenId = tokenId;
        }
        ++this.nboftransitions;
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int index = -1;
        int i = 0;
        while (i < transitions.size()) {
            if (transitions.get(i).getRelBegAddress() == relBegAddress) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            index = transitions.size();
            transitions.add(new TransitionObject(relBegAddress, new ArrayList<TransitionPair>()));
            ArrayList<TransitionPair> outgoings = transitions.get(index).getOutgoings();
            outgoings.add(new TransitionPair(tokenId, relEndAddress));
            transitions.get(index).setOutgoings(outgoings);
            ++this.nbOfTransitions;
        } else {
            ArrayList<TransitionPair> outgoings = transitions.get(index).getOutgoings();
            boolean alreadyThere = false;
            int io = 0;
            while (io < outgoings.size()) {
                int tid = outgoings.get(io).getTokenId();
                double rel = outgoings.get(io).getRelEndAddress();
                if (tokenId == tid && relEndAddress == rel) {
                    alreadyThere = true;
                    break;
                }
                ++io;
            }
            if (!alreadyThere) {
                outgoings.add(new TransitionPair(tokenId, relEndAddress));
                ++this.nbOfTransitions;
            }
        }
    }

    private int filterOutNonXrefsTransitions(ArrayList<TransitionObject> transitions, ArrayList<Object> annotations, double begAddress) {
        ParameterCheck.mandatoryCollection("transitions", transitions);
        ParameterCheck.mandatoryCollection("annotations", annotations);
        int nbOfRemoved = 0;
        int index = 0;
        while (index < transitions.size()) {
            if (transitions.get(index).getRelBegAddress() == begAddress) {
                ArrayList<TransitionPair> outgoings = transitions.get(index).getOutgoings();
                int io = 0;
                while (io < outgoings.size()) {
                    int tk = outgoings.get(io).getTokenId();
                    String lexeme = (String)annotations.get(tk);
                    if (lexeme.indexOf("XREF") == -1) {
                        outgoings.remove(io);
                        ++nbOfRemoved;
                        continue;
                    }
                    ++io;
                }
            }
            ++index;
        }
        return nbOfRemoved;
    }

    final void deleteNonXrefsAndAddTransition(int tuNb, double relBegAddress, int tokenId, ArrayList<Object> annotations, double relEndAddress) {
        ParameterCheck.mandatoryCollection("annotations", annotations);
        if (relBegAddress > (double)this.maxRelBegAddress) {
            this.maxRelBegAddress = (int)relBegAddress;
        }
        if (relEndAddress - relBegAddress > (double)this.maxLenAddress) {
            this.maxLenAddress = (int)(relEndAddress - relBegAddress);
        }
        if (tokenId > this.maxTokenId) {
            this.maxTokenId = tokenId;
        }
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int index = -1;
        int i = 0;
        while (i < transitions.size()) {
            if (transitions.get(i).getRelBegAddress() == relBegAddress) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            index = transitions.size();
            transitions.add(new TransitionObject(relBegAddress, new ArrayList<TransitionPair>()));
            ArrayList<TransitionPair> outgoings = transitions.get(index).getOutgoings();
            outgoings.add(new TransitionPair(tokenId, relEndAddress));
            transitions.get(index).setOutgoings(outgoings);
            ++this.nbOfTransitions;
        } else {
            ArrayList<TransitionPair> outgoings = transitions.get(index).getOutgoings();
            outgoings.add(new TransitionPair(tokenId, relEndAddress));
            ++this.nbOfTransitions;
            this.nbOfTransitions -= this.filterOutNonXrefsTransitions(transitions, annotations, relBegAddress);
        }
    }

    public final void filterInconsistentXrefs(ArrayList<Object> annotations, int tuNb) {
        ParameterCheck.mandatoryCollection("annotations", annotations);
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        HashMap<String, ArrayList> hc = new HashMap<String, ArrayList>();
        int it = 0;
        while (it < transitions.size()) {
            ArrayList<TransitionPair> outgoings = transitions.get(it).getOutgoings();
            int io = 0;
            while (io < outgoings.size()) {
                int index;
                int tkId = outgoings.get(io).getTokenId();
                String lbl = (String)annotations.get(tkId);
                if (lbl != null && (index = lbl.indexOf("XREF=")) != -1) {
                    StringBuilder sb = new StringBuilder();
                    int i = index + new String("XREF=").length();
                    while (i < lbl.length() && (Character.isDigit(lbl.charAt(i)) || lbl.charAt(i) == '.')) {
                        sb.append(lbl.charAt(i));
                        ++i;
                    }
                    String xrefnb = sb.toString();
                    ArrayList al = null;
                    if (!hc.containsKey(xrefnb)) {
                        al = new ArrayList();
                        al.add(it);
                        al.add(io);
                        hc.put(xrefnb, al);
                    } else {
                        al = (ArrayList)hc.get(xrefnb);
                        al.add(it);
                        al.add(io);
                    }
                }
                ++io;
            }
            ++it;
        }
        boolean thereIsAnInconsistency = false;
        Set hcKeySet = hc.keySet();
        for (String xrefnb : hcKeySet) {
            int index = xrefnb.indexOf(46);
            String scount = xrefnb.substring(index + 1);
            int count = Integer.parseInt(scount);
            ArrayList al = (ArrayList)hc.get(xrefnb);
            if (al.size() == count * 2) continue;
            int ian = 0;
            while (ian < al.size()) {
                int it2 = (Integer)al.get(ian);
                ArrayList<TransitionPair> outgoings = transitions.get(it2).getOutgoings();
                int io = (Integer)al.get(ian + 1);
                outgoings.get(io).setTokenId(-1);
                thereIsAnInconsistency = true;
                ian += 3;
            }
        }
        if (thereIsAnInconsistency) {
            int it3 = 0;
            while (it3 < transitions.size()) {
                ArrayList<TransitionPair> outgoings = transitions.get(it3).getOutgoings();
                int io = 0;
                while (io < outgoings.size()) {
                    int tkId = outgoings.get(io).getTokenId();
                    if (tkId == -1) {
                        outgoings.remove(io);
                        continue;
                    }
                    ++io;
                }
                ++it3;
            }
        }
    }

    public final int filterTransitions(ArrayList<Object> annotations, int tuNb, double relBegAddress, String symbol, RefObject<Boolean> anXrefWasRemoved) {
        ParameterCheck.mandatoryCollection("annotations", annotations);
        ParameterCheck.mandatoryString("symbol", symbol);
        ParameterCheck.mandatory("anXrefWasRemoved", anXrefWasRemoved);
        anXrefWasRemoved.argvalue = false;
        int nbOfRemoved = 0;
        String entry = null;
        String lemma = null;
        String category = null;
        String[] features = null;
        boolean negation = false;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        RefObject<Boolean> tempRef_negation = new RefObject<Boolean>(negation);
        boolean tempVar = !Dic.parseSymbolFeatureArray(symbol, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features, tempRef_negation);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        negation = (Boolean)tempRef_negation.argvalue;
        if (tempVar) {
            return nbOfRemoved;
        }
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int index = -1;
        int i = 0;
        while (i < transitions.size()) {
            if (transitions.get(i).getRelBegAddress() == relBegAddress) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return nbOfRemoved;
        }
        ArrayList<TransitionPair> initialTrans = transitions.get(index).getOutgoings();
        if (initialTrans.isEmpty()) {
            return nbOfRemoved;
        }
        ArrayList<TransitionPair> outgoings = new ArrayList<TransitionPair>(initialTrans);
        int io = 0;
        while (io < outgoings.size()) {
            block53: {
                String val;
                String lfeature;
                int n;
                int n2;
                String[] stringArray;
                String feature;
                int n3;
                int n4;
                String[] stringArray2;
                boolean match;
                String[] lFeatures;
                boolean anxref;
                block56: {
                    String lCategory;
                    String lLemma;
                    block55: {
                        String lEntry;
                        block54: {
                            anxref = false;
                            int tkId = outgoings.get(io).getTokenId();
                            String lbl = (String)annotations.get(tkId);
                            if (lbl == null) break block53;
                            lEntry = null;
                            RefObject<Object> tempRef_lEntry = new RefObject<Object>(lEntry);
                            lLemma = null;
                            RefObject<Object> tempRef_lLemma = new RefObject<Object>(lLemma);
                            lCategory = null;
                            RefObject<Object> tempRef_lCategory = new RefObject<Object>(lCategory);
                            lFeatures = null;
                            RefObject<Object> tempRef_lfeatures = new RefObject<Object>(lFeatures);
                            boolean tempVar2 = !Dic.parseDELAFFeatureArray(lbl, tempRef_lEntry, tempRef_lLemma, tempRef_lCategory, tempRef_lfeatures);
                            lEntry = (String)tempRef_lEntry.argvalue;
                            lLemma = (String)tempRef_lLemma.argvalue;
                            lCategory = (String)tempRef_lCategory.argvalue;
                            lFeatures = (String[])tempRef_lfeatures.argvalue;
                            if (tempVar2) break block53;
                            if (lCategory.equals("XREF") || Dic.lookFor("XREF", lFeatures) != null) {
                                anxref = true;
                            }
                            if (negation) break block54;
                            if (entry != null && !entry.equals(lEntry)) {
                                outgoings.remove(io);
                                --this.nbOfTransitions;
                                if (anxref) {
                                    anXrefWasRemoved.argvalue = true;
                                }
                                ++nbOfRemoved;
                                --io;
                            } else if (lemma != null && !lemma.equals(lLemma)) {
                                outgoings.remove(io);
                                --this.nbOfTransitions;
                                if (anxref) {
                                    anXrefWasRemoved.argvalue = true;
                                }
                                ++nbOfRemoved;
                                --io;
                            } else if (category != null && !category.equals(lCategory) && !category.equals("DIC")) {
                                outgoings.remove(io);
                                --this.nbOfTransitions;
                                if (anxref) {
                                    anXrefWasRemoved.argvalue = true;
                                }
                                ++nbOfRemoved;
                                --io;
                            } else if (features != null) {
                                match = false;
                                stringArray2 = features;
                                n4 = features.length;
                                n3 = 0;
                                while (n3 < n4) {
                                    feature = stringArray2[n3];
                                    if (feature.charAt(0) == '+') {
                                        match = false;
                                        if (lFeatures != null) {
                                            stringArray = lFeatures;
                                            n2 = lFeatures.length;
                                            n = 0;
                                            while (n < n2) {
                                                lfeature = stringArray[n];
                                                if (lfeature.equals(feature.substring(1))) {
                                                    match = true;
                                                    break;
                                                }
                                                if (lfeature.indexOf(61) != -1 && (val = lfeature.substring(lfeature.indexOf(61) + 1)).equals(feature.substring(1))) {
                                                    match = true;
                                                    break;
                                                }
                                                ++n;
                                            }
                                        }
                                        if (!match) {
                                            break;
                                        }
                                    } else {
                                        match = true;
                                        if (lFeatures != null) {
                                            stringArray = lFeatures;
                                            n2 = lFeatures.length;
                                            n = 0;
                                            while (n < n2) {
                                                lfeature = stringArray[n];
                                                if (lfeature.equals(feature.substring(1))) {
                                                    match = false;
                                                    break;
                                                }
                                                if (lfeature.indexOf(61) != -1 && (val = lfeature.substring(lfeature.indexOf(61) + 1)).equals(feature.substring(1))) {
                                                    match = false;
                                                    break;
                                                }
                                                ++n;
                                            }
                                        }
                                        if (!match) break;
                                    }
                                    ++n3;
                                }
                                if (!match) {
                                    outgoings.remove(io);
                                    --this.nbOfTransitions;
                                    if (anxref) {
                                        anXrefWasRemoved.argvalue = true;
                                    }
                                    ++nbOfRemoved;
                                    --io;
                                }
                            }
                            break block53;
                        }
                        if (entry == null) break block55;
                        if (entry.equals(lEntry)) break block56;
                        break block53;
                    }
                    if (lemma == null ? category != null && !category.equals(lCategory) : !lemma.equals(lLemma)) break block53;
                }
                if (features == null) {
                    outgoings.remove(io);
                    --this.nbOfTransitions;
                    if (anxref) {
                        anXrefWasRemoved.argvalue = true;
                    }
                    ++nbOfRemoved;
                    --io;
                } else {
                    match = false;
                    stringArray2 = features;
                    n4 = features.length;
                    n3 = 0;
                    while (n3 < n4) {
                        feature = stringArray2[n3];
                        if (feature.charAt(0) == '+') {
                            match = false;
                            if (lFeatures != null) {
                                stringArray = lFeatures;
                                n2 = lFeatures.length;
                                n = 0;
                                while (n < n2) {
                                    lfeature = stringArray[n];
                                    if (lfeature.equals(feature.substring(1))) {
                                        match = true;
                                        break;
                                    }
                                    if (lfeature.indexOf(61) != -1 && (val = lfeature.substring(lfeature.indexOf(61) + 1)).equals(feature.substring(1))) {
                                        match = true;
                                        break;
                                    }
                                    ++n;
                                }
                            }
                            if (!match) {
                                break;
                            }
                        } else {
                            match = true;
                            if (lFeatures != null) {
                                stringArray = lFeatures;
                                n2 = lFeatures.length;
                                n = 0;
                                while (n < n2) {
                                    lfeature = stringArray[n];
                                    if (lfeature.equals(feature.substring(1))) {
                                        match = false;
                                        break;
                                    }
                                    if (lfeature.indexOf(61) != -1 && (val = lfeature.substring(lfeature.indexOf(61) + 1)).equals(feature.substring(1))) {
                                        match = false;
                                        break;
                                    }
                                    ++n;
                                }
                            }
                            if (!match) break;
                        }
                        ++n3;
                    }
                    if (match) {
                        outgoings.remove(io);
                        --this.nbOfTransitions;
                        if (anxref) {
                            anXrefWasRemoved.argvalue = true;
                        }
                        ++nbOfRemoved;
                        --io;
                    }
                }
            }
            ++io;
        }
        if (outgoings.size() > 0) {
            transitions.get(index).setOutgoings(outgoings);
        }
        return nbOfRemoved;
    }

    final boolean thereAreLexs(int tuNb, double relBegAddress) {
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int i = 0;
        while (i < transitions.size()) {
            if (transitions.get(i).getRelBegAddress() == relBegAddress) {
                return true;
            }
            ++i;
        }
        return false;
    }

    final int getAllLexIds(int tuNb, double relBegAddress, RefObject<ArrayList<Integer>> lexIds, RefObject<ArrayList<Double>> fLengths) {
        ParameterCheck.mandatory("lexIds", lexIds);
        ParameterCheck.mandatory("fLengths", fLengths);
        lexIds.argvalue = null;
        fLengths.argvalue = null;
        ArrayList<TransitionPair> outgoings = this.getOutgoingTransitions(tuNb, relBegAddress);
        if (outgoings == null) {
            return 0;
        }
        int io = 0;
        while (io < outgoings.size()) {
            if (lexIds.argvalue == null) {
                lexIds.argvalue = new ArrayList();
                fLengths.argvalue = new ArrayList();
            }
            ((ArrayList)lexIds.argvalue).add(outgoings.get(io).getTokenId());
            long hund_len = (long)(100.0 * outgoings.get(io).getRelEndAddress()) - (long)(100.0 * relBegAddress);
            double len = (double)hund_len / 100.0;
            ((ArrayList)fLengths.argvalue).add(len);
            ++io;
        }
        if (lexIds.argvalue == null) {
            return 0;
        }
        int iLex = 1;
        while (iLex < ((ArrayList)lexIds.argvalue).size()) {
            int lexId = (Integer)((ArrayList)lexIds.argvalue).get(iLex);
            double len = (Double)((ArrayList)fLengths.argvalue).get(iLex);
            boolean found = false;
            int jLex = 0;
            while (jLex < iLex) {
                int jLexId = (Integer)((ArrayList)lexIds.argvalue).get(jLex);
                double jlen = (Double)((ArrayList)fLengths.argvalue).get(jLex);
                if (lexId == jLexId && len == jlen) {
                    found = true;
                    break;
                }
                ++jLex;
            }
            if (found) {
                ((ArrayList)lexIds.argvalue).remove(iLex);
                ((ArrayList)fLengths.argvalue).remove(iLex);
                continue;
            }
            ++iLex;
        }
        return ((ArrayList)lexIds.argvalue).size();
    }

    final int getAllLexIdsAndContracted(int tuNb, double relBegAddress, RefObject<ArrayList<Integer>> lexIds, RefObject<ArrayList<Double>> fLengths) {
        ParameterCheck.mandatory("lexIds", lexIds);
        ParameterCheck.mandatory("fLengths", fLengths);
        lexIds.argvalue = null;
        fLengths.argvalue = null;
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int index = -1;
        int i = 0;
        while (i < transitions.size()) {
            if (transitions.get(i).getRelBegAddress() == relBegAddress) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return 0;
        }
        ArrayList<TransitionPair> outgoings = transitions.get(index).getOutgoings();
        int io = 0;
        while (io < outgoings.size()) {
            if (lexIds.argvalue == null) {
                lexIds.argvalue = new ArrayList();
                fLengths.argvalue = new ArrayList();
            }
            ((ArrayList)lexIds.argvalue).add(outgoings.get(io).getTokenId());
            double len = outgoings.get(io).getRelEndAddress() - relBegAddress;
            ((ArrayList)fLengths.argvalue).add(len);
            ++io;
        }
        if (lexIds.argvalue == null) {
            return 0;
        }
        double relBegAddress2 = relBegAddress;
        do {
            relBegAddress2 += 0.01;
            index = -1;
            int i2 = 0;
            while (i2 < transitions.size()) {
                if (transitions.get(i2).getRelBegAddress() == relBegAddress2) {
                    index = i2;
                    break;
                }
                ++i2;
            }
            if (index == -1) continue;
            outgoings = transitions.get(index).getOutgoings();
            int io2 = 0;
            while (io2 < outgoings.size()) {
                ((ArrayList)lexIds.argvalue).add(outgoings.get(io2).getTokenId());
                double len = outgoings.get(io2).getRelEndAddress() - relBegAddress;
                ((ArrayList)fLengths.argvalue).add(len);
                ++io2;
            }
        } while (index != -1);
        int iLex = 1;
        while (iLex < ((ArrayList)lexIds.argvalue).size()) {
            int lexId = (Integer)((ArrayList)lexIds.argvalue).get(iLex);
            double len = (Double)((ArrayList)fLengths.argvalue).get(iLex);
            boolean found = false;
            int jLex = 0;
            while (jLex < iLex) {
                int jlexid = (Integer)((ArrayList)lexIds.argvalue).get(jLex);
                double jlen = (Double)((ArrayList)fLengths.argvalue).get(jLex);
                if (lexId == jlexid && len == jlen) {
                    found = true;
                    break;
                }
                ++jLex;
            }
            if (found) {
                ((ArrayList)lexIds.argvalue).remove(iLex);
                ((ArrayList)fLengths.argvalue).remove(iLex);
                continue;
            }
            ++iLex;
        }
        return ((ArrayList)lexIds.argvalue).size();
    }

    public final void beforeSaving(double multiplier) {
        int tokenId;
        int len;
        int relendaddress;
        int k;
        int j;
        int itu;
        int k2;
        ArrayList<TransitionPair> state;
        int j2;
        ArrayList<TransitionObject> trans;
        int itu2;
        this.lengths_s = null;
        this.lengths_i = null;
        int maxLength = 0;
        int i = 0;
        while (i < this.tuLengths.length) {
            if (this.tuLengths[i] > maxLength) {
                maxLength = this.tuLengths[i];
            }
            ++i;
        }
        if (maxLength < Short.MAX_VALUE) {
            this.lengths_s = new short[this.tuLengths.length];
            i = 0;
            while (i < this.tuLengths.length) {
                this.lengths_s[i] = (short)this.tuLengths[i];
                ++i;
            }
        } else {
            this.lengths_i = new int[this.tuLengths.length];
            i = 0;
            while (i < this.tuLengths.length) {
                this.lengths_i[i] = this.tuLengths[i];
                ++i;
            }
        }
        this.nbOfTransPerTu = new int[this.aTransitions.size()];
        this.trans_beg_s = null;
        this.trans_beg_i = null;
        int ibeg = 0;
        if ((double)this.maxRelBegAddress * multiplier < 32767.0) {
            this.trans_beg_s = new short[this.nboftransitions];
            itu2 = 1;
            while (itu2 < this.aTransitions.size()) {
                this.nbOfTransPerTu[itu2] = 0;
                trans = this.aTransitions.get(itu2);
                j2 = 0;
                while (j2 < trans.size()) {
                    short relbegaddress = (short)(trans.get(j2).getRelBegAddress() * multiplier);
                    state = trans.get(j2).getOutgoings();
                    k2 = 0;
                    while (k2 < state.size()) {
                        this.trans_beg_s[ibeg++] = relbegaddress;
                        int n = itu2;
                        this.nbOfTransPerTu[n] = this.nbOfTransPerTu[n] + 1;
                        ++k2;
                    }
                    ++j2;
                }
                ++itu2;
            }
        } else {
            this.trans_beg_i = new int[this.nboftransitions];
            itu2 = 1;
            while (itu2 < this.aTransitions.size()) {
                this.nbOfTransPerTu[itu2] = 0;
                trans = this.aTransitions.get(itu2);
                j2 = 0;
                while (j2 < trans.size()) {
                    int relBegAddress = (int)(trans.get(j2).getRelBegAddress() * multiplier);
                    state = trans.get(j2).getOutgoings();
                    k2 = 0;
                    while (k2 < state.size()) {
                        this.trans_beg_i[ibeg++] = relBegAddress;
                        int n = itu2;
                        this.nbOfTransPerTu[n] = this.nbOfTransPerTu[n] + 1;
                        ++k2;
                    }
                    ++j2;
                }
                ++itu2;
            }
        }
        this.trans_end_b = null;
        this.trans_end_s = null;
        this.trans_end_i = null;
        int iend = 0;
        if ((double)this.maxLenAddress * multiplier < 127.0) {
            this.trans_end_b = new byte[this.nboftransitions];
            itu = 1;
            while (itu < this.aTransitions.size()) {
                ArrayList<TransitionObject> trans2 = this.aTransitions.get(itu);
                j = 0;
                while (j < trans2.size()) {
                    int relbegaddress = (int)(multiplier * trans2.get(j).getRelBegAddress());
                    ArrayList<TransitionPair> state2 = trans2.get(j).getOutgoings();
                    k = 0;
                    while (k < state2.size()) {
                        relendaddress = (int)(multiplier * state2.get(k).getRelEndAddress());
                        len = relendaddress - relbegaddress;
                        this.trans_end_b[iend++] = (byte)len;
                        ++k;
                    }
                    ++j;
                }
                ++itu;
            }
        } else if (this.maxLenAddress < Short.MAX_VALUE) {
            this.trans_end_s = new short[this.nboftransitions];
            itu = 1;
            while (itu < this.aTransitions.size()) {
                ArrayList<TransitionObject> trans3 = this.aTransitions.get(itu);
                j = 0;
                while (j < trans3.size()) {
                    int relbegaddress = (int)(multiplier * trans3.get(j).getRelBegAddress());
                    ArrayList<TransitionPair> state3 = trans3.get(j).getOutgoings();
                    k = 0;
                    while (k < state3.size()) {
                        int relEndAddress = (int)(multiplier * state3.get(k).getRelEndAddress());
                        len = relEndAddress - relbegaddress;
                        this.trans_end_s[iend++] = (short)len;
                        ++k;
                    }
                    ++j;
                }
                ++itu;
            }
        } else {
            this.trans_end_i = new int[this.nboftransitions];
            itu = 1;
            while (itu < this.aTransitions.size()) {
                ArrayList<TransitionObject> trans4 = this.aTransitions.get(itu);
                j = 0;
                while (j < trans4.size()) {
                    int relbegaddress = (int)(multiplier * trans4.get(j).getRelBegAddress());
                    ArrayList<TransitionPair> state4 = trans4.get(j).getOutgoings();
                    k = 0;
                    while (k < state4.size()) {
                        relendaddress = (int)(multiplier * state4.get(k).getRelEndAddress());
                        len = relendaddress - relbegaddress;
                        this.trans_end_i[iend++] = len;
                        ++k;
                    }
                    ++j;
                }
                ++itu;
            }
        }
        this.trans_tok_s = null;
        this.trans_tok_i = null;
        int itok = 0;
        if (this.maxTokenId < Short.MAX_VALUE) {
            this.trans_tok_s = new short[this.nboftransitions];
            int itu3 = 1;
            while (itu3 < this.aTransitions.size()) {
                ArrayList<TransitionObject> trans5 = this.aTransitions.get(itu3);
                int j3 = 0;
                while (j3 < trans5.size()) {
                    ArrayList<TransitionPair> state5 = trans5.get(j3).getOutgoings();
                    k = 0;
                    while (k < state5.size()) {
                        tokenId = state5.get(k).getTokenId();
                        this.trans_tok_s[itok++] = (short)tokenId;
                        ++k;
                    }
                    ++j3;
                }
                ++itu3;
            }
        } else {
            this.trans_tok_i = new int[this.nboftransitions];
            int itu4 = 1;
            while (itu4 < this.aTransitions.size()) {
                ArrayList<TransitionObject> trans6 = this.aTransitions.get(itu4);
                int j4 = 0;
                while (j4 < trans6.size()) {
                    ArrayList<TransitionPair> state6 = trans6.get(j4).getOutgoings();
                    k = 0;
                    while (k < state6.size()) {
                        tokenId = state6.get(k).getTokenId();
                        this.trans_tok_i[itok++] = tokenId;
                        ++k;
                    }
                    ++j4;
                }
                ++itu4;
            }
        }
    }

    final void afterLoading(double divider) {
        int i;
        if (divider == 0.0) {
            divider = 10.0;
        }
        this.multiplier = divider;
        if (this.lengths_s != null) {
            this.tuLengths = new int[this.lengths_s.length];
            i = 0;
            while (i < this.lengths_s.length) {
                this.tuLengths[i] = this.lengths_s[i];
                ++i;
            }
            this.lengths_s = null;
        } else {
            this.tuLengths = new int[this.lengths_i.length];
            i = 0;
            while (i < this.lengths_i.length) {
                this.tuLengths[i] = this.lengths_i[i];
                ++i;
            }
            this.lengths_i = null;
        }
        this.aTransitions = new ArrayList();
        int originalNbOfTransitions = this.nboftransitions;
        if (originalNbOfTransitions == 0) {
            this.aTransitions.add(null);
            int itu = 1;
            while (itu < this.tuAddresses.length) {
                this.aTransitions.add(new ArrayList());
                ++itu;
            }
        } else {
            int iTrans = 0;
            double relBegAddress = this.trans_beg_s != null ? (double)this.trans_beg_s[0] / divider : (double)this.trans_beg_i[0] / divider;
            double relEndAddress = this.trans_end_b != null ? relBegAddress + (double)this.trans_end_b[0] / divider : (this.trans_end_s != null ? relBegAddress + (double)this.trans_end_s[0] / divider : relBegAddress + (double)this.trans_end_i[0] / divider);
            int tokenId = this.trans_tok_s != null ? this.trans_tok_s[0] : this.trans_tok_i[0];
            this.aTransitions.add(null);
            int itu = 1;
            while (itu < this.tuAddresses.length) {
                this.aTransitions.add(new ArrayList());
                int jtrans = 0;
                while (jtrans < this.nbOfTransPerTu[itu]) {
                    this.addTransition(itu, relBegAddress, tokenId, relEndAddress);
                    if (++iTrans >= originalNbOfTransitions) break;
                    relBegAddress = this.trans_beg_s != null ? (double)this.trans_beg_s[iTrans] / divider : (double)this.trans_beg_i[iTrans] / divider;
                    relEndAddress = this.trans_end_b != null ? relBegAddress + (double)this.trans_end_b[iTrans] / divider : (this.trans_end_s != null ? relBegAddress + (double)this.trans_end_s[iTrans] / divider : relBegAddress + (double)this.trans_end_i[iTrans] / divider);
                    tokenId = this.trans_tok_s != null ? this.trans_tok_s[iTrans] : this.trans_tok_i[iTrans];
                    ++jtrans;
                }
                ++itu;
            }
        }
        this.trans_beg_s = null;
        this.trans_beg_i = null;
        this.trans_end_b = null;
        this.trans_end_s = null;
        this.trans_end_i = null;
        this.trans_tok_s = null;
        this.trans_tok_i = null;
    }
}

