/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import net.nooj4nlp.engine.Charlist;
import net.nooj4nlp.engine.Corpus;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Indexkey;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Mft;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.TransitionObject;
import net.nooj4nlp.engine.TransitionPair;
import net.nooj4nlp.engine.helper.ParameterCheck;

public class Ntext
implements Serializable {
    private static final long serialVersionUID = 4556178507526248243L;
    public String LanguageName;
    public transient Language Lan;
    public String DelimPattern;
    public String[] XmlNodes;
    public transient Charlist charlist = null;
    public transient HashMap<String, Indexkey> hTokens = null;
    public transient HashMap<String, ArrayList<Object>> hAmbiguities = null;
    public transient HashMap<String, ArrayList<Object>> hUnambiguities = null;
    public transient HashMap<String, Indexkey> hDigrams = null;
    public transient HashMap<String, Integer> hLexemes = null;
    public transient HashMap<String, Integer> hUnknowns = null;
    public transient HashMap<String, Integer> hPhrases = null;
    public transient ArrayList<String> listOfResources = null;
    public String buffer;
    public Mft mft;
    public ArrayList<Object> annotations;
    public int nbOfTextUnits;
    public int nbOfChars;
    public int nbOfDiffChars;
    public int nbOfLetters;
    public int nbOfDiffLetters;
    public int nbOfDelimiters;
    public int nbOfDiffDelimiters;
    public int nbOfBlanks;
    public int nbOfDiffBlanks;
    public int nbOfDigits;
    public int nbOfDiffDigits;
    public int nbOfTokens;
    public int nbOfDiffTokens;
    public int nbOfWords;
    public int nbOfDiffWords;

    public Ntext(String languageName, String delimPattern, String[] xmlNodes) {
        ParameterCheck.mandatoryString("languageName", languageName);
        this.LanguageName = languageName;
        this.Lan = new Language(languageName);
        if (this.Lan != null) {
            this.DelimPattern = delimPattern;
            this.XmlNodes = xmlNodes;
            this.charlist = null;
            this.buffer = null;
            this.mft = null;
            this.annotations = null;
            this.nbOfDiffWords = -1;
            this.nbOfWords = -1;
            this.nbOfDiffTokens = -1;
            this.nbOfTokens = -1;
            this.nbOfDiffDigits = -1;
            this.nbOfDigits = -1;
            this.nbOfDiffBlanks = -1;
            this.nbOfBlanks = -1;
            this.nbOfDiffDelimiters = -1;
            this.nbOfDelimiters = -1;
            this.nbOfDiffLetters = -1;
            this.nbOfLetters = -1;
            this.nbOfDiffChars = -1;
            this.nbOfChars = -1;
            this.nbOfTextUnits = -1;
        } else {
            System.out.println("Cannot construct language for languagename = " + languageName);
        }
    }

    public Ntext(Corpus corpus) {
        ParameterCheck.mandatory("corpus", corpus);
        this.LanguageName = corpus.languageName;
        this.Lan = corpus.lan;
        this.DelimPattern = corpus.delimPattern;
        this.XmlNodes = corpus.xmlNodes;
        this.charlist = null;
        this.buffer = null;
        this.mft = null;
        this.annotations = null;
        this.nbOfDiffWords = -1;
        this.nbOfWords = -1;
        this.nbOfDiffTokens = -1;
        this.nbOfTokens = -1;
        this.nbOfDiffDigits = -1;
        this.nbOfDigits = -1;
        this.nbOfDiffBlanks = -1;
        this.nbOfBlanks = -1;
        this.nbOfDiffDelimiters = -1;
        this.nbOfDelimiters = -1;
        this.nbOfDiffLetters = -1;
        this.nbOfLetters = -1;
        this.nbOfDiffChars = -1;
        this.nbOfChars = -1;
        this.nbOfTextUnits = -1;
    }

    public Ntext(String languageName) {
        ParameterCheck.mandatoryString("languageName", languageName);
        this.LanguageName = languageName;
        this.Lan = new Language(languageName);
        if (this.Lan != null) {
            this.DelimPattern = null;
            this.XmlNodes = null;
            this.charlist = null;
            this.buffer = null;
            this.mft = null;
            this.annotations = null;
            this.nbOfDiffWords = -1;
            this.nbOfWords = -1;
            this.nbOfDiffTokens = -1;
            this.nbOfTokens = -1;
            this.nbOfDiffDigits = -1;
            this.nbOfDigits = -1;
            this.nbOfDiffBlanks = -1;
            this.nbOfBlanks = -1;
            this.nbOfDiffDelimiters = -1;
            this.nbOfDelimiters = -1;
            this.nbOfDiffLetters = -1;
            this.nbOfLetters = -1;
            this.nbOfDiffChars = -1;
            this.nbOfChars = -1;
            this.nbOfTextUnits = -1;
        }
    }

    public final String delimitXmlTextUnitsAndImportXmlTags(Corpus corpus, Engine engine, String[] xmlNodes, ArrayList<Object> annotations, HashMap<String, Integer> hLexemes, HashMap<String, Integer> hPhrases) {
        ParameterCheck.mandatory("engine", engine);
        ParameterCheck.mandatory("xmlNodes", xmlNodes);
        String errMessage = "";
        RefObject<String> tempRef_errmessage = new RefObject<String>(errMessage);
        this.mft = engine.delimitXml(this, xmlNodes, tempRef_errmessage);
        errMessage = (String)tempRef_errmessage.argvalue;
        if (this.mft == null) {
            return errMessage;
        }
        engine.addAllXmlAnnotations(corpus, this, annotations);
        return "";
    }

    public final String delimitTextUnits(Engine engine) {
        ParameterCheck.mandatory("engine", engine);
        this.mft = engine.delimit(this);
        if (this.mft == null) {
            return "Cannot split text into text units: one text unit is larger than 65K characters";
        }
        return "";
    }

    public final void cleanupBadAnnotations(ArrayList<Object> annotations) {
        ArrayList<TransitionObject> transitions;
        int itu;
        ParameterCheck.mandatoryCollection("annotations", annotations);
        HashMap foundANullAnnotation = new HashMap();
        int i = 0;
        while (i < annotations.size()) {
            String lexeme = (String)annotations.get(i);
            if (lexeme == null) {
                foundANullAnnotation.put(i, null);
            } else {
                String entry = null;
                RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                String lemma = null;
                RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                String category = null;
                RefObject<Object> tempRef_category = new RefObject<Object>(category);
                String features = null;
                RefObject<Object> tempRef_features = new RefObject<Object>(features);
                boolean tempVar = !Dic.parseDELAF(lexeme, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
                entry = (String)tempRef_entry.argvalue;
                lemma = (String)tempRef_lemma.argvalue;
                category = (String)tempRef_category.argvalue;
                features = (String)tempRef_features.argvalue;
                if (!tempVar && (category.equals("NW") || features != null && !features.equals("") && Dic.lookFor("FXC", features) != null)) {
                    annotations.set(i, null);
                    foundANullAnnotation.put(i, null);
                }
            }
            ++i;
        }
        if (foundANullAnnotation.size() > 0) {
            itu = 1;
            while (itu < this.mft.tuAddresses.length) {
                transitions = this.mft.aTransitions.get(itu);
                int istate = 0;
                while (istate < transitions.size()) {
                    ArrayList<TransitionPair> state = transitions.get(istate).getOutgoings();
                    int k = 0;
                    while (k < state.size()) {
                        int tokenId = state.get(k).getTokenId();
                        if (foundANullAnnotation.containsKey(tokenId)) {
                            state.subList(k, k + 1).clear();
                            continue;
                        }
                        ++k;
                    }
                    ++istate;
                }
                ++itu;
            }
        }
        itu = 1;
        while (itu < this.mft.tuAddresses.length) {
            transitions = this.mft.aTransitions.get(itu);
            HashMap endings = new HashMap();
            int istate = 0;
            while (istate < transitions.size()) {
                ArrayList<TransitionPair> outgoings = transitions.get(istate).getOutgoings();
                int k = 0;
                while (k < outgoings.size()) {
                    double ending = outgoings.get(k).getRelEndAddress();
                    if (!endings.containsKey(ending)) {
                        endings.put(ending, null);
                    }
                    ++k;
                }
                ++istate;
            }
            istate = 0;
            while (istate < transitions.size()) {
                int h_beg2;
                double beginning = transitions.get(istate).getRelBegAddress();
                int h_beg = (int)(100.0 * beginning);
                if (h_beg != (h_beg2 = (int)beginning * 100)) {
                    if (!endings.containsKey(beginning)) {
                        transitions.subList(istate, istate + 1).clear();
                        continue;
                    }
                    ++istate;
                    continue;
                }
                ++istate;
            }
            ++itu;
        }
    }

    private void keepOnlyInternal(RefObject<ArrayList<String>> lexs, RefObject<ArrayList<Double>> lens, int length) {
        ParameterCheck.mandatory("lexs", lexs);
        ParameterCheck.mandatory("lens", lens);
        int i = 0;
        while (i < ((ArrayList)lexs.argvalue).size()) {
            double la = (Double)((ArrayList)lens.argvalue).get(i);
            if (la > (double)length) {
                ((ArrayList)lexs.argvalue).remove(i);
                ((ArrayList)lens.argvalue).remove(i);
                continue;
            }
            ++i;
        }
    }

    private void keepOnlyInside(RefObject<ArrayList<String>> lexs, RefObject<ArrayList<Double>> lens, int length) {
        ParameterCheck.mandatory("lexs", lexs);
        ParameterCheck.mandatory("lens", lens);
        int i = 0;
        while (i < ((ArrayList)lexs.argvalue).size()) {
            double la = (Double)((ArrayList)lens.argvalue).get(i);
            if (la >= (double)length) {
                ((ArrayList)lexs.argvalue).remove(i);
                ((ArrayList)lens.argvalue).remove(i);
                continue;
            }
            ++i;
        }
    }

    private void keepOnlyLongest(RefObject<ArrayList<String>> lexs, RefObject<ArrayList<Double>> lens) {
        ParameterCheck.mandatory("lexs", lexs);
        ParameterCheck.mandatory("lens", lens);
        double maxlen = 0.0;
        int i = 0;
        while (i < ((ArrayList)lexs.argvalue).size()) {
            double li = (Double)((ArrayList)lens.argvalue).get(i);
            if (li > maxlen) {
                maxlen = li;
            }
            ++i;
        }
        i = 0;
        while (i < ((ArrayList)lexs.argvalue).size()) {
            double la = (Double)((ArrayList)lens.argvalue).get(i);
            if (la < maxlen) {
                ((ArrayList)lexs.argvalue).remove(i);
                ((ArrayList)lens.argvalue).remove(i);
                continue;
            }
            ++i;
        }
    }

    private String cleanupAndAddQuotes(String feature) {
        ParameterCheck.mandatoryString("feature", feature);
        if (feature.equals("")) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder();
        if (feature.charAt(0) != '\"' || feature.charAt(feature.length() - 1) != '\"') {
            sb.append('\"');
        }
        int i = 0;
        while (i < feature.length()) {
            if (feature.charAt(i) != '<' && feature.charAt(i) != '>') {
                sb.append(feature.charAt(i));
            }
            ++i;
        }
        if (feature.charAt(0) != '\"' || feature.charAt(feature.length() - 1) != '\"') {
            sb.append('\"');
        }
        return sb.toString();
    }

    private String cleanupXmlTags(String line) {
        ParameterCheck.mandatoryString("line", line);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) != '<') {
                sb.append(line.charAt(i));
            } else {
                ++i;
                while (line.charAt(i) != '>') {
                    ++i;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public final void buildXmlTaggedText(String currentLine, int beg, boolean filterOut, PrintWriter pw, int itu, ArrayList<Object> annotations, String[] xmlAnnotations, Language lan, boolean insideOnly) {
        ParameterCheck.mandatory("pw", pw);
        ParameterCheck.mandatoryCollection("annotations", annotations);
        ParameterCheck.mandatory("xmlAnnotations", xmlAnnotations);
        ParameterCheck.mandatory("lan", lan);
        iChar = 0;
        while (iChar < currentLine.length()) {
            block53: {
                if (Character.isWhitespace(currentLine.charAt(iChar))) {
                    if (!filterOut) {
                        pw.print(currentLine.charAt(iChar));
                    }
                    ++iChar;
                    continue;
                }
                if (Language.isLetter(currentLine.charAt(cpos = iChar++))) {
                    while (iChar < currentLine.length() && Language.isLetter(currentLine.charAt(iChar))) {
                        ++iChar;
                    }
                    token = currentLine.substring(cpos, iChar);
                } else if (this.XmlNodes != null && currentLine.charAt(cpos) == '<') {
                    level = 1;
                    ++iChar;
                    while (iChar < currentLine.length()) {
                        if (currentLine.charAt(iChar) == '>') {
                            if (--level == 0) {
                                break;
                            }
                        } else if (currentLine.charAt(iChar) == '<') {
                            ++level;
                        }
                        ++iChar;
                    }
                    if (iChar < currentLine.length()) {
                        ++iChar;
                        continue;
                    }
                    iChar = cpos + 1;
                    token = currentLine.substring(cpos, cpos + 1);
                } else {
                    ++iChar;
                    token = currentLine.substring(cpos, cpos + 1);
                }
                lexIds = null;
                lens = null;
                rlexs = null;
                rlens = null;
                tempRef_lexids = new RefObject<Object>(lexIds);
                tempRef_lens = new RefObject<Object>(lens);
                da = this.mft.getAllLexIdsAndContracted(itu, beg + cpos, tempRef_lexids, tempRef_lens);
                lexIds = (ArrayList)tempRef_lexids.argvalue;
                lens = (ArrayList)tempRef_lens.argvalue;
                if (da > 0) {
                    lexs = new ArrayList();
                    i = 0;
                    while (i < da) {
                        tkId = (Integer)lexIds.get(i);
                        lex = (String)annotations.get(tkId);
                        if (lex != null) {
                            lexs.add(lex);
                        }
                        ++i;
                    }
                    tempRef_lexs = new RefObject<ArrayList<String>>(lexs);
                    tempRef_lens2 = new RefObject<ArrayList<Double>>(lens);
                    this.keepOnlyInternal(tempRef_lexs, tempRef_lens2, currentLine.length() - cpos);
                    lexs = (ArrayList)tempRef_lexs.argvalue;
                    lens = (ArrayList)tempRef_lens2.argvalue;
                    tempRef_lexs2 = new RefObject<ArrayList<String>>(lexs);
                    tempRef_lens3 = new RefObject<ArrayList<Double>>(lens);
                    if (insideOnly && cpos == 0) {
                        this.keepOnlyInside(tempRef_lexs2, tempRef_lens3, currentLine.length() - cpos);
                    }
                    lexs = (ArrayList)tempRef_lexs2.argvalue;
                    lens = (ArrayList)tempRef_lens3.argvalue;
                    tempRef_lexs3 = new RefObject<ArrayList<String>>(lexs);
                    tempRef_lens4 = new RefObject<ArrayList<Double>>(lens);
                    this.keepOnlyLongest(tempRef_lexs3, tempRef_lens4);
                    lexs = (ArrayList)tempRef_lexs3.argvalue;
                    lens = (ArrayList)tempRef_lens4.argvalue;
                    if (da > 0) {
                        g = new Grammar();
                        tempRef_rlexs = new RefObject<ArrayList<String>>(rlexs);
                        tempRef_rlens = new RefObject<ArrayList<Double>>(rlens);
                        g.xmlFilterMatches(lexs, lens, xmlAnnotations, tempRef_rlexs, tempRef_rlens);
                        rlexs = (ArrayList)tempRef_rlexs.argvalue;
                        rlens = (ArrayList)tempRef_rlens.argvalue;
                    }
                }
                if (rlexs == null || rlexs.size() <= 0) break block53;
                len = 0;
                thereIsATrans = false;
                i = 0;
                while (i < rlexs.size()) {
                    block54: {
                        lex = (String)rlexs.get(i);
                        tempVar = Dic.parseDELAFFeatureArray(lex, tempRef_entry = new RefObject<Object>((entry = null)), tempRef_lemma = new RefObject<Object>((lemma = null)), tempRef_category = new RefObject<Object>((category = null)), tempRef_features = new RefObject<Object>((features = null))) == false;
                        entry = (String)tempRef_entry.argvalue;
                        lemma = (String)tempRef_lemma.argvalue;
                        category = (String)tempRef_category.argvalue;
                        features = (String[])tempRef_features.argvalue;
                        if (tempVar || !lemma.equals("SYNTAX") || !category.equals("TRANS")) break block54;
                        thereIsATrans = true;
                        if (features == null) ** GOTO lbl138
                        txtzone = null;
                        propzone = null;
                        ifeat = 0;
                        while (ifeat < features.length) {
                            feat = features[ifeat];
                            propname = null;
                            propvalue = null;
                            tempRef_propname = new RefObject<Object>(propname);
                            tempRef_propvalue = new RefObject<Object>(propvalue);
                            Dic.getPropertyNameValue(feat, tempRef_propname, tempRef_propvalue);
                            propname = (String)tempRef_propname.argvalue;
                            propvalue = (String)tempRef_propvalue.argvalue;
                            j = 0;
                            while (j < xmlAnnotations.length) {
                                if (xmlAnnotations[j].equals("<TRANS+" + propname + ">")) {
                                    propzone = propname;
                                    txtzone = propvalue;
                                }
                                ++j;
                            }
                            ++ifeat;
                        }
                        if (propzone == null) {
                            thereIsATrans = false;
                        } else {
                            pw.print("<" + propzone);
                            ifeat = 0;
                            while (ifeat < features.length) {
                                feat = features[ifeat];
                                propname = null;
                                propvalue = null;
                                tempRef_propname2 = new RefObject<String>(propname);
                                tempRef_propvalue2 = new RefObject<String>(propvalue);
                                Dic.getPropertyNameValue(feat, tempRef_propname2, tempRef_propvalue2);
                                propname = (String)tempRef_propname2.argvalue;
                                propvalue = (String)tempRef_propvalue2.argvalue;
                                if (!propzone.equals(propname)) {
                                    pw.print(" \"" + propname + "\"");
                                }
                                ++ifeat;
                            }
                            pw.print(">");
                            pw.print(String.valueOf(txtzone) + "</" + propzone + ">");
lbl138:
                            // 2 sources

                            helpDouble = (Double)rlens.get(i);
                            len = (int)helpDouble;
                            iChar = cpos + len;
                            break;
                        }
                    }
                    ++i;
                }
                if (thereIsATrans) continue;
                if (rlexs == null || rlexs.isEmpty()) {
                    if (filterOut) continue;
                    pw.print(token);
                    continue;
                }
                thereisunamb = false;
                i = 0;
                while (i < rlexs.size()) {
                    lex = (String)rlexs.get(i);
                    tempVar2 = Dic.parseDELAFFeatureArray(lex, tempRef_entry2 = new RefObject<Object>((entry = null)), tempRef_lemma2 = new RefObject<Object>((lemma = null)), tempRef_category2 = new RefObject<Object>((category = null)), tempRef_features2 = new RefObject<Object>((features = null))) == false;
                    entry = (String)tempRef_entry2.argvalue;
                    lemma = (String)tempRef_lemma2.argvalue;
                    category = (String)tempRef_category2.argvalue;
                    features = (String[])tempRef_features2.argvalue;
                    if (!tempVar2 && !category.equals("TRANS")) {
                        if (lemma.equals("SYNTAX")) {
                            pw.print("<" + category);
                            if (features != null) {
                                ifeat = 0;
                                while (ifeat < features.length) {
                                    feat = features[ifeat];
                                    propname = null;
                                    propvalue = null;
                                    tempRef_propname3 = new RefObject<Object>(propname);
                                    tempRef_propvalue3 = new RefObject<Object>(propvalue);
                                    Dic.getPropertyNameValue(feat, tempRef_propname3, tempRef_propvalue3);
                                    propname = (String)tempRef_propname3.argvalue;
                                    propvalue = (String)tempRef_propvalue3.argvalue;
                                    if (propvalue.equals("UNAMB")) {
                                        thereisunamb = true;
                                    } else if (propname.equals(propvalue)) {
                                        pw.print(" TYPE=" + this.cleanupAndAddQuotes(propvalue));
                                    } else {
                                        pw.print(" " + propname + "=" + this.cleanupAndAddQuotes(propvalue));
                                    }
                                    ++ifeat;
                                }
                            }
                            pw.print(">");
                        } else {
                            pw.print("<LU LEMMA=\"" + lemma + "\" CAT=\"" + category + "\"");
                            if (features != null) {
                                ifeat = 0;
                                while (ifeat < features.length) {
                                    feat = features[ifeat];
                                    propname = null;
                                    propvalue = null;
                                    tempRef_propname4 = new RefObject<Object>(propname);
                                    tempRef_propvalue4 = new RefObject<Object>(propvalue);
                                    Dic.getPropertyNameValue(feat, tempRef_propname4, tempRef_propvalue4);
                                    propname = (String)tempRef_propname4.argvalue;
                                    propvalue = (String)tempRef_propvalue4.argvalue;
                                    if (propvalue.equals("UNAMB")) {
                                        thereisunamb = true;
                                    } else if (feat.equals(propname)) {
                                        pw.print(" TYPE=" + this.cleanupAndAddQuotes(propvalue));
                                    } else {
                                        pw.print(" " + propname + "=" + this.cleanupAndAddQuotes(propvalue));
                                    }
                                    ++ifeat;
                                }
                            }
                            pw.print(">");
                        }
                    }
                    ++i;
                }
                helpDouble = (Double)rlens.get(0);
                len = (int)helpDouble;
                if (len == 0) {
                    len = token.length();
                }
                recurrentline = currentLine.substring(cpos, cpos + len);
                if (len > token.length()) {
                    if (thereisunamb) {
                        pw.print(this.cleanupXmlTags(recurrentline));
                    } else {
                        this.buildXmlTaggedText(recurrentline, beg + cpos, filterOut, pw, itu, annotations, xmlAnnotations, lan, true);
                    }
                } else {
                    pw.print(this.cleanupXmlTags(recurrentline));
                }
                iChar = cpos + len;
                i = rlexs.size() - 1;
                while (i >= 0) {
                    lex = (String)rlexs.get(i);
                    tempVar3 = Dic.parseDELAFFeatureArray(lex, tempRef_entry3 = new RefObject<Object>((entry = null)), tempRef_lemma3 = new RefObject<Object>((lemma = null)), tempRef_category3 = new RefObject<Object>((category = null)), tempRef_features3 = new RefObject<Object>((features = null))) == false;
                    entry = (String)tempRef_entry3.argvalue;
                    lemma = (String)tempRef_lemma3.argvalue;
                    category = (String)tempRef_category3.argvalue;
                    features = (String[])tempRef_features3.argvalue;
                    if (!tempVar3 && !category.equals("TRANS")) {
                        if (lemma.equals("SYNTAX")) {
                            pw.print("</" + category + ">");
                        } else {
                            pw.print("</LU>");
                        }
                    }
                    --i;
                }
                continue;
            }
            if (filterOut) continue;
            pw.print(token);
        }
    }

    private static void computehLexemes(Ntext text) {
        ParameterCheck.mandatory("text", text);
        text.hLexemes = new HashMap();
        text.hPhrases = new HashMap();
        text.hUnknowns = new HashMap();
        if (text.annotations.size() > 0) {
            int i = 0;
            while (i < text.annotations.size()) {
                String lex = (String)text.annotations.get(i);
                if (lex != null) {
                    String entry = null;
                    RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                    String lemma = null;
                    RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                    String info = null;
                    RefObject<Object> tempRef_info = new RefObject<Object>(info);
                    boolean tempVar = !Dic.parseDELAF(lex, tempRef_entry, tempRef_lemma, tempRef_info);
                    entry = (String)tempRef_entry.argvalue;
                    lemma = (String)tempRef_lemma.argvalue;
                    info = (String)tempRef_info.argvalue;
                    if (tempVar) {
                        Dic.writeLog("Invalid annotation: \"" + lex + "\"");
                    }
                    if (info.equals("UNKNOWN")) {
                        if (!text.hUnknowns.containsKey(lex)) {
                            text.hUnknowns.put(lex, i);
                        }
                    } else if (lemma.equals("SYNTAX")) {
                        if (!text.hPhrases.containsKey(lex)) {
                            text.hPhrases.put(lex, i);
                        }
                    } else if (!text.hLexemes.containsKey(lex)) {
                        text.hLexemes.put(lex, i);
                    }
                }
                ++i;
            }
        }
    }

    public static Ntext load(String fullNamePath, String languageName, RefObject<String> errMessage) throws IOException, ClassNotFoundException {
        ParameterCheck.mandatoryString("fullNamePath", fullNamePath);
        ParameterCheck.mandatoryString("languageName", languageName);
        ParameterCheck.mandatory("errMessage", errMessage);
        errMessage.argvalue = null;
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        Ntext text = null;
        try {
            fileInputStream = new FileInputStream(fullNamePath);
            objectInputStream = new ObjectInputStream(fileInputStream);
            text = (Ntext)objectInputStream.readObject();
        }
        catch (RuntimeException ex) {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            errMessage.argvalue = "Cannot load text " + fullNamePath + ": " + ex.getMessage();
            Dic.writeLog((String)errMessage.argvalue);
            return null;
        }
        if (objectInputStream != null) {
            objectInputStream.close();
        }
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        text.Lan = new Language(text.LanguageName);
        if (text.Lan == null) {
            return null;
        }
        double multiplier = 1.0;
        if (text.annotations != null && text.annotations.size() > 0) {
            if (text.annotations.get(0) != null && text.annotations.get(0).getClass() == HashMap.class) {
                text.hTokens = (HashMap)text.annotations.get(0);
                text.annotations.remove(0);
            } else {
                String keyword;
                do {
                    if ((keyword = (String)text.annotations.get(0)).equals("$tokens$")) {
                        text.hTokens = (HashMap)text.annotations.get(1);
                        text.annotations.remove(0);
                        text.annotations.remove(0);
                        continue;
                    }
                    if (keyword.equals("$colors$")) {
                        text.annotations.remove(0);
                        text.annotations.remove(0);
                        continue;
                    }
                    if (keyword.equals("$multiplier$")) {
                        multiplier = text.annotations.get(1) == null ? 100.0 : (Double)text.annotations.get(1);
                        text.annotations.remove(0);
                        text.annotations.remove(0);
                        continue;
                    }
                    if (!keyword.equals("$resources$")) continue;
                    text.listOfResources = (ArrayList)text.annotations.get(1);
                    text.annotations.remove(0);
                    text.annotations.remove(0);
                } while (text.annotations.size() > 0 && (keyword.equals("$tokens$") || keyword.equals("$colors$") || keyword.equals("$multiplier$") || keyword.equals("$resources$")));
            }
        }
        if (text.mft != null) {
            text.mft.afterLoading(multiplier);
        }
        if (text.annotations != null) {
            Ntext.computehLexemes(text);
        }
        return text;
    }

    public static Ntext loadForCorpus(String fullNamePath, Language lan, double multiplier) throws IOException {
        ParameterCheck.mandatoryString("fullNamePath", fullNamePath);
        ParameterCheck.mandatory("lan", lan);
        FileInputStream fileInputStream = null;
        Ntext text = null;
        fileInputStream = new FileInputStream(fullNamePath);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        try {
            text = (Ntext)objectInputStream.readObject();
        }
        catch (Exception e) {
            fileInputStream.close();
            return null;
        }
        fileInputStream.close();
        text.Lan = lan;
        if (text.mft != null) {
            text.mft.afterLoading(multiplier);
        }
        return text;
    }

    public static Ntext loadJustBufferForCorpus(String fullNamePath, Language lan, double multiplier) throws IOException {
        ParameterCheck.mandatoryString("fullNamePath", fullNamePath);
        ParameterCheck.mandatory("lan", lan);
        FileInputStream fileInputStream = null;
        Ntext text = null;
        fileInputStream = new FileInputStream(fullNamePath);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        try {
            text = (Ntext)objectInputStream.readObject();
        }
        catch (Exception e) {
            fileInputStream.close();
            return null;
        }
        fileInputStream.close();
        text.Lan = lan;
        return text;
    }

    public final void save(String fullNamePath) throws IOException {
        File file;
        ParameterCheck.mandatoryString("fullNamePath", fullNamePath);
        int nbOfHacks = 0;
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        if (this.hTokens != null) {
            this.annotations.add(0, "$tokens$");
            this.annotations.add(1, this.hTokens);
            ++nbOfHacks;
        }
        if (this.listOfResources != null) {
            this.annotations.add(0, "$resources$");
            this.annotations.add(1, this.listOfResources);
            ++nbOfHacks;
        }
        if (this.mft != null) {
            this.mft.beforeSaving(this.mft.multiplier);
            this.annotations.add(0, "$multiplier$");
            this.annotations.add(1, null);
            ++nbOfHacks;
        }
        if (!(file = new File(fullNamePath)).exists()) {
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
        fileOutputStream.close();
        if (nbOfHacks > 0) {
            int i = 0;
            while (i < nbOfHacks) {
                this.annotations.remove(0);
                this.annotations.remove(0);
                ++i;
            }
        }
    }

    public final void saveForCorpus(String fullNamePath) throws IOException {
        File file;
        ParameterCheck.mandatoryString("fullNamePath", fullNamePath);
        if (this.mft != null) {
            this.mft.beforeSaving(this.mft.multiplier);
        }
        if (!(file = new File(fullNamePath)).exists()) {
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
        fileOutputStream.close();
    }

    public final boolean updateAnnotationsForText() {
        if (this.mft == null) {
            return false;
        }
        boolean[] exist = new boolean[this.annotations.size()];
        int i = 0;
        while (i < exist.length) {
            exist[i] = false;
            ++i;
        }
        int tuNb = 1;
        while (tuNb <= this.mft.tuAddresses.length - 1) {
            ArrayList<TransitionObject> transitions = this.mft.aTransitions.get(tuNb);
            int it = 0;
            while (it < transitions.size()) {
                ArrayList<TransitionPair> outgoings = transitions.get(it).getOutgoings();
                int io = 0;
                while (io < outgoings.size()) {
                    int tokenId = outgoings.get(io).getTokenId();
                    if (tokenId >= exist.length) {
                        return false;
                    }
                    exist[tokenId] = true;
                    ++io;
                }
                ++it;
            }
            ++tuNb;
        }
        int ia = 0;
        while (ia < this.annotations.size()) {
            String label;
            if (!exist[ia] && (label = (String)this.annotations.get(ia)) != null) {
                String entry = null;
                String info = null;
                RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                RefObject<Object> tempRef_info = new RefObject<Object>(info);
                boolean tempVar = Dic.parseDELAS(label, tempRef_entry, tempRef_info);
                entry = (String)tempRef_entry.argvalue;
                info = (String)tempRef_info.argvalue;
                if (tempVar) {
                    this.annotations.set(ia, null);
                }
            }
            ++ia;
        }
        return true;
    }

    public Language getLanguage() {
        return this.Lan;
    }

    public String getDelimPattern() {
        return this.DelimPattern;
    }

    public ArrayList<Object> getAnnotations() {
        return this.annotations;
    }
}

