/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.util.ArrayList;
import java.util.HashMap;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.helper.ParameterCheck;

class Tree {
    private Tree LeftChild = null;
    private Tree RightChild = null;
    private String Label = null;

    Tree() {
    }

    static Tree leafTree(String factor) {
        Tree t = new Tree();
        t.Label = factor;
        return t;
    }

    static Tree binaryTree(Tree leftChild, Tree rightChild, String label) {
        Tree t = new Tree();
        t.Label = label;
        t.LeftChild = leftChild;
        t.RightChild = rightChild;
        return t;
    }

    Gram explore(ArrayList<String> aVocab, HashMap<String, Integer> hVocab) {
        Gram gram;
        ParameterCheck.mandatory("aVocab", aVocab);
        ParameterCheck.mandatory("hVocab", hVocab);
        if (this.Label.equals("*")) {
            if (this.LeftChild == null) {
                System.out.println("NooJ: a '*' operator has no first argument");
                gram = Gram.token(this.Label, aVocab, hVocab);
            } else if (this.RightChild != null) {
                System.out.println("NooJ: a '*' operator has a second argument");
                gram = Gram.token(this.Label, aVocab, hVocab);
            } else {
                Gram gram1 = this.LeftChild.explore(aVocab, hVocab);
                gram = gram1.kleene();
            }
        } else if (this.Label.equals("+")) {
            if (this.LeftChild == null) {
                gram = Gram.token(this.Label, aVocab, hVocab);
            } else if (this.RightChild == null) {
                gram = Gram.token(this.Label, aVocab, hVocab);
            } else {
                Gram gram1 = this.LeftChild.explore(aVocab, hVocab);
                ArrayList<Gram> rightGrams = new ArrayList<Gram>();
                Tree rightTree = this.RightChild;
                while (rightTree.Label.equals("+")) {
                    if (rightTree.LeftChild == null || rightTree.RightChild == null) break;
                    Gram leftGram = rightTree.LeftChild.explore(aVocab, hVocab);
                    rightGrams.add(leftGram);
                    rightTree = rightTree.RightChild;
                }
                if (rightGrams.size() > 0) {
                    gram1.disjunctions(rightGrams);
                }
                Gram gram2 = rightTree.explore(aVocab, hVocab);
                gram = gram1.disjunction(gram2);
            }
        } else if (this.Label.equals(".")) {
            if (this.LeftChild == null) {
                gram = Gram.token(this.Label, aVocab, hVocab);
            } else if (this.RightChild == null) {
                gram = Gram.token(this.Label, aVocab, hVocab);
            } else {
                Gram gram1 = this.LeftChild.explore(aVocab, hVocab);
                ArrayList<Gram> rightGrams = new ArrayList<Gram>();
                Tree rightTree = this.RightChild;
                while (rightTree.Label.equals(".")) {
                    if (rightTree.LeftChild == null || rightTree.RightChild == null) break;
                    Gram leftGram = rightTree.LeftChild.explore(aVocab, hVocab);
                    rightGrams.add(leftGram);
                    rightTree = rightTree.RightChild;
                }
                if (rightGrams.size() > 0) {
                    gram1.concatenations(rightGrams);
                }
                Gram gram2 = rightTree.explore(aVocab, hVocab);
                gram = gram1.concatenation(gram2);
            }
        } else {
            gram = Gram.token(this.Label, aVocab, hVocab);
        }
        return gram;
    }

    Gram explore(String output, ArrayList<String> aVocab, HashMap<String, Integer> hVocab) {
        ParameterCheck.mandatory("aVocab", aVocab);
        ParameterCheck.mandatory("hVocab", hVocab);
        Gram resultGram = output != null ? Gram.addOutput(this.explore(aVocab, hVocab), output, aVocab, hVocab) : this.explore(aVocab, hVocab);
        return resultGram;
    }
}

