/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.nooj4nlp.controller.TextEditorShell.JMftPanel;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.helper.PenAttributes;

public class TuGraph {
    public ArrayList<Double> stPositions;
    public ArrayList<ArrayList<TransCell>> transitions;
    private int gHeight = 0;
    private int gWidth = 0;
    public int xCoord;
    private int yCoord;
    private int[] stateNumber;
    private int[] colNumber;
    private int[] x;
    private int[] yc;
    private int lastX;
    private HashMap<String, PenAttributes<Color, Float>> pen = new HashMap();
    private Font font;
    private Font font_col;
    private Color brush;
    private Color brush_col;
    private Color brush_sel;
    public boolean needToBeComputed;
    public int currentFrameX;
    public double selectedAnnotation_relBegAddress;
    public int selectedAnnotation_tokenId;
    private int shift = 10;

    public TuGraph() {
        this.stPositions = new ArrayList();
        this.transitions = new ArrayList();
        this.pen.put("pen", new PenAttributes(Color.BLACK, 1.0f));
        this.brush = Color.BLACK;
        this.pen.put("pen_sel", new PenAttributes(Color.RED, 5.0f));
        this.brush_sel = Color.RED;
        this.pen.put("pen_col", new PenAttributes(Color.GRAY, 2.0f));
        this.brush_col = Color.BLUE;
    }

    public void addTransition(double strtPos, int tokenId, double destPos) {
        int idst;
        int isrc;
        if (this.stPositions.indexOf(strtPos) == -1) {
            this.stPositions.add(strtPos);
            isrc = this.stPositions.lastIndexOf(strtPos);
            this.transitions.add(new ArrayList());
        } else {
            isrc = this.stPositions.indexOf(strtPos);
        }
        if (this.stPositions.indexOf(destPos) == -1) {
            this.stPositions.add(destPos);
            idst = this.stPositions.lastIndexOf(destPos);
            this.transitions.add(new ArrayList());
        } else {
            idst = this.stPositions.indexOf(destPos);
        }
        ArrayList<TransCell> trans = this.transitions.get(isrc);
        TransCell tr = new TransCell(tokenId, idst);
        boolean found = false;
        for (TransCell ctr : trans) {
            if (tr.tokenId != ctr.tokenId || tr.dest != ctr.dest) continue;
            found = true;
            break;
        }
        if (!found) {
            trans.add(tr);
        }
    }

    public void computeXYcoord(JPanel mftPanel, double selectAllAnnotationsAtPosition, int y) {
        this.xCoord = 0;
        if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            this.xCoord = mftPanel.getWidth() - 1;
        }
        this.yCoord = 10 + (y + 20) / 40 * 40;
        if (this.stateNumber == null) {
            return;
        }
        int iCol = 0;
        while (iCol < this.stateNumber.length) {
            int iState = this.stateNumber[iCol];
            int statePos = (int)(100.0 * this.stPositions.get(iState));
            int x0 = mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? this.lastX - this.x[iCol] : this.x[iCol];
            double sp = (double)statePos / 100.0;
            if (sp == selectAllAnnotationsAtPosition) {
                this.xCoord = mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? x0 - (this.currentFrameX - mftPanel.getWidth()) : x0 - this.currentFrameX;
                if (this.xCoord < 0) {
                    this.xCoord = 0;
                }
                return;
            }
            ++iCol;
        }
    }

    public void computeCurrentFrameX(double selectAllAnnotationsAtPosition, JPanel mftPanel) {
        this.currentFrameX = 0;
        if (this.stateNumber == null) {
            return;
        }
        int iCol = 0;
        while (iCol < this.stateNumber.length) {
            int iState = this.stateNumber[iCol];
            int statePos = (int)(100.0 * this.stPositions.get(iState));
            int x0 = mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? this.lastX - this.x[iCol] : this.x[iCol];
            double sp = (double)statePos / 100.0;
            if (sp == selectAllAnnotationsAtPosition) {
                this.currentFrameX = mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? ((x0 - 1) / mftPanel.getWidth() + 1) * mftPanel.getWidth() : x0 / mftPanel.getWidth() * mftPanel.getWidth();
            }
            ++iCol;
        }
    }

    public void computeDrawing(ArrayList<Object> annotations, JMftPanel mftPanel, Graphics2D g) {
        int iTrans;
        int iCol;
        this.font = mftPanel.getFont();
        this.font_col = new Font(mftPanel.getFont().getName(), 0, 8);
        int nbOfStates = this.stPositions.size();
        if (nbOfStates == 0) {
            this.stateNumber = null;
            return;
        }
        this.stateNumber = new int[nbOfStates];
        int i = 0;
        while (i < nbOfStates) {
            this.stateNumber[i] = i;
            ++i;
        }
        int iCol2 = 0;
        while (iCol2 < nbOfStates) {
            int si = this.stateNumber[iCol2];
            int posi = (int)(100.0 * this.stPositions.get(si));
            int jCol = iCol2 + 1;
            while (jCol < nbOfStates) {
                int sj = this.stateNumber[jCol];
                int posj = (int)(100.0 * this.stPositions.get(sj));
                if (posi > posj) {
                    int coltmp = this.stateNumber[iCol2];
                    this.stateNumber[iCol2] = this.stateNumber[jCol];
                    this.stateNumber[jCol] = coltmp;
                    si = this.stateNumber[iCol2];
                    posi = (int)(100.0 * this.stPositions.get(si));
                }
                ++jCol;
            }
            ++iCol2;
        }
        this.colNumber = new int[nbOfStates];
        iCol2 = 0;
        while (iCol2 < nbOfStates) {
            this.colNumber[this.stateNumber[iCol2]] = iCol2;
            ++iCol2;
        }
        this.x = new int[nbOfStates];
        int icol = 0;
        while (icol < nbOfStates) {
            this.x[icol] = icol * 20;
            ++icol;
        }
        boolean modified = true;
        while (modified) {
            modified = false;
            iCol = 0;
            while (iCol < nbOfStates) {
                int iState = this.stateNumber[iCol];
                ArrayList<TransCell> trans = this.transitions.get(iState);
                iTrans = 0;
                while (iTrans < trans.size()) {
                    String[] features;
                    RefObject<Object> refFeatures;
                    String category;
                    RefObject<String> refCategory;
                    String lemma;
                    RefObject<String> refLemma;
                    String entry;
                    RefObject<String> refEntry;
                    TransCell t = trans.get(iTrans);
                    int tkId = t.tokenId;
                    String lbl0 = tkId < 0 || tkId >= annotations.size() ? "ANNOTATION,ERROR" : (String)annotations.get(tkId);
                    if (lbl0 != null && Dic.parseDELAFFeatureArray(lbl0, refEntry = new RefObject<String>(entry = ""), refLemma = new RefObject<String>(lemma = ""), refCategory = new RefObject<String>(category = ""), refFeatures = new RefObject<Object>((features = null)))) {
                        entry = (String)refEntry.argvalue;
                        lemma = (String)refLemma.argvalue;
                        category = (String)refCategory.argvalue;
                        features = (String[])refFeatures.argvalue;
                        if (!(category.equals("NW") || features != null && Dic.lookFor("FXC", features) != null)) {
                            String lbl;
                            if (lemma.equals("SYNTAX")) {
                                lbl = String.valueOf(category) + Dic.getRidOfSpecialFeatures(features);
                            } else {
                                String newFeatures = Dic.getRidOfSpecialFeaturesPlus(features);
                                lbl = String.valueOf(lemma) + "," + category + newFeatures;
                            }
                            int width = this.measureText(g, lbl, this.font);
                            int jState = t.dest;
                            int jCol = this.colNumber[jState];
                            if (jCol != iCol && width > this.x[jCol] - this.x[iCol]) {
                                int oldRightMargin = this.x[jCol];
                                int newRightMargin = this.x[iCol] + width + 1;
                                int k = 0;
                                while (k < nbOfStates) {
                                    if (this.x[k] >= oldRightMargin) {
                                        this.x[k] = newRightMargin + (this.x[k] - oldRightMargin);
                                        modified = true;
                                    }
                                    ++k;
                                }
                            }
                        }
                    }
                    ++iTrans;
                }
                ++iCol;
            }
        }
        this.lastX = this.x[this.stateNumber.length - 1];
        int iState = 0;
        while (iState < nbOfStates) {
            ArrayList<TransCell> trans = this.transitions.get(iState);
            int i2 = 0;
            while (i2 < trans.size()) {
                int j = i2 + 1;
                while (j < trans.size()) {
                    TransCell tmp;
                    int desI = (int)(100.0 * this.stPositions.get(trans.get(i2).dest));
                    String labI = (String)annotations.get(trans.get(i2).tokenId);
                    int desJ = (int)(100.0 * this.stPositions.get(trans.get(j).dest));
                    int tokId = trans.get(j).tokenId;
                    String labJ = tokId < 0 || tokId >= annotations.size() ? "annotation,INVALIDRANGE" : (String)annotations.get(tokId);
                    if (labI != null && labI.indexOf("XREF=") != -1 || labJ != null && labJ.indexOf("XREF=") != -1) {
                        if (labI == null || labI.indexOf("XREF=") == -1) {
                            tmp = trans.get(i2);
                            trans.set(i2, trans.get(j));
                            trans.set(j, tmp);
                        }
                    } else if (desI < desJ) {
                        tmp = trans.get(i2);
                        trans.set(i2, trans.get(j));
                        trans.set(j, tmp);
                    }
                    ++j;
                }
                ++i2;
            }
            ++iState;
        }
        this.yc = new int[nbOfStates];
        iCol = 0;
        while (iCol < nbOfStates) {
            int iState2 = this.stateNumber[iCol];
            ArrayList<TransCell> trans = this.transitions.get(iState2);
            if (this.yc[iCol] == 0) {
                this.yc[iCol] = 50;
            }
            iTrans = 0;
            while (iTrans < trans.size()) {
                TransCell t = trans.get(iTrans);
                int curry = this.yc[iCol] + 40 * iTrans;
                int jcol = iCol + 1;
                while (jcol < nbOfStates) {
                    int jState = this.stateNumber[jcol];
                    if ((int)(100.0 * this.stPositions.get(t.dest)) > (int)(100.0 * this.stPositions.get(jState)) && this.yc[jcol] < curry + 40) {
                        this.yc[jcol] = curry + 40;
                    }
                    ++jcol;
                }
                ++iTrans;
            }
            ++iCol;
        }
        this.gWidth = this.x[nbOfStates - 1];
        this.gHeight = 0;
        int icol2 = 0;
        while (icol2 < nbOfStates) {
            int iState3 = this.stateNumber[icol2];
            ArrayList<TransCell> trans = this.transitions.get(iState3);
            if (this.gHeight < this.yc[icol2] + 40 * trans.size()) {
                this.gHeight = this.yc[icol2] + 40 * trans.size();
            }
            ++icol2;
        }
        mftPanel.setSize(this.gWidth, this.gHeight);
        this.needToBeComputed = false;
    }

    public boolean getSelectedAnnotation(int xClick, int yClick, JPanel mftPanel, RefObject<Double> selectAllAnnotationsAtPosition) {
        if (this.stateNumber == null) {
            selectAllAnnotationsAtPosition.argvalue = 0.0;
            return false;
        }
        int largestX = -1;
        if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            largestX = mftPanel.getWidth() + 1;
        }
        int iCol0 = -1;
        int iCol = 0;
        while (iCol < this.stateNumber.length) {
            int x0;
            int colX;
            if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                colX = this.lastX - this.x[iCol];
                if (colX <= this.currentFrameX) {
                    if (colX < this.currentFrameX - mftPanel.getWidth()) break;
                    x0 = colX - (this.currentFrameX - mftPanel.getWidth());
                    if (x0 > xClick && x0 < largestX) {
                        largestX = x0;
                        iCol0 = iCol;
                    }
                }
            } else {
                colX = this.x[iCol];
                if (colX >= this.currentFrameX) {
                    if (colX > this.currentFrameX + mftPanel.getWidth()) break;
                    x0 = colX - this.currentFrameX;
                    if (x0 < xClick && x0 > largestX) {
                        largestX = x0;
                        iCol0 = iCol;
                    }
                }
            }
            ++iCol;
        }
        if (iCol0 == -1) {
            selectAllAnnotationsAtPosition.argvalue = 0.0;
            return false;
        }
        int istate0 = this.stateNumber[iCol0];
        selectAllAnnotationsAtPosition.argvalue = (double)this.stPositions.get(istate0);
        return true;
    }

    public void draw(ArrayList<Object> annotations, double selectAllAnnotationsAtPosition, JMftPanel mftPanel, Graphics2D g) {
        JScrollPane parent = mftPanel.getParentScrollPane();
        g.setColor(parent.getBackground());
        g.fillRect(0, 0, parent.getWidth(), parent.getHeight());
        this.computeCurrentFrameX(selectAllAnnotationsAtPosition, mftPanel);
        this.selectedAnnotation_relBegAddress = -1.0;
        this.selectedAnnotation_tokenId = -1;
        if (this.stateNumber == null) {
            return;
        }
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, mftPanel.getWidth(), this.gHeight);
        g.setColor((Color)this.pen.get((Object)"pen_col").color);
        g.setStroke(new BasicStroke(this.pen.get((Object)"pen_col").stroke));
        g.drawRect(0, 0, mftPanel.getWidth(), this.gHeight);
        ArrayList<Object> allXRefs = new ArrayList<Object>();
        int iCol = 0;
        while (iCol < this.stateNumber.length) {
            block39: {
                int x0;
                ArrayList<TransCell> trans;
                int statePos;
                block40: {
                    block38: {
                        int iState = this.stateNumber[iCol];
                        statePos = (int)(100.0 * (this.stPositions.get(iState) + 0.005));
                        trans = this.transitions.get(iState);
                        if (mftPanel.getComponentOrientation() != ComponentOrientation.RIGHT_TO_LEFT) break block38;
                        x0 = this.lastX - this.x[iCol];
                        if (x0 < 0) break;
                        if (x0 > this.currentFrameX) break block39;
                        x0 -= this.currentFrameX - mftPanel.getWidth();
                        break block40;
                    }
                    x0 = this.x[iCol];
                    if (x0 > this.currentFrameX + mftPanel.getWidth()) break;
                    if (x0 < this.currentFrameX) break block39;
                    x0 -= this.currentFrameX;
                }
                double sp = (double)statePos / 100.0;
                String colNb = Integer.toString((int)sp);
                if (sp == selectAllAnnotationsAtPosition) {
                    this.selectedAnnotation_relBegAddress = sp;
                    g.setColor((Color)this.pen.get((Object)"pen_sel").color);
                    g.setStroke(new BasicStroke(this.pen.get((Object)"pen_sel").stroke));
                    g.drawLine(x0, 0, x0, mftPanel.getHeight());
                    if (trans.size() > 0) {
                        g.setColor(this.brush_sel);
                        g.setFont(this.font_col);
                        g.drawString(colNb, x0, 0 + this.shift);
                    }
                } else {
                    g.setColor((Color)this.pen.get((Object)"pen_col").color);
                    g.setStroke(new BasicStroke(this.pen.get((Object)"pen_col").stroke));
                    g.drawLine(x0, 0, x0, mftPanel.getHeight());
                    if (trans.size() > 0) {
                        g.setColor(this.brush_col);
                        g.setFont(this.font_col);
                        g.drawString(colNb, x0, 0 + this.shift);
                    }
                }
                int it = 0;
                while (it < trans.size()) {
                    block41: {
                        Color tBrush;
                        BasicStroke tStroke;
                        Color tPen;
                        String label;
                        Color color;
                        int yt;
                        int y;
                        int x1;
                        int tokenId;
                        block44: {
                            String xref;
                            String[] features;
                            String category;
                            String lemma;
                            block42: {
                                block43: {
                                    RefObject<Object> refFeatures;
                                    RefObject<String> refCategory;
                                    RefObject<String> refLemma;
                                    String entry;
                                    RefObject<String> refEntry;
                                    TransCell t = trans.get(it);
                                    tokenId = t.tokenId;
                                    if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                                        x1 = this.lastX - this.x[this.colNumber[t.dest]];
                                        if (x1 < 0) break;
                                        x1 -= this.currentFrameX - mftPanel.getWidth();
                                    } else {
                                        x1 = this.x[this.colNumber[t.dest]];
                                        if (x1 > this.currentFrameX + mftPanel.getWidth()) break;
                                        x1 -= this.currentFrameX;
                                    }
                                    y = this.yc[iCol] + 40 * it;
                                    yt = y - 20;
                                    String label0 = tokenId < 0 || tokenId >= annotations.size() ? "annotations,INVALIDRANGE" : (String)annotations.get(tokenId);
                                    if (label0 == null || !Dic.parseDELAFFeatureArray(label0, refEntry = new RefObject<String>(entry = ""), refLemma = new RefObject<String>(lemma = ""), refCategory = new RefObject<String>(category = ""), refFeatures = new RefObject<Object>((features = null)))) break block41;
                                    entry = (String)refEntry.argvalue;
                                    lemma = (String)refLemma.argvalue;
                                    category = (String)refCategory.argvalue;
                                    features = (String[])refFeatures.argvalue;
                                    if (category.equals("NW") || features != null && Dic.lookFor("FXC", features) != null) break block41;
                                    if (!lemma.equals("SYNTAX")) break block42;
                                    xref = Dic.lookFor("XREF", features);
                                    if (!category.equals("XREF")) break block43;
                                    String cat2 = "";
                                    String info2 = "";
                                    RefObject<String> refInfo2 = new RefObject<String>(info2);
                                    if (!Dic.parseDELAF(label0, refEntry, refLemma, refInfo2)) break block41;
                                    info2 = (String)refInfo2.argvalue;
                                    cat2 = Dic.lookForAtBeg("XREF", info2);
                                    allXRefs.add(cat2);
                                    allXRefs.add(x0);
                                    allXRefs.add(y);
                                    allXRefs.add(x1);
                                    color = Color.BLACK;
                                    label = category.equals("XREF") ? "..." : String.valueOf(category) + Dic.getRidOfSpecialFeaturesPlus(features);
                                    break block44;
                                }
                                if (xref != null) {
                                    allXRefs.add(xref);
                                    allXRefs.add(x0);
                                    allXRefs.add(y);
                                    allXRefs.add(x1);
                                    color = Color.BLACK;
                                    label = category.equals("XREF") ? "..." : String.valueOf(category) + Dic.getRidOfSpecialFeaturesPlus(features);
                                } else {
                                    color = Color.GREEN;
                                    label = String.valueOf(category) + Dic.getRidOfSpecialFeaturesPlus(features);
                                }
                                break block44;
                            }
                            xref = Dic.lookFor("XREF", features);
                            if (category.equals("XREF") || xref != null) {
                                allXRefs.add(xref);
                                allXRefs.add(x0);
                                allXRefs.add(y);
                                allXRefs.add(x1);
                                color = Color.BLACK;
                            } else {
                                color = Color.BLACK;
                            }
                            String newFeatures = Dic.getRidOfSpecialFeaturesPlus(features);
                            label = category.equals("XREF") ? "..." : String.valueOf(Dic.protectComma(lemma)) + "," + category + newFeatures;
                        }
                        if (color == Color.BLACK) {
                            if (y == this.yCoord && sp == selectAllAnnotationsAtPosition) {
                                this.selectedAnnotation_tokenId = tokenId;
                                tPen = (Color)this.pen.get((Object)"pen_sel").color;
                                tStroke = new BasicStroke(this.pen.get((Object)"pen_sel").stroke);
                                tBrush = this.brush_sel;
                            } else {
                                tPen = (Color)this.pen.get((Object)"pen").color;
                                tStroke = new BasicStroke(this.pen.get((Object)"pen").stroke);
                                tBrush = this.brush;
                            }
                            g.setColor(tPen);
                            g.setStroke(tStroke);
                            g.drawLine(x0, y, x1, y);
                            if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                                g.drawLine(x1 + 10, y - 4, x1, y);
                                g.drawLine(x1 + 10, y + 4, x1, y);
                            } else {
                                g.drawLine(x1 - 10, y - 4, x1, y);
                                g.drawLine(x1 - 10, y + 4, x1, y);
                            }
                            if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                                g.setColor(tBrush);
                                g.setFont(this.font);
                                g.drawString(label, x1, yt);
                            } else {
                                g.setColor(tBrush);
                                g.setFont(this.font);
                                g.drawString(label, x0, yt);
                            }
                        } else {
                            if (y == this.yCoord && sp == selectAllAnnotationsAtPosition) {
                                this.selectedAnnotation_tokenId = tokenId;
                                tPen = (Color)this.pen.get((Object)"pen_sel").color;
                                tStroke = new BasicStroke(this.pen.get((Object)"pen_sel").stroke);
                                tBrush = this.brush_sel;
                            } else {
                                tPen = color;
                                tStroke = new BasicStroke(2.0f);
                                tBrush = color;
                            }
                            g.setColor(tPen);
                            g.setStroke(tStroke);
                            g.drawLine(x0, y, x1, y);
                            if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                                g.drawLine(x1 + 10, y - 4, x1, y);
                                g.drawLine(x1 + 10, y + 4, x1, y);
                            } else {
                                g.drawLine(x1 - 10, y - 4, x1, y);
                                g.drawLine(x1 - 10, y + 4, x1, y);
                            }
                            if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                                g.setColor(tBrush);
                                g.setFont(this.font);
                                g.drawString(label, x1, yt);
                            } else {
                                g.setColor(tBrush);
                                g.setFont(this.font);
                                g.drawString(label, x0, yt);
                            }
                        }
                    }
                    ++it;
                }
            }
            ++iCol;
        }
        if (allXRefs.size() > 0) {
            Color xPen = Color.BLACK;
            BasicStroke xStroke = new BasicStroke(1.0f);
            int ixref = 0;
            while (ixref < allXRefs.size()) {
                String xrefi = (String)allXRefs.get(ixref);
                int yi = (Integer)allXRefs.get(ixref + 2);
                int xendi = (Integer)allXRefs.get(ixref + 3);
                int jxref = ixref + 4;
                while (jxref < allXRefs.size()) {
                    String xrefj = (String)allXRefs.get(jxref);
                    int xbegj = (Integer)allXRefs.get(jxref + 1);
                    int yj = (Integer)allXRefs.get(jxref + 2);
                    if (!(mftPanel.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT && xbegj < xendi || mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT && xbegj > xendi || xrefi != xrefj)) {
                        Point pt3;
                        Point pt2;
                        GeneralPath path;
                        Point pt1 = new Point(xendi, yi);
                        Point pt4 = new Point(xbegj, yj);
                        if (mftPanel.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
                            Point pt32;
                            Point pt22;
                            if (xbegj - xendi > 70) {
                                pt22 = new Point(xendi + 35, yi - 35);
                                pt32 = new Point(xbegj - 35, yj - 35);
                            } else {
                                pt22 = new Point(xendi + 10, yi - 20);
                                pt32 = new Point(xbegj - 10, yj - 20);
                            }
                            g.setStroke(xStroke);
                            g.setColor(xPen);
                            path = new GeneralPath();
                            path.moveTo(pt1.x, pt1.y);
                            path.curveTo(pt22.x, pt22.y, pt32.x, pt32.y, pt4.x, pt4.y);
                            break;
                        }
                        if (xendi - xbegj > 70) {
                            pt2 = new Point(xendi - 35, yi - 35);
                            pt3 = new Point(xbegj + 35, yj - 35);
                        } else {
                            pt2 = new Point(xendi - 10, yi - 20);
                            pt3 = new Point(xbegj + 10, yj - 20);
                        }
                        g.setStroke(xStroke);
                        g.setColor(xPen);
                        path = new GeneralPath();
                        path.moveTo(pt4.x, pt4.y);
                        path.curveTo(pt3.x, pt3.y, pt2.x, pt2.y, pt1.x, pt1.y);
                        break;
                    }
                    jxref += 4;
                }
                ixref += 4;
            }
        }
        int lastcol = this.stateNumber.length - 1;
        if (mftPanel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            g.setStroke(new BasicStroke(this.pen.get((Object)"pen_col").stroke));
            g.setColor((Color)this.pen.get((Object)"pen_col").color);
            g.drawLine(this.lastX - this.x[lastcol], 0, this.lastX - this.x[lastcol], mftPanel.getHeight());
        } else {
            g.setStroke(new BasicStroke(this.pen.get((Object)"pen_col").stroke));
            g.setColor((Color)this.pen.get((Object)"pen_col").color);
            g.drawLine(this.x[lastcol], 0, this.x[lastcol], mftPanel.getHeight());
        }
        mftPanel.setPreferredSize(new Dimension(mftPanel.getWidth(), mftPanel.getHeight()));
    }

    private int measureText(Graphics2D g, String text, Font f) {
        Font previousFont = g.getFont();
        g.setFont(f);
        FontMetrics metrics = g.getFontMetrics();
        g.setFont(previousFont);
        return metrics.stringWidth(text);
    }

    public boolean isNeedToBeComputed() {
        return this.needToBeComputed;
    }

    public void setNeedToBeComputed(boolean needToBeComputed) {
        this.needToBeComputed = needToBeComputed;
    }

    public void setTransitions(ArrayList<ArrayList<TransCell>> transitions) {
        this.transitions = transitions;
    }

    public class TransCell {
        private int tokenId;
        private int dest;

        private TransCell(int tokenid, int dst) {
            this.tokenId = tokenid;
            this.dest = dst;
        }
    }
}

