/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.nooj4nlp.engine.helper.ParameterCheck;

public class Zip {
    public static void compressDir(String sourceDirPath, String destinationZipFilePath) throws IOException {
        ParameterCheck.mandatoryString("sourceDirPath", sourceDirPath);
        ParameterCheck.mandatoryString("destinationZipFilePath", destinationZipFilePath);
        File directory = new File(sourceDirPath);
        File[] sourceDirFiles = directory.listFiles();
        CRC32 crc = new CRC32();
        File zipFile = new File(destinationZipFilePath);
        if (!zipFile.createNewFile()) {
            zipFile.delete();
            zipFile.createNewFile();
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(zipFile);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            zipOutputStream.setLevel(6);
            File[] fileArray = sourceDirFiles;
            int n = sourceDirFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File sourceDirFile = fileArray[n2];
                try {
                    fileInputStream = new FileInputStream(sourceDirFile);
                    byte[] dataBuffer = null;
                    dataBuffer = new byte[(int)sourceDirFile.length()];
                    fileInputStream.read(dataBuffer, 0, dataBuffer.length);
                    String sourceDirFileName = sourceDirFile.getName();
                    ZipEntry zipEntry = new ZipEntry(sourceDirFileName);
                    zipEntry.setTime(new Date().getTime());
                    zipEntry.setSize(sourceDirFile.length());
                    fileInputStream.close();
                    crc.reset();
                    crc.update(dataBuffer);
                    zipEntry.setCrc(crc.getValue());
                    zipOutputStream.putNextEntry(zipEntry);
                    zipOutputStream.write(dataBuffer, 0, dataBuffer.length);
                }
                catch (RuntimeException e) {
                    System.out.println(String.valueOf(e.getMessage()) + "\n\nNooJ: cannot store file " + sourceDirFile);
                }
                ++n2;
            }
            zipOutputStream.finish();
            zipOutputStream.close();
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
    }

    public static void uncompressDir(String destinationDirPath, String sourceZipFilePath) throws IOException {
        ParameterCheck.mandatoryString("destinationDirPath", destinationDirPath);
        ParameterCheck.mandatoryString("sourceZipFilePath", sourceZipFilePath);
        InputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(sourceZipFilePath);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                String zipEntryFileName = zipEntry.getName();
                zipInputStream = zipFile.getInputStream(zipEntry);
                new File(destinationDirPath).mkdir();
                if (zipEntryFileName.equals("")) continue;
                File file = new File(destinationDirPath, zipEntryFileName);
                if (!file.createNewFile()) {
                    file.delete();
                    file.createNewFile();
                }
                fileOutputStream = new FileOutputStream(file);
                int bufferSize = 2048;
                byte[] dataBuffer = new byte[2048];
                while ((bufferSize = zipInputStream.read(dataBuffer, 0, dataBuffer.length)) > 0) {
                    fileOutputStream.write(dataBuffer, 0, bufferSize);
                }
                fileOutputStream.close();
            }
            zipInputStream.close();
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }
}

