/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine.helper;

import java.awt.Color;
import java.io.IOException;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.DictionaryDialog.DictionaryDialogController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Dictionary;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.gui.actions.shells.modify.UnitSelectionListener;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class BackgroundWorker
extends SwingWorker<Void, Void> {
    public static final String CORPUS_ALPHABETISATION = "corpus alphabetisation";
    private static final String CORPUS_TOKENIZATION = "corpus tokenization";
    public static final String CORPUS_AMBIGUITIES = "corpus ambiguities";
    public static final String CORPUS_UNAMBIGUITIES = "corpus unambiguities";
    private static final String CORPUS_DIGRAMIZATION = "corpus digramization";
    public static final String CORPUS_LING_ANALYSIS = "corpus linguistic analysis";
    public static final String CORPUS_LOCATE = "corpus locate";
    public static final String TEXT_ALPHABETISATION = "text alphabetisation";
    public static final String TEXT_TOKENIZATION = "text tokenization";
    public static final String TEXT_AMBIGUITIES = "text ambiguities";
    public static final String TEXT_UNAMBIGUITIES = "text unambiguities";
    public static final String TEXT_DIGRAMIZATION = "text digramization";
    public static final String TEXT_LING_ANALYSIS = "text linguistic analysis";
    public static final String TEXT_LOCATE = "text locate";
    public static final String DIC_COMPILE = "dic compile";
    public static final String DIC_INFLECT = "dic inflect";
    private String processName;
    private TextEditorShellController textController;
    private CorpusEditorShellController corpusController;
    private DictionaryDialogController dictionaryController;
    private boolean cancellationPending;
    private boolean isBusy;

    public BackgroundWorker() {
        this.processName = "";
        this.textController = null;
        this.corpusController = null;
        this.dictionaryController = null;
    }

    public BackgroundWorker(String processName, TextEditorShellController textController, CorpusEditorShellController corpusController, DictionaryDialogController dictionaryController) {
        this.processName = processName;
        this.textController = textController;
        this.corpusController = corpusController;
        this.dictionaryController = dictionaryController;
        this.isBusy = false;
        this.cancellationPending = false;
    }

    public void reportProgress(int i) {
        this.setProgress(i);
    }

    @Override
    public Void doInBackground() {
        this.isBusy = true;
        Launcher.processName = this.processName;
        if (this.processName.equals(CORPUS_ALPHABETISATION)) {
            this.corpusController.computeAlphabet();
        } else if (this.processName.equals(CORPUS_TOKENIZATION)) {
            this.corpusController.computeTokens();
        } else if (this.processName.equals(CORPUS_AMBIGUITIES)) {
            this.corpusController.computeAmbiguities(true);
        } else if (this.processName.equals(CORPUS_UNAMBIGUITIES)) {
            this.corpusController.computeAmbiguities(false);
        } else if (this.processName.equals(CORPUS_DIGRAMIZATION)) {
            this.corpusController.computeDigrams();
        } else if (this.processName.equals(CORPUS_LING_ANALYSIS)) {
            this.corpusController.linguisticAnalysis();
        } else if (this.processName.equals(CORPUS_LOCATE)) {
            this.corpusController.getLocateDialog().getConcordanceLocateActionListener().launchLocate();
        } else if (this.processName.equals(TEXT_ALPHABETISATION)) {
            this.textController.computeAlphabet();
        } else if (this.processName.equals(TEXT_TOKENIZATION)) {
            this.textController.computeTokens();
        } else if (this.processName.equals(TEXT_AMBIGUITIES)) {
            this.textController.computeAmbiguities(true);
        } else if (this.processName.equals(TEXT_UNAMBIGUITIES)) {
            this.textController.computeAmbiguities(false);
        } else if (this.processName.equals(TEXT_DIGRAMIZATION)) {
            this.textController.computeDigrams();
        } else if (this.processName.equals(TEXT_LING_ANALYSIS)) {
            this.textController.linguisticAnalysis();
        } else if (this.processName.equals(TEXT_LOCATE)) {
            this.textController.getTextShell().getLocateDialog().getConcordanceLocateActionListener().launchLocate();
        } else if (this.processName.equals(DIC_COMPILE)) {
            Language lan;
            String fullName = this.dictionaryController.getTxtDictionaryName().getText();
            String fName = FilenameUtils.removeExtension(FilenameUtils.getName(fullName));
            String dirName = FilenameUtils.getFullPath(fullName);
            String resName = String.valueOf(dirName) + fName + "." + "jnod";
            try {
                lan = new Language(Dictionary.getLanguage(fullName));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Dictionary has not a valid format.", "NooJ: cannot read dictionary language", 1);
                return null;
            }
            try {
                Dictionary.compile(fullName, resName, Launcher.checkAgreement, lan);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
        } else if (this.processName.equals(DIC_INFLECT)) {
            Language lan;
            String fullName = this.dictionaryController.getTxtDictionaryName().getText();
            String fName = FilenameUtils.removeExtension(FilenameUtils.getName(fullName));
            String dirName = FilenameUtils.getFullPath(fullName);
            String resName = String.valueOf(dirName) + fName + "." + "jnod";
            try {
                lan = new Language(Dictionary.getLanguage(fullName));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Dictionary has not a valid format.", "NooJ: cannot read dictionary language", 1);
                return null;
            }
            try {
                Dictionary.inflect(fullName, resName, Launcher.checkAgreement, lan, Launcher.preferences);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
        }
        return null;
    }

    @Override
    public void done() {
        Date now = new Date();
        long sec = (now.getTime() - Launcher.initialDate.getTime()) / 1000L;
        Launcher.getStatusBar().getBtnCancel().setEnabled(false);
        Launcher.getStatusBar().getBtnCancel().setForeground(Color.black);
        Launcher.getStatusBar().getProgressLabel().setText(String.valueOf(Long.toString(sec)) + " sec");
        Launcher.getStatusBar().getProgressBar().setValue(0);
        Launcher.backgroundWorking = false;
        if (this.isCancelled()) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Process canceled", "NooJ", 1);
        }
        if (this.processName.equals(CORPUS_ALPHABETISATION)) {
            this.corpusController.getShell().getAlphabetDialog().fillInTheAlphabet(this.corpusController.getCorpus().charlist);
            this.corpusController.reactivateOps();
            this.corpusController.updateTitle();
            this.corpusController.updateTextPaneStats();
            this.corpusController.updateResults();
            Launcher.progressMessage = "Displaying alphabet...";
            this.corpusController.getShell().getAlphabetDialog().show();
        } else if (this.processName.equals(CORPUS_TOKENIZATION)) {
            this.corpusController.getShell().getTokensDialog().fillInTheTokensDigramsTable(true);
            this.corpusController.reactivateOps();
            this.corpusController.updateTitle();
            this.corpusController.updateTextPaneStats();
            this.corpusController.updateResults();
            Launcher.progressMessage = "Displaying tokens...";
            this.corpusController.getShell().getTokensDialog().show();
        } else if (this.processName.equals(CORPUS_AMBIGUITIES)) {
            this.corpusController.getShell().getAmbiguitiesDialog().fillInTheTable();
            this.corpusController.reactivateOps();
            this.corpusController.updateTitle();
            this.corpusController.updateTextPaneStats();
            this.corpusController.updateResults();
            Launcher.progressMessage = "Displaying ambiguities...";
            this.corpusController.getShell().getAmbiguitiesDialog().show();
        } else if (this.processName.equals(CORPUS_UNAMBIGUITIES)) {
            this.corpusController.getShell().getUnAmbiguitiesDialog().fillInTheTable();
            this.corpusController.reactivateOps();
            this.corpusController.updateTitle();
            this.corpusController.updateTextPaneStats();
            this.corpusController.updateResults();
            Launcher.progressMessage = "Displaying unambiguous words...";
            this.corpusController.getShell().getUnAmbiguitiesDialog().show();
        } else if (this.processName.equals(CORPUS_DIGRAMIZATION)) {
            this.corpusController.getShell().getDigramsDialog().fillInTheTokensDigramsTable(true);
            this.corpusController.reactivateOps();
            this.corpusController.updateTitle();
            this.corpusController.updateTextPaneStats();
            this.corpusController.updateResults();
            Launcher.progressMessage = "Displaying digrams...";
            this.corpusController.getShell().getDigramsDialog().show();
        } else if (this.processName.equals(CORPUS_LING_ANALYSIS)) {
            this.corpusController.reactivateOps();
            this.corpusController.updateTitle();
            this.corpusController.updateTextPaneStats();
            this.corpusController.updateResults();
        } else if (this.processName.equals(CORPUS_LOCATE)) {
            this.corpusController.reactivateOps();
            Launcher.progressMessage = "Displaying concordance...";
            this.corpusController.getConcordanceController().refreshConcordance();
        } else if (this.processName.equals(TEXT_ALPHABETISATION)) {
            this.textController.getTextShell().getAlphabetDialog().fillInTheAlphabet(this.textController.getMyText().charlist);
            this.textController.reactivateOps();
            this.textController.updateTextPaneStats();
            this.textController.rtbTextUpdate(false);
            Launcher.progressMessage = "Displaying alphabet...";
            this.textController.getTextShell().getAlphabetDialog().show();
        } else if (this.processName.equals(TEXT_TOKENIZATION)) {
            this.textController.getTextShell().getTokensDialog().fillInTheTokensDigramsTable(false);
            this.textController.reactivateOps();
            this.textController.updateTextPaneStats();
            this.textController.rtbTextUpdate(false);
            Launcher.progressMessage = "Displaying tokens...";
            this.textController.getTextShell().getTokensDialog().show();
        } else if (this.processName.equals(TEXT_AMBIGUITIES)) {
            this.textController.getTextShell().getAmbiguitiesDialog().fillInTheTable();
            this.textController.reactivateOps();
            this.textController.updateTextPaneStats();
            Launcher.progressMessage = "Displaying ambiguities...";
            this.textController.getTextShell().getAmbiguitiesDialog().show();
        } else if (this.processName.equals(TEXT_UNAMBIGUITIES)) {
            this.textController.getTextShell().getUnAmbiguitiesDialog().fillInTheTable();
            this.textController.reactivateOps();
            this.textController.updateTextPaneStats();
            Launcher.progressMessage = "Displaying unambiguous words...";
            this.textController.getTextShell().getUnAmbiguitiesDialog().show();
        } else if (this.processName.equals(TEXT_DIGRAMIZATION)) {
            this.textController.getTextShell().getDigramsDialog().fillInTheTokensDigramsTable(false);
            this.textController.reactivateOps();
            this.textController.updateTextPaneStats();
            this.textController.rtbTextUpdate(false);
            Launcher.progressMessage = "Displaying digrams...";
            this.textController.getTextShell().getDigramsDialog().show();
        } else if (this.processName.equals(TEXT_LING_ANALYSIS)) {
            this.textController.linguisticAnalysisForNewText(this.textController.getTextShell().getTextPane(), this.textController.getTextShell());
            this.textController.reactivateOps();
            this.textController.updateTextPaneStats();
            this.textController.rtbTextUpdate(false);
            this.textController.modify();
            JTextPane textPane = this.textController.getTextShell().getTextPane();
            int caretPosition = textPane.getCaretPosition();
            UnitSelectionListener selectionListener = this.textController.getTextShell().getUnitSelectionListener();
            textPane.removeCaretListener(selectionListener);
            textPane.setCaretPosition(caretPosition);
            textPane.getCaret().setVisible(true);
            textPane.addCaretListener(selectionListener);
        } else if (this.processName.equals(TEXT_LOCATE)) {
            this.textController.reactivateOps();
            Launcher.progressMessage = "Displaying concordance...";
            this.textController.getConcordanceController().refreshConcordance();
        } else if (this.processName.equals(DIC_COMPILE)) {
            this.dictionaryController.reactivateOps();
        } else if (this.processName.equals(DIC_INFLECT)) {
            this.dictionaryController.reactivateOps();
        }
        this.isBusy = false;
        this.cancellationPending = false;
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public boolean isCancellationPending() {
        return this.cancellationPending;
    }

    public void setCancellationPending(boolean cancellationPending) {
        this.cancellationPending = cancellationPending;
    }
}

