/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.actions.documents;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.tree.TreeNode;
import net.nooj4nlp.controller.DictionaryDialog.DictionaryDialogController;
import net.nooj4nlp.controller.DictionaryEditorShell.DictionaryEditorShellController;
import net.nooj4nlp.controller.FlexDescEditorShell.FlexDescEditorShellController;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.controller.PropDefEditorShell.PropDefEditorShellController;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.dialogs.DictionaryDialog;
import net.nooj4nlp.gui.dialogs.FindReplaceDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.DictionaryEditorShell;
import net.nooj4nlp.gui.shells.FlexDescEditorShell;
import net.nooj4nlp.gui.shells.GrammarEditorShell;
import net.nooj4nlp.gui.shells.PropDefEditorShell;
import net.nooj4nlp.gui.shells.TextEditorShell;
import org.apache.commons.io.FilenameUtils;

public class FindReplaceEvents {
    private int indexToText = -1;
    private int iMatchCollection = 0;
    private int labDicoContext;
    private int graphNumber;
    private int nodeNumber;
    private int position;
    private int length;
    private Matcher matchCollection = null;
    private Pattern rexp;
    private String buffer = "";
    private int highlightRemainder = 0;
    private JInternalFrame activeFrame;
    private JTextArea rtBox = null;
    private JTextPane rtb;
    private DefaultHighlighter.DefaultHighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
    private JComboBox findComboBox;
    private JComboBox replaceComboBox;
    private JRadioButton rbExact;
    private JButton buttonNext;
    private JButton buttonReplace;

    public FindReplaceEvents(FindReplaceDialog dialog) {
        this.rtb = dialog.getRtb();
        this.activeFrame = dialog.getActiveFrame();
        this.findComboBox = dialog.getComboFindPattern();
        this.replaceComboBox = dialog.getComboReplacePattern();
        this.findComboBox.setFont(Launcher.preferences.DFont);
        this.replaceComboBox.setFont(Launcher.preferences.DFont);
        this.rbExact = dialog.getRdbtnExactPattern();
        this.buttonNext = dialog.getBtnNext();
        this.buttonReplace = dialog.getBtnReplaceThenNext();
        this.labDicoContext = dialog.getLabDicoContext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void find() {
        this.highlightRemainder = 0;
        String cls = this.activeFrame.getClass().getSimpleName();
        boolean grammarContextCall = cls.equals("GrammarEditorShell");
        if ((this.rtb == null || this.rtb.getStyledDocument().getLength() == 0) && this.buffer.equals("") && !grammarContextCall) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "No text to work on!", "NooJ Error!", 0);
            return;
        }
        String pattern = this.findComboBox.getSelectedItem().toString();
        if (pattern.length() == 0) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Invalid empty pattern!", "NooJ: no pattern to look for", 0);
            return;
        }
        if (grammarContextCall) {
            boolean found;
            GrammarEditorShell grammarShell = (GrammarEditorShell)this.activeFrame;
            GrammarEditorShellController grammarController = grammarShell.getController();
            this.graphNumber = grammarController.current;
            RefObject<Integer> graphNumberRef = new RefObject<Integer>(this.graphNumber);
            RefObject<Integer> nodeNumberRef = new RefObject<Integer>(this.nodeNumber);
            RefObject<Integer> positionRef = new RefObject<Integer>(this.position);
            RefObject<Integer> lengthRef = new RefObject<Integer>(this.length);
            if (this.rbExact.isSelected()) {
                this.rexp = null;
                found = grammarController.findPattern(pattern, -1, graphNumberRef, nodeNumberRef, positionRef, lengthRef);
            } else {
                try {
                    this.rexp = Pattern.compile(pattern, 8);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ: PERL pattern is invalid!", 0);
                    return;
                }
                found = grammarController.findPattern(this.rexp, -1, graphNumberRef, nodeNumberRef, positionRef, lengthRef);
            }
            this.graphNumber = (Integer)graphNumberRef.argvalue;
            this.nodeNumber = (Integer)nodeNumberRef.argvalue;
            this.position = (Integer)positionRef.argvalue;
            this.length = (Integer)lengthRef.argvalue;
            if (!found) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Pattern not found!", "NooJ", 1);
                return;
            }
            grammarController.current = this.graphNumber;
            grammarController.grf = grammarController.grammar.graphs.get(this.graphNumber);
            int i = 0;
            while (i < grammarController.grf.selected.size()) {
                grammarController.grf.selected.set(i, false);
                ++i;
            }
            grammarController.editor.paintImmediately(grammarController.editor.getBounds());
            grammarController.UpdateGraphStructureFromTop((TreeNode)grammarController.formGramStruct.tvGraphs.getModel().getRoot());
            grammarController.displayRtbox(this.nodeNumber);
            this.rtBox = grammarShell.getRtBox();
            try {
                this.rtBox.getHighlighter().removeAllHighlights();
                this.rtBox.getHighlighter().addHighlight(this.position, this.position + this.length, this.highlightPainter);
                this.rtBox.setCaretPosition(this.position);
            }
            catch (BadLocationException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ Error!", 1);
                return;
            }
            this.buttonNext.setEnabled(true);
            this.buttonReplace.setEnabled(true);
            return;
        }
        try {
            CursorChangeEffect.setCustomCursor(3);
            int start = 0;
            if (cls.equals("DictionaryEditorShell") || this.labDicoContext > 0) {
                start = DictionaryEditorShellController.sizeOfHeader();
            }
            if (this.rbExact.isSelected()) {
                this.indexToText = this.rtb.getText().indexOf(pattern, start);
                if (this.indexToText == -1) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Exact pattern not found!", "NooJ", 1);
                    return;
                }
                try {
                    this.rtb.getHighlighter().removeAllHighlights();
                    this.rtb.getHighlighter().addHighlight(this.indexToText, this.indexToText + pattern.length(), this.highlightPainter);
                    this.rtb.setCaretPosition(this.indexToText);
                }
                catch (BadLocationException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ Error!", 1);
                    CursorChangeEffect.setCustomCursor(0);
                    return;
                }
            }
            try {
                this.rexp = Pattern.compile(pattern, 8);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ: PERL pattern is invalid!", 0);
                CursorChangeEffect.setCustomCursor(0);
                return;
            }
            this.matchCollection = this.rexp.matcher(this.rtb.getText());
            this.matchCollection.region(start, this.rtb.getText().length());
            if (!this.matchCollection.find()) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ: PERL pattern not found!", "NooJ", 1);
                return;
            }
            this.iMatchCollection = 0;
            try {
                this.rtb.getHighlighter().removeAllHighlights();
                this.rtb.getHighlighter().addHighlight(this.matchCollection.start(), this.matchCollection.end(), this.highlightPainter);
                this.rtb.setCaretPosition(this.matchCollection.start());
            }
            catch (BadLocationException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ Error!", 1);
                CursorChangeEffect.setCustomCursor(0);
                return;
            }
            this.buttonNext.setEnabled(true);
            this.buttonReplace.setEnabled(true);
            return;
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void next() {
        String pattern = this.findComboBox.getSelectedItem().toString();
        if (pattern.length() == 0) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Invalid pattern!", "NooJ: no pattern to look for", 0);
            return;
        }
        String cls = this.activeFrame.getClass().getSimpleName();
        boolean grammarContextCall = cls.equals("GrammarEditorShell");
        if (grammarContextCall) {
            GrammarEditorShellController grammarController = ((GrammarEditorShell)this.activeFrame).getController();
            this.graphNumber = grammarController.current;
            RefObject<Integer> graphNumberRef = new RefObject<Integer>(this.graphNumber);
            RefObject<Integer> nodeNumberRef = new RefObject<Integer>(this.nodeNumber);
            RefObject<Integer> positionRef = new RefObject<Integer>(this.position);
            RefObject<Integer> lengthRef = new RefObject<Integer>(this.length);
            boolean found = this.rexp == null ? grammarController.findNextPattern(pattern, -1, graphNumberRef, nodeNumberRef, positionRef, lengthRef) : grammarController.findNextPattern(this.rexp, -1, graphNumberRef, nodeNumberRef, positionRef, lengthRef);
            this.graphNumber = (Integer)graphNumberRef.argvalue;
            this.nodeNumber = (Integer)nodeNumberRef.argvalue;
            this.position = (Integer)positionRef.argvalue;
            this.length = (Integer)lengthRef.argvalue;
            if (!found) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Pattern not found!", "NooJ", 1);
                return;
            }
            grammarController.current = this.graphNumber;
            grammarController.grf = grammarController.grammar.graphs.get(this.graphNumber);
            int i = 0;
            while (i < grammarController.grf.selected.size()) {
                grammarController.grf.selected.set(i, false);
                ++i;
            }
            grammarController.editor.paintImmediately(grammarController.editor.getBounds());
            grammarController.UpdateGraphStructureFromTop((TreeNode)grammarController.formGramStruct.tvGraphs.getModel().getRoot());
            grammarController.displayRtbox(this.nodeNumber);
            grammarController.editor.rtBox.select(this.position, this.position + this.length);
            this.buttonNext.setEnabled(true);
            this.buttonReplace.setEnabled(true);
            return;
        }
        try {
            CursorChangeEffect.setCustomCursor(3);
            int start = this.rtb.getHighlighter().getHighlights()[0].getEndOffset();
            if (this.rbExact.isSelected()) {
                this.indexToText = this.rtb.getText().indexOf(pattern, start);
                if (this.indexToText == -1) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "No more match!", "NooJ", 1);
                    this.buttonNext.setEnabled(false);
                    this.buttonReplace.setEnabled(false);
                    return;
                }
                try {
                    this.rtb.getHighlighter().removeAllHighlights();
                    this.rtb.getHighlighter().addHighlight(this.indexToText, this.indexToText + pattern.length(), this.highlightPainter);
                    this.rtb.setCaretPosition(this.indexToText);
                    return;
                }
                catch (BadLocationException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ Error!", 1);
                    CursorChangeEffect.setCustomCursor(0);
                    return;
                }
            }
            ++this.iMatchCollection;
            try {
                this.rexp = Pattern.compile(pattern, 8);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ: PERL pattern is invalid!", 0);
                CursorChangeEffect.setCustomCursor(0);
                return;
            }
            if (!this.matchCollection.find()) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "No more match!", "NooJ", 1);
                this.buttonNext.setEnabled(false);
                this.buttonReplace.setEnabled(false);
                return;
            }
            try {
                this.rtb.getHighlighter().removeAllHighlights();
                this.rtb.getHighlighter().addHighlight(this.matchCollection.start() - this.highlightRemainder, this.matchCollection.end() - this.highlightRemainder, this.highlightPainter);
                this.rtb.setCaretPosition(this.matchCollection.start() - this.highlightRemainder);
                return;
            }
            catch (BadLocationException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ Error!", 1);
                CursorChangeEffect.setCustomCursor(0);
                return;
            }
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }

    public void replace() {
        block39: {
            String cls = this.activeFrame.getClass().getSimpleName();
            boolean grammarContextCall = cls.equals("GrammarEditorShell");
            String replacementText = this.replaceComboBox.getSelectedItem().toString();
            String pattern = this.findComboBox.getSelectedItem().toString();
            int patternLength = pattern.length();
            int replacementLength = replacementText.length();
            if (Launcher.preferences.multiplebackups) {
                PropDefEditorShellController propDefController;
                if (cls.equals("DictionaryEditorShell")) {
                    DictionaryEditorShellController dictionaryController = ((DictionaryEditorShell)this.activeFrame).getController();
                    if (dictionaryController.getFullName() != null && dictionaryController.isModified()) {
                        dictionaryController.save();
                    }
                } else if (cls.equals("FlexDescEditorShell")) {
                    FlexDescEditorShellController flexDescController = ((FlexDescEditorShell)this.activeFrame).getController();
                    if (flexDescController.getFullName() != null && flexDescController.isModified()) {
                        flexDescController.save();
                    }
                } else if (cls.equals("PropDefEditorShell") && (propDefController = ((PropDefEditorShell)this.activeFrame).getController()).getFullName() != null && propDefController.isModified()) {
                    propDefController.save();
                }
            }
            if (grammarContextCall) {
                GrammarEditorShell grammarShell = (GrammarEditorShell)this.activeFrame;
                GrammarEditorShellController grammarController = grammarShell.getController();
                JTextArea rtBox = grammarShell.getRtBox();
                rtBox.replaceRange(replacementText, this.position, this.position + this.length);
                Graph grf = grammarController.grammar.graphs.get(this.graphNumber);
                grf.label.set(this.nodeNumber, rtBox.getText());
                grammarController.hideRtbox();
                this.next();
                return;
            }
            Highlighter.Highlight[] highlightList = this.rtb.getHighlighter().getHighlights();
            if (this.rtb == null || this.rtb.getText().length() == 0 || highlightList.length == 0) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot perform replacement!", "NooJ: No text to work on!", 0);
                this.buttonNext.setEnabled(false);
                this.buttonReplace.setEnabled(false);
                return;
            }
            String text = this.rtb.getText();
            try {
                CursorChangeEffect.setCustomCursor(3);
                TextEditorShell textShell = null;
                if (this.rbExact.isSelected()) {
                    if (pattern.equals("")) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Enter an exact pattern to look for!", "NooJ", 2);
                        return;
                    }
                    Highlighter.Highlight highlighter = this.rtb.getHighlighter().getHighlights()[0];
                    int start = highlighter.getEndOffset();
                    this.indexToText = this.rtb.getText().indexOf(pattern, start);
                    int replaceStart = highlighter.getStartOffset();
                    try {
                        text = this.replaceFirstFrom(text, replaceStart, pattern, replacementText);
                    }
                    catch (BadLocationException e1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "NooJ Error!", 0);
                        CursorChangeEffect.setCustomCursor(0);
                        return;
                    }
                    if (cls.equals("TextEditorShell")) {
                        textShell = (TextEditorShell)this.activeFrame;
                        this.rtb.removeCaretListener(textShell.getUnitSelectionListener());
                    }
                    this.rtb.setText(text);
                    if (this.indexToText == -1) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot perform replacement!", "NooJ: No more match to work with!", 1);
                        if (textShell != null) {
                            this.rtb.addCaretListener(textShell.getUnitSelectionListener());
                        }
                        this.buttonNext.setEnabled(false);
                        this.buttonReplace.setEnabled(false);
                        return;
                    }
                    this.indexToText -= patternLength - replacementLength;
                    try {
                        if (textShell != null) {
                            this.rtb.addCaretListener(textShell.getUnitSelectionListener());
                            textShell.getTextController().textHasJustBeenEdited();
                        }
                        this.rtb.getHighlighter().removeAllHighlights();
                        this.rtb.getHighlighter().addHighlight(this.indexToText, this.indexToText + pattern.length(), this.highlightPainter);
                        this.rtb.setCaretPosition(this.indexToText);
                        break block39;
                    }
                    catch (BadLocationException e) {
                        JOptionPane.showMessageDialog(null, e.getMessage(), "NooJ Error!", 0);
                        CursorChangeEffect.setCustomCursor(0);
                        return;
                    }
                }
                if (cls.equals("TextEditorShell")) {
                    textShell = (TextEditorShell)this.activeFrame;
                    this.rtb.removeCaretListener(textShell.getUnitSelectionListener());
                }
                int start = 0;
                if (cls.equals("DictionaryEditorShell") || this.labDicoContext > 0) {
                    start = DictionaryEditorShellController.sizeOfHeader();
                }
                this.matchCollection = this.rexp.matcher(this.rtb.getText());
                this.matchCollection.region(start, this.rtb.getText().length());
                Matcher helpMatcher = this.rexp.matcher(replacementText);
                int patternInReplaceCounter = -1;
                while (helpMatcher.find()) {
                    ++patternInReplaceCounter;
                }
                int helpVar = 0;
                StringBuffer buffer = new StringBuffer();
                int startOfNewRegion = 0;
                int endOfNewRegion = 0;
                while (this.matchCollection.find()) {
                    if (helpVar == this.iMatchCollection) {
                        int index = this.matchCollection.end();
                        this.matchCollection.appendReplacement(buffer, replacementText);
                        this.iMatchCollection += patternInReplaceCounter;
                        this.highlightRemainder = this.matchCollection.group().length() - replacementLength;
                        startOfNewRegion = index;
                        endOfNewRegion = text.length();
                        break;
                    }
                    ++helpVar;
                }
                this.matchCollection.appendTail(buffer);
                this.matchCollection.region(startOfNewRegion, endOfNewRegion);
                this.rtb.setText(buffer.toString());
                if (textShell != null) {
                    this.rtb.addCaretListener(textShell.getUnitSelectionListener());
                }
                if (!this.matchCollection.find()) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot perform replacement!", "NooJ: No more match to work with!", 1);
                    this.buttonNext.setEnabled(false);
                    this.buttonReplace.setEnabled(false);
                    return;
                }
                try {
                    this.rtb.getHighlighter().removeAllHighlights();
                    this.rtb.getHighlighter().addHighlight(this.matchCollection.start() - this.highlightRemainder, this.matchCollection.end() - this.highlightRemainder, this.highlightPainter);
                    if (textShell != null) {
                        textShell.getTextController().textHasJustBeenEdited();
                    }
                    this.rtb.setCaretPosition(this.matchCollection.start() - this.highlightRemainder);
                }
                catch (BadLocationException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ Error!", 1);
                    CursorChangeEffect.setCustomCursor(0);
                    return;
                }
                ++this.iMatchCollection;
            }
            finally {
                CursorChangeEffect.setCustomCursor(0);
            }
        }
    }

    public void replaceAll() {
        String cls = this.activeFrame.getClass().getSimpleName();
        boolean grammarContext = cls.equals("GrammarEditorShell");
        if (!grammarContext && (this.rtb == null || this.rtb.getText().length() == 0) && this.buffer.equals("")) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "No text to work on!", "NooJ Error!", 0);
            return;
        }
        if (Launcher.preferences.multiplebackups) {
            PropDefEditorShellController propDefController;
            if (cls.equals("DictionaryEditorShell")) {
                DictionaryEditorShellController dictionaryController = ((DictionaryEditorShell)this.activeFrame).getController();
                if (dictionaryController.getFullName() != null && dictionaryController.isModified()) {
                    dictionaryController.save();
                }
            } else if (cls.equals("FlexDescEditorShell")) {
                FlexDescEditorShellController flexDescController = ((FlexDescEditorShell)this.activeFrame).getController();
                if (flexDescController.getFullName() != null && flexDescController.isModified()) {
                    flexDescController.save();
                }
            } else if (cls.equals("PropDefEditorShell") && (propDefController = ((PropDefEditorShell)this.activeFrame).getController()).getFullName() != null && propDefController.isModified()) {
                propDefController.save();
            }
        }
        String replacementText = this.replaceComboBox.getSelectedItem().toString();
        String pattern = this.findComboBox.getSelectedItem().toString();
        if (pattern.equals("")) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Enter an exact pattern to look for!", "NooJ", 2);
            return;
        }
        if (cls.equals("GrammarEditorShell")) {
            GrammarEditorShell grammarShell = (GrammarEditorShell)this.activeFrame;
            GrammarEditorShellController grammarController = grammarShell.getController();
            int count = 0;
            if (this.rbExact.isSelected()) {
                this.rexp = null;
                count = grammarController.replaceAll(pattern, replacementText);
            } else {
                try {
                    this.rexp = Pattern.compile(pattern, 8);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ: PERL pattern is invalid!", 0);
                    return;
                }
                count = grammarController.replaceAllPerl(this.rexp, replacementText);
            }
            if (this.rtBox != null) {
                grammarController.hideRtbox();
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), String.valueOf(count) + " replacements.", "NooJ", 1);
            return;
        }
        try {
            CursorChangeEffect.setCustomCursor(3);
            TextEditorShell textShell = null;
            String text = "";
            String buffer2 = "";
            int start = 0;
            if (this.rtb != null) {
                text = this.rtb.getText();
            } else if (!this.buffer.equals("")) {
                text = this.buffer;
            }
            start = cls.equals("DictionaryEditorShell") || this.labDicoContext > 0 ? DictionaryEditorShellController.sizeOfHeader() : 0;
            int cpt = 0;
            if (this.rbExact.isSelected()) {
                if (cls.equals("TextEditorShell")) {
                    textShell = (TextEditorShell)this.activeFrame;
                    this.rtb.removeCaretListener(textShell.getUnitSelectionListener());
                }
                if ((start = text.indexOf(pattern, start)) < 0) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Exact pattern not found!", "NooJ", 2);
                    return;
                }
                int currentPosition = 0;
                StringBuilder tmp = new StringBuilder();
                while (start >= 0) {
                    tmp.append(text.substring(currentPosition, start));
                    tmp.append(replacementText);
                    currentPosition = start + pattern.length();
                    start = text.indexOf(pattern, currentPosition);
                    ++cpt;
                }
                tmp.append(text.substring(currentPosition));
                if (this.labDicoContext > 0) {
                    buffer2 = tmp.toString();
                } else if (this.rtb != null) {
                    this.rtb.setText(tmp.toString());
                }
                if (textShell != null) {
                    this.rtb.addCaretListener(textShell.getUnitSelectionListener());
                }
            } else {
                Pattern rexp2;
                if (cls.equals("TextEditorShell")) {
                    textShell = (TextEditorShell)this.activeFrame;
                    this.rtb.removeCaretListener(textShell.getUnitSelectionListener());
                }
                try {
                    rexp2 = Pattern.compile(pattern, 8);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ: PERL pattern is invalid!", 0);
                    CursorChangeEffect.setCustomCursor(0);
                    return;
                }
                cpt = 0;
                Matcher helpMatcher = rexp2.matcher(this.rtb.getText());
                while (helpMatcher.find()) {
                    if (helpMatcher.end() < start) continue;
                    ++cpt;
                }
                if (cpt == 0) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "PERL pattern not found", "NooJ", 1);
                    return;
                }
                StringBuilder tmp = new StringBuilder();
                int currentPosition = 0;
                Matcher matchCollection2 = rexp2.matcher(this.rtb.getText());
                matchCollection2.region(start, this.rtb.getText().length());
                while (matchCollection2.find()) {
                    if (matchCollection2.end() < start) continue;
                    tmp.append(this.rtb.getText().substring(currentPosition, matchCollection2.start()));
                    tmp.append(replacementText);
                    currentPosition = matchCollection2.start() + matchCollection2.group().length();
                }
                tmp.append(this.rtb.getText().substring(currentPosition));
                matchCollection2.replaceAll(replacementText);
                if (this.labDicoContext > 0) {
                    buffer2 = tmp.toString();
                } else if (this.rtb != null) {
                    this.rtb.setText(tmp.toString());
                }
                if (textShell != null) {
                    this.rtb.addCaretListener(textShell.getUnitSelectionListener());
                }
            }
            if (cls.equals("TextEditorShell") && !(textShell = (TextEditorShell)this.activeFrame).getTextPane().isEditable()) {
                textShell.getTextController().textHasJustBeenEdited();
            }
            if (this.labDicoContext > 0) {
                PrintWriter pw;
                DictionaryDialog dictionaryDialog = (DictionaryDialog)this.activeFrame;
                DictionaryDialogController dicDialogController = dictionaryDialog.getController();
                String filePath = dicDialogController.getTxtDictionaryName().getText();
                File dicFile = new File(filePath);
                String fileName = "";
                String extension = "";
                if (dicFile != null) {
                    String fileNameWithExtension = dicFile.getName();
                    fileName = FilenameUtils.removeExtension(fileNameWithExtension);
                    extension = FilenameUtils.getExtension(fileNameWithExtension);
                }
                String parentPath = dicFile.getParent();
                String fullPath = String.valueOf(parentPath) + System.getProperty("file.separator") + fileName + "-r" + "." + extension;
                try {
                    pw = new PrintWriter(fullPath);
                }
                catch (FileNotFoundException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Cannot fill vocabulary!", 0);
                    CursorChangeEffect.setCustomCursor(0);
                    return;
                }
                pw.write(buffer2);
                pw.close();
                this.buffer = "";
                int value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), "Do you want to work with new created dictionary " + fullPath + " (" + cpt + " replacement" + (cpt > 1 ? "s" : "") + ")?", "NooJ", 0, 2, null, null, null);
                if (value == 1 || value == -1) {
                    return;
                }
                dicDialogController.getTxtDictionaryName().setText(fullPath);
                if (dicDialogController.loadLines(0, 500)) {
                    dicDialogController.getTitledBorder().setTitle("Display " + new File(fullPath).getName());
                } else {
                    dicDialogController.getTitledBorder().setTitle("Display beginning of " + new File(fullPath).getName());
                }
                dicDialogController.getFindReplaceDialog().dispose();
            } else {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), String.valueOf(cpt) + " replacement" + (cpt > 1 ? "s" : ""), "NooJ", 1);
            }
            this.buttonNext.setEnabled(true);
            this.buttonReplace.setEnabled(true);
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extract() {
        block43: {
            block41: {
                block42: {
                    if ((this.rtb == null || this.rtb.getText().length() == 0) && this.buffer.equals("")) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "No text to work on!", "NooJ", 0);
                        return;
                    }
                    CursorChangeEffect.setCustomCursor(3);
                    pattern = this.findComboBox.getSelectedItem().toString();
                    if (pattern.equals("")) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Enter an exact pattern to look for!", "NooJ", 2);
                    }
                    ** GOTO lbl-1000
                    CursorChangeEffect.setCustomCursor(0);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        cpt = 0;
                        text = "";
                        if (this.rtb != null) {
                            text = this.rtb.getText();
                        } else if (!this.buffer.equals("")) {
                            text = this.buffer;
                        }
                        tmp = new StringBuilder();
                        start = DictionaryEditorShellController.sizeOfHeader();
                        if (!this.rbExact.isSelected()) break block41;
                        indexToText = text.indexOf(pattern, start);
                        if (indexToText >= 0) break block42;
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Exact pattern not found!", "NooJ", 1);
                    }
                    CursorChangeEffect.setCustomCursor(0);
                    return;
                }
                block14: while (indexToText >= 0) {
                    beginOfLine = indexToText;
                    while (true) {
                        if (beginOfLine <= 0 || text.charAt(beginOfLine) == '\n') {
                            if (text.charAt(beginOfLine) == '\n') {
                                ++beginOfLine;
                            }
                            break;
                        }
                        --beginOfLine;
                    }
                    endOfLine = indexToText;
                    while (true) {
                        if (endOfLine >= text.length() || text.charAt(endOfLine) == '\n') {
                            if (endOfLine < text.length()) {
                                ++endOfLine;
                            }
                            if (beginOfLine >= start) {
                                tmp.append(text.substring(beginOfLine, endOfLine));
                            }
                            start = indexToText + pattern.length();
                            indexToText = text.indexOf(pattern, start);
                            ++cpt;
                            continue block14;
                        }
                        ++endOfLine;
                    }
                }
                break block43;
            }
            try {
                rexp = Pattern.compile(pattern, 8);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ: PERL pattern is invalid!", 0);
                CursorChangeEffect.setCustomCursor(0);
                return;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 347->423)] { 
lbl65:
            // 1 sources

            this.matchCollection = rexp.matcher(text);
            this.matchCollection.region(DictionaryEditorShellController.sizeOfHeader(), text.length());
            helpMatcher = rexp.matcher(text);
            helpMatcher.region(start, text.length());
            while (helpMatcher.find()) {
                ++cpt;
            }
            if (cpt == 0) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ: PERL pattern not found!", "NooJ", 0);
                return;
            }
            beginOfLine = -1;
            endOfLine = -1;
            while (this.matchCollection.find()) {
                beginOfLine = this.matchCollection.start();
                while (beginOfLine > 0 && text.charAt(beginOfLine) != '\n') {
                    --beginOfLine;
                }
                if (text.charAt(beginOfLine) == '\n') {
                    ++beginOfLine;
                }
                if (beginOfLine < endOfLine) continue;
                endOfLine = this.matchCollection.start();
                while (endOfLine < text.length() && text.charAt(endOfLine) != '\n') {
                    ++endOfLine;
                }
                if (endOfLine < text.length()) {
                    ++endOfLine;
                }
                tmp.append(text.substring(beginOfLine, endOfLine));
            }
        }
        if (cpt == 0) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "No line has been extracted!", "NooJ", 2);
            return;
        }
        cls = this.activeFrame.getClass().getSimpleName();
        if (cls.equals("DictionaryEditorShell")) {
            dicShell = new DictionaryEditorShell();
            dicController = dicShell.getController();
            dicController.initLoad(((DictionaryEditorShell)this.activeFrame).getController().getLan().isoName);
            newRtbPaneText = String.valueOf(dicController.getTextPane().getText()) + "#extract \"" + pattern + "\"\n" + tmp.toString();
            dicController.getTextPane().setText(newRtbPaneText);
            dicController.getLblnTus().setText("Dictionary contains " + DictionaryDialogController.count(dicController.getTextPane()) + " entries.");
            Launcher.getDesktopPane().add(dicShell);
            dicShell.setVisible(true);
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), String.valueOf(cpt) + " match" + (cpt > 1 ? "es have" : "has") + " been extracted.", "NooJ", 1);
            return;
        }
        if (cls.equals("DictionaryDialog") == false) return;
        dicDialog = (DictionaryDialog)this.activeFrame;
        dicController = dicDialog.getController();
        filePath = dicController.getTxtDictionaryName().getText();
        dicFile = new File(filePath);
        fileName = "";
        extension = "";
        if (dicFile != null) {
            fileNameWithExtension = dicFile.getName();
            fileName = FilenameUtils.removeExtension(fileNameWithExtension);
            extension = FilenameUtils.getExtension(fileNameWithExtension);
        }
        parentPath = dicFile.getParent();
        fullPath = String.valueOf(parentPath) + System.getProperty("file.separator") + fileName + "-e" + "." + extension;
        isoName = "";
        if (this.rtb != null) {
            isoName = DictionaryEditorShellController.getLanguage();
        }
        try {
            pw = new PrintWriter(fullPath);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Cannot fill vocabulary!", 0);
            CursorChangeEffect.setCustomCursor(0);
            return;
        }
        pw.write(DictionaryEditorShellController.buildHeader(isoName));
        pw.write("# extract \"" + pattern + "\"\n");
        pw.write(tmp.toString());
        pw.close();
        value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), "Do you want to work with new created dictionary " + fullPath + " (" + cpt + " match" + (cpt > 1 ? "es" : "") + ")?", "NooJ", 0, 2, null, null, null);
        if (value == 1) return;
        if (value == -1) {
            return;
        }
        dicController.getTxtDictionaryName().setText(fullPath);
        if (dicController.loadLines(0, 500)) {
            dicController.getTitledBorder().setTitle("Display " + new File(fullPath).getName());
        } else {
            dicController.getTitledBorder().setTitle("Display beginning of " + new File(fullPath).getName());
        }
        dicController.getFindReplaceDialog().dispose();
        return;
lbl151:
        // 1 sources

        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }

    public void filter() {
        block44: {
            String cls = this.activeFrame.getClass().getSimpleName();
            if ((this.rtb == null || this.rtb.getText().length() == 0) && this.buffer.equals("")) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "No text to work on!", "NooJ Error!", 0);
                return;
            }
            try {
                PrintWriter pw;
                CursorChangeEffect.setCustomCursor(3);
                String pattern = this.findComboBox.getSelectedItem().toString();
                if (pattern.equals("")) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Enter an exact pattern to look for!", "NooJ", 2);
                    return;
                }
                int cpt = 0;
                String text = "";
                if (cls.equals("DictionaryEditorShell")) {
                    text = this.rtb.getText();
                } else if (cls.equals("DictionaryDialog")) {
                    text = this.buffer;
                }
                StringBuilder tmp = new StringBuilder();
                int start = 0;
                if (cls.equals("DictionaryEditorShell") || this.labDicoContext > 0) {
                    start = DictionaryEditorShellController.sizeOfHeader();
                }
                if (this.rbExact.isSelected()) {
                    int indexToText = text.indexOf(pattern, start);
                    if (indexToText < 0) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Exact pattern not found!", "NooJ", 1);
                        return;
                    }
                    int currentPosition = 0;
                    while (indexToText >= 0) {
                        int beginOfLine = indexToText;
                        while (beginOfLine > 0 && text.charAt(beginOfLine) != '\n') {
                            --beginOfLine;
                        }
                        if (text.charAt(beginOfLine) == '\n') {
                            ++beginOfLine;
                        }
                        int endOfLine = indexToText;
                        while (endOfLine < text.length() && text.charAt(endOfLine) != '\n') {
                            ++endOfLine;
                        }
                        if (endOfLine < text.length()) {
                            ++endOfLine;
                        }
                        if (currentPosition < beginOfLine) {
                            tmp.append(text.substring(currentPosition, beginOfLine));
                        }
                        currentPosition = endOfLine;
                        start = indexToText + pattern.length();
                        indexToText = text.indexOf(pattern, start);
                        ++cpt;
                    }
                    tmp.append(text.substring(currentPosition));
                } else {
                    Pattern rexp2;
                    try {
                        rexp2 = Pattern.compile(pattern, 8);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ: PERL pattern is invalid!", 0);
                        CursorChangeEffect.setCustomCursor(0);
                        return;
                    }
                    this.matchCollection = rexp2.matcher(text);
                    this.matchCollection.region(start, text.length());
                    Matcher helpMatcher = rexp2.matcher(text);
                    helpMatcher.region(start, text.length());
                    while (helpMatcher.find()) {
                        ++cpt;
                    }
                    if (cpt == 0) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "PERL pattern not found", "NooJ", 1);
                        return;
                    }
                    int currentPosition = start;
                    while (this.matchCollection.find()) {
                        int beginOfLine = this.matchCollection.start();
                        while (beginOfLine > 0 && text.charAt(beginOfLine) != '\n') {
                            --beginOfLine;
                        }
                        if (text.charAt(beginOfLine) == '\n') {
                            ++beginOfLine;
                        }
                        int endOfLine = this.matchCollection.start();
                        while (endOfLine < text.length() && text.charAt(endOfLine) != '\n') {
                            ++endOfLine;
                        }
                        if (endOfLine < text.length()) {
                            ++endOfLine;
                        }
                        if (currentPosition < beginOfLine) {
                            tmp.append(text.substring(currentPosition, beginOfLine));
                        }
                        currentPosition = endOfLine;
                    }
                    tmp.append(text.substring(currentPosition));
                }
                if (cpt == 0) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "No line has been filtered out!", "NooJ", 1);
                    return;
                }
                if (cls.equals("DictionaryEditorShell")) {
                    DictionaryEditorShell dicShell = new DictionaryEditorShell();
                    DictionaryEditorShellController dicController = dicShell.getController();
                    dicController.initLoad(((DictionaryEditorShell)this.activeFrame).getController().getLan().isoName);
                    String newRtbPaneText = String.valueOf(dicController.getTextPane().getText()) + "# filter out \"" + pattern + "\"\n" + tmp.toString();
                    dicController.getTextPane().setText(newRtbPaneText);
                    dicController.getLblnTus().setText("Dictionary contains " + DictionaryDialogController.count(dicController.getTextPane()) + " entries.");
                    Launcher.getDesktopPane().add(dicShell);
                    dicShell.setVisible(true);
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), String.valueOf(cpt) + " match" + (cpt > 1 ? "es have" : "has") + " been filtered out.", "NooJ", 1);
                    break block44;
                }
                if (!cls.equals("DictionaryDialog")) break block44;
                DictionaryDialog dicDialog = (DictionaryDialog)this.activeFrame;
                DictionaryDialogController dicController = dicDialog.getController();
                String filePath = dicController.getTxtDictionaryName().getText();
                File dicFile = new File(filePath);
                String fileName = "";
                String extension = "";
                if (dicFile != null) {
                    String fileNameWithExtension = dicFile.getName();
                    fileName = FilenameUtils.removeExtension(fileNameWithExtension);
                    extension = FilenameUtils.getExtension(fileNameWithExtension);
                }
                String parentPath = dicFile.getParent();
                String fullPath = String.valueOf(parentPath) + System.getProperty("file.separator") + fileName + "-f" + "." + extension;
                String isoName = "";
                if (this.rtb != null) {
                    isoName = DictionaryEditorShellController.getLanguage();
                }
                try {
                    pw = new PrintWriter(fullPath);
                }
                catch (FileNotFoundException e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Cannot fill vocabulary!", 0);
                    CursorChangeEffect.setCustomCursor(0);
                    return;
                }
                pw.write(DictionaryEditorShellController.buildHeader(isoName));
                pw.write("# filter out \"" + pattern + "\"\n");
                pw.write(tmp.toString());
                pw.close();
                int value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), "Do you want to work with new created dictionary " + fullPath + " (" + cpt + " match" + (cpt > 1 ? "es" : "") + ")?", "NooJ", 0, 2, null, null, null);
                if (value == 1 || value == -1) {
                    return;
                }
                dicController.getTxtDictionaryName().setText(fullPath);
                if (dicController.loadLines(0, 500)) {
                    dicController.getTitledBorder().setTitle("Display " + new File(fullPath).getName());
                } else {
                    dicController.getTitledBorder().setTitle("Display beginning of " + new File(fullPath).getName());
                }
                dicController.getFindReplaceDialog().dispose();
            }
            finally {
                CursorChangeEffect.setCustomCursor(0);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void count() {
        block32: {
            block31: {
                block29: {
                    block30: {
                        cls = this.activeFrame.getClass().getSimpleName();
                        if (this.rtb == null) {
                            return;
                        }
                        CursorChangeEffect.setCustomCursor(3);
                        text = this.rtb.getText();
                        if (text.equals("")) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ has no text to look in!", "NooJ", 0);
                        }
                        ** GOTO lbl-1000
                        CursorChangeEffect.setCustomCursor(0);
                        return;
lbl-1000:
                        // 1 sources

                        {
                            start = 0;
                            if (cls.equals("DictionaryEditorShell")) {
                                start = DictionaryEditorShellController.sizeOfHeader();
                            }
                            if (!(pattern = this.findComboBox.getSelectedItem().toString()).equals("")) ** GOTO lbl-1000
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Enter an exact pattern to look for!", "NooJ", 2);
                        }
                        CursorChangeEffect.setCustomCursor(0);
                        return;
lbl-1000:
                        // 1 sources

                        {
                            cpt = 0;
                            if (!this.rbExact.isSelected()) break block29;
                            indexToText = text.indexOf(pattern, start);
                            if (indexToText >= 0) break block30;
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Exact pattern not found!", "NooJ", 1);
                        }
                        CursorChangeEffect.setCustomCursor(0);
                        return;
                    }
                    block11: while (indexToText >= 0) {
                        beginOfLine = indexToText;
                        while (true) {
                            if (beginOfLine <= 0 || text.charAt(beginOfLine) == '\n') {
                                if (text.charAt(beginOfLine) == '\n') {
                                    ++beginOfLine;
                                }
                                break;
                            }
                            --beginOfLine;
                        }
                        endOfLine = indexToText;
                        while (true) {
                            if (endOfLine >= text.length() || text.charAt(endOfLine) == '\n') {
                                if (endOfLine < text.length()) {
                                    ++endOfLine;
                                }
                                start = indexToText + pattern.length();
                                indexToText = text.indexOf(pattern, start);
                                ++cpt;
                                continue block11;
                            }
                            ++endOfLine;
                        }
                    }
                    break block32;
                }
                try {
                    rexp2 = Pattern.compile(pattern, 8);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "NooJ: PERL pattern is invalid!", 0);
                    CursorChangeEffect.setCustomCursor(0);
                    return;
                }
                {
                    this.matchCollection = rexp2.matcher(text);
                    this.matchCollection.region(start, text.length());
                    helpMatcher = rexp2.matcher(text);
                    helpMatcher.region(start, text.length());
                    while (helpMatcher.find()) {
                        ++cpt;
                    }
                    if (cpt != 0) break block31;
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ: PERL pattern not found!", "NooJ", 0);
                }
                CursorChangeEffect.setCustomCursor(0);
                return;
            }
            block15: while (this.matchCollection.find()) {
                beginOfLine = this.matchCollection.start();
                while (true) {
                    if (beginOfLine <= 0 || text.charAt(beginOfLine) == '\n') {
                        if (text.charAt(beginOfLine) == '\n') {
                            ++beginOfLine;
                        }
                        break;
                    }
                    --beginOfLine;
                }
                endOfLine = this.matchCollection.start();
                while (true) {
                    if (endOfLine >= text.length() || text.charAt(endOfLine) == '\n') {
                        if (endOfLine >= text.length()) continue block15;
                        ++endOfLine;
                        continue block15;
                    }
                    ++endOfLine;
                }
            }
        }
        if (cpt == 0) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "No matching line!", "NooJ", 1);
            CursorChangeEffect.setCustomCursor(0);
            return;
        }
        ** try [egrp 7[TRYBLOCK] [7 : 507->565)] { 
lbl98:
        // 1 sources

        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), String.valueOf(cpt) + " match" + (cpt > 1 ? "es have" : " has") + " been found.", "NooJ", 1);
        return;
lbl100:
        // 1 sources

        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }

    public void replaceAllFrom() {
        String cls = this.activeFrame.getClass().getSimpleName();
        int cpt = 0;
        int cptRules = 0;
        int value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), "Replacement file must contain lines such as:\naaa,bbb\nccc,ddd\netc.", "NooJ", 0, 2, null, null, null);
        if (value == 1 || value == -1) {
            return;
        }
        JFileChooser jFileChooser = Launcher.getOpenSourceChooser();
        int result = jFileChooser.showOpenDialog(this.activeFrame);
        File selectedFile = jFileChooser.getSelectedFile();
        if (result == 0) {
            BufferedReader br = null;
            String patternFilePath = selectedFile.getAbsolutePath();
            File selectedFileFromPath = new File(patternFilePath);
            if (!selectedFile.exists()) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file " + patternFilePath, "NooJ Error!", 0);
                return;
            }
            try {
                br = new BufferedReader(new FileReader(selectedFileFromPath));
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Cannot fill vocabulary!", 0);
                return;
            }
            if (cls.equals("GrammarEditorShell")) {
                GrammarEditorShellController grammarController = ((GrammarEditorShell)this.activeFrame).getController();
                int count = 0;
                try {
                    String line = br.readLine();
                    while (line != null) {
                        String pattern;
                        int i = 0;
                        while (i < line.length() && line.charAt(i) != '#') {
                            ++i;
                        }
                        if (i < line.length()) {
                            line = line.substring(0, i);
                        }
                        if (!line.equals("") && (i = line.indexOf(44)) != -1 && !(pattern = line.substring(0, i)).equals("")) {
                            String replacementText = line.substring(i + 1);
                            count += grammarController.replaceAll(pattern, replacementText);
                        }
                        line = br.readLine();
                    }
                    br.close();
                    if (this.rtBox != null) {
                        grammarController.hideRtbox();
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), String.valueOf(count) + " replacements.", "NooJ", 1);
                    return;
                }
                catch (IOException e) {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException i) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                    return;
                }
            }
            TextEditorShell textShell = null;
            try {
                CursorChangeEffect.setCustomCursor(3);
                String text = this.rtb.getText();
                if (cls.equals("TextEditorShell")) {
                    textShell = (TextEditorShell)this.activeFrame;
                    textShell.getTextPane().removeCaretListener(textShell.getUnitSelectionListener());
                }
                try {
                    String line = br.readLine();
                    while (line != null) {
                        String pattern;
                        int i = 0;
                        while (i < line.length() && line.charAt(i) != '#') {
                            ++i;
                        }
                        if (i < line.length()) {
                            line = line.substring(0, i);
                        }
                        if (!line.equals("") && (i = line.indexOf(44)) != -1 && !(pattern = line.substring(0, i)).equals("")) {
                            String replacementText = line.substring(i + 1);
                            int start = 0;
                            if (cls.equals("DictionaryEditorShell")) {
                                String header = DictionaryEditorShellController.getHeader(text);
                                start = header.length();
                            }
                            ++cptRules;
                            if ((start = text.indexOf(pattern, start)) >= 0) {
                                int currentPosition = 0;
                                StringBuilder tmp = new StringBuilder();
                                while (start >= 0) {
                                    tmp.append(text.substring(currentPosition, start));
                                    tmp.append(replacementText);
                                    currentPosition = start + pattern.length();
                                    start = text.indexOf(pattern, currentPosition);
                                    ++cpt;
                                }
                                tmp.append(text.substring(currentPosition));
                                text = tmp.toString();
                            }
                        }
                        line = br.readLine();
                    }
                    br.close();
                    this.rtb.setText(text);
                    if (textShell != null) {
                        textShell.getTextPane().addCaretListener(textShell.getUnitSelectionListener());
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), String.valueOf(cptRules) + " rules; " + cpt + " replacement" + (cpt > 1 ? "s" : ""), "NooJ", 1);
                }
                catch (IOException e) {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                    CursorChangeEffect.setCustomCursor(0);
                    return;
                }
            }
            finally {
                CursorChangeEffect.setCustomCursor(0);
            }
        }
    }

    private String replaceFirstFrom(String text, int startingIndex, String pattern, String replacement) throws BadLocationException {
        if (startingIndex > text.length()) {
            throw new BadLocationException("Invalid index!", text.length());
        }
        String prefix = text.substring(0, startingIndex);
        String rest = text.substring(startingIndex);
        rest = rest.replaceFirst(pattern, replacement);
        return String.valueOf(prefix) + rest;
    }

    public void setBuffer(String buffer) {
        this.buffer = buffer;
    }
}

