/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.actions.grammar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.gui.dialogs.OpenGrammarDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.GrammarEditorShell;
import org.apache.commons.io.FilenameUtils;

public class ImportGrammarActionListener
implements ActionListener {
    private GrammarEditorShell editor;
    private GrammarEditorShellController controller;
    private boolean closedWithXButton = true;

    public ImportGrammarActionListener(GrammarEditorShell shell) {
        this.editor = shell;
        this.controller = this.editor.getController();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        JFileChooser openGraphChooser = new JFileChooser();
        openGraphChooser.setDialogTitle("Open");
        openGraphChooser.setAcceptAllFileFilterUsed(false);
        openGraphChooser.setMultiSelectionEnabled(true);
        String currentDirToBeSetPath = FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(this.controller.lan.isoName, "Syntactic Analysis"));
        openGraphChooser.setCurrentDirectory(new File(currentDirToBeSetPath));
        String extension = "";
        boolean knownType = true;
        if (this.controller.grammar.gramType == GramType.SYNTAX) {
            extension = "nog";
        } else if (this.controller.grammar.gramType == GramType.FLX) {
            extension = "jnof";
        } else if (this.controller.grammar.gramType == GramType.MORPHO) {
            extension = "jnom";
        } else {
            knownType = false;
            openGraphChooser.setAcceptAllFileFilterUsed(true);
        }
        if (knownType) {
            FileNameExtensionFilter fileFilter = new FileNameExtensionFilter("Nooj Grammar (*." + extension + ")", extension);
            FileNameExtensionFilter filterGrammar = new FileNameExtensionFilter("INTEX Graphs (*.grf)", "grf");
            openGraphChooser.addChoosableFileFilter(fileFilter);
            openGraphChooser.addChoosableFileFilter(filterGrammar);
            openGraphChooser.setFileFilter(fileFilter);
        }
        if (openGraphChooser.showOpenDialog(Launcher.getDesktopPane()) == 1) {
            return;
        }
        GramType gramType = this.controller.grammar.gramType;
        if (openGraphChooser.getFileFilter().getDescription().startsWith("INTEX")) {
            OpenGrammarDialog openGrammarDialog = new OpenGrammarDialog(this, Launcher.getIndexOfDefaultEncoding());
            JList inputLanguageList = openGrammarDialog.getInputLanguageList();
            int index = ((DefaultListModel)inputLanguageList.getModel()).indexOf(this.controller.grammar.iLanguage);
            if (index != -1) {
                inputLanguageList.setSelectedIndex(index);
                inputLanguageList.ensureIndexIsVisible(index);
            }
            inputLanguageList.setEnabled(false);
            JList outputLanguageList = openGrammarDialog.getOutputLanguageList();
            index = ((DefaultListModel)outputLanguageList.getModel()).indexOf(this.controller.grammar.oLanguage);
            if (index != -1) {
                outputLanguageList.setSelectedIndex(index);
                outputLanguageList.ensureIndexIsVisible(index);
            }
            outputLanguageList.setEnabled(false);
            JButton buttonFlex = openGrammarDialog.getInflectionalGrammarButton();
            JButton buttonMorpho = openGrammarDialog.getMorphologicalGrammarButton();
            JButton buttonSyntax = openGrammarDialog.getSyntacticGrammarButton();
            if (gramType == GramType.FLX) {
                buttonFlex.setEnabled(true);
                buttonMorpho.setEnabled(false);
                buttonSyntax.setEnabled(false);
            } else if (gramType == GramType.MORPHO) {
                buttonFlex.setEnabled(false);
                buttonMorpho.setEnabled(true);
                buttonSyntax.setEnabled(false);
            } else {
                buttonFlex.setEnabled(false);
                buttonMorpho.setEnabled(false);
                buttonSyntax.setEnabled(true);
            }
            openGrammarDialog.setModal(true);
            openGrammarDialog.setVisible(true);
            if (this.closedWithXButton) {
                return;
            }
            String encodingCode = Launcher.getEncodingCodeOfOpenGrammar();
            if (gramType == GramType.FLX) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Will convert all C/D/L/R operators (eg: replace all Ls with <B>, delete :s)", "Intex => NooJ Conversion", 1);
            } else if (gramType == GramType.MORPHO) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Will replace all dots with commas (attention: conversions .=>= and .=>. must be done manually)", "Intex => NooJ Conversion", 1);
            } else {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Will convert symbols <MOT>, <MIN>, <MAJ>, <PRE>, and all dots to commas", "Intex => NooJ Conversion", 1);
            }
            File[] fileArray = openGraphChooser.getSelectedFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = FilenameUtils.removeExtension(file.getName());
                boolean found = false;
                do {
                    found = false;
                    int iG = 0;
                    while (iG < this.controller.grammar.graphs.size()) {
                        Graph g = this.controller.grammar.graphs.get(iG);
                        if (g.name.equals(fileName)) {
                            found = true;
                            break;
                        }
                        ++iG;
                    }
                    if (!found) continue;
                    fileName = String.valueOf(fileName) + "'";
                } while (found);
                String filePath = file.getAbsolutePath();
                if (!this.controller.addIntexGraph(filePath, fileName, encodingCode, gramType)) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot import graph " + filePath, "NooJ: Intex graph => NooJ conversion failure", 0);
                } else {
                    this.controller.modify("import intex graph", true, false);
                }
                ++n2;
            }
        } else {
            File[] fileArray = openGraphChooser.getSelectedFiles();
            int n = fileArray.length;
            int n3 = 0;
            while (n3 < n) {
                File file = fileArray[n3];
                String fileName = FilenameUtils.removeExtension(file.getName());
                boolean found = false;
                do {
                    found = false;
                    int iG = 0;
                    while (iG < this.controller.grammar.graphs.size()) {
                        Graph g = this.controller.grammar.graphs.get(iG);
                        if (g.name.equals(fileName)) {
                            found = true;
                            break;
                        }
                        ++iG;
                    }
                    if (!found) continue;
                    fileName = String.valueOf(fileName) + "'";
                } while (found);
                this.controller.addNoojGrammar(file.getAbsolutePath(), fileName, gramType);
                this.controller.modify("import nooj grammar", true, false);
                if (this.controller.editor.formGramStruct != null) {
                    this.controller.editor.formGramStruct.getController().expandAll(true);
                }
                ++n3;
            }
        }
        this.controller.updateFormHeader();
        this.controller.editor.invalidate();
        this.controller.editor.repaint();
    }

    public void setClosedWithXButton(boolean closedWithXButton) {
        this.closedWithXButton = closedWithXButton;
    }
}

