/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.actions.shells.construct;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import net.nooj4nlp.gui.dialogs.TextCorpusDialog;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class NewTextCorpusActionListener
implements ActionListener {
    private boolean isCorpus;
    private TextCorpusDialog dialog;
    private JInternalFrame frame;
    private static String chosenFileName;

    public NewTextCorpusActionListener(boolean corpus, JInternalFrame frame) {
        this.isCorpus = corpus;
        this.frame = frame;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.isCorpus) {
            JFileChooser jFileChooser = Launcher.getOpenCorpusChooser();
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setDialogTitle("Create New Corpus");
            int result = jFileChooser.showSaveDialog(this.frame);
            if (result == 0) {
                File selectedNOCFile = jFileChooser.getSelectedFile();
                chosenFileName = FilenameUtils.removeExtension(selectedNOCFile.getName());
                if (selectedNOCFile.exists()) {
                    int dialogButton = 0;
                    int affirm = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Corpus file already exists. Are you sure you want to delete it?", "NooJ", dialogButton);
                    if (affirm == 1) {
                        return;
                    }
                }
                this.dialog = new TextCorpusDialog(true, false, this.frame, selectedNOCFile);
                this.dialog.setModal(true);
                this.dialog.setDefaultCloseOperation(2);
                this.dialog.setVisible(true);
            }
        } else {
            chosenFileName = "";
            this.dialog = new TextCorpusDialog(false, false, this.frame, null);
            this.dialog.setModal(true);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setVisible(true);
        }
    }

    public static String getChosenFileName() {
        return chosenFileName;
    }
}

