/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.actions.shells.control;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class CascadeWindowsActionListener
implements ActionListener {
    private JDesktopPane desktopPane;

    public CascadeWindowsActionListener(JDesktopPane p) {
        this.desktopPane = p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        this.cascadeWindows(frames, this.desktopPane.getBounds());
    }

    private void cascadeWindows(JInternalFrame[] frames, Rectangle dBounds) {
        Dimension cd;
        Dimension d;
        int margin = 0;
        int i = 0;
        while (i < frames.length) {
            d = frames[i].getSize();
            cd = frames[i].getContentPane().getSize();
            margin += Math.max(d.width - cd.width, d.height - cd.height);
            ++i;
        }
        int width = dBounds.width - margin;
        int height = dBounds.height - margin;
        int offset = 0;
        int i2 = 0;
        while (i2 < frames.length) {
            if (!frames[i2].isResizable()) {
                width = frames[i2].getSize().width;
                height = frames[i2].getSize().height;
            }
            frames[i2].setBounds(dBounds.x + offset, dBounds.y + offset, width, height);
            d = frames[i2].getSize();
            cd = frames[i2].getContentPane().getSize();
            try {
                frames[i2].setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            offset += Math.max(d.width - cd.width, d.height - cd.height);
            ++i2;
        }
    }
}

