/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import net.nooj4nlp.gui.components.ThreeDimensionalBorder;

public class ColoredJButtonUI
extends BasicButtonUI {
    private Color backgroundColor;
    private Color pressedStateColor;

    public ColoredJButtonUI(Color backgroundColor, Color pressedStateColor) {
        this.backgroundColor = backgroundColor;
        this.pressedStateColor = pressedStateColor;
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        Graphics2D g2D = (Graphics2D)g;
        JButton myButton = (JButton)component;
        myButton.setBorder(new ThreeDimensionalBorder(Color.BLACK, 200, 2));
        Font buttonFont = new Font(myButton.getFont().getName(), 1, myButton.getFont().getSize());
        myButton.setFont(buttonFont);
        g2D.setRenderingHints(ThreeDimensionalBorder.getHints());
        ButtonModel buttonModel = myButton.getModel();
        if (buttonModel.isPressed() || buttonModel.isSelected()) {
            g2D.setColor(this.pressedStateColor);
        } else {
            g2D.setColor(this.backgroundColor);
        }
        int strokePad = ThreeDimensionalBorder.getStrokePad();
        int thickness = ThreeDimensionalBorder.getThickness();
        int shadowPad = ThreeDimensionalBorder.getShadowPad();
        g2D.fillRoundRect(0 + strokePad, 0 + strokePad, component.getWidth() - thickness - shadowPad - 1, component.getHeight() - thickness - shadowPad - 1, 5, 5);
        super.paint(g2D, component);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }
}

