/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.components;

import java.text.Collator;
import java.util.Comparator;
import net.nooj4nlp.engine.Language;

public class NooJTableSorter
implements Comparator<Object[]> {
    private int currentColumn;
    private Language language = null;
    private boolean reversedSort = false;
    private boolean sortingIntegers = false;

    public NooJTableSorter(int currentColumn, Language language) {
        this.language = language;
        this.currentColumn = currentColumn;
    }

    public NooJTableSorter(int currentColumn, boolean reversedSort, boolean sortingIntegers, Language language) {
        this.currentColumn = currentColumn;
        this.reversedSort = reversedSort;
        this.sortingIntegers = sortingIntegers;
        this.language = language;
    }

    @Override
    public int compare(Object[] o1, Object[] o2) {
        int secondNumber;
        if (!this.sortingIntegers) {
            Collator collator = this.language != null ? Collator.getInstance(this.language.locale) : Collator.getInstance();
            collator.setStrength(3);
            String firstString = o1[this.currentColumn].toString();
            String secondString = o2[this.currentColumn].toString();
            if (!this.reversedSort) {
                return collator.compare(firstString, secondString);
            }
            StringBuilder tmp1 = new StringBuilder();
            StringBuilder tmp2 = new StringBuilder();
            tmp1.append(firstString).reverse();
            tmp2.append(secondString).reverse();
            return collator.compare(tmp1.toString(), tmp2.toString());
        }
        int firstNumber = (Integer)o1[this.currentColumn];
        if (firstNumber < (secondNumber = ((Integer)o2[this.currentColumn]).intValue())) {
            return 1;
        }
        if (firstNumber > secondNumber) {
            return -1;
        }
        return 0;
    }
}

