/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.AlignmentDialog.AlignmentController;
import net.nooj4nlp.controller.AlignmentDialog.AlignmentJPanel;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.gui.components.UsualColoredButtonUI;

public class AlignmentDialog
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private AlignmentController controller;
    private JCheckBox cbUseGrid;

    public AlignmentDialog(GrammarEditorShellController grammarController) {
        this.setMaximizable(false);
        this.setIconifiable(false);
        this.setClosable(false);
        this.setResizable(false);
        this.setTitle("Alignment");
        this.setBounds(123, 123, 290, 320);
        this.getContentPane().setLayout(new MigLayout("ins 4", "[grow][100:110:120]", "[100][grow][40]"));
        AlignmentJPanel panelHorizontal = new AlignmentJPanel(true);
        panelHorizontal.setBorder(new TitledBorder(null, "Horizontal", 4, 2, null, null));
        panelHorizontal.setLayout(new MigLayout("ins 2", "[33%][34%][33%]", "[]"));
        this.getContentPane().add((Component)panelHorizontal, "cell 0 0, height 90, span");
        JButton buttonTop = new JButton("Top");
        buttonTop.setPreferredSize(new Dimension(60, 25));
        buttonTop.setUI(new UsualColoredButtonUI(Color.GRAY, Color.BLACK));
        panelHorizontal.add((Component)buttonTop, "cell 0 0, gapleft 10, aligny bottom");
        JButton buttonHCenter = new JButton("Center");
        buttonHCenter.setPreferredSize(new Dimension(60, 41));
        buttonHCenter.setUI(new UsualColoredButtonUI(Color.GRAY, Color.BLACK));
        panelHorizontal.add((Component)buttonHCenter, "cell 1 0, gapleft 6, aligny center");
        JButton buttonBottom = new JButton("Bottom");
        buttonBottom.setPreferredSize(new Dimension(60, 31));
        buttonBottom.setUI(new UsualColoredButtonUI(Color.GRAY, Color.BLACK));
        panelHorizontal.add((Component)buttonBottom, "cell 2 0, gapright 10, gapbottom 35, aligny top");
        AlignmentJPanel panelVertical = new AlignmentJPanel(false);
        panelVertical.setBorder(new TitledBorder(null, "Vertical", 4, 2, null, null));
        panelVertical.setLayout(new MigLayout("ins 2", "[grow]", "[33%][34%][33%]"));
        this.getContentPane().add((Component)panelVertical, "cell 0 1, height 170, span 1 2, grow");
        JButton buttonLeft = new JButton("Left");
        buttonLeft.setPreferredSize(new Dimension(60, 31));
        buttonLeft.setUI(new UsualColoredButtonUI(Color.GRAY, Color.BLACK));
        panelVertical.add((Component)buttonLeft, "cell 0 0, alignx right, gapbottom 15, gapright 8");
        JButton buttonVCenter = new JButton("Center");
        buttonVCenter.setPreferredSize(new Dimension(60, 36));
        buttonVCenter.setUI(new UsualColoredButtonUI(Color.GRAY, Color.BLACK));
        panelVertical.add((Component)buttonVCenter, "cell 0 1, alignx center, gapbottom 8");
        JButton buttonRight = new JButton("Right");
        buttonRight.setPreferredSize(new Dimension(60, 31));
        buttonRight.setUI(new UsualColoredButtonUI(Color.GRAY, Color.BLACK));
        panelVertical.add((Component)buttonRight, "cell 0 2, gapleft 8, gapbottom 5");
        this.cbUseGrid = new JCheckBox("Use Grid");
        this.getContentPane().add((Component)this.cbUseGrid, "cell 1 1, alignx left, aligny bottom");
        JButton buttonClose = new JButton("Close");
        this.getContentPane().add((Component)buttonClose, "cell 1 2, alignx left, aligny top, gapleft 2, growx");
        this.controller = new AlignmentController(this, grammarController);
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentDialog.this.controller.close();
            }
        });
        buttonBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentDialog.this.controller.bottomAlign();
            }
        });
        buttonTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentDialog.this.controller.topAlign();
            }
        });
        buttonHCenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentDialog.this.controller.centerHorizontalAlign();
            }
        });
        buttonLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentDialog.this.controller.leftAlign();
            }
        });
        buttonRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentDialog.this.controller.rightAlign();
            }
        });
        buttonVCenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentDialog.this.controller.centerVerticalAlign();
            }
        });
        this.cbUseGrid.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AlignmentDialog.this.controller.useGrid();
            }
        });
    }

    public AlignmentController getController() {
        return this.controller;
    }

    public JCheckBox getCbUseGrid() {
        return this.cbUseGrid;
    }
}

