/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.dialogs;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.nooj4nlp.gui.actions.documents.FindReplaceActionListener;
import net.nooj4nlp.gui.actions.documents.FindReplaceCloseInternalFrame;
import net.nooj4nlp.gui.actions.documents.FindReplaceEvents;
import net.nooj4nlp.gui.shells.DictionaryEditorShell;
import net.nooj4nlp.gui.shells.FlexDescEditorShell;
import net.nooj4nlp.gui.shells.PropDefEditorShell;
import net.nooj4nlp.gui.shells.TextEditorShell;

public class FindReplaceDialog
extends JInternalFrame {
    private static final long serialVersionUID = -6173419966017392181L;
    private JTextPane rtb;
    private FindReplaceEvents listener;
    private int labDicoContext;
    private JInternalFrame activeFrame;
    private JComboBox comboReplacePattern;
    private JComboBox comboFindPattern;
    private JRadioButton rdbtnExactPattern;
    private JButton btnNext;
    private JButton btnReplaceThenNext;

    public FindReplaceDialog(JInternalFrame activeFrame, String title, int labDicoContext) {
        this.activeFrame = activeFrame;
        this.labDicoContext = labDicoContext;
        this.setClosable(true);
        this.setIconifiable(true);
        this.setBounds(100, 100, 558, 202);
        this.getContentPane().setLayout(null);
        this.setTitle(title);
        ButtonGroup grpPattern = new ButtonGroup();
        this.rdbtnExactPattern = new JRadioButton("Exact pattern");
        this.rdbtnExactPattern.setBounds(43, 7, 109, 23);
        this.rdbtnExactPattern.setActionCommand("Exact");
        this.rdbtnExactPattern.setSelected(true);
        this.getContentPane().add(this.rdbtnExactPattern);
        grpPattern.add(this.rdbtnExactPattern);
        JRadioButton rdbtnPerlPattern = new JRadioButton("PERL pattern");
        rdbtnPerlPattern.setBounds(154, 7, 109, 23);
        rdbtnPerlPattern.setActionCommand("Regex");
        this.getContentPane().add(rdbtnPerlPattern);
        grpPattern.add(rdbtnPerlPattern);
        JLabel lblFind = new JLabel("Find:");
        lblFind.setBounds(10, 41, 34, 14);
        this.getContentPane().add(lblFind);
        this.comboFindPattern = new JComboBox();
        this.comboFindPattern.setEditable(true);
        this.comboFindPattern.setBounds(43, 37, 488, 23);
        this.comboFindPattern.setSelectedItem("");
        JTextComponent comboTextField = (JTextComponent)this.comboFindPattern.getEditor().getEditorComponent();
        comboTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FindReplaceDialog.this.btnNext.setEnabled(false);
                FindReplaceDialog.this.btnReplaceThenNext.setEnabled(false);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FindReplaceDialog.this.btnNext.setEnabled(false);
                FindReplaceDialog.this.btnReplaceThenNext.setEnabled(false);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FindReplaceDialog.this.btnNext.setEnabled(false);
                FindReplaceDialog.this.btnReplaceThenNext.setEnabled(false);
            }
        });
        comboTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FindReplaceDialog.this.listener.find();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.getContentPane().add(this.comboFindPattern);
        JButton btnFindFirst = new JButton("Find 1st occurrence");
        btnFindFirst.setBounds(10, 72, 127, 23);
        btnFindFirst.setActionCommand("Find");
        this.getContentPane().add(btnFindFirst);
        this.btnNext = new JButton("Next");
        this.btnNext.setBounds(147, 72, 55, 23);
        this.btnNext.setEnabled(false);
        this.btnNext.setActionCommand("Next");
        this.getContentPane().add(this.btnNext);
        JButton btnCountLines = new JButton("Count Lines");
        btnCountLines.setBounds(212, 72, 89, 23);
        btnCountLines.setToolTipText("Count all entries that match the pattern");
        btnCountLines.setActionCommand("Count");
        this.getContentPane().add(btnCountLines);
        JButton btnExtractLines = new JButton("Extract Lines");
        btnExtractLines.setBounds(311, 72, 101, 23);
        btnExtractLines.setToolTipText("Extract all entries that match the pattern");
        btnExtractLines.setActionCommand("Extract");
        this.getContentPane().add(btnExtractLines);
        JButton btnFilterOutLines = new JButton("Filter Out Lines");
        btnFilterOutLines.setBounds(422, 72, 109, 23);
        btnFilterOutLines.setToolTipText("Extract all entries that do not match the pattern");
        btnFilterOutLines.setActionCommand("Filter");
        this.getContentPane().add(btnFilterOutLines);
        JLabel lblReplaceWith = new JLabel("Replace with:");
        lblReplaceWith.setBounds(10, 106, 72, 14);
        this.getContentPane().add(lblReplaceWith);
        this.comboReplacePattern = new JComboBox();
        this.comboReplacePattern.setEditable(true);
        this.comboReplacePattern.setBounds(81, 102, 451, 23);
        this.comboReplacePattern.setSelectedItem("");
        JTextComponent comboReplaceField = (JTextComponent)this.comboReplacePattern.getEditor().getEditorComponent();
        comboReplaceField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FindReplaceDialog.this.btnNext.setEnabled(false);
                FindReplaceDialog.this.btnReplaceThenNext.setEnabled(false);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FindReplaceDialog.this.btnNext.setEnabled(false);
                FindReplaceDialog.this.btnReplaceThenNext.setEnabled(false);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FindReplaceDialog.this.btnNext.setEnabled(false);
                FindReplaceDialog.this.btnReplaceThenNext.setEnabled(false);
            }
        });
        this.getContentPane().add(this.comboReplacePattern);
        this.btnReplaceThenNext = new JButton("Replace, then Next");
        this.btnReplaceThenNext.setBounds(10, 136, 165, 23);
        this.btnReplaceThenNext.setEnabled(false);
        this.btnReplaceThenNext.setActionCommand("Replace");
        this.getContentPane().add(this.btnReplaceThenNext);
        JButton btnReplaceAll = new JButton("Replace All");
        btnReplaceAll.setBounds(185, 136, 116, 23);
        btnReplaceAll.setActionCommand("ReplaceAll");
        this.getContentPane().add(btnReplaceAll);
        JButton btnReplaceAllFrom = new JButton("Replace All from rules in File");
        btnReplaceAllFrom.setBounds(311, 136, 220, 23);
        btnReplaceAllFrom.setToolTipText("Find,Replace rules are stored in a .dic file");
        btnReplaceAllFrom.setActionCommand("ReplaceAllFrom");
        this.getContentPane().add(btnReplaceAllFrom);
        String cls = activeFrame.getClass().getSimpleName();
        if (cls.equals("TextEditorShell")) {
            TextEditorShell textShell = (TextEditorShell)activeFrame;
            this.rtb = textShell.getTextPane();
        } else if (cls.equals("DictionaryEditorShell")) {
            DictionaryEditorShell dictionaryShell = (DictionaryEditorShell)activeFrame;
            this.rtb = dictionaryShell.getTextPane();
            btnCountLines.setVisible(true);
            btnExtractLines.setVisible(true);
            btnFilterOutLines.setVisible(true);
        } else if (cls.equals("FlexDescEditorShell")) {
            FlexDescEditorShell flexDescShell = (FlexDescEditorShell)activeFrame;
            this.rtb = flexDescShell.getTextPane();
            btnCountLines.setVisible(false);
            btnExtractLines.setVisible(false);
            btnFilterOutLines.setVisible(false);
        } else if (cls.equals("PropDefEditorShell")) {
            PropDefEditorShell propDefShell = (PropDefEditorShell)activeFrame;
            this.rtb = propDefShell.getTextPane();
            btnCountLines.setVisible(false);
            btnExtractLines.setVisible(false);
            btnFilterOutLines.setVisible(false);
        } else if (cls.equals("GrammarEditorShell")) {
            this.rtb = null;
            btnCountLines.setVisible(false);
            btnExtractLines.setVisible(false);
            btnFilterOutLines.setVisible(false);
        }
        if (labDicoContext > 0) {
            this.btnReplaceThenNext.setVisible(false);
            btnReplaceAllFrom.setVisible(false);
            btnFindFirst.setVisible(false);
            btnCountLines.setVisible(false);
            this.btnNext.setVisible(false);
            if (labDicoContext == 1) {
                btnExtractLines.setVisible(false);
                btnFilterOutLines.setVisible(false);
            } else if (labDicoContext == 2) {
                this.comboReplacePattern.setVisible(false);
                lblReplaceWith.setVisible(false);
                btnReplaceAll.setVisible(false);
            }
        }
        this.listener = new FindReplaceEvents(this);
        FindReplaceActionListener actionListener = new FindReplaceActionListener(this.listener);
        btnFindFirst.addActionListener(actionListener);
        this.btnNext.addActionListener(actionListener);
        this.btnReplaceThenNext.addActionListener(actionListener);
        btnReplaceAll.addActionListener(actionListener);
        btnExtractLines.addActionListener(actionListener);
        btnFilterOutLines.addActionListener(actionListener);
        btnCountLines.addActionListener(actionListener);
        btnReplaceAllFrom.addActionListener(actionListener);
        this.addInternalFrameListener(new FindReplaceCloseInternalFrame(activeFrame));
    }

    public JTextPane getRtb() {
        return this.rtb;
    }

    public void setRtb(JTextPane rtb) {
        this.rtb = rtb;
    }

    public JInternalFrame getActiveFrame() {
        return this.activeFrame;
    }

    public JComboBox getComboReplacePattern() {
        return this.comboReplacePattern;
    }

    public JComboBox getComboFindPattern() {
        return this.comboFindPattern;
    }

    public JRadioButton getRdbtnExactPattern() {
        return this.rdbtnExactPattern;
    }

    public JButton getBtnNext() {
        return this.btnNext;
    }

    public JButton getBtnReplaceThenNext() {
        return this.btnReplaceThenNext;
    }

    public int getLabDicoContext() {
        return this.labDicoContext;
    }

    public FindReplaceEvents getListener() {
        return this.listener;
    }
}

