/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.LocateDialog.CloseInternalFrameListener;
import net.nooj4nlp.controller.LocateDialog.ConcordanceLocateActionListener;
import net.nooj4nlp.controller.LocateDialog.LocateDialogPatternActionListener;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Constants;
import net.nooj4nlp.gui.components.ColoredJButtonUI;
import net.nooj4nlp.gui.dialogs.LocateDialogLimitationActionListener;

public class LocateDialog
extends JInternalFrame {
    private static final long serialVersionUID = -5687237998263649977L;
    private TextEditorShellController textController;
    private CorpusEditorShellController corpusController;
    private boolean isCorpus;
    private JRadioButton rbStringPattern;
    private JRadioButton rbPerlPattern;
    private JRadioButton rbNooJPattern;
    private JRadioButton rbNooJGrammar;
    private JRadioButton rbShortestMatches;
    private JRadioButton rbLongestMatches;
    private JRadioButton rbAllIndexMatches;
    private JRadioButton rbAllOccurrences;
    private JRadioButton rbOnly;
    private JComboBox nooJRegeXCombo;
    private JComboBox nooJGrammarPathCombo;
    private JTextField txtNumberOfOccurrences;
    private JButton setButton;
    private JCheckBox syntacticAnalysisCBox;
    private JCheckBox oneOccPerMatchCBox;
    private JCheckBox resetConcordanceCBox;
    private ConcordanceLocateActionListener concordanceLocateActionListener;

    public LocateDialog(TextEditorShellController textController, CorpusEditorShellController corpusController, boolean corpus) {
        this.textController = textController;
        this.corpusController = corpusController;
        this.isCorpus = corpus;
        this.setIconifiable(false);
        this.setMaximizable(false);
        this.setResizable(false);
        this.setClosable(true);
        if (!corpus) {
            if (this.textController.getFileToBeOpenedOrImported() != null) {
                this.setTitle("Locate a pattern in " + this.textController.getFileToBeOpenedOrImported().getName());
            } else {
                this.setTitle("Locate a pattern in ");
            }
        } else {
            this.setTitle("Locate a pattern in " + this.corpusController.getFullName());
        }
        this.setBounds(50, 50, 400, 420);
        this.getContentPane().setLayout(new MigLayout("insets 5", "[::150,grow,left][::220,grow,fill]", "[200::,grow][50::,grow,fill][20]"));
        JPanel patternPanel = new JPanel();
        patternPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Pattern is:", 4, 2, null, new Color(0, 0, 0)));
        this.getContentPane().add((Component)patternPanel, "cell 0 0, span 2, grow");
        patternPanel.setLayout(new MigLayout("insets 3", "[250!][30!, grow, fill]", "[20::, grow, fill][20::, grow, fill][20::, grow, fill][20, fill][20::][20, fill][20::, grow, center]"));
        this.rbStringPattern = new JRadioButton("a string of characters:");
        patternPanel.add((Component)this.rbStringPattern, "cell 0 0, span 2, align left");
        this.rbStringPattern.addActionListener(new LocateDialogPatternActionListener(this));
        this.rbPerlPattern = new JRadioButton("a PERL regular expression:");
        patternPanel.add((Component)this.rbPerlPattern, "cell 0 1, span 2, align left");
        this.rbPerlPattern.addActionListener(new LocateDialogPatternActionListener(this));
        this.rbNooJPattern = new JRadioButton("a NooJ regular expression:");
        this.rbNooJPattern.setSelected(true);
        patternPanel.add((Component)this.rbNooJPattern, "cell 0 2, span 2, align left");
        this.rbNooJPattern.addActionListener(new LocateDialogPatternActionListener(this));
        List<String> inputRegexList = this.isCorpus ? corpusController.getLocateRegexMemoryList() : textController.getLocateRegexMemoryList();
        this.nooJRegeXCombo = inputRegexList != null && inputRegexList.size() > 0 ? new JComboBox<Object>(inputRegexList.toArray()) : new JComboBox();
        this.nooJRegeXCombo.setPrototypeDisplayValue("XXX");
        this.nooJRegeXCombo.setEditable(true);
        this.nooJRegeXCombo.setSelectedItem(new String(""));
        this.nooJRegeXCombo.setMaximumSize(new Dimension(280, 20));
        patternPanel.add((Component)this.nooJRegeXCombo, "cell 0 3, span 2, gapleft 20, width 280, height 20");
        if (this.isCorpus) {
            if (corpusController.getCorpus().lan.rightToLeft) {
                this.nooJRegeXCombo.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            } else {
                this.nooJRegeXCombo.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            }
        } else if (textController.isNooJRightToLeft()) {
            this.nooJRegeXCombo.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            this.nooJRegeXCombo.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        }
        this.rbNooJGrammar = new JRadioButton("a NooJ grammar:");
        patternPanel.add((Component)this.rbNooJGrammar, "cell 0 4, span 2, align left");
        if (this.isCorpus) {
            this.rbNooJGrammar.addActionListener(new LocateDialogPatternActionListener((JInternalFrame)this, corpusController, this));
        } else {
            this.rbNooJGrammar.addActionListener(new LocateDialogPatternActionListener((JInternalFrame)this, textController, this));
        }
        List<String> inputGrammarList = this.isCorpus ? corpusController.getLocateGrammarMemoryList() : textController.getLocateGrammarMemoryList();
        this.nooJGrammarPathCombo = inputGrammarList != null && inputGrammarList.size() > 0 ? new JComboBox<Object>(inputGrammarList.toArray()) : new JComboBox();
        this.nooJGrammarPathCombo.setPrototypeDisplayValue("XXX");
        this.nooJGrammarPathCombo.setEditable(true);
        this.nooJGrammarPathCombo.setSelectedItem(new String(""));
        this.nooJGrammarPathCombo.setMaximumSize(new Dimension(250, 20));
        patternPanel.add((Component)this.nooJGrammarPathCombo, "cell 0 5, align left, gapleft 20, width 250, height 20");
        this.nooJGrammarPathCombo.setEnabled(false);
        this.setButton = new JButton("Set");
        patternPanel.add((Component)this.setButton, "cell 1 5, gapleft 10, align right, wrap");
        this.setButton.setEnabled(false);
        if (this.isCorpus) {
            this.setButton.addActionListener(new LocateDialogPatternActionListener((JInternalFrame)this, corpusController, this));
        } else {
            this.setButton.addActionListener(new LocateDialogPatternActionListener((JInternalFrame)this, textController, this));
        }
        this.syntacticAnalysisCBox = new JCheckBox("Syntactic Analysis");
        patternPanel.add((Component)this.syntacticAnalysisCBox, "cell 0 6, gapleft 50");
        this.syntacticAnalysisCBox.setEnabled(false);
        ButtonGroup rbPatternGroup = new ButtonGroup();
        rbPatternGroup.add(this.rbStringPattern);
        rbPatternGroup.add(this.rbPerlPattern);
        rbPatternGroup.add(this.rbNooJPattern);
        rbPatternGroup.add(this.rbNooJGrammar);
        this.resetConcordanceCBox = new JCheckBox("Reset Concordance");
        this.getContentPane().add((Component)this.resetConcordanceCBox, "cell 0 2, align left");
        this.resetConcordanceCBox.setSelected(true);
        JButton actionButtonR = new JButton("N");
        actionButtonR.setUI(new ColoredJButtonUI(Constants.NOOJ_RED_BUTTON_COLOR, Constants.NOOJ_PRESSED_RED_BUTTON_COLOR));
        this.getContentPane().add((Component)actionButtonR, "cell 1 2, split 4, align right");
        JButton actionButtonG = new JButton("o");
        actionButtonG.setUI(new ColoredJButtonUI(Constants.NOOJ_GREEN_BUTTON_COLOR, Constants.NOOJ_PRESSED_GREEN_BUTTON_COLOR));
        this.getContentPane().add((Component)actionButtonG, "cell 1 2, align right");
        JButton actionButtonB = new JButton("o");
        actionButtonB.setUI(new ColoredJButtonUI(Constants.NOOJ_BLUE_BUTTON_COLOR, Constants.NOOJ_PRESSED_BLUE_BUTTON_COLOR));
        this.getContentPane().add((Component)actionButtonB, "cell 1 2, align right");
        JButton actionButtonC = new JButton("J");
        actionButtonC.setUI(new ColoredJButtonUI(Constants.NOOJ_GRAY_BUTTON_COLOR, Constants.NOOJ_PRESSED_GRAY_BUTTON_COLOR));
        this.getContentPane().add((Component)actionButtonC, "cell 1 2, align right");
        this.concordanceLocateActionListener = new ConcordanceLocateActionListener(this.isCorpus, textController, corpusController, this);
        actionButtonR.addActionListener(this.concordanceLocateActionListener);
        actionButtonG.addActionListener(this.concordanceLocateActionListener);
        actionButtonB.addActionListener(this.concordanceLocateActionListener);
        actionButtonC.addActionListener(this.concordanceLocateActionListener);
        JPanel indexPanel = new JPanel();
        indexPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Index", 4, 2, null, new Color(0, 0, 0)));
        this.getContentPane().add((Component)indexPanel, "cell 0 1, align left, grow");
        indexPanel.setLayout(new MigLayout("insets 3", "[100::, grow, fill]", "[20::, grow, fill][20!, grow, fill][20::, grow, fill]"));
        this.rbShortestMatches = new JRadioButton("Shortest matches");
        indexPanel.add((Component)this.rbShortestMatches, "cell 0 0, align left");
        this.rbLongestMatches = new JRadioButton("Longest matches");
        this.rbLongestMatches.setSelected(true);
        indexPanel.add((Component)this.rbLongestMatches, "cell 0 1, align left");
        this.rbAllIndexMatches = new JRadioButton("All matches");
        indexPanel.add((Component)this.rbAllIndexMatches, "cell 0 2, align left");
        ButtonGroup rbIndexGroup = new ButtonGroup();
        rbIndexGroup.add(this.rbShortestMatches);
        rbIndexGroup.add(this.rbLongestMatches);
        rbIndexGroup.add(this.rbAllIndexMatches);
        JPanel limitationPanel = new JPanel();
        limitationPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Limitation", 4, 2, null, new Color(0, 0, 0)));
        this.getContentPane().add((Component)limitationPanel, "cell 1 1, align right, grow");
        limitationPanel.setLayout(new MigLayout("insets 3", "[50::, grow, fill][50::, grow, fill][50::, grow, fill]", "[20::, grow, fill][20!, grow, fill][20::, grow, fill]"));
        this.rbAllOccurrences = new JRadioButton("All occurrences");
        limitationPanel.add((Component)this.rbAllOccurrences, "cell 0 0, span 3, align left");
        this.rbOnly = new JRadioButton("Only: ");
        this.rbOnly.setSelected(true);
        limitationPanel.add((Component)this.rbOnly, "cell 0 1, align left");
        this.txtNumberOfOccurrences = new JTextField();
        limitationPanel.add((Component)this.txtNumberOfOccurrences, "cell 1 1, align center");
        this.txtNumberOfOccurrences.setText("100");
        this.rbAllOccurrences.addActionListener(new LocateDialogLimitationActionListener(this.txtNumberOfOccurrences, this.rbOnly));
        this.rbOnly.addActionListener(new LocateDialogLimitationActionListener(this.txtNumberOfOccurrences, this.rbOnly));
        JLabel occurrencesLabel = new JLabel("occ.");
        limitationPanel.add((Component)occurrencesLabel, "cell 2 1, align left");
        this.oneOccPerMatchCBox = new JCheckBox("1 occ. per match");
        this.oneOccPerMatchCBox.setSelected(false);
        limitationPanel.add((Component)this.oneOccPerMatchCBox, "cell 0 2, span 3, align left");
        ButtonGroup rbLimitationGroup = new ButtonGroup();
        rbLimitationGroup.add(this.rbAllOccurrences);
        rbLimitationGroup.add(this.rbOnly);
        this.addInternalFrameListener(new CloseInternalFrameListener(corpusController, textController));
    }

    public ConcordanceLocateActionListener getConcordanceLocateActionListener() {
        return this.concordanceLocateActionListener;
    }

    public TextEditorShellController getTextController() {
        return this.textController;
    }

    public CorpusEditorShellController getCorpusController() {
        return this.corpusController;
    }

    public JRadioButton getRbStringPattern() {
        return this.rbStringPattern;
    }

    public void setRbStringPattern(JRadioButton rbStringPattern) {
        this.rbStringPattern = rbStringPattern;
    }

    public JRadioButton getRbPerlPattern() {
        return this.rbPerlPattern;
    }

    public void setRbPerlPattern(JRadioButton rbPerlPattern) {
        this.rbPerlPattern = rbPerlPattern;
    }

    public JRadioButton getRbNooJPattern() {
        return this.rbNooJPattern;
    }

    public void setRbNooJPattern(JRadioButton rbNooJPattern) {
        this.rbNooJPattern = rbNooJPattern;
    }

    public JRadioButton getRbNooJGrammar() {
        return this.rbNooJGrammar;
    }

    public void setRbNooJGrammar(JRadioButton rbNooJGrammar) {
        this.rbNooJGrammar = rbNooJGrammar;
    }

    public JCheckBox getSyntacticAnalysisCBox() {
        return this.syntacticAnalysisCBox;
    }

    public void setSyntacticAnalysisCBox(JCheckBox syntacticAnalysisCBox) {
        this.syntacticAnalysisCBox = syntacticAnalysisCBox;
    }

    public JComboBox getNooJGrammarPathCombo() {
        return this.nooJGrammarPathCombo;
    }

    public void setNooJGrammarPathCombo(JComboBox nooJGrammarPathCombo) {
        this.nooJGrammarPathCombo = nooJGrammarPathCombo;
    }

    public JComboBox getNooJRegeXCombo() {
        return this.nooJRegeXCombo;
    }

    public void setNooJRegeXCombo(JComboBox nooJRegeXCombo) {
        this.nooJRegeXCombo = nooJRegeXCombo;
    }

    public JCheckBox getOneOccPerMatchCBox() {
        return this.oneOccPerMatchCBox;
    }

    public JCheckBox getResetConcordanceCBox() {
        return this.resetConcordanceCBox;
    }

    public JButton getSetButton() {
        return this.setButton;
    }

    public JRadioButton getRbShortestMatches() {
        return this.rbShortestMatches;
    }

    public JRadioButton getRbLongestMatches() {
        return this.rbLongestMatches;
    }

    public JRadioButton getRbAllIndexMatches() {
        return this.rbAllIndexMatches;
    }

    public JRadioButton getRbOnly() {
        return this.rbOnly;
    }

    public JTextField getTxtNumberOfOccurrences() {
        return this.txtNumberOfOccurrences;
    }
}

