/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.dialogs.OpenCorpusDialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.CorpusEditorShell.AmbiguitiesUnambiguitiesActionListener;
import net.nooj4nlp.controller.CorpusEditorShell.CloseInternalFrameListener;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Constants;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.helper.BackgroundWorker;
import net.nooj4nlp.gui.components.ColoredJButtonUI;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.AmbigUnambigOnCloseEvents;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.InversiveSortActionListener;
import net.nooj4nlp.gui.main.Launcher;

public class AmbiguitiesUnambiguitiesDialog
extends JInternalFrame
implements PropertyChangeListener {
    private static final long serialVersionUID = -8021962323484527458L;
    private JTable tableAmbigUnambig;
    private JLabel counterLabel;
    private JButton btnLocateR;
    private JButton btnLocateG;
    private JButton btnLocateB;
    private JButton btnLocateW;
    private JComboBox comboPattern;
    private JCheckBox cBoxDisplayCategories;
    private CorpusEditorShellController corpusController;
    private TextEditorShellController textController;
    private boolean isACorpus;
    private int nbOfAmb;
    private boolean areAmbiguities;
    private Language language;
    private boolean reversedSortingActive = false;

    public AmbiguitiesUnambiguitiesDialog(CorpusEditorShellController corpusController, TextEditorShellController textController, boolean areAmbiguities) {
        this.textController = textController;
        this.corpusController = corpusController;
        this.areAmbiguities = areAmbiguities;
        if (corpusController != null && corpusController.getShell() != null) {
            this.isACorpus = true;
            this.language = corpusController.getCorpus().lan;
        } else {
            this.isACorpus = false;
            this.language = textController.getMyText().Lan;
        }
        if (areAmbiguities) {
            this.setTitle("Ambiguities");
        } else {
            this.setTitle("Unambiguous Words");
        }
        this.setBounds(170, 170, 500, 450);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        this.getContentPane().setLayout(new MigLayout("", "[150px][100:170:220][grow]", "[20!, grow][20!, grow][grow][35!, grow]"));
        JLabel selectAnalysisLabel = new JLabel("Select analysis: ");
        this.getContentPane().add((Component)selectAnalysisLabel, "cell 0 0, alignx left, aligny top");
        if (!areAmbiguities) {
            selectAnalysisLabel.setVisible(false);
        }
        this.comboPattern = new JComboBox();
        this.getContentPane().add((Component)this.comboPattern, "cell 1 0, alignx center, span 2, aligny top, wmin 170");
        if (!areAmbiguities) {
            this.comboPattern.setVisible(false);
        }
        this.comboPattern.setSelectedItem("");
        this.counterLabel = new JLabel(":)");
        this.getContentPane().add((Component)this.counterLabel, "cell 0 1, alignx left, aligny top, span 2");
        DefaultTableModel tableModel = new DefaultTableModel(new Object[]{"Freq", "Annotation", "Positions"}, 0);
        this.tableAmbigUnambig = new JTable(tableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tableAmbigUnambig.setUI(new BasicTableUI(){

            @Override
            protected MouseInputListener createMouseInputListener() {
                return new BasicTableUI.MouseInputHandler(this){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        e.getClickCount();
                    }
                };
            }
        });
        if (areAmbiguities) {
            this.tableAmbigUnambig.setSelectionMode(2);
        } else {
            this.tableAmbigUnambig.setSelectionMode(0);
        }
        this.tableAmbigUnambig.removeColumn(this.tableAmbigUnambig.getColumnModel().getColumn(2));
        if (areAmbiguities) {
            this.tableAmbigUnambig.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JTable target = (JTable)e.getSource();
                    if (target.getModel().getRowCount() == 0) {
                        return;
                    }
                    int row = target.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    row = AmbiguitiesUnambiguitiesDialog.this.tableAmbigUnambig.convertRowIndexToModel(row);
                    String lexs = target.getModel().getValueAt(row, 1).toString();
                    String[] alexs = Dic.parseSequenceOfSymbols(lexs);
                    AmbiguitiesUnambiguitiesDialog.this.comboPattern.removeAllItems();
                    String[] stringArray = alexs;
                    int n = alexs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        AmbiguitiesUnambiguitiesDialog.this.comboPattern.addItem(s);
                        ++n2;
                    }
                    AmbiguitiesUnambiguitiesDialog.this.comboPattern.setSelectedIndex(0);
                }
            });
        }
        JScrollPane scrollPane1 = new JScrollPane(this.tableAmbigUnambig, 20, 30);
        scrollPane1.setBorder(new BevelBorder(1, null, null, null, null));
        this.getContentPane().add((Component)scrollPane1, "cell 0 2, grow, span 3");
        this.tableAmbigUnambig.setAutoResizeMode(0);
        this.tableAmbigUnambig.setAutoCreateRowSorter(false);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.tableAmbigUnambig.getModel());
        sorter.setSortable(0, false);
        sorter.setSortable(1, false);
        this.tableAmbigUnambig.setRowSorter(sorter);
        this.cBoxDisplayCategories = new JCheckBox("Display Only Categories");
        this.getContentPane().add((Component)this.cBoxDisplayCategories, "cell 0 3, aligny bottom, alignx left, gapright 80, grow");
        if (areAmbiguities) {
            this.cBoxDisplayCategories.addActionListener(new AmbiguitiesUnambiguitiesActionListener(corpusController, textController, this, areAmbiguities, false));
        } else {
            this.cBoxDisplayCategories.setVisible(false);
        }
        this.btnLocateR = new JButton("N");
        this.btnLocateR.setUI(new ColoredJButtonUI(Constants.NOOJ_RED_BUTTON_COLOR, Constants.NOOJ_PRESSED_RED_BUTTON_COLOR));
        this.getContentPane().add((Component)this.btnLocateR, "cell 1 3, alignx left, grow, split 4");
        this.btnLocateG = new JButton("o");
        this.btnLocateG.setUI(new ColoredJButtonUI(Constants.NOOJ_GREEN_BUTTON_COLOR, Constants.NOOJ_PRESSED_GREEN_BUTTON_COLOR));
        this.getContentPane().add((Component)this.btnLocateG, "cell 1 3, alignx left, grow");
        this.btnLocateB = new JButton("o");
        this.btnLocateB.setUI(new ColoredJButtonUI(Constants.NOOJ_BLUE_BUTTON_COLOR, Constants.NOOJ_PRESSED_BLUE_BUTTON_COLOR));
        this.getContentPane().add((Component)this.btnLocateB, "cell 1 3, alignx left, grow");
        this.btnLocateW = new JButton("J");
        this.btnLocateW.setUI(new ColoredJButtonUI(Constants.NOOJ_GRAY_BUTTON_COLOR, Constants.NOOJ_PRESSED_GRAY_BUTTON_COLOR));
        this.getContentPane().add((Component)this.btnLocateW, "cell 1 3, alignx left, grow");
        this.addInternalFrameListener(new CloseInternalFrameListener(corpusController, this));
        AmbiguitiesUnambiguitiesActionListener auListener = new AmbiguitiesUnambiguitiesActionListener(corpusController, textController, this, areAmbiguities, true);
        this.btnLocateR.addActionListener(auListener);
        this.btnLocateG.addActionListener(auListener);
        this.btnLocateB.addActionListener(auListener);
        this.btnLocateW.addActionListener(auListener);
        InversiveSortActionListener inversiveSort = new InversiveSortActionListener(this, this.reversedSortingActive, this.language);
        this.tableAmbigUnambig.getTableHeader().addMouseListener(inversiveSort);
        this.addInternalFrameListener(new AmbigUnambigOnCloseEvents(this, inversiveSort));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            Launcher.getStatusBar().getProgressBar().setIndeterminate(false);
            Launcher.getStatusBar().getProgressBar().setValue(progress);
        }
    }

    public void fillInTheData() {
        this.computeAmbiguities(this.areAmbiguities);
    }

    private void computeAmbiguities(boolean areAmbiguities) {
        if (Launcher.backgroundWorking) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "One process is already running.", "NooJ: one process only in this version", 0);
            return;
        }
        Launcher.initialDate = new Date();
        if (this.isVisible()) {
            this.hide();
        }
        if (this.isACorpus) {
            this.corpusController.desactivateOps();
        } else {
            this.textController.desactivateOps();
        }
        Launcher.getStatusBar().getBtnCancel().setEnabled(true);
        Launcher.getStatusBar().getBtnCancel().setForeground(Color.red);
        if (areAmbiguities) {
            Launcher.progressMessage = "Compute ambiguities...";
            Launcher.getStatusBar().getProgressLabel().setText("Compute ambiguities...");
        } else {
            Launcher.progressMessage = "Look for Unambiguous words...";
            Launcher.getStatusBar().getProgressLabel().setText("Look for Unambiguous words...");
        }
        if (this.isACorpus) {
            if (areAmbiguities) {
                if (Launcher.multithread) {
                    Launcher.backgroundWorking = true;
                    Launcher.backgroundWorker = new BackgroundWorker("corpus ambiguities", null, this.corpusController, null);
                    Launcher.backgroundWorker.addPropertyChangeListener(this);
                    Launcher.backgroundWorker.execute();
                } else {
                    this.corpusController.computeAmbiguities(true);
                    this.fillInTheTable();
                    this.corpusController.reactivateOps();
                    this.corpusController.updateTextPaneStats();
                    this.corpusController.updateResults();
                    this.show();
                    Date now = new Date();
                    long sec = (now.getTime() - Launcher.initialDate.getTime()) / 1000L;
                    Launcher.getStatusBar().getProgressLabel().setText(String.valueOf(Long.toString(sec)) + " sec");
                }
            } else if (Launcher.multithread) {
                Launcher.backgroundWorking = true;
                Launcher.backgroundWorker = new BackgroundWorker("corpus unambiguities", null, this.corpusController, null);
                Launcher.backgroundWorker.addPropertyChangeListener(this);
                Launcher.backgroundWorker.execute();
            } else {
                this.corpusController.computeAmbiguities(false);
                this.fillInTheTable();
                this.corpusController.reactivateOps();
                this.corpusController.updateTextPaneStats();
                this.corpusController.updateResults();
                this.show();
                Date now = new Date();
                long sec = (now.getTime() - Launcher.initialDate.getTime()) / 1000L;
                Launcher.getStatusBar().getProgressLabel().setText(String.valueOf(Long.toString(sec)) + " sec");
            }
        } else if (areAmbiguities) {
            if (Launcher.multithread) {
                Launcher.backgroundWorking = true;
                Launcher.backgroundWorker = new BackgroundWorker("text ambiguities", this.textController, null, null);
                Launcher.backgroundWorker.addPropertyChangeListener(this);
                Launcher.backgroundWorker.execute();
            } else {
                this.textController.computeAmbiguities(true);
                this.fillInTheTable();
                this.textController.reactivateOps();
                this.textController.updateTextPaneStats();
                this.show();
                Date now = new Date();
                long sec = (now.getTime() - Launcher.initialDate.getTime()) / 1000L;
                Launcher.getStatusBar().getProgressLabel().setText(String.valueOf(Long.toString(sec)) + " sec");
            }
        } else if (Launcher.multithread) {
            Launcher.backgroundWorking = true;
            Launcher.backgroundWorker = new BackgroundWorker("text unambiguities", this.textController, null, null);
            Launcher.backgroundWorker.addPropertyChangeListener(this);
            Launcher.backgroundWorker.execute();
        } else {
            this.textController.computeAmbiguities(false);
            this.fillInTheTable();
            this.textController.reactivateOps();
            this.textController.updateTextPaneStats();
            this.show();
            Date now = new Date();
            long sec = (now.getTime() - Launcher.initialDate.getTime()) / 1000L;
            Launcher.getStatusBar().getProgressLabel().setText(String.valueOf(Long.toString(sec)) + " sec");
        }
    }

    public void fillInTheTable() {
        if (this.isACorpus && this.areAmbiguities) {
            HashMap<String, ArrayList<Object>> ambigHashTable = this.corpusController.getCorpus().hAmbiguities;
            this.fillInDataHelpFunction(ambigHashTable, this.tableAmbigUnambig);
            this.nbOfAmb = ambigHashTable.size();
        } else if (this.isACorpus && !this.areAmbiguities) {
            HashMap<String, ArrayList<Object>> ambigHashTable = this.corpusController.getCorpus().hUnambiguities;
            this.fillInDataHelpFunction(ambigHashTable, this.tableAmbigUnambig);
            this.nbOfAmb = ambigHashTable.size();
        } else if (this.areAmbiguities) {
            HashMap<String, ArrayList<Object>> ambigHashTable = this.textController.getMyText().hAmbiguities;
            this.fillInDataHelpFunction(ambigHashTable, this.tableAmbigUnambig);
            this.nbOfAmb = ambigHashTable.size();
        } else {
            HashMap<String, ArrayList<Object>> ambigHashTable = this.textController.getMyText().hUnambiguities;
            this.fillInDataHelpFunction(ambigHashTable, this.tableAmbigUnambig);
            this.nbOfAmb = ambigHashTable.size();
        }
        if (this.areAmbiguities) {
            this.counterLabel.setText(String.valueOf(this.nbOfAmb) + " different types of ambiguities!");
        } else {
            this.counterLabel.setText(String.valueOf(this.nbOfAmb) + " unambiguous linguistic units!");
        }
    }

    private void fillInDataHelpFunction(HashMap<String, ArrayList<Object>> ambigHashTable, JTable previewTable) {
        DefaultTableModel tableModel = (DefaultTableModel)previewTable.getModel();
        tableModel.getDataVector().removeAllElements();
        tableModel.fireTableDataChanged();
        previewTable.setModel(tableModel);
        AmbiguitiesUnambiguitiesActionListener.fillTheTable(this.corpusController, this.textController, this, this.areAmbiguities);
    }

    public JTable getTableAmbigUnambig() {
        return this.tableAmbigUnambig;
    }

    public void setTableAmbigUnambig(JTable tableAmbigUnambig) {
        this.tableAmbigUnambig = tableAmbigUnambig;
    }

    public boolean isACorpus() {
        return this.isACorpus;
    }

    public JCheckBox getcBoxDisplayCategories() {
        return this.cBoxDisplayCategories;
    }

    public JComboBox getComboPattern() {
        return this.comboPattern;
    }

    public TextEditorShellController getTextController() {
        return this.textController;
    }

    public CorpusEditorShellController getCorpusController() {
        return this.corpusController;
    }

    public boolean isReversedSortingActive() {
        return this.reversedSortingActive;
    }

    public void setReversedSortingActive(boolean reversedSortingActive) {
        this.reversedSortingActive = reversedSortingActive;
    }

    public boolean isAreAmbiguities() {
        return this.areAmbiguities;
    }
}

