/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.undo.UndoManager;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.CorpusEditorShell.ExportXmlDialog.XmlAnnotationsTextPaneResources;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.controller.packageconfigurationdialog.PackageConfigurationDialogController;
import net.nooj4nlp.controller.packageconfigurationdialog.UseProjectActionListener;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.Preferences;
import net.nooj4nlp.engine.Utilities;
import net.nooj4nlp.engine.helper.BackgroundWorker;
import net.nooj4nlp.gui.actions.documents.RedoActionListener;
import net.nooj4nlp.gui.actions.documents.SaveActionListener;
import net.nooj4nlp.gui.actions.documents.SaveForNooJActionListener;
import net.nooj4nlp.gui.actions.documents.UndoActionListener;
import net.nooj4nlp.gui.actions.shells.construct.ConsoleActionListener;
import net.nooj4nlp.gui.actions.shells.construct.ConstructCorpusActionListener;
import net.nooj4nlp.gui.actions.shells.construct.DictionaryActionListener;
import net.nooj4nlp.gui.actions.shells.construct.FindReplaceActionListener;
import net.nooj4nlp.gui.actions.shells.construct.LanguageSpecificsActionListener;
import net.nooj4nlp.gui.actions.shells.construct.MorphologyActionListener;
import net.nooj4nlp.gui.actions.shells.construct.NewDictionaryPropDefActionListener;
import net.nooj4nlp.gui.actions.shells.construct.NewGrammarActionListener;
import net.nooj4nlp.gui.actions.shells.construct.NewTextCorpusActionListener;
import net.nooj4nlp.gui.actions.shells.construct.OpenConcordanceActionListener;
import net.nooj4nlp.gui.actions.shells.construct.OpenCorpusActionListener;
import net.nooj4nlp.gui.actions.shells.construct.OpenDictionaryActionListener;
import net.nooj4nlp.gui.actions.shells.construct.OpenGrammarActionListener;
import net.nooj4nlp.gui.actions.shells.construct.OpenPropDefActionListener;
import net.nooj4nlp.gui.actions.shells.construct.OpenTextActionListener;
import net.nooj4nlp.gui.actions.shells.construct.PackageConfigurationActionListener;
import net.nooj4nlp.gui.actions.shells.construct.PerlRegexActionListener;
import net.nooj4nlp.gui.actions.shells.construct.PreferencesActionListener;
import net.nooj4nlp.gui.actions.shells.construct.TextEncodingActionListener;
import net.nooj4nlp.gui.actions.shells.control.ArrangeIconsActionListener;
import net.nooj4nlp.gui.actions.shells.control.CascadeWindowsActionListener;
import net.nooj4nlp.gui.actions.shells.control.CloseActionListener;
import net.nooj4nlp.gui.actions.shells.control.ExitActionListener;
import net.nooj4nlp.gui.actions.shells.control.MinimizeAllWindowsActionListener;
import net.nooj4nlp.gui.actions.shells.control.ResizeActionListener;
import net.nooj4nlp.gui.actions.shells.control.TileWindowsActionListener;
import net.nooj4nlp.gui.components.CustomStatusBar;
import net.nooj4nlp.gui.dialogs.PackageConfigurationDialog;
import net.nooj4nlp.gui.shells.ConcordanceShell;
import net.nooj4nlp.gui.shells.DictionaryEditorShell;
import net.nooj4nlp.gui.shells.FlexDescEditorShell;
import net.nooj4nlp.gui.shells.TextEditorShell;
import org.apache.commons.io.FilenameUtils;

public class Launcher {
    private static JFrame frame;
    private static JMenuBar menuBar;
    private static JDesktopPane desktopPane;
    public static JInternalFrame lastActive;
    private UndoManager doManager;
    private static JMenuItem mntmCopy;
    private static JMenuItem mntmCut;
    private static JMenuItem mntmPaste;
    private static JMenuItem mntmSelectAll;
    private static JMenuItem mntmRunProject;
    private static JMenuItem mntmNewProject;
    private static JFileChooser openDicChooser;
    private static JFileChooser saveDicChooser;
    private static JFileChooser openGramChooser;
    private static JFileChooser saveGramChooser;
    private static JFileChooser openDefDialogChooser;
    private static JFileChooser saveDefDialogChooser;
    private static JFileChooser openSourceChooser;
    private static JFileChooser openCorpusChooser;
    private static JFileChooser saveCorpusChooser;
    private static JFileChooser openTextChooser;
    private static JFileChooser saveTextChooser;
    private static JFileChooser openFolderChooser;
    private static JFileChooser saveConcordanceChooser;
    private static JFileChooser openConcordanceChooser;
    private static JFileChooser openProjectChooser;
    private static JFileChooser saveProjectChooser;
    private static CustomStatusBar statusBar;
    public static String nooJVersion;
    public static Preferences preferences;
    public static Preferences savedPreferences;
    public static Graph graphClipboard;
    public static int iGraphClipboard;
    public static ArrayList<Integer> nGraphClipboard;
    public static boolean projectMode;
    private static XmlAnnotationsTextPaneResources xmlAnnotationsTextPaneResources;
    private static String[] Arguments;
    public static boolean multithread;
    public static boolean backgroundWorking;
    public static BackgroundWorker backgroundWorker;
    public static Date initialDate;
    public static String processName;
    public static int progressPercentage;
    public static String progressMessage;
    public static boolean checkAgreement;
    private static List<String> regexMemoryList;
    private static List<String> xmlMemoryList;
    private static int corpusTextRadioButtonSelectionMemory;
    private static int regexMemoryIndex;
    private static int xmlMemoryIndex;
    private static int indexOfDefaultEncoding;
    private static String encodingCodeOfOpenGrammar;

    static {
        nooJVersion = "v3.1 b0109";
        savedPreferences = null;
        multithread = true;
        backgroundWorking = false;
        regexMemoryList = new ArrayList<String>();
        xmlMemoryList = new ArrayList<String>();
        corpusTextRadioButtonSelectionMemory = 2;
        regexMemoryIndex = -1;
        xmlMemoryIndex = -1;
        indexOfDefaultEncoding = -1;
        encodingCodeOfOpenGrammar = "";
    }

    public static void main(String[] args) {
        Arguments = args;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Launcher window = new Launcher();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void processTheArguments() {
        if (Arguments == null) {
            return;
        }
        if (Arguments.length == 0) {
            return;
        }
        String[] stringArray = Arguments;
        int n = Arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            int mid = arg.lastIndexOf(".");
            String ext = arg.substring(mid, arg.length());
            if (!(ext.equalsIgnoreCase("DIC") || ext.equalsIgnoreCase("FLX") || ext.equalsIgnoreCase("DEF"))) {
                JInternalFrame shell;
                Object controller;
                File file;
                if (ext.equalsIgnoreCase("jnoc")) {
                    file = new File(arg);
                    controller = new CorpusEditorShellController(null, null, null, null);
                    shell = ((CorpusEditorShellController)controller).openNoojCorpus(file, false);
                    ((CorpusEditorShellController)controller).openNoojEngine();
                    if (controller != null && ((CorpusEditorShellController)controller).getCorpus() != null) {
                        shell.show();
                    }
                } else if (!(ext.equalsIgnoreCase("jnof") || ext.equalsIgnoreCase("nog") || ext.equalsIgnoreCase("NOM"))) {
                    if (ext.equalsIgnoreCase("NOP")) {
                        PackageConfigurationDialog packageConfigDialog = new PackageConfigurationDialog();
                        controller = new PackageConfigurationDialogController(packageConfigDialog);
                        ((PackageConfigurationDialogController)controller).openProject(arg);
                        if (controller == null || PackageConfigurationDialogController.getProject() == null) {
                            return;
                        }
                        statusBar.getProjectLabel().setText("PROJECT MODE");
                        Arguments = null;
                        return;
                    }
                    if (ext.equalsIgnoreCase("jnot")) {
                        file = new File(arg);
                        controller = new TextEditorShellController(file);
                        shell = ((TextEditorShellController)controller).openText(file);
                        if (controller != null) {
                            ((TextEditorShellController)controller).rtbTextUpdate(false);
                            ((TextEditorShellController)controller).updateTextPaneStats();
                            shell.show();
                        }
                    }
                }
            }
            ++n2;
        }
        Arguments = null;
    }

    public Launcher() {
        this.initialize();
        Paths.InitializePaths();
        this.createFileChoosers();
        this.init();
        this.loadXmlAnnotationsTextPaneResources();
    }

    private void init() {
        int mustxcopy = 0;
        String updatefile = FilenameUtils.concat(Paths.docDir, "update.txt");
        File file = new File(updatefile);
        if (!file.exists()) {
            mustxcopy = 1;
        }
        if (mustxcopy > 0) {
            try {
                Utilities.initAllDiskResources();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
            PrintWriter sw = null;
            try {
                sw = new PrintWriter(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            sw.write("Hello NooJ User");
            sw.close();
        }
        this.loadDefaultPreference();
        Launcher.setOpenDirectories();
        Launcher.processTheArguments();
    }

    public static void setOpenDirectories() {
        if (projectMode) {
            String prjdir;
            Launcher.preferences.openTextDir = prjdir = PackageConfigurationDialogController.getProjectDir();
            Launcher.preferences.openDicDir = prjdir;
            Launcher.preferences.openGrammarDir = prjdir;
            Launcher.preferences.openProjDir = null;
            Paths.projectDir = prjdir;
        } else {
            Launcher.preferences.openProjDir = FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(Launcher.preferences.deflanguage, "Projects"));
            File directory = new File(Launcher.preferences.openProjDir);
            if (!directory.exists()) {
                directory.mkdir();
            }
            Launcher.preferences.openTextDir = FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(Launcher.preferences.deflanguage, "Projects"));
            Launcher.preferences.openDicDir = FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(Launcher.preferences.deflanguage, "Lexical Analysis"));
            directory = new File(Launcher.preferences.openDicDir);
            if (!directory.exists()) {
                directory.mkdir();
            }
            Launcher.preferences.openGrammarDir = FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(Launcher.preferences.deflanguage, "Syntactic Analysis"));
            directory = new File(Launcher.preferences.openGrammarDir);
            if (!directory.exists()) {
                directory.mkdir();
            }
        }
        openDicChooser.setCurrentDirectory(new File(Launcher.preferences.openDicDir));
        saveDicChooser.setCurrentDirectory(new File(Launcher.preferences.openDicDir));
        openDefDialogChooser.setCurrentDirectory(new File(Launcher.preferences.openDicDir));
        saveDefDialogChooser.setCurrentDirectory(new File(Launcher.preferences.openDicDir));
        openGramChooser.setCurrentDirectory(new File(Launcher.preferences.openGrammarDir));
        saveGramChooser.setCurrentDirectory(new File(Launcher.preferences.openGrammarDir));
        openTextChooser.setCurrentDirectory(new File(Launcher.preferences.openTextDir));
        saveTextChooser.setCurrentDirectory(new File(Launcher.preferences.openTextDir));
        openCorpusChooser.setCurrentDirectory(new File(Launcher.preferences.openTextDir));
        saveCorpusChooser.setCurrentDirectory(new File(Launcher.preferences.openTextDir));
        if (Launcher.preferences.openProjDir != null) {
            openProjectChooser.setCurrentDirectory(new File(Launcher.preferences.openProjDir));
            saveProjectChooser.setCurrentDirectory(new File(Launcher.preferences.openProjDir));
        }
    }

    private void initialize() {
        frame = new JFrame();
        frame.setTitle("NooJ");
        frame.setExtendedState(6);
        frame.setDefaultCloseOperation(3);
        frame.setMinimumSize(new Dimension(640, 480));
        desktopPane = new JDesktopPane();
        frame.getContentPane().add((Component)desktopPane, "Center");
        desktopPane.setBackground(new Color(171, 171, 171));
        menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        this.doManager = new UndoManager();
        this.createMenuContents();
        statusBar = new CustomStatusBar(frame);
        statusBar.getBtnCancel().setEnabled(false);
        backgroundWorker = new BackgroundWorker();
        frame.getContentPane().add((Component)statusBar, "South");
        regexMemoryList.add("^[A-Z ][A-Z ]*");
        xmlMemoryList.add("<title> <head> <p>");
        xmlMemoryList.add("<s>");
    }

    private void loadXmlAnnotationsTextPaneResources() {
        xmlAnnotationsTextPaneResources = new XmlAnnotationsTextPaneResources();
    }

    private void loadDefaultPreference() {
        String prefname = FilenameUtils.concat(Paths.docDir, "Preferences.jnoj");
        preferences = Preferences.Load(prefname);
        if (preferences == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load preference file " + prefname, "NooJ setup problem?", 0);
            prefname = String.valueOf(Paths.applicationDir) + "Preferences." + "jnoj";
            preferences = Preferences.Load(prefname);
            if (preferences == null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load preference file " + prefname, "NooJ setup problem?", 0);
                preferences = new Preferences();
            }
        }
    }

    public static void modifyAllFonts() {
        JInternalFrame[] allFrames;
        JInternalFrame[] jInternalFrameArray = allFrames = Launcher.getDesktopPane().getAllFrames();
        int n = allFrames.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame currentForm = jInternalFrameArray[n2];
            String cls = currentForm.getClass().getSimpleName();
            if (cls.equals("DictionaryEditorShell")) {
                DictionaryEditorShell dictionaryEditorShell = (DictionaryEditorShell)currentForm;
                dictionaryEditorShell.modifyFont(Launcher.preferences.DFont.getFamily(), Launcher.preferences.DFont.getSize());
            } else if (cls.equals("TextEditorShell")) {
                TextEditorShell textEditorShell = (TextEditorShell)currentForm;
                textEditorShell.getTextController().modifyTextFont(Launcher.preferences.TFont.getFamily(), Launcher.preferences.TFont.getSize());
            } else if (cls.equals("ConcordanceShell")) {
                ((ConcordanceShell)currentForm).getConcordanceTable().setFont(Launcher.preferences.TFont);
            } else if (cls.equals("FlexDescEditorShell")) {
                ((FlexDescEditorShell)currentForm).modifyFont(Launcher.preferences.DFont.getFamily(), Launcher.preferences.DFont.getSize());
            }
            ++n2;
        }
    }

    private void createFileChoosers() {
        FileNameExtensionFilter filterDic = new FileNameExtensionFilter("NooJ Dictionary (*.dic)", "dic");
        FileNameExtensionFilter filterGram = new FileNameExtensionFilter("NooJ Grammar (*.nog)", "nog");
        FileNameExtensionFilter filterCSharpGram = new FileNameExtensionFilter("C# NooJ Grammar (*.xml)", "xml");
        FileNameExtensionFilter filterDef = new FileNameExtensionFilter("Properties' definition (*.def)", "def");
        openDicChooser = new JFileChooser();
        openDicChooser.setDialogTitle("Open a dictionary");
        openDicChooser.setFileSelectionMode(0);
        openDicChooser.addChoosableFileFilter(filterDic);
        openDicChooser.setFileFilter(filterDic);
        saveDicChooser = new JFileChooser();
        saveDicChooser.setDialogTitle("Save a dictionary");
        saveDicChooser.addChoosableFileFilter(filterDic);
        saveDicChooser.setFileFilter(filterDic);
        saveDicChooser.setAcceptAllFileFilterUsed(false);
        openGramChooser = new JFileChooser();
        openGramChooser.setDialogTitle("Open a grammar");
        openGramChooser.setFileSelectionMode(0);
        openGramChooser.addChoosableFileFilter(filterGram);
        openGramChooser.addChoosableFileFilter(filterCSharpGram);
        openGramChooser.setFileFilter(filterGram);
        saveGramChooser = new JFileChooser();
        saveGramChooser.setDialogTitle("Save a grammar");
        saveGramChooser.addChoosableFileFilter(filterGram);
        saveGramChooser.setFileFilter(filterGram);
        saveGramChooser.setAcceptAllFileFilterUsed(false);
        openDefDialogChooser = new JFileChooser();
        openDefDialogChooser.setDialogTitle("Open Properties' definition");
        openDefDialogChooser.setAcceptAllFileFilterUsed(false);
        openDefDialogChooser.setFileSelectionMode(0);
        openDefDialogChooser.addChoosableFileFilter(filterDef);
        openDefDialogChooser.setFileFilter(filterDef);
        saveDefDialogChooser = new JFileChooser();
        saveDefDialogChooser.setDialogTitle("Save Properties' definition");
        saveDefDialogChooser.addChoosableFileFilter(filterDef);
        saveDefDialogChooser.setFileFilter(filterDef);
        saveDefDialogChooser.setAcceptAllFileFilterUsed(false);
        openSourceChooser = new JFileChooser();
        openSourceChooser.setFileSelectionMode(0);
        openCorpusChooser = new JFileChooser();
        FileNameExtensionFilter filterCorpus = new FileNameExtensionFilter("NooJ Corpus (*.jnoc)", "jnoc");
        openCorpusChooser.addChoosableFileFilter(filterCorpus);
        openCorpusChooser.setFileFilter(filterCorpus);
        saveCorpusChooser = new JFileChooser();
        FileNameExtensionFilter filterSaveCorpus = new FileNameExtensionFilter("NooJ-formated Corpus (*.jnoc)", "jnoc");
        saveCorpusChooser.addChoosableFileFilter(filterSaveCorpus);
        saveCorpusChooser.setFileFilter(filterSaveCorpus);
        openTextChooser = new JFileChooser();
        FileNameExtensionFilter filterOpenText1 = new FileNameExtensionFilter("NooJ-formated Text (*.jnot)", "jnot");
        openTextChooser.addChoosableFileFilter(filterOpenText1);
        openTextChooser.setFileSelectionMode(0);
        saveTextChooser = new JFileChooser();
        FileNameExtensionFilter filterSaveText = new FileNameExtensionFilter("Nooj-formated Text (*.jnot)", "jnot");
        saveTextChooser.addChoosableFileFilter(filterSaveText);
        openFolderChooser = new JFileChooser();
        openFolderChooser.setFileSelectionMode(1);
        saveConcordanceChooser = new JFileChooser();
        saveConcordanceChooser.setDialogTitle("Save concordance");
        FileNameExtensionFilter filterSaveConcordance = new FileNameExtensionFilter("NooJ concordance (*.jncc)", "jncc");
        saveConcordanceChooser.addChoosableFileFilter(filterSaveConcordance);
        openConcordanceChooser = new JFileChooser();
        openConcordanceChooser.setDialogTitle("Open a concordance");
        FileNameExtensionFilter filterOpenConcordance = new FileNameExtensionFilter("NooJ concordance (*.jncc)", "jncc");
        openConcordanceChooser.addChoosableFileFilter(filterOpenConcordance);
        saveProjectChooser = new JFileChooser();
        saveProjectChooser.setDialogTitle("Save a project");
        FileNameExtensionFilter filterSaveProject = new FileNameExtensionFilter("Project (*.jnop)", "jnop");
        saveProjectChooser.addChoosableFileFilter(filterSaveProject);
        openProjectChooser = new JFileChooser();
        openProjectChooser.setDialogTitle("Open a project");
        openProjectChooser.addChoosableFileFilter(filterSaveProject);
    }

    private void createMenuContents() {
        JMenu mnFile = new JMenu("File");
        mnFile.setVisible(true);
        menuBar.add(mnFile);
        JMenu mnNew = new JMenu("New");
        mnFile.add(mnNew);
        JMenuItem mntmText = new JMenuItem("Text");
        mnNew.add(mntmText);
        mntmText.addActionListener(new NewTextCorpusActionListener(false, lastActive));
        JMenuItem mntmCorpus = new JMenuItem("Corpus");
        mnNew.add(mntmCorpus);
        mntmCorpus.addActionListener(new NewTextCorpusActionListener(true, lastActive));
        JSeparator separator_1 = new JSeparator();
        mnNew.add(separator_1);
        JMenuItem mntmNewDictionary = new JMenuItem("Dictionary");
        mnNew.add(mntmNewDictionary);
        mntmNewDictionary.addActionListener(new NewDictionaryPropDefActionListener(true));
        JMenuItem mntmPropertiesDefinition = new JMenuItem("Properties' definition");
        mnNew.add(mntmPropertiesDefinition);
        mntmPropertiesDefinition.addActionListener(new NewDictionaryPropDefActionListener(false));
        JSeparator separator_2 = new JSeparator();
        mnNew.add(separator_2);
        JMenuItem mntmGrammar = new JMenuItem("Grammar");
        mnNew.add(mntmGrammar);
        mntmGrammar.addActionListener(new NewGrammarActionListener());
        JMenu mnOpen = new JMenu("Open");
        mnFile.add(mnOpen);
        JMenuItem mntmText_1 = new JMenuItem("Text");
        mnOpen.add(mntmText_1);
        mntmText_1.addActionListener(new OpenTextActionListener(desktopPane));
        JMenuItem mntmCorpus_1 = new JMenuItem("Corpus");
        mnOpen.add(mntmCorpus_1);
        mntmCorpus_1.addActionListener(new OpenCorpusActionListener(desktopPane));
        JMenuItem mntmConcordance = new JMenuItem("Concordance");
        mnOpen.add(mntmConcordance);
        mntmConcordance.addActionListener(new OpenConcordanceActionListener(desktopPane));
        JSeparator separator_3 = new JSeparator();
        mnOpen.add(separator_3);
        JMenuItem mntmOpenDictionary = new JMenuItem("Dictionary");
        mnOpen.add(mntmOpenDictionary);
        mntmOpenDictionary.addActionListener(new OpenDictionaryActionListener(desktopPane));
        JMenuItem mntmPropertiesDefinition_1 = new JMenuItem("Properties' definition");
        mnOpen.add(mntmPropertiesDefinition_1);
        mntmPropertiesDefinition_1.addActionListener(new OpenPropDefActionListener(desktopPane));
        JSeparator separator_4 = new JSeparator();
        mnOpen.add(separator_4);
        JMenuItem mntmGrammar_1 = new JMenuItem("Grammar");
        mntmGrammar_1.addActionListener(new OpenGrammarActionListener(desktopPane));
        mnOpen.add(mntmGrammar_1);
        JMenuItem mntmSave = new JMenuItem("Save");
        mntmSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        mnFile.add(mntmSave);
        mntmSave.addActionListener(new SaveActionListener(false));
        JMenuItem mntmSaveAs = new JMenuItem("Save As");
        mnFile.add(mntmSaveAs);
        mntmSaveAs.addActionListener(new SaveActionListener(true));
        JMenuItem mntmSaveForNooJ = new JMenuItem("Save for NooJ");
        mnFile.add(mntmSaveForNooJ);
        mntmSaveForNooJ.addActionListener(new SaveForNooJActionListener());
        JSeparator separator = new JSeparator();
        mnFile.add(separator);
        JMenuItem mntmClose = new JMenuItem("Close");
        mnFile.add(mntmClose);
        mntmClose.addActionListener(new CloseActionListener(desktopPane));
        JMenuItem mntmExit = new JMenuItem("Exit");
        mnFile.add(mntmExit);
        mntmExit.addActionListener(new ExitActionListener(frame));
        JMenu mnEdit = new JMenu("Edit");
        menuBar.add(mnEdit);
        mntmCopy = new JMenuItem("Copy");
        mntmCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        mnEdit.add(mntmCopy);
        mntmCut = new JMenuItem("Cut");
        mntmCut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        mnEdit.add(mntmCut);
        mntmPaste = new JMenuItem("Paste");
        mntmPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        mnEdit.add(mntmPaste);
        mntmSelectAll = new JMenuItem("Select All");
        mntmSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        mnEdit.add(mntmSelectAll);
        JSeparator separator_5 = new JSeparator();
        mnEdit.add(separator_5);
        JMenuItem mntmFindReplace = new JMenuItem("Find & Replace");
        mntmFindReplace.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        mnEdit.add(mntmFindReplace);
        mntmFindReplace.addActionListener(new FindReplaceActionListener(desktopPane));
        JSeparator separator_6 = new JSeparator();
        mnEdit.add(separator_6);
        JMenuItem mntmUndo = new JMenuItem("Undo");
        mntmUndo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        mnEdit.add(mntmUndo);
        mntmUndo.addActionListener(new UndoActionListener(this.doManager));
        JMenuItem mntmRedo = new JMenuItem("Redo");
        mntmRedo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        mnEdit.add(mntmRedo);
        mntmRedo.addActionListener(new RedoActionListener(this.doManager));
        JMenu mnLab = new JMenu("Lab");
        menuBar.add(mnLab);
        JMenuItem mntmTextEncoding = new JMenuItem("Text Encoding");
        mnLab.add(mntmTextEncoding);
        mntmTextEncoding.addActionListener(new TextEncodingActionListener(desktopPane));
        JSeparator separator_8 = new JSeparator();
        mnLab.add(separator_8);
        JMenuItem mntmPerlRegExpr = new JMenuItem("PERL Reg. Expr.");
        mnLab.add(mntmPerlRegExpr);
        mntmPerlRegExpr.addActionListener(new PerlRegexActionListener(desktopPane));
        JMenuItem mntmConstructACorpus = new JMenuItem("Construct a Corpus");
        mnLab.add(mntmConstructACorpus);
        mntmConstructACorpus.addActionListener(new ConstructCorpusActionListener(desktopPane));
        JSeparator separator_7 = new JSeparator();
        mnLab.add(separator_7);
        JMenuItem mntmLanguageSpecifics = new JMenuItem("Language Specifics");
        mnLab.add(mntmLanguageSpecifics);
        mntmLanguageSpecifics.addActionListener(new LanguageSpecificsActionListener(desktopPane));
        JMenuItem mntmMorphology = new JMenuItem("Morphology");
        mnLab.add(mntmMorphology);
        mntmMorphology.addActionListener(new MorphologyActionListener(desktopPane));
        JMenuItem mntmDictionary = new JMenuItem("Dictionary");
        mnLab.add(mntmDictionary);
        mntmDictionary.addActionListener(new DictionaryActionListener(desktopPane));
        JMenu mnProject = new JMenu("Project");
        menuBar.add(mnProject);
        mntmRunProject = new JMenuItem("Run Project");
        mnProject.add(mntmRunProject);
        mntmRunProject.addActionListener(new UseProjectActionListener(desktopPane));
        JSeparator separator_9 = new JSeparator();
        mnProject.add(separator_9);
        mntmNewProject = new JMenuItem("Package Configuration");
        mnProject.add(mntmNewProject);
        mntmNewProject.addActionListener(new PackageConfigurationActionListener(desktopPane));
        JMenu mnWindows = new JMenu("Windows");
        menuBar.add(mnWindows);
        JMenuItem mntmResizeTo800 = new JMenuItem("Resize to 800x600");
        mnWindows.add(mntmResizeTo800);
        mntmResizeTo800.addActionListener(new ResizeActionListener(frame, 1));
        JMenuItem mntmResizeTo1024 = new JMenuItem("Resize to 1024x768");
        mnWindows.add(mntmResizeTo1024);
        mntmResizeTo1024.addActionListener(new ResizeActionListener(frame, 2));
        JSeparator separator_10 = new JSeparator();
        mnWindows.add(separator_10);
        JMenuItem mntmCascade = new JMenuItem("Cascade");
        mnWindows.add(mntmCascade);
        mntmCascade.addActionListener(new CascadeWindowsActionListener(desktopPane));
        JMenuItem mntmTileHorizontally = new JMenuItem("Tile Horizontally");
        mnWindows.add(mntmTileHorizontally);
        mntmTileHorizontally.addActionListener(new TileWindowsActionListener(desktopPane, true));
        JMenuItem mntmTileVertically = new JMenuItem("Tile Vertically");
        mnWindows.add(mntmTileVertically);
        mntmTileVertically.addActionListener(new TileWindowsActionListener(desktopPane, false));
        JMenuItem mntmArrangeIcons = new JMenuItem("Arrange Icons");
        mnWindows.add(mntmArrangeIcons);
        mntmArrangeIcons.addActionListener(new ArrangeIconsActionListener(desktopPane));
        JMenuItem mntmMinimizeAllWindows = new JMenuItem("Minimize All Windows");
        mnWindows.add(mntmMinimizeAllWindows);
        mntmMinimizeAllWindows.addActionListener(new MinimizeAllWindowsActionListener(desktopPane, false));
        JMenuItem mntmMinimizeAllOther = new JMenuItem("Minimize All Other Windows");
        mnWindows.add(mntmMinimizeAllOther);
        mntmMinimizeAllOther.addActionListener(new MinimizeAllWindowsActionListener(desktopPane, true));
        JMenu mnInfo = new JMenu("Info");
        menuBar.add(mnInfo);
        JMenuItem mntmPreferences = new JMenuItem("Preferences");
        mnInfo.add(mntmPreferences);
        mntmPreferences.addActionListener(new PreferencesActionListener());
        JMenuItem mntmConsole = new JMenuItem("Console");
        mnInfo.add(mntmConsole);
        mntmConsole.addActionListener(new ConsoleActionListener(desktopPane));
        JSeparator separator_11 = new JSeparator();
        mnInfo.add(separator_11);
        JMenuItem mntmHelp = new JMenuItem("Help");
        mnInfo.add(mntmHelp);
        JMenuItem mntmAboutNooj = new JMenuItem("About NooJ");
        mnInfo.add(mntmAboutNooj);
    }

    public static HashMap<String, JMenuItem> getTextCommands() {
        HashMap<String, JMenuItem> commands = new HashMap<String, JMenuItem>();
        commands.put("Cut", mntmCut);
        commands.put("Copy", mntmCopy);
        commands.put("Paste", mntmPaste);
        commands.put("Select All", mntmSelectAll);
        return commands;
    }

    public static JDesktopPane getDesktopPane() {
        return desktopPane;
    }

    public static JMenuBar getMenuBar() {
        return menuBar;
    }

    public static JFileChooser getOpenDicChooser() {
        return openDicChooser;
    }

    public static JFileChooser getSaveDicChooser() {
        return saveDicChooser;
    }

    public static JFileChooser getOpenGramChooser() {
        return openGramChooser;
    }

    public static JFileChooser getSaveGramChooser() {
        return saveGramChooser;
    }

    public static JFileChooser getOpenDefDialogChooser() {
        return openDefDialogChooser;
    }

    public static JFileChooser getSaveDefDialogChooser() {
        return saveDefDialogChooser;
    }

    public static JFileChooser getOpenCorpusChooser() {
        return openCorpusChooser;
    }

    public static JFileChooser getSaveCorpusChooser() {
        return saveCorpusChooser;
    }

    public static JFileChooser getOpenTextChooser() {
        return openTextChooser;
    }

    public static JFileChooser getSaveTextChooser() {
        return saveTextChooser;
    }

    public static JFileChooser getOpenSourceChooser() {
        return openSourceChooser;
    }

    public static JFileChooser getOpenFolderChooser() {
        return openFolderChooser;
    }

    public static JFileChooser getSaveConcordanceChooser() {
        return saveConcordanceChooser;
    }

    public static JFileChooser getOpenConcordanceChooser() {
        return openConcordanceChooser;
    }

    public static JFileChooser getOpenProjectChooser() {
        return openProjectChooser;
    }

    public static JFileChooser getSaveProjectChooser() {
        return saveProjectChooser;
    }

    public static CustomStatusBar getStatusBar() {
        return statusBar;
    }

    public static JMenuItem getMntmRunProject() {
        return mntmRunProject;
    }

    public static JMenuItem getMntmNewProject() {
        return mntmNewProject;
    }

    public static XmlAnnotationsTextPaneResources getXmlAnnotationsTextPaneResources() {
        return xmlAnnotationsTextPaneResources;
    }

    public static void setSavedPreferences(Preferences savedPreferences) {
        Launcher.savedPreferences = savedPreferences;
    }

    public static List<String> getRegexMemoryList() {
        return regexMemoryList;
    }

    public static void setRegexMemoryList(List<String> regexMemoryList) {
        Launcher.regexMemoryList = regexMemoryList;
    }

    public static List<String> getXmlMemoryList() {
        return xmlMemoryList;
    }

    public static void setXmlMemoryList(List<String> xmlMemoryList) {
        Launcher.xmlMemoryList = xmlMemoryList;
    }

    public static int getCorpusTextRadioButtonSelectionMemory() {
        return corpusTextRadioButtonSelectionMemory;
    }

    public static void setCorpusTextRadioButtonSelectionMemory(int corpusTextRadioButtonSelectionMemory) {
        Launcher.corpusTextRadioButtonSelectionMemory = corpusTextRadioButtonSelectionMemory;
    }

    public static int getRegexMemoryIndex() {
        return regexMemoryIndex;
    }

    public static void setRegexMemoryIndex(int regexMemoryIndex) {
        Launcher.regexMemoryIndex = regexMemoryIndex;
    }

    public static int getXmlMemoryIndex() {
        return xmlMemoryIndex;
    }

    public static void setXmlMemoryIndex(int xmlMemoryIndex) {
        Launcher.xmlMemoryIndex = xmlMemoryIndex;
    }

    public static int getIndexOfDefaultEncoding() {
        return indexOfDefaultEncoding;
    }

    public static void setIndexOfDefaultEncoding(int indexOfDefaultEncoding) {
        Launcher.indexOfDefaultEncoding = indexOfDefaultEncoding;
    }

    public static String getEncodingCodeOfOpenGrammar() {
        return encodingCodeOfOpenGrammar;
    }

    public static void setEncodingCodeOfOpenGrammar(String encodingCodeOfOpenGrammar) {
        Launcher.encodingCodeOfOpenGrammar = encodingCodeOfOpenGrammar;
    }
}

