/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.shells;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.CorpusEditorShell.AddActionListener;
import net.nooj4nlp.controller.CorpusEditorShell.CloseInternalFrameListener;
import net.nooj4nlp.controller.CorpusEditorShell.ComputeMouseAdapter;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.CorpusEditorShell.ExportColoredToHtmlActionListener;
import net.nooj4nlp.controller.CorpusEditorShell.ExportXmlActionListener;
import net.nooj4nlp.controller.CorpusEditorShell.LinguisticAnalysisActionListener;
import net.nooj4nlp.controller.CorpusEditorShell.RemoveActionListener;
import net.nooj4nlp.controller.CorpusEditorShell.RightClickPopupMenuForCorpus;
import net.nooj4nlp.controller.CorpusEditorShell.TableSorterActionListener;
import net.nooj4nlp.controller.LocateDialog.LocateDialogTextActionListener;
import net.nooj4nlp.controller.TextEditorShell.OpenTextFromCorpusActionListener;
import net.nooj4nlp.gui.actions.shells.control.CorpusCommandInternalFrameListener;
import net.nooj4nlp.gui.dialogs.ExportXmlDialog;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.AlphabetDialog;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.AmbiguitiesUnambiguitiesDialog;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.TokensDigramsDialog;
import net.nooj4nlp.gui.shells.TextEditorShell;

public class CorpusEditorShell
extends JInternalFrame {
    private static final long serialVersionUID = 8330102707204048318L;
    private JTextPane textPaneStats = new JTextPane();
    private JTable tableTexts;
    private JList listResults;
    private JButton btnRemove;
    private JButton btnAdd;
    private AlphabetDialog alphabetDialog = null;
    private TokensDigramsDialog tokensDialog = null;
    private TokensDigramsDialog digramsDialog = null;
    private AmbiguitiesUnambiguitiesDialog ambiguitiesDialog = null;
    private AmbiguitiesUnambiguitiesDialog unAmbiguitiesDialog = null;
    private TextEditorShell textEditorShell;
    private ExportXmlDialog exportXmlDialog = null;
    private CorpusEditorShellController controller;
    private TableSorterActionListener tableSorterActionListener;
    private JMenu mnCorpus;

    public CorpusEditorShell() {
        DefaultTableModel tableModel = new DefaultTableModel(new Object[]{"FileName", "Size", "Modified", "NText"}, 0);
        this.tableTexts = new JTable(tableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tableTexts.setUI(new BasicTableUI(){

            @Override
            protected MouseInputListener createMouseInputListener() {
                return new BasicTableUI.MouseInputHandler(this){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        e.getClickCount();
                    }
                };
            }
        });
        DefaultListModel model2 = new DefaultListModel();
        this.listResults = new JList(model2);
        this.controller = new CorpusEditorShellController(this, this.textPaneStats, this.tableTexts, this.listResults);
        this.controller.updateTitle();
        this.controller.reactivateOps();
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        this.setBounds(100, 100, 600, 300);
        this.getContentPane().setLayout(new MigLayout("insets 5", "[300!,grow][100::,grow]", "[100!, grow][grow][]"));
        JScrollPane scrollPane1 = new JScrollPane(this.textPaneStats);
        scrollPane1.setBorder(new BevelBorder(1, null, null, null, null));
        this.getContentPane().add((Component)scrollPane1, "cell 0 0");
        JScrollPane scrollPane2 = new JScrollPane(this.listResults);
        this.getContentPane().add((Component)scrollPane2, "cell 1 0");
        JScrollPane scrollPane3 = new JScrollPane(this.tableTexts);
        scrollPane3.setBorder(new BevelBorder(1, null, null, null, null));
        this.getContentPane().add((Component)scrollPane3, "cell 0 1, span 2, grow");
        this.btnRemove = new JButton("Remove");
        this.getContentPane().add((Component)this.btnRemove, "cell 1 2, split 2");
        this.btnAdd = new JButton("Add");
        this.getContentPane().add(this.btnAdd);
        this.btnRemove.addActionListener(new RemoveActionListener(this.controller));
        this.btnAdd.addActionListener(new AddActionListener(this.controller, this));
        this.listResults.addMouseListener(new ComputeMouseAdapter(this.controller, this.listResults));
        this.tableTexts.addMouseListener(new OpenTextFromCorpusActionListener(this.controller, this.tableTexts));
        MouseListener rightClickListener = new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    RightClickPopupMenuForCorpus menu = new RightClickPopupMenuForCorpus(CorpusEditorShell.this.controller);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.addMouseListener(rightClickListener);
        this.tableTexts.addMouseListener(rightClickListener);
        this.listResults.addMouseListener(rightClickListener);
        this.textPaneStats.addMouseListener(rightClickListener);
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(tableModel);
        sorter.setSortable(0, false);
        sorter.setSortable(1, false);
        sorter.setSortable(2, false);
        this.tableTexts.setRowSorter(sorter);
        this.addInternalFrameListener(new CloseInternalFrameListener(this.controller, this));
        this.addInternalFrameListener(new CorpusCommandInternalFrameListener(this.controller));
        this.controller.updateTitle();
        this.controller.resetLv();
        this.controller.updateTextPaneStats();
        this.controller.updateResults();
        this.tableSorterActionListener = new TableSorterActionListener();
        this.tableTexts.getTableHeader().addMouseListener(this.tableSorterActionListener);
    }

    public CorpusEditorShell(CorpusEditorShellController c) {
        DefaultTableModel tableModel = new DefaultTableModel(new Object[]{"FileName", "Size", "Modified", "NText"}, 0);
        this.tableTexts = new JTable(tableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tableTexts.setUI(new BasicTableUI(){

            @Override
            protected MouseInputListener createMouseInputListener() {
                return new BasicTableUI.MouseInputHandler(this){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        e.getClickCount();
                    }
                };
            }
        });
        DefaultListModel model2 = new DefaultListModel();
        this.listResults = new JList(model2);
        this.controller = c;
        this.controller.setShell(this);
        this.controller.setTextPaneStats(this.textPaneStats);
        this.controller.setTableTexts(this.tableTexts);
        this.controller.setListResults(this.listResults);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        this.setBounds(100, 100, 600, 300);
        this.getContentPane().setLayout(new MigLayout("insets 5", "[300!,grow][100::,grow]", "[100!, grow][grow][]"));
        JScrollPane scrollPane1 = new JScrollPane(this.textPaneStats);
        scrollPane1.setBorder(new BevelBorder(1, null, null, null, null));
        this.getContentPane().add((Component)scrollPane1, "cell 0 0");
        JScrollPane scrollPane2 = new JScrollPane(this.listResults);
        this.getContentPane().add((Component)scrollPane2, "cell 1 0, grow");
        JScrollPane scrollPane3 = new JScrollPane(this.tableTexts);
        scrollPane3.setBorder(new BevelBorder(1, null, null, null, null));
        this.getContentPane().add((Component)scrollPane3, "cell 0 1, span 2, grow");
        this.btnRemove = new JButton("Remove");
        this.getContentPane().add((Component)this.btnRemove, "cell 1 2, split 2, grow");
        this.btnAdd = new JButton("Add");
        this.getContentPane().add((Component)this.btnAdd, "cell 1 2, grow");
        this.btnRemove.addActionListener(new RemoveActionListener(this.controller));
        this.btnAdd.addActionListener(new AddActionListener(this.controller, this));
        this.listResults.addMouseListener(new ComputeMouseAdapter(this.controller, this.listResults));
        this.tableTexts.addMouseListener(new OpenTextFromCorpusActionListener(this.controller, this.tableTexts));
        MouseListener rightClickListener = new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    RightClickPopupMenuForCorpus menu = new RightClickPopupMenuForCorpus(CorpusEditorShell.this.controller);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.addMouseListener(rightClickListener);
        this.tableTexts.addMouseListener(rightClickListener);
        this.listResults.addMouseListener(rightClickListener);
        this.textPaneStats.addMouseListener(rightClickListener);
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(tableModel);
        sorter.setSortable(0, false);
        sorter.setSortable(1, false);
        sorter.setSortable(2, false);
        this.tableTexts.setRowSorter(sorter);
        this.addInternalFrameListener(new CloseInternalFrameListener(this.controller, this));
        this.addInternalFrameListener(new CorpusCommandInternalFrameListener(this.controller));
        this.controller.updateTitle();
        this.controller.resetLv();
        this.controller.updateTextPaneStats();
        this.controller.updateResults();
        this.tableSorterActionListener = new TableSorterActionListener();
        this.tableTexts.getTableHeader().addMouseListener(this.tableSorterActionListener);
        this.mnCorpus = this.createCorpusMenu();
    }

    private JMenu createCorpusMenu() {
        JMenu mnCorpus = new JMenu("CORPUS");
        JMenuItem mntmLinguisticAnalysis = new JMenuItem("Linguistic analysis");
        mnCorpus.add(mntmLinguisticAnalysis);
        mntmLinguisticAnalysis.addActionListener(new LinguisticAnalysisActionListener(this.controller));
        JMenuItem mntmLocate = new JMenuItem("Locate");
        mnCorpus.add(mntmLocate);
        mntmLocate.addActionListener(new LocateDialogTextActionListener(null, this.controller));
        JSeparator separator_12 = new JSeparator();
        mnCorpus.add(separator_12);
        JMenuItem mntmExportColoredTexts = new JMenuItem("Export colored texts as HTML documents");
        mnCorpus.add(mntmExportColoredTexts);
        mntmExportColoredTexts.setEnabled(this.controller.isColored());
        mntmExportColoredTexts.addActionListener(new ExportColoredToHtmlActionListener(this.controller, null));
        JMenuItem mntmExportAnnotatedTexts = new JMenuItem("Export annotated texts as XML documents");
        mnCorpus.add(mntmExportAnnotatedTexts);
        mntmExportAnnotatedTexts.addActionListener(new ExportXmlActionListener(this.controller));
        return mnCorpus;
    }

    public CorpusEditorShellController getController() {
        return this.controller;
    }

    public AlphabetDialog getAlphabetDialog() {
        return this.alphabetDialog;
    }

    public void setAlphabetDialog(AlphabetDialog alphabetDialog) {
        this.alphabetDialog = alphabetDialog;
    }

    public TokensDigramsDialog getTokensDialog() {
        return this.tokensDialog;
    }

    public void setTokensDialog(TokensDigramsDialog tokensDialog) {
        this.tokensDialog = tokensDialog;
    }

    public TokensDigramsDialog getDigramsDialog() {
        return this.digramsDialog;
    }

    public void setDigramsDialog(TokensDigramsDialog digramsDialog) {
        this.digramsDialog = digramsDialog;
    }

    public AmbiguitiesUnambiguitiesDialog getAmbiguitiesDialog() {
        return this.ambiguitiesDialog;
    }

    public void setAmbiguitiesDialog(AmbiguitiesUnambiguitiesDialog ambiguitiesDialog) {
        this.ambiguitiesDialog = ambiguitiesDialog;
    }

    public AmbiguitiesUnambiguitiesDialog getUnAmbiguitiesDialog() {
        return this.unAmbiguitiesDialog;
    }

    public void setUnAmbiguitiesDialog(AmbiguitiesUnambiguitiesDialog unAmbiguitiesDialog) {
        this.unAmbiguitiesDialog = unAmbiguitiesDialog;
    }

    public ExportXmlDialog getExportXmlDialog() {
        return this.exportXmlDialog;
    }

    public void setExportXmlDialog(ExportXmlDialog exportXmlDialog) {
        this.exportXmlDialog = exportXmlDialog;
    }

    public TextEditorShell getTextEditorShell() {
        return this.textEditorShell;
    }

    public void setTextEditorShell(TextEditorShell textEditorShell) {
        this.textEditorShell = textEditorShell;
    }

    public JTable getTableTexts() {
        return this.tableTexts;
    }

    public JButton getBtnRemove() {
        return this.btnRemove;
    }

    public JButton getBtnAdd() {
        return this.btnAdd;
    }

    public TableSorterActionListener getTableSorterActionListener() {
        return this.tableSorterActionListener;
    }

    public void setTableSorterActionListener(TableSorterActionListener tableSorterActionListener) {
        this.tableSorterActionListener = tableSorterActionListener;
    }

    public JMenu getMnCorpus() {
        return this.mnCorpus;
    }
}

