/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.shells;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.nooj4nlp.gui.main.Launcher;

public class LabInstructionsShell
extends JInternalFrame {
    private static final long serialVersionUID = 2207198069870629997L;

    public LabInstructionsShell(String instructions) {
        this.setBounds(100, 100, 450, 459);
        this.setTitle(instructions);
        this.setResizable(true);
        this.setIconifiable(true);
        HTMLEditorKit html = new HTMLEditorKit();
        JEditorPane editor = new JEditorPane();
        editor.setEditorKit(html);
        editor.setBackground(Color.white);
        editor.setEditable(false);
        this.getContentPane().add((Component)editor, "North");
        HTMLDocument doc = (HTMLDocument)editor.getDocument();
        doc.putProperty("IgnoreCharsetDirective", new Boolean(true));
        JScrollPane scrollPane = new JScrollPane(editor);
        this.getContentPane().add((Component)scrollPane, "Center");
        FileInputStream fInput = null;
        Reader fin = null;
        try {
            switch (instructions.charAt(0)) {
                case 'T': {
                    fInput = new FileInputStream("_Misc/TextEncoding.htm");
                    break;
                }
                case 'M': {
                    fInput = new FileInputStream("_Misc/Morphology.htm");
                    break;
                }
                case 'C': {
                    fInput = new FileInputStream("_Misc/CorpusConstruction.htm");
                    break;
                }
                case 'D': {
                    fInput = new FileInputStream("_Misc/Dictionary.htm");
                    break;
                }
                case 'P': {
                    fInput = new FileInputStream("_Misc/Perl.htm");
                    break;
                }
                case 'L': {
                    fInput = new FileInputStream("_Misc/LanguageSpecifics.htm");
                    break;
                }
                default: {
                    System.out.println("NONE!");
                }
            }
            fin = new BufferedReader(new InputStreamReader((InputStream)fInput, Charset.forName("UTF-8")));
            html.read(fin, (Document)doc, 0);
            fin.close();
            fInput.close();
        }
        catch (FileNotFoundException e) {
            try {
                if (fin != null) {
                    fin.close();
                }
                if (fInput != null) {
                    fInput.close();
                }
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
        }
        catch (IOException e) {
            try {
                if (fin != null) {
                    fin.close();
                }
                if (fInput != null) {
                    fInput.close();
                }
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
        }
        catch (BadLocationException e) {
            try {
                if (fin != null) {
                    fin.close();
                }
                if (fInput != null) {
                    fInput.close();
                }
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
        }
    }
}

