/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.shells;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.StatsShell.DrawingJPanel;
import net.nooj4nlp.controller.StatsShell.StatsShellController;
import net.nooj4nlp.controller.StatsShell.TableJPanel;

public class StatsShell
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private StatsShellController statsController;
    private JRadioButton rbFrequencies;
    private JRadioButton rbStandardScore;
    private JRadioButton rbTfIDf;
    private JRadioButton rbDistances;
    private JPanel displayPanel;
    private DrawingJPanel panelOfFrequencies;
    private DrawingJPanel panelOfStandardScore;
    private TableJPanel panelOfRelevances;
    private TableJPanel panelOfSimilarities;

    public StatsShell() {
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        this.setBounds(200, 100, 850, 700);
        this.getContentPane().setLayout(new MigLayout("insets 5", "[grow][grow][grow][grow][grow]", "[::50][grow]"));
        this.rbFrequencies = new JRadioButton("Frequencies");
        this.getContentPane().add((Component)this.rbFrequencies, "cell  0 0, alignx left");
        this.rbFrequencies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatsShell.this.statsController.changePanel(StatsShell.this.displayPanel, "Frequencies");
            }
        });
        this.rbStandardScore = new JRadioButton("Standard Score");
        this.getContentPane().add((Component)this.rbStandardScore, "cell 1 0, alignx left");
        this.rbStandardScore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatsShell.this.statsController.changePanel(StatsShell.this.displayPanel, "StandardScore");
            }
        });
        this.rbTfIDf = new JRadioButton("Relevance");
        this.getContentPane().add((Component)this.rbTfIDf, "cell 2 0, alignx left");
        this.rbTfIDf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatsShell.this.statsController.changePanel(StatsShell.this.displayPanel, "Relevances");
            }
        });
        this.rbDistances = new JRadioButton("Similarity");
        this.getContentPane().add((Component)this.rbDistances, "cell 3 0, alignx left");
        this.rbDistances.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatsShell.this.statsController.changePanel(StatsShell.this.displayPanel, "Similarity");
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbFrequencies);
        group.add(this.rbStandardScore);
        group.add(this.rbTfIDf);
        group.add(this.rbDistances);
        JButton exportButton = new JButton("Export Report");
        this.getContentPane().add((Component)exportButton, "cell 4 0, alignx right");
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatsShell.this.statsController.exportStatistics();
            }
        });
        this.displayPanel = new JPanel(new CardLayout());
        this.getContentPane().add((Component)this.displayPanel, "cell 0 1, span 5, grow");
        this.panelOfFrequencies = new DrawingJPanel(this, true);
        this.panelOfStandardScore = new DrawingJPanel(this, false);
        this.panelOfRelevances = new TableJPanel(true);
        this.panelOfSimilarities = new TableJPanel(false);
    }

    public void setStatsController(StatsShellController statsController) {
        this.statsController = statsController;
    }

    public StatsShellController getStatsController() {
        return this.statsController;
    }

    public JRadioButton getRbFrequencies() {
        return this.rbFrequencies;
    }

    public JPanel getDisplayPanel() {
        return this.displayPanel;
    }

    public DrawingJPanel getPanelOfFrequencies() {
        return this.panelOfFrequencies;
    }

    public DrawingJPanel getPanelOfStandardScore() {
        return this.panelOfStandardScore;
    }

    public TableJPanel getPanelOfRelevances() {
        return this.panelOfRelevances;
    }

    public TableJPanel getPanelOfSimilarities() {
        return this.panelOfSimilarities;
    }

    public JRadioButton getRbStandardScore() {
        return this.rbStandardScore;
    }

    public JRadioButton getRbTfIDf() {
        return this.rbTfIDf;
    }

    public JRadioButton getRbDistances() {
        return this.rbDistances;
    }
}

