/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.shells;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.CorpusEditorShell.CorpusEditorShellController;
import net.nooj4nlp.controller.CorpusEditorShell.ExportColoredToHtmlActionListener;
import net.nooj4nlp.controller.CorpusEditorShell.ExportXmlActionListener;
import net.nooj4nlp.controller.LocateDialog.LocateDialogTextActionListener;
import net.nooj4nlp.controller.TextEditorShell.CloseInternalFrameListener;
import net.nooj4nlp.controller.TextEditorShell.ComputeMouseAdapterForText;
import net.nooj4nlp.controller.TextEditorShell.JMftPanel;
import net.nooj4nlp.controller.TextEditorShell.RightClickPopupMenuForText;
import net.nooj4nlp.controller.TextEditorShell.TASactionListener;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.controller.TextEditorShell.TextLinguisticAnalysisActionListener;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.gui.actions.documents.CopyActionListener;
import net.nooj4nlp.gui.actions.documents.CutActionListener;
import net.nooj4nlp.gui.actions.documents.PasteActionListener;
import net.nooj4nlp.gui.actions.documents.SelectAllActionListener;
import net.nooj4nlp.gui.actions.shells.control.TextCommandInternalFrameListener;
import net.nooj4nlp.gui.actions.shells.modify.ModifyTextActionListener;
import net.nooj4nlp.gui.actions.shells.modify.UnitSelectionListener;
import net.nooj4nlp.gui.components.CustomJSpinner;
import net.nooj4nlp.gui.dialogs.ExportXmlDialog;
import net.nooj4nlp.gui.dialogs.FindReplaceDialog;
import net.nooj4nlp.gui.dialogs.LocateDialog;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.AlphabetDialog;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.AmbiguitiesUnambiguitiesDialog;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.TokensDigramsDialog;
import net.nooj4nlp.gui.main.Launcher;

public class TextEditorShell
extends JInternalFrame {
    private static final long serialVersionUID = -1613487531803530130L;
    private JTextPane textPane;
    private JList listOfResults;
    private CustomJSpinner spinner;
    private Ntext text;
    private JCheckBox chckbxShowTextAnnotation;
    private JLabel lblnTus;
    private TextEditorShellController textController;
    private CorpusEditorShellController corpusController;
    private boolean newText;
    private JTextArea txtInfo;
    private JScrollPane scrollList;
    private JSplitPane splitPane;
    private JScrollPane panelScrollPane;
    private JScrollPane scrollPane;
    private JMftPanel hiddenPanel;
    private MouseListener rightClickListener;
    private ExportXmlDialog exportXmlDialog = null;
    private LocateDialog locateDialog;
    private FindReplaceDialog findReplaceDialog = null;
    private AlphabetDialog alphabetDialog = null;
    private AmbiguitiesUnambiguitiesDialog ambiguitiesDialog = null;
    private AmbiguitiesUnambiguitiesDialog unAmbiguitiesDialog = null;
    private TokensDigramsDialog tokensDialog = null;
    private TokensDigramsDialog digramsDialog = null;
    private TextCommandInternalFrameListener textCommandInternalFrameListener;
    private ComputeMouseAdapterForText computeMouseAdapterForText;
    private UnitSelectionListener unitSelectionListener;
    private CloseInternalFrameListener closeInternalFrameListener;
    private TASactionListener tasActionListener;
    private JMenu mnText;

    public TextEditorShell(CorpusEditorShellController controller, Ntext txt, String title, String delimText, boolean newText) {
        this.text = txt;
        this.corpusController = controller;
        this.newText = newText;
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        this.setTitle(title);
        this.setBounds(100, 100, 935, 435);
        this.setMinimumSize(new Dimension(500, 350));
        this.getContentPane().setLayout(new MigLayout("ins 7", "[150!,left][120!,right][100::, grow]", "[100][20][][fill,grow]"));
        this.txtInfo = new JTextArea();
        this.txtInfo.setBackground(new Color(227, 227, 227));
        this.txtInfo.setEnabled(false);
        this.txtInfo.setText("Language is \"" + this.text.getLanguage().engName + " (" + this.text.getLanguage().isoName + ")\".\n" + delimText);
        this.txtInfo.setBorder(BorderFactory.createLoweredBevelBorder());
        JScrollPane scrollInfo = new JScrollPane(this.txtInfo, 20, 30);
        scrollInfo.setMinimumSize(new Dimension(170, 100));
        this.getContentPane().add((Component)scrollInfo, "cell 2 0,span 0 2, alignx right, aligny top, width 90, height 100, growx");
        this.chckbxShowTextAnnotation = new JCheckBox("Show Text Annotation Structure");
        this.getContentPane().add((Component)this.chckbxShowTextAnnotation, "cell 0 1, aligny bottom, alignx left");
        DefaultListModel model2 = new DefaultListModel();
        this.listOfResults = new JList(model2);
        this.listOfResults.setBorder(BorderFactory.createLoweredBevelBorder());
        this.scrollList = new JScrollPane(this.listOfResults, 20, 30);
        this.getContentPane().add((Component)this.scrollList, "cell 1 0, aligny top, alignx right, grow");
        this.textPane = new JTextPane();
        this.textPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.textController = new TextEditorShellController(this);
        if (!newText) {
            this.spinner = new CustomJSpinner(this, this.text.nbOfTextUnits);
            this.spinner.setEnabled(true);
        } else {
            this.spinner = new CustomJSpinner(this, 1);
            this.spinner.setEnabled(false);
        }
        this.getContentPane().add((Component)this.spinner, "flowx,cell 0 0, split 2, alignx left, aligny top");
        final JFormattedTextField jtf = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
        jtf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String text = jtf.getText();
                    try {
                        Integer newValue = Integer.valueOf(text);
                        CustomJSpinner spinner = TextEditorShell.this.getSpinner();
                        if (newValue > spinner.getUpperLimit() || newValue < 1) {
                            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Input number was outside of range! Please, type a number between 1 and total number of TUs!", "NooJ error", 0);
                            return;
                        }
                        spinner.setCustomValue(newValue);
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please, type a valid number!", "NooJ error", 0);
                    }
                } else {
                    TextEditorShell.this.unitSelectionListener.keyEventFunction(TextEditorShell.this.textController, e);
                }
            }
        });
        this.lblnTus = new JLabel("");
        this.getContentPane().add((Component)this.lblnTus, "cell 0 0,alignx center,aligny top");
        this.scrollPane = new JScrollPane(this.textPane, 20, 30);
        this.getContentPane().add((Component)this.scrollPane, "cell 0 3, span 3, hidemode 2, grow");
        this.hiddenPanel = new JMftPanel(this.textController);
        this.panelScrollPane = new JScrollPane(this.hiddenPanel, 22, 32);
        this.panelScrollPane.setPreferredSize(new Dimension(850, 200));
        this.hiddenPanel.setParentScrollPane(this.panelScrollPane);
        this.splitPane = new JSplitPane(0, true);
        this.splitPane.setContinuousLayout(true);
        Dimension minimumSize = new Dimension(400, 50);
        this.scrollPane.setMinimumSize(minimumSize);
        this.splitPane.setMinimumSize(minimumSize);
        this.splitPane.setDividerLocation(0.5);
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setVisible(false);
        this.getContentPane().add((Component)this.splitPane, "cell 0 2, span 3, hidemode 2");
        this.tasActionListener = new TASactionListener(this.getContentPane(), this.chckbxShowTextAnnotation, this.splitPane, this.scrollPane, this.panelScrollPane, this.textController);
        this.chckbxShowTextAnnotation.addActionListener(this.tasActionListener);
        if (this.corpusController == null) {
            this.textCommandInternalFrameListener = new TextCommandInternalFrameListener(this.textController);
            this.addInternalFrameListener(this.textCommandInternalFrameListener);
        } else {
            this.corpusController.setTextShell(this);
        }
        this.computeMouseAdapterForText = new ComputeMouseAdapterForText(this.textController);
        this.listOfResults.addMouseListener(this.computeMouseAdapterForText);
        this.closeInternalFrameListener = new CloseInternalFrameListener(this.textController, this, this.corpusController);
        this.addInternalFrameListener(this.closeInternalFrameListener);
        this.rightClickListener = new RightClickPopupMenuForText(this.textController);
        this.addMouseListener(this.rightClickListener);
        this.textPane.addMouseListener(this.rightClickListener);
        this.txtInfo.addMouseListener(this.rightClickListener);
        if (this.text.buffer != null) {
            this.textPane.setText(this.text.buffer);
            this.textPane.moveCaretPosition(0);
            this.textPane.getCaret().setVisible(true);
            this.unitSelectionListener = new UnitSelectionListener(this.textController, this.textPane);
            this.textPane.addCaretListener(this.unitSelectionListener);
            this.textPane.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    TextEditorShell.this.unitSelectionListener.keyEventFunction(TextEditorShell.this.textController, e);
                }
            });
            this.textPane.setEditable(false);
        } else {
            this.text.buffer = "";
        }
        this.mnText = this.createTextMenu();
    }

    public void refreshListenersAndAdapters() {
        this.removeInternalFrameListener(this.textCommandInternalFrameListener);
        this.textCommandInternalFrameListener = new TextCommandInternalFrameListener(this.textController);
        this.addInternalFrameListener(this.textCommandInternalFrameListener);
        this.listOfResults.removeMouseListener(this.computeMouseAdapterForText);
        this.computeMouseAdapterForText = new ComputeMouseAdapterForText(this.textController);
        this.listOfResults.addMouseListener(this.computeMouseAdapterForText);
        this.textPane.removeCaretListener(this.unitSelectionListener);
        this.unitSelectionListener = new UnitSelectionListener(this.textController, this.textPane);
        this.textPane.addCaretListener(this.unitSelectionListener);
        this.removeInternalFrameListener(this.closeInternalFrameListener);
        this.closeInternalFrameListener = new CloseInternalFrameListener(this.textController, this, this.corpusController);
        this.addInternalFrameListener(this.closeInternalFrameListener);
    }

    private JMenu createTextMenu() {
        JMenuItem mntmCut = Launcher.getTextCommands().get("Cut");
        JMenuItem mntmCopy = Launcher.getTextCommands().get("Copy");
        JMenuItem mntmPaste = Launcher.getTextCommands().get("Paste");
        JMenuItem mntmSelectAll = Launcher.getTextCommands().get("Select All");
        mntmCut.addActionListener(new CutActionListener(this.textPane));
        mntmCopy.addActionListener(new CopyActionListener(this.textPane));
        mntmPaste.addActionListener(new PasteActionListener(this.textPane));
        mntmSelectAll.addActionListener(new SelectAllActionListener(this.textPane));
        this.mnText = new JMenu("TEXT");
        JMenuItem mntmLinguisticAnalysis = new JMenuItem("Linguistic Analysis");
        this.mnText.add(mntmLinguisticAnalysis);
        TextLinguisticAnalysisActionListener textLinguisticAnalysisActionListener = new TextLinguisticAnalysisActionListener(this.textController);
        mntmLinguisticAnalysis.addActionListener(textLinguisticAnalysisActionListener);
        JMenuItem mntmLocate = new JMenuItem("Locate");
        this.mnText.add(mntmLocate);
        mntmLocate.addActionListener(new LocateDialogTextActionListener(this.textController, null));
        JSeparator separator_1 = new JSeparator();
        this.mnText.add(separator_1);
        JMenuItem mntmExportColoredTexts = new JMenuItem("Export colored text as an HTML document");
        this.mnText.add(mntmExportColoredTexts);
        mntmExportColoredTexts.setEnabled(this.textController.isColored());
        mntmExportColoredTexts.addActionListener(new ExportColoredToHtmlActionListener(null, this.textController));
        JMenuItem mntmExportAnnotatedTexts = new JMenuItem("Export annotated text as an XML document");
        this.mnText.add(mntmExportAnnotatedTexts);
        mntmExportAnnotatedTexts.addActionListener(new ExportXmlActionListener(this.textController));
        JSeparator separator_2 = new JSeparator();
        this.mnText.add(separator_2);
        JMenuItem mntmModify = new JMenuItem("Modify Text");
        this.mnText.add(mntmModify);
        mntmModify.addActionListener(new ModifyTextActionListener(this.textController));
        return this.mnText;
    }

    public JMenu getMnText() {
        return this.mnText;
    }

    public CustomJSpinner getSpinner() {
        return this.spinner;
    }

    public JCheckBox getChckbxShowTextAnnotation() {
        return this.chckbxShowTextAnnotation;
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public void setTextPane(JTextPane textPane) {
        this.textPane = textPane;
    }

    public Ntext getText() {
        return this.text;
    }

    public JLabel getLblnTus() {
        return this.lblnTus;
    }

    public ExportXmlDialog getExportXmlDialog() {
        return this.exportXmlDialog;
    }

    public void setExportXmlDialog(ExportXmlDialog exportXmlDialog) {
        this.exportXmlDialog = exportXmlDialog;
    }

    public CorpusEditorShellController getCorpusController() {
        return this.corpusController;
    }

    public TextEditorShellController getTextController() {
        return this.textController;
    }

    public void setTextController(TextEditorShellController textController) {
        this.textController = textController;
    }

    public LocateDialog getLocateDialog() {
        return this.locateDialog;
    }

    public void setLocateDialog(LocateDialog locateDialog) {
        this.locateDialog = locateDialog;
    }

    public AlphabetDialog getAlphabetDialog() {
        return this.alphabetDialog;
    }

    public void setAlphabetDialog(AlphabetDialog alphabetDialog) {
        this.alphabetDialog = alphabetDialog;
    }

    public AmbiguitiesUnambiguitiesDialog getAmbiguitiesDialog() {
        return this.ambiguitiesDialog;
    }

    public void setAmbiguitiesDialog(AmbiguitiesUnambiguitiesDialog ambiguitiesDialog) {
        this.ambiguitiesDialog = ambiguitiesDialog;
    }

    public AmbiguitiesUnambiguitiesDialog getUnAmbiguitiesDialog() {
        return this.unAmbiguitiesDialog;
    }

    public void setUnAmbiguitiesDialog(AmbiguitiesUnambiguitiesDialog unAmbiguitiesDialog) {
        this.unAmbiguitiesDialog = unAmbiguitiesDialog;
    }

    public TokensDigramsDialog getTokensDialog() {
        return this.tokensDialog;
    }

    public void setTokensDialog(TokensDigramsDialog tokensDialog) {
        this.tokensDialog = tokensDialog;
    }

    public TokensDigramsDialog getDigramsDialog() {
        return this.digramsDialog;
    }

    public void setDigramsDialog(TokensDigramsDialog digramsDialog) {
        this.digramsDialog = digramsDialog;
    }

    public JMftPanel getHiddenPanel() {
        return this.hiddenPanel;
    }

    public MouseListener getRightClickListener() {
        return this.rightClickListener;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public JScrollPane getPanelScrollPane() {
        return this.panelScrollPane;
    }

    public void setPanelScrollPane(JScrollPane panelScrollPane) {
        this.panelScrollPane = panelScrollPane;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public FindReplaceDialog getFindReplaceDialog() {
        return this.findReplaceDialog;
    }

    public void setFindReplaceDialog(FindReplaceDialog findReplaceDialog) {
        this.findReplaceDialog = findReplaceDialog;
    }

    public UnitSelectionListener getUnitSelectionListener() {
        return this.unitSelectionListener;
    }

    public TASactionListener getTasActionListener() {
        return this.tasActionListener;
    }

    public void setTasActionListener(TASactionListener tasActionListener) {
        this.tasActionListener = tasActionListener;
    }

    public boolean isNewText() {
        return this.newText;
    }

    public void setSpinner(CustomJSpinner spinner) {
        this.spinner = spinner;
    }

    public void setUnitSelectionListener(UnitSelectionListener unitSelectionListener) {
        this.unitSelectionListener = unitSelectionListener;
    }

    public TextCommandInternalFrameListener getTextCommandInternalFrameListener() {
        return this.textCommandInternalFrameListener;
    }

    public JScrollPane getScrollList() {
        return this.scrollList;
    }

    public JTextArea getTxtInfo() {
        return this.txtInfo;
    }

    public JList getListOfResults() {
        return this.listOfResults;
    }
}

