/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.sprm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.poi.hwpf.sprm.SprmIterator;
import org.apache.poi.hwpf.sprm.SprmOperation;
import org.apache.poi.hwpf.sprm.SprmUncompressor;
import org.apache.poi.hwpf.usermodel.BorderCode;
import org.apache.poi.hwpf.usermodel.DateAndTime;
import org.apache.poi.hwpf.usermodel.DropCapSpecifier;
import org.apache.poi.hwpf.usermodel.LineSpacingDescriptor;
import org.apache.poi.hwpf.usermodel.ParagraphProperties;
import org.apache.poi.hwpf.usermodel.ShadingDescriptor;
import org.apache.poi.util.LittleEndian;

public final class ParagraphSprmUncompressor
extends SprmUncompressor {
    public static ParagraphProperties uncompressPAP(ParagraphProperties parent, byte[] grpprl, int offset) {
        ParagraphProperties newProperties = null;
        try {
            newProperties = (ParagraphProperties)parent.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("There is no way this exception should happen!!");
        }
        SprmIterator sprmIt = new SprmIterator(grpprl, offset);
        while (sprmIt.hasNext()) {
            SprmOperation sprm = sprmIt.next();
            if (sprm.getType() != 1) continue;
            ParagraphSprmUncompressor.unCompressPAPOperation(newProperties, sprm);
        }
        return newProperties;
    }

    static void unCompressPAPOperation(ParagraphProperties newPAP, SprmOperation sprm) {
        switch (sprm.getOperation()) {
            case 0: {
                newPAP.setIstd(sprm.getOperand());
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (newPAP.getIstd() > 9 && newPAP.getIstd() < 1) break;
                byte paramTmp = (byte)sprm.getOperand();
                newPAP.setIstd(newPAP.getIstd() + paramTmp);
                newPAP.setLvl((byte)(newPAP.getLvl() + paramTmp));
                if ((paramTmp >> 7 & 1) == 1) {
                    newPAP.setIstd(Math.max(newPAP.getIstd(), 1));
                    break;
                }
                newPAP.setIstd(Math.min(newPAP.getIstd(), 9));
                break;
            }
            case 3: {
                newPAP.setJc((byte)sprm.getOperand());
                break;
            }
            case 4: {
                newPAP.setFSideBySide((byte)sprm.getOperand());
                break;
            }
            case 5: {
                newPAP.setFKeep((byte)sprm.getOperand());
                break;
            }
            case 6: {
                newPAP.setFKeepFollow((byte)sprm.getOperand());
                break;
            }
            case 7: {
                newPAP.setFPageBreakBefore((byte)sprm.getOperand());
                break;
            }
            case 8: {
                newPAP.setBrcl((byte)sprm.getOperand());
                break;
            }
            case 9: {
                newPAP.setBrcp((byte)sprm.getOperand());
                break;
            }
            case 10: {
                newPAP.setIlvl((byte)sprm.getOperand());
                break;
            }
            case 11: {
                newPAP.setIlfo(sprm.getOperand());
                break;
            }
            case 12: {
                newPAP.setFNoLnn((byte)sprm.getOperand());
                break;
            }
            case 13: {
                ParagraphSprmUncompressor.handleTabs(newPAP, sprm);
                break;
            }
            case 14: {
                newPAP.setDxaRight(sprm.getOperand());
                break;
            }
            case 15: {
                newPAP.setDxaLeft(sprm.getOperand());
                break;
            }
            case 16: {
                newPAP.setDxaLeft(newPAP.getDxaLeft() + sprm.getOperand());
                newPAP.setDxaLeft(Math.max(0, newPAP.getDxaLeft()));
                break;
            }
            case 17: {
                newPAP.setDxaLeft1(sprm.getOperand());
                break;
            }
            case 18: {
                newPAP.setLspd(new LineSpacingDescriptor(sprm.getGrpprl(), sprm.getGrpprlOffset()));
                break;
            }
            case 19: {
                newPAP.setDyaBefore(sprm.getOperand());
                break;
            }
            case 20: {
                newPAP.setDyaAfter(sprm.getOperand());
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                newPAP.setFInTable((byte)sprm.getOperand());
                break;
            }
            case 23: {
                newPAP.setFTtp((byte)sprm.getOperand());
                break;
            }
            case 24: {
                newPAP.setDxaAbs(sprm.getOperand());
                break;
            }
            case 25: {
                newPAP.setDyaAbs(sprm.getOperand());
                break;
            }
            case 26: {
                newPAP.setDxaWidth(sprm.getOperand());
                break;
            }
            case 27: {
                byte param = (byte)sprm.getOperand();
                byte pcVert = (byte)((param & 0xC) >> 2);
                byte pcHorz = (byte)(param & 3);
                if (pcVert != 3) {
                    newPAP.setPcVert(pcVert);
                }
                if (pcHorz == 3) break;
                newPAP.setPcHorz(pcHorz);
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                newPAP.setDxaFromText(sprm.getOperand());
                break;
            }
            case 35: {
                newPAP.setWr((byte)sprm.getOperand());
                break;
            }
            case 36: {
                newPAP.setBrcTop(new BorderCode(sprm.getGrpprl(), sprm.getGrpprlOffset()));
                break;
            }
            case 37: {
                newPAP.setBrcLeft(new BorderCode(sprm.getGrpprl(), sprm.getGrpprlOffset()));
                break;
            }
            case 38: {
                newPAP.setBrcBottom(new BorderCode(sprm.getGrpprl(), sprm.getGrpprlOffset()));
                break;
            }
            case 39: {
                newPAP.setBrcRight(new BorderCode(sprm.getGrpprl(), sprm.getGrpprlOffset()));
                break;
            }
            case 40: {
                newPAP.setBrcBetween(new BorderCode(sprm.getGrpprl(), sprm.getGrpprlOffset()));
                break;
            }
            case 41: {
                newPAP.setBrcBar(new BorderCode(sprm.getGrpprl(), sprm.getGrpprlOffset()));
                break;
            }
            case 42: {
                newPAP.setFNoAutoHyph((byte)sprm.getOperand());
                break;
            }
            case 43: {
                newPAP.setDyaHeight(sprm.getOperand());
                break;
            }
            case 44: {
                newPAP.setDcs(new DropCapSpecifier((short)sprm.getOperand()));
                break;
            }
            case 45: {
                newPAP.setShd(new ShadingDescriptor((short)sprm.getOperand()));
                break;
            }
            case 46: {
                newPAP.setDyaFromText(sprm.getOperand());
                break;
            }
            case 47: {
                newPAP.setDxaFromText(sprm.getOperand());
                break;
            }
            case 48: {
                newPAP.setFLocked((byte)sprm.getOperand());
                break;
            }
            case 49: {
                newPAP.setFWidowControl((byte)sprm.getOperand());
                break;
            }
            case 50: {
                break;
            }
            case 51: {
                newPAP.setFKinsoku((byte)sprm.getOperand());
                break;
            }
            case 52: {
                newPAP.setFWordWrap((byte)sprm.getOperand());
                break;
            }
            case 53: {
                newPAP.setFOverflowPunct((byte)sprm.getOperand());
                break;
            }
            case 54: {
                newPAP.setFTopLinePunct((byte)sprm.getOperand());
                break;
            }
            case 55: {
                newPAP.setFAutoSpaceDE((byte)sprm.getOperand());
                break;
            }
            case 56: {
                newPAP.setFAutoSpaceDN((byte)sprm.getOperand());
                break;
            }
            case 57: {
                newPAP.setWAlignFont(sprm.getOperand());
                break;
            }
            case 58: {
                newPAP.setFontAlign((short)sprm.getOperand());
                break;
            }
            case 59: {
                break;
            }
            case 62: {
                byte[] buf = new byte[sprm.size() - 3];
                System.arraycopy(buf, 0, sprm.getGrpprl(), sprm.getGrpprlOffset(), buf.length);
                newPAP.setAnld(buf);
                break;
            }
            case 63: {
                try {
                    byte[] varParam = sprm.getGrpprl();
                    int offset = sprm.getGrpprlOffset();
                    newPAP.setFPropRMark(varParam[offset]);
                    newPAP.setIbstPropRMark(LittleEndian.getShort(varParam, offset + 1));
                    newPAP.setDttmPropRMark(new DateAndTime(varParam, offset + 3));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 64: {
                newPAP.setLvl((byte)sprm.getOperand());
                break;
            }
            case 65: {
                break;
            }
            case 67: {
                newPAP.setFNumRMIns((byte)sprm.getOperand());
                break;
            }
            case 68: {
                break;
            }
            case 69: {
                if (sprm.getSizeCode() != 6) break;
                byte[] buf = new byte[sprm.size() - 3];
                System.arraycopy(buf, 0, sprm.getGrpprl(), sprm.getGrpprlOffset(), buf.length);
                newPAP.setNumrm(buf);
                break;
            }
            case 71: {
                newPAP.setFUsePgsuSettings((byte)sprm.getOperand());
                break;
            }
            case 72: {
                newPAP.setFAdjustRight((byte)sprm.getOperand());
                break;
            }
            case 73: {
                newPAP.setTableLevel((byte)sprm.getOperand());
                break;
            }
            case 75: {
                newPAP.setEmbeddedCellMark((byte)sprm.getOperand());
                break;
            }
            case 76: {
                newPAP.setFTtpEmbedded((byte)sprm.getOperand());
                break;
            }
            case 97: {
                break;
            }
        }
    }

    private static void handleTabs(ParagraphProperties pap, SprmOperation sprm) {
        int x;
        byte[] grpprl = sprm.getGrpprl();
        int offset = sprm.getGrpprlOffset();
        int delSize = grpprl[offset++];
        int[] tabPositions = pap.getRgdxaTab();
        byte[] tabDescriptors = pap.getRgtbd();
        HashMap<Integer, Byte> tabMap = new HashMap<Integer, Byte>();
        for (x = 0; x < tabPositions.length; ++x) {
            tabMap.put(tabPositions[x], tabDescriptors[x]);
        }
        for (x = 0; x < delSize; ++x) {
            tabMap.remove(LittleEndian.getShort(grpprl, offset));
            offset += 2;
        }
        int addSize = grpprl[offset++];
        int start = offset;
        for (int x2 = 0; x2 < addSize; ++x2) {
            Integer key = LittleEndian.getShort(grpprl, offset);
            Byte val = grpprl[start + (2 * addSize + x2)];
            tabMap.put(key, val);
            offset += 2;
        }
        tabPositions = new int[tabMap.size()];
        tabDescriptors = new byte[tabPositions.length];
        ArrayList list = new ArrayList();
        Iterator keyIT = tabMap.keySet().iterator();
        while (keyIT.hasNext()) {
            list.add(keyIT.next());
        }
        Collections.sort(list);
        for (int x3 = 0; x3 < tabPositions.length; ++x3) {
            Integer key = (Integer)list.get(x3);
            tabPositions[x3] = key;
            tabDescriptors[x3] = (Byte)tabMap.get(key);
        }
        pap.setRgdxaTab(tabPositions);
        pap.setRgtbd(tabDescriptors);
    }
}

