/*
 * Decompiled with CFR 0.152.
 */
package wox.serial;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.jdom.Comment;
import org.jdom.Element;
import wox.serial.EncodeBase64;
import wox.serial.ObjectWriter;
import wox.serial.TypeMapping;
import wox.serial.Util;

public class SimpleWriter
extends TypeMapping
implements ObjectWriter {
    HashMap map = new HashMap();
    int count = 0;
    boolean writePrimitiveTypes = true;
    boolean doStatic = true;
    boolean doFinal = false;

    @Override
    public Element write(Object ob) {
        Element el;
        if (ob == null) {
            return new Element("object");
        }
        if (this.map.get(ob) != null) {
            Element el2 = new Element("object");
            el2.setAttribute("idref", this.map.get(ob).toString());
            return el2;
        }
        this.map.put(ob, new Integer(this.count++));
        if (Util.stringable(ob)) {
            el = new Element("object");
            String woxType = (String)mapJavaToWOX.get(ob.getClass());
            el.setAttribute("type", woxType);
            el.setAttribute("value", SimpleWriter.stringify(ob));
        } else if (ob.getClass().isArray()) {
            el = this.writeArray(ob);
        } else if (ob instanceof ArrayList) {
            el = this.writeArrayList(ob);
        } else if (ob instanceof HashMap) {
            el = this.writeHashMap(ob);
        } else {
            el = new Element("object");
            el.setAttribute("type", ob.getClass().getName());
            this.writeFields(ob, el);
        }
        el.setAttribute("id", this.map.get(ob).toString());
        return el;
    }

    private Element writeHashMap(Object ob) {
        Element el = new Element("object");
        el.setAttribute("type", "map");
        HashMap hashMap = (HashMap)ob;
        Set keys = hashMap.entrySet();
        for (Map.Entry entryMap : keys) {
            el.addContent(this.writeMapEntry(entryMap));
        }
        return el;
    }

    private Element writeMapEntry(Object ob) {
        Element el = new Element("object");
        el.setAttribute("type", "entry");
        Map.Entry entry = (Map.Entry)ob;
        el.addContent(this.writeMapEntryKey(entry.getKey()));
        el.addContent(this.writeMapEntryKey(entry.getValue()));
        return el;
    }

    private Element writeMapEntryKey(Object ob) {
        return this.write(ob);
    }

    private Element writeMapEntryValue(Object ob) {
        return this.write(ob);
    }

    private Element writeArrayList(Object ob) {
        Element el = new Element("object");
        el.setAttribute("type", "list");
        ArrayList list = (ArrayList)ob;
        ob = list.toArray();
        return this.writeObjectArrayGeneric(ob, el);
    }

    private Element writeArray(Object ob) {
        if (this.isPrimitiveArray(ob.getClass())) {
            return this.writePrimitiveArray(ob);
        }
        return this.writeObjectArray(ob);
    }

    private Element writeObjectArray(Object ob) {
        Element el = new Element("object");
        el.setAttribute("type", "array");
        return this.writeObjectArrayGeneric(ob, el);
    }

    private Element writeObjectArrayGeneric(Object ob, Element el) {
        String woxType = (String)mapJavaToWOX.get(ob.getClass().getComponentType());
        if (woxType == null) {
            woxType = (String)mapArrayJavaToWOX.get(ob.getClass().getComponentType());
            if (woxType != null) {
                el.setAttribute("elementType", woxType);
            } else if (ob.getClass().getComponentType().getName().equals("java.lang.Object")) {
                el.setAttribute("elementType", "Object");
            } else {
                el.setAttribute("elementType", ob.getClass().getComponentType().getName());
            }
        } else {
            el.setAttribute("elementType", woxType);
        }
        int len = Array.getLength(ob);
        el.setAttribute("length", "" + len);
        for (int i = 0; i < len; ++i) {
            el.addContent(this.write(Array.get(ob, i)));
        }
        return el;
    }

    private Element writePrimitiveArray(Object ob) {
        Element el = new Element("object");
        el.setAttribute("type", "array");
        String woxType = (String)mapJavaToWOX.get(ob.getClass().getComponentType());
        el.setAttribute("elementType", woxType);
        int len = Array.getLength(ob);
        if (ob instanceof byte[] || ob instanceof Byte[]) {
            if (ob instanceof Byte[]) {
                Byte[] arrayWrapperByte = (Byte[])ob;
                byte[] arrayPrimitiveByte = new byte[arrayWrapperByte.length];
                for (int k = 0; k < arrayWrapperByte.length; ++k) {
                    arrayPrimitiveByte[k] = arrayWrapperByte[k];
                }
                el.setText(this.byteArrayString(arrayPrimitiveByte, el));
            } else {
                el.setText(this.byteArrayString((byte[])ob, el));
            }
        } else {
            el.setAttribute("length", "" + len);
            el.setText(this.arrayString(ob, len));
        }
        return el;
    }

    private String byteArrayString(byte[] a, Element e) {
        byte[] target = EncodeBase64.encode(a);
        e.setAttribute("length", "" + target.length);
        String strTarget = new String(target);
        return strTarget;
    }

    private String arrayString(Object ob, int len) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            Object arrayElement;
            if (i > 0) {
                sb.append(" ");
            }
            if (ob instanceof Class[]) {
                arrayElement = (Class)Array.get(ob, i);
                if (arrayElement != null) {
                    String woxType = (String)mapJavaToWOX.get(arrayElement);
                    if (woxType != null) {
                        sb.append(woxType);
                        continue;
                    }
                    woxType = (String)mapArrayJavaToWOX.get(arrayElement);
                    if (woxType != null) {
                        sb.append(woxType);
                        continue;
                    }
                    sb.append(((Class)arrayElement).getName());
                    continue;
                }
                sb.append("null");
                continue;
            }
            if (ob instanceof char[] || ob instanceof Character[]) {
                arrayElement = Array.get(ob, i);
                if (arrayElement != null) {
                    Character myChar = (Character)Array.get(ob, i);
                    sb.append(SimpleWriter.getUnicodeValue(myChar));
                    continue;
                }
                sb.append("null");
                continue;
            }
            arrayElement = Array.get(ob, i);
            if (arrayElement != null) {
                sb.append(arrayElement.toString());
                continue;
            }
            sb.append("null");
        }
        return sb.toString();
    }

    private void writeFields(Object o, Element parent) {
        Class<?> cl = o.getClass();
        Field[] fields = SimpleWriter.getFields(cl);
        String name = null;
        for (int i = 0; i < fields.length; ++i) {
            if (!this.doStatic && Modifier.isStatic(fields[i].getModifiers()) || !this.doFinal && Modifier.isFinal(fields[i].getModifiers())) continue;
            try {
                fields[i].setAccessible(true);
                name = fields[i].getName();
                Object value = fields[i].get(o);
                Element field = new Element("field");
                field.setAttribute("name", name);
                if (this.shadowed(fields, name)) {
                    field.setAttribute("declaredClass", fields[i].getDeclaringClass().getName());
                }
                if (fields[i].getType().isPrimitive()) {
                    if (this.writePrimitiveTypes) {
                        field.setAttribute("type", fields[i].getType().getName());
                    }
                    if (fields[i].getType().getName().equals("char")) {
                        Character myChar = (Character)value;
                        String unicodeValue = SimpleWriter.getUnicodeValue(myChar);
                        field.setAttribute("value", unicodeValue);
                    } else {
                        field.setAttribute("value", value.toString());
                    }
                } else if (mapJavaToWOX.get(fields[i].getType()) != null) {
                    String woxType = (String)mapJavaToWOX.get(value.getClass());
                    field.setAttribute("type", woxType);
                    field.setAttribute("value", SimpleWriter.stringify(value));
                } else {
                    field.addContent(this.write(value));
                }
                parent.addContent(field);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(e);
                parent.addContent(new Comment(e.toString()));
            }
        }
    }

    private static String getUnicodeValue(Character character) {
        char asciiValue = character.charValue();
        String hexValue = Integer.toHexString(asciiValue);
        String unicodeValue = "\\u" + SimpleWriter.fillWithZeros(hexValue);
        return unicodeValue;
    }

    private static String fillWithZeros(String hexValue) {
        int len = hexValue.length();
        switch (len) {
            case 1: {
                return "000" + hexValue;
            }
            case 2: {
                return "00" + hexValue;
            }
            case 3: {
                return "0" + hexValue;
            }
        }
        return hexValue;
    }

    private boolean shadowed(Field[] fields, String fieldName) {
        int count = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (!fieldName.equals(fields[i].getName())) continue;
            ++count;
        }
        return count > 1;
    }

    private static String stringify(Object ob) {
        if (ob instanceof Class) {
            String woxType = (String)mapJavaToWOX.get((Class)ob);
            if (woxType != null) {
                return woxType;
            }
            return ((Class)ob).getName();
        }
        if (ob instanceof Character) {
            return SimpleWriter.getUnicodeValue((Character)ob);
        }
        return ob.toString();
    }

    private static Field[] getFields(Class c) {
        int i;
        Vector<Field> v = new Vector<Field>();
        while (c != null) {
            Field[] fields = c.getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                v.addElement(fields[i]);
            }
            c = c.getSuperclass();
        }
        Field[] f = new Field[v.size()];
        for (i = 0; i < f.length; ++i) {
            f[i] = (Field)v.get(i);
        }
        return f;
    }

    private static Object[] getValues(Object o, Field[] fields) {
        Object[] values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            try {
                fields[i].setAccessible(true);
                values[i] = fields[i].get(o);
                continue;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return values;
    }

    private boolean isPrimitiveArray(Class c) {
        for (int i = 0; i < primitiveArrays.length; ++i) {
            if (!c.equals(primitiveArrays[i])) continue;
            return true;
        }
        return false;
    }
}

